-- -----------------------------------------
-- upgrade path for Icinga IDOUtils 1.4.0
--
-- -----------------------------------------
-- Copyright (c) 2010-2011 Icinga Development Team (http://www.icinga.org)
--
-- Please check http://docs.icinga.org for upgrading information!
-- -----------------------------------------


-- --------------------------------------------------------
-- remove number limitations, change id autoincrement type to native serial type (bigint unsigned not null)
-- fixes Bug #1173: int(11) to small for some of ido tables https://dev.icinga.org/issues/1173
--       Bug #1401: integer not big enough for bytes_processed https://dev.icinga.org/issues/1401
-- remove NOT NULL constraints
-- Feature #1355 drop unnessary constraints and rename remaining https://dev.icinga.org/issues/1355
-- --------------------------------------------------------

Alter table icinga_acknowledgements  modify acknowledgement_id serial;
Alter table icinga_acknowledgements  modify instance_id bigint unsigned default 0;
Alter table icinga_acknowledgements  modify entry_time_usec  int default 0;
Alter table icinga_acknowledgements  modify acknowledgement_type smallint default 0;
Alter table icinga_acknowledgements  modify object_id bigint unsigned default 0;
Alter table icinga_acknowledgements  modify state smallint default 0;
Alter table icinga_acknowledgements  modify is_sticky smallint default 0;
Alter table icinga_acknowledgements  modify persistent_comment smallint default 0;
Alter table icinga_acknowledgements  modify notify_contacts smallint default 0;
Alter table icinga_commands  modify command_id serial;
Alter table icinga_commands  modify instance_id bigint unsigned default 0;
Alter table icinga_commands  modify config_type smallint default 0;
Alter table icinga_commands  modify object_id bigint unsigned default 0;
Alter table icinga_commenthistory  modify commenthistory_id serial;
Alter table icinga_commenthistory  modify instance_id bigint unsigned default 0;
Alter table icinga_commenthistory  modify entry_time_usec  int default 0;
Alter table icinga_commenthistory  modify comment_type smallint default 0;
Alter table icinga_commenthistory  modify entry_type smallint default 0;
Alter table icinga_commenthistory  modify object_id bigint unsigned default 0;
Alter table icinga_commenthistory  modify internal_comment_id bigint unsigned default 0;
Alter table icinga_commenthistory  modify is_persistent smallint default 0;
Alter table icinga_commenthistory  modify comment_source smallint default 0;
Alter table icinga_commenthistory  modify expires smallint default 0;
Alter table icinga_commenthistory  modify deletion_time_usec  int default 0;
Alter table icinga_comments  modify comment_id serial;
Alter table icinga_comments  modify instance_id bigint unsigned default 0;
Alter table icinga_comments  modify entry_time_usec  int default 0;
Alter table icinga_comments  modify comment_type smallint default 0;
Alter table icinga_comments  modify entry_type smallint default 0;
Alter table icinga_comments  modify object_id bigint unsigned default 0;
Alter table icinga_comments  modify internal_comment_id bigint unsigned default 0;
Alter table icinga_comments  modify is_persistent smallint default 0;
Alter table icinga_comments  modify comment_source smallint default 0;
Alter table icinga_comments  modify expires smallint default 0;
Alter table icinga_configfiles  modify configfile_id serial;
Alter table icinga_configfiles  modify instance_id bigint unsigned default 0;
Alter table icinga_configfiles  modify configfile_type smallint default 0;
Alter table icinga_configfilevariables  modify configfilevariable_id serial;
Alter table icinga_configfilevariables  modify instance_id bigint unsigned default 0;
Alter table icinga_configfilevariables  modify configfile_id bigint unsigned default 0;
Alter table icinga_conninfo  modify conninfo_id serial;
Alter table icinga_conninfo  modify instance_id bigint unsigned default 0;
Alter table icinga_conninfo  modify bytes_processed  bigint unsigned default 0;
Alter table icinga_conninfo  modify lines_processed  bigint unsigned default 0;
Alter table icinga_conninfo  modify entries_processed  bigint unsigned default 0;
Alter table icinga_contactgroups  modify contactgroup_id serial;
Alter table icinga_contactgroups  modify instance_id bigint unsigned default 0;
Alter table icinga_contactgroups  modify config_type smallint default 0;
Alter table icinga_contactgroups  modify contactgroup_object_id bigint unsigned default 0;
Alter table icinga_contactgroup_members  modify contactgroup_member_id serial;
Alter table icinga_contactgroup_members  modify instance_id bigint unsigned default 0;
Alter table icinga_contactgroup_members  modify contactgroup_id bigint unsigned default 0;
Alter table icinga_contactgroup_members  modify contact_object_id bigint unsigned default 0;
Alter table icinga_contactnotificationmethods  modify contactnotificationmethod_id serial;
Alter table icinga_contactnotificationmethods  modify instance_id bigint unsigned default 0;
Alter table icinga_contactnotificationmethods  modify contactnotification_id bigint unsigned default 0;
Alter table icinga_contactnotificationmethods  modify start_time_usec  int default 0;
Alter table icinga_contactnotificationmethods  modify end_time_usec  int default 0;
Alter table icinga_contactnotificationmethods  modify command_object_id bigint unsigned default 0;
Alter table icinga_contactnotifications  modify contactnotification_id serial;
Alter table icinga_contactnotifications  modify instance_id bigint unsigned default 0;
Alter table icinga_contactnotifications  modify notification_id bigint unsigned default 0;
Alter table icinga_contactnotifications  modify contact_object_id bigint unsigned default 0;
Alter table icinga_contactnotifications  modify start_time_usec  int default 0;
Alter table icinga_contactnotifications  modify end_time_usec  int default 0;
Alter table icinga_contacts  modify contact_id serial;
Alter table icinga_contacts  modify instance_id bigint unsigned default 0;
Alter table icinga_contacts  modify config_type smallint default 0;
Alter table icinga_contacts  modify contact_object_id bigint unsigned default 0;
Alter table icinga_contacts  modify host_timeperiod_object_id bigint unsigned default 0;
Alter table icinga_contacts  modify service_timeperiod_object_id bigint unsigned default 0;
Alter table icinga_contacts  modify host_notifications_enabled smallint default 0;
Alter table icinga_contacts  modify service_notifications_enabled smallint default 0;
Alter table icinga_contacts  modify can_submit_commands smallint default 0;
Alter table icinga_contacts  modify notify_service_recovery smallint default 0;
Alter table icinga_contacts  modify notify_service_warning smallint default 0;
Alter table icinga_contacts  modify notify_service_unknown smallint default 0;
Alter table icinga_contacts  modify notify_service_critical smallint default 0;
Alter table icinga_contacts  modify notify_service_flapping smallint default 0;
Alter table icinga_contacts  modify notify_service_downtime smallint default 0;
Alter table icinga_contacts  modify notify_host_recovery smallint default 0;
Alter table icinga_contacts  modify notify_host_down smallint default 0;
Alter table icinga_contacts  modify notify_host_unreachable smallint default 0;
Alter table icinga_contacts  modify notify_host_flapping smallint default 0;
Alter table icinga_contacts  modify notify_host_downtime smallint default 0;
Alter table icinga_contactstatus  modify contactstatus_id serial;
Alter table icinga_contactstatus  modify instance_id bigint unsigned default 0;
Alter table icinga_contactstatus  modify contact_object_id bigint unsigned default 0;
Alter table icinga_contactstatus  modify host_notifications_enabled smallint default 0;
Alter table icinga_contactstatus  modify service_notifications_enabled smallint default 0;
Alter table icinga_contactstatus  modify modified_attributes  int default 0;
Alter table icinga_contactstatus  modify modified_host_attributes  int default 0;
Alter table icinga_contactstatus  modify modified_service_attributes  int default 0;
Alter table icinga_contact_addresses  modify contact_address_id serial;
Alter table icinga_contact_addresses  modify instance_id bigint unsigned default 0;
Alter table icinga_contact_addresses  modify contact_id bigint unsigned default 0;
Alter table icinga_contact_addresses  modify address_number smallint default 0;
Alter table icinga_contact_notificationcommands  modify contact_notificationcommand_id serial;
Alter table icinga_contact_notificationcommands  modify instance_id bigint unsigned default 0;
Alter table icinga_contact_notificationcommands  modify contact_id bigint unsigned default 0;
Alter table icinga_contact_notificationcommands  modify notification_type smallint default 0;
Alter table icinga_contact_notificationcommands  modify command_object_id bigint unsigned default 0;
Alter table icinga_customvariables  modify customvariable_id serial;
Alter table icinga_customvariables  modify instance_id bigint unsigned default 0;
Alter table icinga_customvariables  modify object_id bigint unsigned default 0;
Alter table icinga_customvariables  modify config_type smallint default 0;
Alter table icinga_customvariables  modify has_been_modified smallint default 0;
Alter table icinga_customvariablestatus  modify customvariablestatus_id serial;
Alter table icinga_customvariablestatus  modify instance_id bigint unsigned default 0;
Alter table icinga_customvariablestatus  modify object_id bigint unsigned default 0;
Alter table icinga_customvariablestatus  modify has_been_modified smallint default 0;
Alter table icinga_dbversion  modify dbversion_id serial;
Alter table icinga_downtimehistory  modify downtimehistory_id serial;
Alter table icinga_downtimehistory  modify instance_id bigint unsigned default 0;
Alter table icinga_downtimehistory  modify downtime_type smallint default 0;
Alter table icinga_downtimehistory  modify object_id bigint unsigned default 0;
Alter table icinga_downtimehistory  modify internal_downtime_id bigint unsigned default 0;
Alter table icinga_downtimehistory  modify triggered_by_id bigint unsigned default 0;
Alter table icinga_downtimehistory  modify is_fixed smallint default 0;
Alter table icinga_downtimehistory  modify duration smallint default 0;
Alter table icinga_downtimehistory  modify was_started smallint default 0;
Alter table icinga_downtimehistory  modify actual_start_time_usec  int default 0;
Alter table icinga_downtimehistory  modify actual_end_time_usec  int default 0;
Alter table icinga_downtimehistory  modify was_cancelled smallint default 0;
Alter table icinga_eventhandlers  modify eventhandler_id serial;
Alter table icinga_eventhandlers  modify instance_id bigint unsigned default 0;
Alter table icinga_eventhandlers  modify eventhandler_type smallint default 0;
Alter table icinga_eventhandlers  modify object_id bigint unsigned default 0;
Alter table icinga_eventhandlers  modify state smallint default 0;
Alter table icinga_eventhandlers  modify state_type smallint default 0;
Alter table icinga_eventhandlers  modify start_time_usec  int default 0;
Alter table icinga_eventhandlers  modify end_time_usec  int default 0;
Alter table icinga_eventhandlers  modify command_object_id bigint unsigned default 0;
Alter table icinga_eventhandlers  modify timeout smallint default 0;
Alter table icinga_eventhandlers  modify early_timeout smallint default 0;
Alter table icinga_eventhandlers  modify return_code smallint default 0;
Alter table icinga_externalcommands  modify externalcommand_id serial;
Alter table icinga_externalcommands  modify instance_id bigint unsigned default 0;
Alter table icinga_externalcommands  modify command_type smallint default 0;
Alter table icinga_flappinghistory  modify flappinghistory_id serial;
Alter table icinga_flappinghistory  modify instance_id bigint unsigned default 0;
Alter table icinga_flappinghistory  modify event_time_usec  int default 0;
Alter table icinga_flappinghistory  modify event_type smallint default 0;
Alter table icinga_flappinghistory  modify reason_type smallint default 0;
Alter table icinga_flappinghistory  modify flapping_type smallint default 0;
Alter table icinga_flappinghistory  modify object_id bigint unsigned default 0;
Alter table icinga_flappinghistory  modify internal_comment_id bigint unsigned default 0;
Alter table icinga_hostchecks  modify hostcheck_id serial;
Alter table icinga_hostchecks  modify instance_id bigint unsigned default 0;
Alter table icinga_hostchecks  modify host_object_id bigint unsigned default 0;
Alter table icinga_hostchecks  modify check_type smallint default 0;
Alter table icinga_hostchecks  modify is_raw_check smallint default 0;
Alter table icinga_hostchecks  modify current_check_attempt smallint default 0;
Alter table icinga_hostchecks  modify max_check_attempts smallint default 0;
Alter table icinga_hostchecks  modify state smallint default 0;
Alter table icinga_hostchecks  modify state_type smallint default 0;
Alter table icinga_hostchecks  modify start_time_usec  int default 0;
Alter table icinga_hostchecks  modify end_time_usec  int default 0;
Alter table icinga_hostchecks  modify command_object_id bigint unsigned default 0;
Alter table icinga_hostchecks  modify timeout smallint default 0;
Alter table icinga_hostchecks  modify early_timeout smallint default 0;
Alter table icinga_hostchecks  modify return_code smallint default 0;
Alter table icinga_hostdependencies  modify hostdependency_id serial;
Alter table icinga_hostdependencies  modify instance_id bigint unsigned default 0;
Alter table icinga_hostdependencies  modify config_type smallint default 0;
Alter table icinga_hostdependencies  modify host_object_id bigint unsigned default 0;
Alter table icinga_hostdependencies  modify dependent_host_object_id bigint unsigned default 0;
Alter table icinga_hostdependencies  modify dependency_type smallint default 0;
Alter table icinga_hostdependencies  modify inherits_parent smallint default 0;
Alter table icinga_hostdependencies  modify timeperiod_object_id bigint unsigned default 0;
Alter table icinga_hostdependencies  modify fail_on_up smallint default 0;
Alter table icinga_hostdependencies  modify fail_on_down smallint default 0;
Alter table icinga_hostdependencies  modify fail_on_unreachable smallint default 0;
Alter table icinga_hostescalations  modify hostescalation_id serial;
Alter table icinga_hostescalations  modify instance_id bigint unsigned default 0;
Alter table icinga_hostescalations  modify config_type smallint default 0;
Alter table icinga_hostescalations  modify host_object_id bigint unsigned default 0;
Alter table icinga_hostescalations  modify timeperiod_object_id bigint unsigned default 0;
Alter table icinga_hostescalations  modify first_notification smallint default 0;
Alter table icinga_hostescalations  modify last_notification smallint default 0;
Alter table icinga_hostescalations  modify escalate_on_recovery smallint default 0;
Alter table icinga_hostescalations  modify escalate_on_down smallint default 0;
Alter table icinga_hostescalations  modify escalate_on_unreachable smallint default 0;
Alter table icinga_hostescalation_contactgroups  modify hostescalation_contactgroup_id serial;
Alter table icinga_hostescalation_contactgroups  modify instance_id bigint unsigned default 0;
Alter table icinga_hostescalation_contactgroups  modify hostescalation_id bigint unsigned default 0;
Alter table icinga_hostescalation_contactgroups  modify contactgroup_object_id bigint unsigned default 0;
Alter table icinga_hostescalation_contacts  modify hostescalation_contact_id serial;
Alter table icinga_hostescalation_contacts  modify instance_id bigint unsigned default 0;
Alter table icinga_hostescalation_contacts  modify hostescalation_id bigint unsigned default 0;
Alter table icinga_hostescalation_contacts  modify contact_object_id bigint unsigned default 0;
Alter table icinga_hostgroups  modify hostgroup_id serial;
Alter table icinga_hostgroups  modify instance_id bigint unsigned default 0;
Alter table icinga_hostgroups  modify config_type smallint default 0;
Alter table icinga_hostgroups  modify hostgroup_object_id bigint unsigned default 0;
Alter table icinga_hostgroup_members  modify hostgroup_member_id serial;
Alter table icinga_hostgroup_members  modify instance_id bigint unsigned default 0;
Alter table icinga_hostgroup_members  modify hostgroup_id bigint unsigned default 0;
Alter table icinga_hostgroup_members  modify host_object_id bigint unsigned default 0;
Alter table icinga_hosts  modify host_id serial;
Alter table icinga_hosts  modify instance_id bigint unsigned default 0;
Alter table icinga_hosts  modify config_type smallint default 0;
Alter table icinga_hosts  modify host_object_id bigint unsigned default 0;
Alter table icinga_hosts  modify check_command_object_id bigint unsigned default 0;
Alter table icinga_hosts  modify eventhandler_command_object_id bigint unsigned default 0;
Alter table icinga_hosts  modify notification_timeperiod_object_id bigint unsigned default 0;
Alter table icinga_hosts  modify check_timeperiod_object_id bigint unsigned default 0;
Alter table icinga_hosts  modify max_check_attempts smallint default 0;
Alter table icinga_hosts  modify notify_on_down smallint default 0;
Alter table icinga_hosts  modify notify_on_unreachable smallint default 0;
Alter table icinga_hosts  modify notify_on_recovery smallint default 0;
Alter table icinga_hosts  modify notify_on_flapping smallint default 0;
Alter table icinga_hosts  modify notify_on_downtime smallint default 0;
Alter table icinga_hosts  modify stalk_on_up smallint default 0;
Alter table icinga_hosts  modify stalk_on_down smallint default 0;
Alter table icinga_hosts  modify stalk_on_unreachable smallint default 0;
Alter table icinga_hosts  modify flap_detection_enabled smallint default 0;
Alter table icinga_hosts  modify flap_detection_on_up smallint default 0;
Alter table icinga_hosts  modify flap_detection_on_down smallint default 0;
Alter table icinga_hosts  modify flap_detection_on_unreachable smallint default 0;
Alter table icinga_hosts  modify process_performance_data smallint default 0;
Alter table icinga_hosts  modify freshness_checks_enabled smallint default 0;
Alter table icinga_hosts  modify freshness_threshold smallint default 0;
Alter table icinga_hosts  modify passive_checks_enabled smallint default 0;
Alter table icinga_hosts  modify event_handler_enabled smallint default 0;
Alter table icinga_hosts  modify active_checks_enabled smallint default 0;
Alter table icinga_hosts  modify retain_status_information smallint default 0;
Alter table icinga_hosts  modify retain_nonstatus_information smallint default 0;
Alter table icinga_hosts  modify notifications_enabled smallint default 0;
Alter table icinga_hosts  modify obsess_over_host smallint default 0;
Alter table icinga_hosts  modify failure_prediction_enabled smallint default 0;
Alter table icinga_hosts  modify have_2d_coords smallint default 0;
Alter table icinga_hosts  modify x_2d smallint default 0;
Alter table icinga_hosts  modify y_2d smallint default 0;
Alter table icinga_hosts  modify have_3d_coords smallint default 0;
Alter table icinga_hoststatus  modify hoststatus_id serial;
Alter table icinga_hoststatus  modify instance_id bigint unsigned default 0;
Alter table icinga_hoststatus  modify host_object_id bigint unsigned default 0;
Alter table icinga_hoststatus  modify current_state smallint default 0;
Alter table icinga_hoststatus  modify has_been_checked smallint default 0;
Alter table icinga_hoststatus  modify should_be_scheduled smallint default 0;
Alter table icinga_hoststatus  modify current_check_attempt smallint default 0;
Alter table icinga_hoststatus  modify max_check_attempts smallint default 0;
Alter table icinga_hoststatus  modify check_type smallint default 0;
Alter table icinga_hoststatus  modify last_hard_state smallint default 0;
Alter table icinga_hoststatus  modify state_type smallint default 0;
Alter table icinga_hoststatus  modify no_more_notifications smallint default 0;
Alter table icinga_hoststatus  modify notifications_enabled smallint default 0;
Alter table icinga_hoststatus  modify problem_has_been_acknowledged smallint default 0;
Alter table icinga_hoststatus  modify acknowledgement_type smallint default 0;
Alter table icinga_hoststatus  modify current_notification_number smallint default 0;
Alter table icinga_hoststatus  modify passive_checks_enabled smallint default 0;
Alter table icinga_hoststatus  modify active_checks_enabled smallint default 0;
Alter table icinga_hoststatus  modify event_handler_enabled smallint default 0;
Alter table icinga_hoststatus  modify flap_detection_enabled smallint default 0;
Alter table icinga_hoststatus  modify is_flapping smallint default 0;
Alter table icinga_hoststatus  modify scheduled_downtime_depth smallint default 0;
Alter table icinga_hoststatus  modify failure_prediction_enabled smallint default 0;
Alter table icinga_hoststatus  modify process_performance_data smallint default 0;
Alter table icinga_hoststatus  modify obsess_over_host smallint default 0;
Alter table icinga_hoststatus  modify modified_host_attributes  int default 0;
Alter table icinga_hoststatus  modify check_timeperiod_object_id bigint unsigned default 0;
Alter table icinga_host_contactgroups  modify host_contactgroup_id serial;
Alter table icinga_host_contactgroups  modify instance_id bigint unsigned default 0;
Alter table icinga_host_contactgroups  modify host_id bigint unsigned default 0;
Alter table icinga_host_contactgroups  modify contactgroup_object_id bigint unsigned default 0;
Alter table icinga_host_contacts  modify host_contact_id serial;
Alter table icinga_host_contacts  modify instance_id bigint unsigned default 0;
Alter table icinga_host_contacts  modify host_id bigint unsigned default 0;
Alter table icinga_host_contacts  modify contact_object_id bigint unsigned default 0;
Alter table icinga_host_parenthosts  modify host_parenthost_id serial;
Alter table icinga_host_parenthosts  modify instance_id bigint unsigned default 0;
Alter table icinga_host_parenthosts  modify host_id bigint unsigned default 0;
Alter table icinga_host_parenthosts  modify parent_host_object_id bigint unsigned default 0;
Alter table icinga_instances  modify instance_id serial;
Alter table icinga_logentries  modify logentry_id serial;
Alter table icinga_logentries  modify instance_id bigint unsigned default 0;
Alter table icinga_logentries  modify entry_time_usec  int default 0;
Alter table icinga_logentries  modify logentry_type  int default 0;
Alter table icinga_logentries  modify realtime_data smallint default 0;
Alter table icinga_logentries  modify inferred_data_extracted smallint default 0;
Alter table icinga_notifications  modify notification_id serial;
Alter table icinga_notifications  modify instance_id bigint unsigned default 0;
Alter table icinga_notifications  modify notification_type smallint default 0;
Alter table icinga_notifications  modify notification_reason smallint default 0;
Alter table icinga_notifications  modify object_id bigint unsigned default 0;
Alter table icinga_notifications  modify start_time_usec  int default 0;
Alter table icinga_notifications  modify end_time_usec  int default 0;
Alter table icinga_notifications  modify state smallint default 0;
Alter table icinga_notifications  modify escalated smallint default 0;
Alter table icinga_notifications  modify contacts_notified smallint default 0;
Alter table icinga_objects  modify object_id serial;
Alter table icinga_objects  modify instance_id bigint unsigned default 0;
Alter table icinga_objects  modify objecttype_id bigint unsigned default 0;
Alter table icinga_objects  modify is_active smallint default 0;
Alter table icinga_processevents  modify processevent_id serial;
Alter table icinga_processevents  modify instance_id bigint unsigned default 0;
Alter table icinga_processevents  modify event_type smallint default 0;
Alter table icinga_processevents  modify event_time_usec  int default 0;
Alter table icinga_processevents  modify process_id bigint unsigned default 0;
Alter table icinga_programstatus  modify programstatus_id serial;
Alter table icinga_programstatus  modify instance_id bigint unsigned default 0;
Alter table icinga_programstatus  modify is_currently_running smallint default 0;
Alter table icinga_programstatus  modify process_id bigint unsigned default 0;
Alter table icinga_programstatus  modify daemon_mode smallint default 0;
Alter table icinga_programstatus  modify notifications_enabled smallint default 0;
Alter table icinga_programstatus  modify active_service_checks_enabled smallint default 0;
Alter table icinga_programstatus  modify passive_service_checks_enabled smallint default 0;
Alter table icinga_programstatus  modify active_host_checks_enabled smallint default 0;
Alter table icinga_programstatus  modify passive_host_checks_enabled smallint default 0;
Alter table icinga_programstatus  modify event_handlers_enabled smallint default 0;
Alter table icinga_programstatus  modify flap_detection_enabled smallint default 0;
Alter table icinga_programstatus  modify failure_prediction_enabled smallint default 0;
Alter table icinga_programstatus  modify process_performance_data smallint default 0;
Alter table icinga_programstatus  modify obsess_over_hosts smallint default 0;
Alter table icinga_programstatus  modify obsess_over_services smallint default 0;
Alter table icinga_programstatus  modify modified_host_attributes  int default 0;
Alter table icinga_programstatus  modify modified_service_attributes  int default 0;
Alter table icinga_runtimevariables  modify runtimevariable_id serial;
Alter table icinga_runtimevariables  modify instance_id bigint unsigned default 0;
Alter table icinga_scheduleddowntime  modify scheduleddowntime_id serial;
Alter table icinga_scheduleddowntime  modify instance_id bigint unsigned default 0;
Alter table icinga_scheduleddowntime  modify downtime_type smallint default 0;
Alter table icinga_scheduleddowntime  modify object_id bigint unsigned default 0;
Alter table icinga_scheduleddowntime  modify internal_downtime_id bigint unsigned default 0;
Alter table icinga_scheduleddowntime  modify triggered_by_id bigint unsigned default 0;
Alter table icinga_scheduleddowntime  modify is_fixed smallint default 0;
Alter table icinga_scheduleddowntime  modify duration smallint default 0;
Alter table icinga_scheduleddowntime  modify was_started smallint default 0;
Alter table icinga_scheduleddowntime  modify actual_start_time_usec  int default 0;
Alter table icinga_servicechecks  modify servicecheck_id serial;
Alter table icinga_servicechecks  modify instance_id bigint unsigned default 0;
Alter table icinga_servicechecks  modify service_object_id bigint unsigned default 0;
Alter table icinga_servicechecks  modify check_type smallint default 0;
Alter table icinga_servicechecks  modify current_check_attempt smallint default 0;
Alter table icinga_servicechecks  modify max_check_attempts smallint default 0;
Alter table icinga_servicechecks  modify state smallint default 0;
Alter table icinga_servicechecks  modify state_type smallint default 0;
Alter table icinga_servicechecks  modify start_time_usec  int default 0;
Alter table icinga_servicechecks  modify end_time_usec  int default 0;
Alter table icinga_servicechecks  modify command_object_id bigint unsigned default 0;
Alter table icinga_servicechecks  modify timeout smallint default 0;
Alter table icinga_servicechecks  modify early_timeout smallint default 0;
Alter table icinga_servicechecks  modify return_code smallint default 0;
Alter table icinga_servicedependencies  modify servicedependency_id serial;
Alter table icinga_servicedependencies  modify instance_id bigint unsigned default 0;
Alter table icinga_servicedependencies  modify config_type smallint default 0;
Alter table icinga_servicedependencies  modify service_object_id bigint unsigned default 0;
Alter table icinga_servicedependencies  modify dependent_service_object_id bigint unsigned default 0;
Alter table icinga_servicedependencies  modify dependency_type smallint default 0;
Alter table icinga_servicedependencies  modify inherits_parent smallint default 0;
Alter table icinga_servicedependencies  modify timeperiod_object_id bigint unsigned default 0;
Alter table icinga_servicedependencies  modify fail_on_ok smallint default 0;
Alter table icinga_servicedependencies  modify fail_on_warning smallint default 0;
Alter table icinga_servicedependencies  modify fail_on_unknown smallint default 0;
Alter table icinga_servicedependencies  modify fail_on_critical smallint default 0;
Alter table icinga_serviceescalations  modify serviceescalation_id serial;
Alter table icinga_serviceescalations  modify instance_id bigint unsigned default 0;
Alter table icinga_serviceescalations  modify config_type smallint default 0;
Alter table icinga_serviceescalations  modify service_object_id bigint unsigned default 0;
Alter table icinga_serviceescalations  modify timeperiod_object_id bigint unsigned default 0;
Alter table icinga_serviceescalations  modify first_notification smallint default 0;
Alter table icinga_serviceescalations  modify last_notification smallint default 0;
Alter table icinga_serviceescalations  modify escalate_on_recovery smallint default 0;
Alter table icinga_serviceescalations  modify escalate_on_warning smallint default 0;
Alter table icinga_serviceescalations  modify escalate_on_unknown smallint default 0;
Alter table icinga_serviceescalations  modify escalate_on_critical smallint default 0;
Alter table icinga_serviceescalation_contactgroups  modify serviceescalation_contactgroup_id serial;
Alter table icinga_serviceescalation_contactgroups  modify instance_id bigint unsigned default 0;
Alter table icinga_serviceescalation_contactgroups  modify serviceescalation_id bigint unsigned default 0;
Alter table icinga_serviceescalation_contactgroups  modify contactgroup_object_id bigint unsigned default 0;
Alter table icinga_serviceescalation_contacts  modify serviceescalation_contact_id serial;
Alter table icinga_serviceescalation_contacts  modify instance_id bigint unsigned default 0;
Alter table icinga_serviceescalation_contacts  modify serviceescalation_id bigint unsigned default 0;
Alter table icinga_serviceescalation_contacts  modify contact_object_id bigint unsigned default 0;
Alter table icinga_servicegroups  modify servicegroup_id serial;
Alter table icinga_servicegroups  modify instance_id bigint unsigned default 0;
Alter table icinga_servicegroups  modify config_type smallint default 0;
Alter table icinga_servicegroups  modify servicegroup_object_id bigint unsigned default 0;
Alter table icinga_servicegroup_members  modify servicegroup_member_id serial;
Alter table icinga_servicegroup_members  modify instance_id bigint unsigned default 0;
Alter table icinga_servicegroup_members  modify servicegroup_id bigint unsigned default 0;
Alter table icinga_servicegroup_members  modify service_object_id bigint unsigned default 0;
Alter table icinga_services  modify service_id serial;
Alter table icinga_services  modify instance_id bigint unsigned default 0;
Alter table icinga_services  modify config_type smallint default 0;
Alter table icinga_services  modify host_object_id bigint unsigned default 0;
Alter table icinga_services  modify service_object_id bigint unsigned default 0;
Alter table icinga_services  modify check_command_object_id bigint unsigned default 0;
Alter table icinga_services  modify eventhandler_command_object_id bigint unsigned default 0;
Alter table icinga_services  modify notification_timeperiod_object_id bigint unsigned default 0;
Alter table icinga_services  modify check_timeperiod_object_id bigint unsigned default 0;
Alter table icinga_services  modify max_check_attempts smallint default 0;
Alter table icinga_services  modify notify_on_warning smallint default 0;
Alter table icinga_services  modify notify_on_unknown smallint default 0;
Alter table icinga_services  modify notify_on_critical smallint default 0;
Alter table icinga_services  modify notify_on_recovery smallint default 0;
Alter table icinga_services  modify notify_on_flapping smallint default 0;
Alter table icinga_services  modify notify_on_downtime smallint default 0;
Alter table icinga_services  modify stalk_on_ok smallint default 0;
Alter table icinga_services  modify stalk_on_warning smallint default 0;
Alter table icinga_services  modify stalk_on_unknown smallint default 0;
Alter table icinga_services  modify stalk_on_critical smallint default 0;
Alter table icinga_services  modify is_volatile smallint default 0;
Alter table icinga_services  modify flap_detection_enabled smallint default 0;
Alter table icinga_services  modify flap_detection_on_ok smallint default 0;
Alter table icinga_services  modify flap_detection_on_warning smallint default 0;
Alter table icinga_services  modify flap_detection_on_unknown smallint default 0;
Alter table icinga_services  modify flap_detection_on_critical smallint default 0;
Alter table icinga_services  modify process_performance_data smallint default 0;
Alter table icinga_services  modify freshness_checks_enabled smallint default 0;
Alter table icinga_services  modify freshness_threshold smallint default 0;
Alter table icinga_services  modify passive_checks_enabled smallint default 0;
Alter table icinga_services  modify event_handler_enabled smallint default 0;
Alter table icinga_services  modify active_checks_enabled smallint default 0;
Alter table icinga_services  modify retain_status_information smallint default 0;
Alter table icinga_services  modify retain_nonstatus_information smallint default 0;
Alter table icinga_services  modify notifications_enabled smallint default 0;
Alter table icinga_services  modify obsess_over_service smallint default 0;
Alter table icinga_services  modify failure_prediction_enabled smallint default 0;
Alter table icinga_servicestatus  modify servicestatus_id serial;
Alter table icinga_servicestatus  modify instance_id bigint unsigned default 0;
Alter table icinga_servicestatus  modify service_object_id bigint unsigned default 0;
Alter table icinga_servicestatus  modify current_state smallint default 0;
Alter table icinga_servicestatus  modify has_been_checked smallint default 0;
Alter table icinga_servicestatus  modify should_be_scheduled smallint default 0;
Alter table icinga_servicestatus  modify current_check_attempt smallint default 0;
Alter table icinga_servicestatus  modify max_check_attempts smallint default 0;
Alter table icinga_servicestatus  modify check_type smallint default 0;
Alter table icinga_servicestatus  modify last_hard_state smallint default 0;
Alter table icinga_servicestatus  modify state_type smallint default 0;
Alter table icinga_servicestatus  modify no_more_notifications smallint default 0;
Alter table icinga_servicestatus  modify notifications_enabled smallint default 0;
Alter table icinga_servicestatus  modify problem_has_been_acknowledged smallint default 0;
Alter table icinga_servicestatus  modify acknowledgement_type smallint default 0;
Alter table icinga_servicestatus  modify current_notification_number smallint default 0;
Alter table icinga_servicestatus  modify passive_checks_enabled smallint default 0;
Alter table icinga_servicestatus  modify active_checks_enabled smallint default 0;
Alter table icinga_servicestatus  modify event_handler_enabled smallint default 0;
Alter table icinga_servicestatus  modify flap_detection_enabled smallint default 0;
Alter table icinga_servicestatus  modify is_flapping smallint default 0;
Alter table icinga_servicestatus  modify scheduled_downtime_depth smallint default 0;
Alter table icinga_servicestatus  modify failure_prediction_enabled smallint default 0;
Alter table icinga_servicestatus  modify process_performance_data smallint default 0;
Alter table icinga_servicestatus  modify obsess_over_service smallint default 0;
Alter table icinga_servicestatus  modify modified_service_attributes  int default 0;
Alter table icinga_servicestatus  modify check_timeperiod_object_id bigint unsigned default 0;
Alter table icinga_service_contactgroups  modify service_contactgroup_id serial;
Alter table icinga_service_contactgroups  modify instance_id bigint unsigned default 0;
Alter table icinga_service_contactgroups  modify service_id bigint unsigned default 0;
Alter table icinga_service_contactgroups  modify contactgroup_object_id bigint unsigned default 0;
Alter table icinga_service_contacts  modify service_contact_id serial;
Alter table icinga_service_contacts  modify instance_id bigint unsigned default 0;
Alter table icinga_service_contacts  modify service_id bigint unsigned default 0;
Alter table icinga_service_contacts  modify contact_object_id bigint unsigned default 0;
Alter table icinga_statehistory  modify statehistory_id serial;
Alter table icinga_statehistory  modify instance_id bigint unsigned default 0;
Alter table icinga_statehistory  modify state_time_usec  int default 0;
Alter table icinga_statehistory  modify object_id bigint unsigned default 0;
Alter table icinga_statehistory  modify state_change smallint default 0;
Alter table icinga_statehistory  modify state smallint default 0;
Alter table icinga_statehistory  modify state_type smallint default 0;
Alter table icinga_statehistory  modify current_check_attempt smallint default 0;
Alter table icinga_statehistory  modify max_check_attempts smallint default 0;
Alter table icinga_statehistory  modify last_state smallint default 0;
Alter table icinga_statehistory  modify last_hard_state smallint default 0;
Alter table icinga_systemcommands  modify systemcommand_id serial;
Alter table icinga_systemcommands  modify instance_id bigint unsigned default 0;
Alter table icinga_systemcommands  modify start_time_usec  int default 0;
Alter table icinga_systemcommands  modify end_time_usec  int default 0;
Alter table icinga_systemcommands  modify timeout smallint default 0;
Alter table icinga_systemcommands  modify early_timeout smallint default 0;
Alter table icinga_systemcommands  modify return_code smallint default 0;
Alter table icinga_timedeventqueue  modify timedeventqueue_id serial;
Alter table icinga_timedeventqueue  modify instance_id bigint unsigned default 0;
Alter table icinga_timedeventqueue  modify event_type smallint default 0;
Alter table icinga_timedeventqueue  modify queued_time_usec  int default 0;
Alter table icinga_timedeventqueue  modify recurring_event smallint default 0;
Alter table icinga_timedeventqueue  modify object_id bigint unsigned default 0;
Alter table icinga_timedevents  modify timedevent_id serial;
Alter table icinga_timedevents  modify instance_id bigint unsigned default 0;
Alter table icinga_timedevents  modify event_type smallint default 0;
Alter table icinga_timedevents  modify queued_time_usec  int default 0;
Alter table icinga_timedevents  modify event_time_usec  int default 0;
Alter table icinga_timedevents  modify recurring_event smallint default 0;
Alter table icinga_timedevents  modify object_id bigint unsigned default 0;
Alter table icinga_timedevents  modify deletion_time_usec  int default 0;
Alter table icinga_timeperiods  modify timeperiod_id serial;
Alter table icinga_timeperiods  modify instance_id bigint unsigned default 0;
Alter table icinga_timeperiods  modify config_type smallint default 0;
Alter table icinga_timeperiods  modify timeperiod_object_id bigint unsigned default 0;
Alter table icinga_timeperiod_timeranges  modify timeperiod_timerange_id serial;
Alter table icinga_timeperiod_timeranges  modify instance_id bigint unsigned default 0;
Alter table icinga_timeperiod_timeranges  modify timeperiod_id bigint unsigned default 0;
Alter table icinga_timeperiod_timeranges  modify day smallint default 0;
Alter table icinga_timeperiod_timeranges  modify start_sec  int default 0;
Alter table icinga_timeperiod_timeranges  modify end_sec  int default 0;


-- -----------------------------------------
-- update dbversion
-- -----------------------------------------

INSERT INTO icinga_dbversion (name, version) VALUES ('idoutils', '1.4.0') ON DUPLICATE KEY UPDATE version='1.4.0';

