/***************************************************************************
                           main.cpp
                             -------------------
    begin                : Don Apr 17 11:30:44 CEST 2003
    revision             : $Revision: 1.24 $
    last modified        : $Date: 2005/02/02 10:08:17 $ by $Author: juergenk $
    copyright            : (C) 2003-2005 by Jürgen Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 
 
#include "kaffeineapp.h"

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kdebug.h>

#include <X11/Xlib.h>

#include <stdlib.h>

static KCmdLineOptions options[] =
{
  { "p", 0, 0 },
  { "play", I18N_NOOP ("Start playing immediately"), 0 },
  { "f", 0, 0 },
  { "fullscreen", I18N_NOOP ("Start in fullscreen mode"), 0 },
  { "a", 0, 0 },
  { "audiodriver <argument>", I18N_NOOP ("Set audio driver"), "default" },
  { "x", 0, 0 },
  { "videodriver <argument>", I18N_NOOP ("Set video driver"), "default" },
  { "d", 0, 0 },
  { "device <argument>", I18N_NOOP ("Set Audio-CD/VCD/DVD device path."), "default"},
  { "verbose", I18N_NOOP ("Output xine debug messages"), 0 },
  { "w", 0, 0 },
  { "wizard", I18N_NOOP ("Run installation wizard"), 0 },
  { "+[file]", I18N_NOOP ("File(s) to play. Can be a local file, a URL, a directory or 'DVD', 'VCD', 'AudioCD'."), 0 },
  { 0, 0, 0 }
};


int main(int argc, char *argv[])
{
  /*
   *  XInitThreads() should always be the first call in multithreaded X programs -
   *  but because of a bug in older xfree versions that can freeze at startup -
   *  for this versions we call XInitThreads() in kxinewidget.cpp
   *  This should finaly fix the crash on closing with xfree 4.4.
   *
   *  kaffeinepart & konqueror: We call XInitThreads() in kxinewidget.cpp - so the part is not stable with xfree 4.4...
   *  The solution would be to add XInitThreads() in main() of konqueror.
   * 
   *  Mmmh, seems that kaffeine 0.5 no longer needs the XInitThreads() call, on exit free() prints out a warning 
   *  but no crash happens.
   */
   
#ifndef WITH_XORG  // configure flag with-xorg not set
#ifdef FamilyInternet6  /* in X.h since xfree version 4.3.99.10 */
  kdDebug() << "Main: XInitThreads()" << endl;
  kdDebug() << "[INFO] If Kaffeine hangs here run 'configure --with-xorg' and recompile/reinstall." << endl;
  XInitThreads();
#endif  
#endif

  KAboutData aboutData( "kaffeine", I18N_NOOP("Kaffeine Player"),
    VERSION, I18N_NOOP("A media player for KDE 3. Can use multiple backends for playback, default is xine."),
    KAboutData::License_GPL,
    "(c) 2003-2005, Jürgen Kofler", 0, "http://kaffeine.sourceforge.net", /*bug reports to:*/ "kaffeine-user@lists.sourceforge.net");

  aboutData.addAuthor("Jürgen Kofler", I18N_NOOP("Developer"), "kaffeine@gmx.net");
  aboutData.addAuthor("Christophe Thommeret", I18N_NOOP("DVB Support"), "hftom@wanadoo.fr");
  
  aboutData.addCredit("Anders Ellenshøj Andersen", I18N_NOOP("Logo animation for Kaffeine 0.5"), "andersa@ellenshoej.dk");
  aboutData.addCredit("Assaf Gillat", I18N_NOOP("Alternate encoding for meta tags. Many patches."), "gillata@gmail.com");
  aboutData.addCredit("Miguel Freitas", I18N_NOOP("xine post plugin handling. Many patches."), "miguel@cetuc.puc-rio.br", "http://www.xinehq.de");
  aboutData.addCredit("Giorgos Gousios", I18N_NOOP("Subtitle file import."), "gousiosg@cs.man.ac.uk");
  aboutData.addCredit("Michael Rolf", I18N_NOOP("M3U import. Testing."), "mi.rolf@gmx.net");
  
  
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); 

  if (!KaffeineApp::start()) 
  {
    exit (0);    /* can't start new instance */
  }
  
  KaffeineApp a;
  
  return a.exec();
}


