/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include "msgfmt.h"

#include <kapp.h>
#include <kprocess.h>

#include <qfileinfo.h>
#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qcstring.h>

#include <stdlib.h>

Msgfmt::Msgfmt(QObject* parent,const char* name)
      : QObject(parent , name)
{
}

Msgfmt::Status Msgfmt::checkSyntax(QString file,QString& output)
{
   Status stat=Ok;
   // this method does not return the right retrun values at the moment :-(

   KProcess proc;

   connect(&proc,SIGNAL(receivedStdout(KProcess*, char*, int)),
            this,SLOT(addToOutput(KProcess*,char *, int )));
   connect(&proc,SIGNAL(receivedStderr(KProcess *, char *, int)),
            this,SLOT(addToOutput(KProcess*,char *, int)));

   // remove last output
   _output="";


   proc << "msgfmt" << "--statistics" << "-o" << "/dev/null" << file;

   if(!proc.start(KProcess::Block,KProcess::Stderr))
   {
      stat=NoExecutable;
   }
   else if(proc.normalExit())
   {
       if( proc.exitStatus() || _output.contains(QRegExp("^.+:\\d+:")) ) // little workaround :-(
         stat=SyntaxError;
   }
   else
      stat=Error;

   output=_output;


   return stat;
}

Msgfmt::Status Msgfmt::checkSyntaxInDir(QString dir,QString regexp,QString& output)
{
   Status stat=Ok;

   // this method does not return the right return values at the moment :-(
   KShellProcess proc;

   connect(&proc,SIGNAL(receivedStdout(KProcess*, char*, int)),
            this,SLOT(addToOutput(KProcess*,char *, int )));
   connect(&proc,SIGNAL(receivedStderr(KProcess *, char *, int)),
            this,SLOT(addToOutput(KProcess*,char *, int)));

   // remove last output
   _output="";


   proc << "cd" << dir << ";" << "msgfmt" << "--statistics" << regexp;

   if(!proc.start(KProcess::Block,KProcess::Stderr))
   {
      stat=NoExecutable;
   }
   else if(proc.normalExit())
   {
       if( proc.exitStatus() || _output.contains(QRegExp("^.+:\\d+:")) ) // little workaround :-(
         stat=SyntaxError;
   }
   else
      stat=Error;

   output=_output;


   return stat;
}



void Msgfmt::addToOutput(KProcess*,char *buffer, int buflen)
{
   QCString newString(buffer,buflen+1);

   _output+=newString;
}


QString Msgfmt::tempSaveName()
{
   return kapp->tempSaveName("/tmp/kbabel_msgfmt.po");
}

#include "msgfmt.moc"
