/*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 * THIS FILE IS NO LONGER IN USE.  THE sim700 + lasi7xx DRIVER
 * HAS BEEN REPLACED BY A NEW 53c700 + lasi700 DRIVER, AND THIS
 * FILE WILL GO AWAY ONCE WE ARE HAPPY WITH THE NEW DRIVER.
 *XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 */

/*
 * sim700.c - Copyright (C) 1999 Richard Hirst <richard@sleepie.demon.co.uk>
 *
 *----------------------------------------------------------------------------
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------------
 *
 * TBD:
 *   wback/inv only the relevant bits of target pages, not whole page
 *   only wback/inv if on an old platform - auto detect?
 *   check for error paths where we forget to pci_unmap
 *   handle 'timeout' ints if 250ms of idle scsi bus while connected
 *
 *
 * MCA card detection code by Trent McNair.
 *
 * Various bits of code in this driver have been copied from 53c7,8xx,c,
 * which is coyright Drew Eckhardt.  The scripts for the SCSI chip are
 * compiled with the script compiler written by Drew.
 *
 * This is a simple driver for the NCR53c710.  More complex drivers
 * for this chip (e.g. 53c7xx.c) require that the scsi chip be able to
 * do DMA block moves between memory and on-chip registers, which can
 * be a problem if those registers are in the I/O address space.  There
 * can also be problems on hardware where the registers are memory
 * mapped, if the design is such that memory-to-memory transfers initiated
 * by the scsi chip cannot access the chip registers.
 *
 * This driver is designed to avoid these problems and is intended to
 * work with any Intel machines using 53c710 chips, including various
 * Compaq and NCR machines.  It was initially written for the Tadpole
 * TP34V VME board which is 68030 based.
 *
 * The driver supports boot-time parameters similar to
 *	sim700=addr:0x9000,irq:15
 * and insmod parameters similar to
 *	sim700="addr:0x9000 irq:15"
 *
 * The complete list of options are:
 *
 * addr:0x9000		Specifies the base I/O port (or address) of the 53C710.
 * irq:15		Specifies the IRQ number used by the 53c710.
 * debug:0xffff		Generates lots of debug output.
 * ignore:0x0a		Makes the driver ignore SCSI IDs 0 and 2.
 * nodisc:0x70		Prevents disconnects from IDs 6, 5 and 4.
 * noneg:0x10		Prevents SDTR negotiation on ID 4.
 * hosttype:1		Set host spcific options, 1 for Siemens PCE-5S
 *
 * Current limitations:
 *
 * o  Async only
 * o  Severely lacking in error recovery
 * o  Auto detection of IRQs and chip addresses only on MCA architectures
 *
 */

#define SIM700_C	/* Include whole of sim700.h */

#include <linux/config.h>
#include <linux/module.h>

#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/string.h>
#include <linux/ioport.h>
#include <linux/delay.h>
#include <linux/sched.h>
#include <linux/proc_fs.h>
#include <linux/init.h>
#include <linux/mca.h>
#include <linux/interrupt.h>
#include <asm/dma.h>
#include <asm/system.h>
#include <linux/spinlock.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include <asm/byteorder.h>
#include <linux/blk.h>
#include <linux/stat.h>
#include <linux/pci.h>		/* For dynamic dma mapping */

#include "scsi.h"
#include "hosts.h"
#include "sim700.h"
#ifdef __hppa__
#include "lasi7xx.h"
#endif

#define  CHECK_WBACK(addr,len) \
	do { if (!dma_consistent) dma_cache_wback((unsigned long)addr,len); } while (0)

#define  CHECK_INV(addr,len) \
	do { if (!dma_consistent) dma_cache_inv((unsigned long)addr,len); } while(0)

#define  CHECK_WBACK_INV(addr,len) \
	do { if (!dma_consistent) dma_cache_wback_inv((unsigned long)addr,len); } while (0)

#define DEBUG
#undef DEBUG_LIMIT_INTS		/* Define to 10 to hang driver after 10 ints */

/* Debug options available via the "debug:0x1234" parameter		*/

#define DEB_NONE	0x0000	/* Nothing				*/
#define DEB_HALT	0x0001	/* Detailed trace of chip halt funtion	*/
#define DEB_REGS	0x0002	/* All chip register read/writes	*/
#define DEB_SYNC	0x0004	/* Sync/async negotiation		*/
#define DEB_PMM		0x0008	/* Phase mis-match handling		*/
#define DEB_INTS	0x0010	/* General interrupt trace		*/
#define DEB_TOUT	0x0020	/* Selection timeouts			*/
#define DEB_RESUME	0x0040	/* Resume addresses for the script	*/
#define DEB_CMND	0x0080	/* Commands and status returned		*/
#define DEB_FIXUP	0x0100	/* Fixup of scsi addresses		*/
#define DEB_DISC	0x0200	/* Disconnect/reselect handling		*/

#define DEB_ANY		0xffff	/* Any and all debug options		*/

#ifdef DEBUG
#define DEB(m,x) do { if (sim700_debug & m) x; }  while(0)
int sim700_debug = DEB_NONE; //DEB_ANY & ~DEB_FIXUP;
#else
#define DEB(m,x)
#endif

/* Redefine scsi_done to force renegotiation of (a)sync transfers
 * following any failed command.
 */

#define SCSI_DONE(cmd)	{ \
	DEB(DEB_CMND, printk("scsi%d: Complete %08x\n", \
		host->host_no, cmd->result)); \
	if (cmd->result) \
	    hostdata->negotiate |= (1 << cmd->target); \
	cmd->scsi_done(cmd); \
    }

#ifndef offsetof
#define offsetof(t, m)      ((size_t) (&((t *)0)->m))
#endif

#define N_TARGETS		8	/* 7 at most really, if we assume the
					 * host is always ID 7, but 8 is
					 * safer for now.
					 */
#define STATE_INITIALISED	0
#define STATE_HALTED		1
#define STATE_IDLE		2
#define STATE_BUSY		3
#define STATE_DISABLED		4
#define STATE_ABORTING		5

#ifdef MODULE

char *sim700;		/* command line passed by insmod */

MODULE_AUTHOR("Richard Hirst");
MODULE_DESCRIPTION("Simple NCR 53C700 and 53C710 driver");
MODULE_PARM(sim700, "s");

#endif

static int sim700_errors = 0;	/* Count of error interrupts */
static int sim700_intrs = 0;	/* Count of all interrupts */
static int ignore_ids = 0x00;	/* Accept all SCSI IDs */
static int opt_nodisc = 0x00;	/* Allow disconnect on all IDs */
static int opt_noneg = 0x00;	/* Allow SDTR negotiation on all IDs */
static int hosttype = 0;	/* Host specific options */
static int opt_base = 0;	/* Base addr from cmndline */
static int opt_irq = 0;		/* IRQ number from cmndline */

static int dma_consistent = 1;	/* Zero if pci_alloc_consistent() fails */

/* The SCSI Script!!! */

#include "sim700_d.h"

#define MAX_SG		128	/* Scatter/Gather elements */

#define MAX_MSGOUT	8
#define MAX_MSGIN	8
#define MAX_CMND	12
#define MAX_STATUS	1

struct sim700_hostdata{
    int state;				/* Chip Running, Idle, etc	*/
    u32 options;			/* Misc control flags		*/
    long addr8_flip;			/* 0 if chip LE, 3 if BE	*/
    Scsi_Cmnd * issue_queue;		/* Outstanding commands		*/
    Scsi_Cmnd * running;		/* Currently executing cmd	*/
    int chip;				/* 700, 710, etc		*/
    u8 negotiate;			/* Bitfield, set = do SDTR	*/
    u32 test1_src __attribute__ ((aligned (4)));
    u32 test1_dst;
    void *targets;			/* Per target data		*/
    void *bounce_bufs;			/* One page for 8 bounce bufs	*/
    dma_addr_t targets_busaddr;		/* Bus address of target data	*/
};

/* We have eight sim700_target structs, each in its own page.  The
 * 8th page is used for common scripts (wait reselect, etc).  In fact
 * all scripts exist in each of the 8 pages, but the common bits are
 * only used in the 8th page.
 */

#define HOST_ID		7		/* Common script page		*/

struct sim700_target {
    u32 script[sizeof(SCRIPT)/4] __attribute__ ((aligned (4)));
    u32 din_script[MAX_SG * 2 + 2];
    u32 dout_script[MAX_SG * 2 + 2];
    Scsi_Cmnd *cur_cmd;			/* Current cmd for this target	*/
    u32 resume_offset;			/* Where to resume on reselect	*/
    u32 din_script_start_index;
    u32 din_script_end_index;
    u32 dout_script_start_index;
    u32 dout_script_end_index;
    u8 reselected_identify;		/* Reselecting LUN - ignored	*/
    u8 msg_reject;			/* MESSAGE_REJECT message byte	*/
    u8  targ_msgout[MAX_MSGOUT];
    u8  targ_msgin[MAX_MSGIN];
    u8  targ_cdb[MAX_CMND];
    u8  targ_status[MAX_STATUS];
    struct sim700_target *ba;		/* Bus address of this struct	*/
    void *virt_addr;			/* non-sg virt buffer address	*/
    dma_addr_t bus_addr;		/* non-sg bus buffer address	*/
    struct {				/* Bounce buffer params for	*/
	void *buf;			/*   non-cacheline aligned	*/
	void *addr;			/*     transfers.		*/
        u32  len;			/* Non-zero if copy needed	*/
    } bounce;
};

/* Convert a target ID in to a targdata pointer				*/
#define TARGDATA(x)	((struct sim700_target *) \
				(hostdata->targets + ((x) << PAGE_SHIFT)))

/* Convert a bus address (assumed to be from DSP_REG) in to a target ID	*/
#define TARGET(x)	((x) < hostdata->targets_busaddr || \
		(x) >= hostdata->targets_busaddr + (8 << PAGE_SHIFT) ? \
			-1 : ((x) - hostdata->targets_busaddr) >> PAGE_SHIFT)

/* Template to request asynchronous transfers */

static const unsigned char async_message[] = {
    EXTENDED_MESSAGE, 3 /* length */, EXTENDED_SDTR, 0, 0 /* asynchronous */};


static void sim700_intr_handle(int irq, void *dev_id, struct pt_regs *regs);
static void do_sim700_intr_handle(int irq, void *dev_id, struct pt_regs *regs);
static __inline__ void run_process_issue_queue(struct sim700_hostdata *);
static void process_issue_queue (struct sim700_hostdata *, unsigned long flags);
static int full_reset(struct Scsi_Host * host);


/*
 * Function : static void ncr_dump (struct Scsi_Host *host)
 *
 * Purpose :  Dump (possibly) useful info
 *
 * Inputs : host - pointer to this host adapter's structure
 */
  
static void
ncr_dump (struct Scsi_Host *host)
{
    unsigned long flags;
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;
 
    save_flags(flags);
    cli();
    printk("scsi%d: Chip register contents:\n", host->host_no);
    printk(" (script[0] at virt %p, bus %x)\n",
	hostdata->targets, hostdata->targets_busaddr);

    /* Only real differences between these two is that DMODE_REG is at a
     * different place, and DSA, LCRC, SCRATCH, and ADDER don't exist on
     * the 700.
     */
    if (hostdata->chip == 700) {
	printk(" 00  sien:  %02x  sdid:  %02x  scntl1:%02x  scntl0:%02x\n"
           " 04  socl:  %02x  sodl:  %02x  sxfer: %02x  scid:  %02x\n"
           " 08  sbcl:  %02x  sbdl:  %02x  sidl:  %02x  sfbr:  %02x\n"
           " 0C  sstat2:%02x  sstat1:%02x  sstat0:%02x  dstat: %02x\n"
	   " 10\n"
           " 14  ctest3:%02x  ctest2:%02x  ctest1:%02x  ctest0:%02x\n"
           " 18  ctest7:%02x  ctest6:%02x  ctest5:%02x  ctest4:%02x\n"
           " 1C  temp:  %08x\n"
           " 20              ctest8:%02x  istat: %02x  dfifo: %02x\n"
           " 24  dbc:   %08x  dnad:  %08x  dsp:   %08x\n"
           " 30  dsps:  %08x\n"
	   " 34  dmode: %02x\n"
           " 38  dcntl: %02x  dwt:   %02x  dien:  %02x\n"
	   " 3C\n",
	   NCR_read8(SIEN_REG), NCR_read8(SDID_REG), NCR_read8(SCNTL1_REG),
	   NCR_read8(SCNTL0_REG), NCR_read8(SOCL_REG), NCR_read8(SODL_REG),
	   NCR_read8(SXFER_REG), NCR_read8(SCID_REG), NCR_read8(SBCL_REG),
	   NCR_read8(SBDL_REG), NCR_read8(SIDL_REG), NCR_read8(SFBR_REG),
	   NCR_read8(SSTAT2_REG), NCR_read8(SSTAT1_REG), NCR_read8(SSTAT0_REG),
	   NCR_read8(DSTAT_REG), NCR_read8(CTEST3_REG),
	   NCR_read8(CTEST2_REG), NCR_read8(CTEST1_REG), NCR_read8(CTEST0_REG),
	   NCR_read8(CTEST7_REG), NCR_read8(CTEST6_REG), NCR_read8(CTEST5_REG),
	   NCR_read8(CTEST4_REG), NCR_read8(TEMP_REG),
	   NCR_read8(CTEST8_REG), NCR_read8(ISTAT_REG), NCR_read8(DFIFO_REG),
	   NCR_read32(DBC_REG), NCR_read32(DNAD_REG), NCR_read32(DSP_REG),
	   NCR_read32(DSPS_REG), NCR_read8(DMODE_REG_700), NCR_read8(DCNTL_REG),
	   NCR_read8(DWT_REG), NCR_read8(DIEN_REG));
    }
    else {
	printk(" 00  sien:  %02x  sdid:  %02x  scntl1:%02x  scntl0:%02x\n"
           " 04  socl:  %02x  sodl:  %02x  sxfer: %02x  scid:  %02x\n"
           " 08  sbcl:  %02x  sbdl:  %02x  sidl:  %02x  sfbr:  %02x\n"
           " 0C  sstat2:%02x  sstat1:%02x  sstat0:%02x  dstat: %02x\n"
           " 10  dsa:   %08x\n"
           " 14  ctest3:%02x  ctest2:%02x  ctest1:%02x  ctest0:%02x\n"
           " 18  ctest7:%02x  ctest6:%02x  ctest5:%02x  ctest4:%02x\n"
           " 1C  temp:  %08x\n"
           " 20  lcrc:  %02x  ctest8:%02x  istat: %02x  dfifo: %02x\n"
           " 24  dbc:   %08x  dnad:  %08x  dsp:   %08x\n"
           " 30  dsps:  %08x  scratch:%08x\n"
           " 38  dcntl: %02x  dwt:   %02x  dien:  %02x  dmode: %02x\n"
           " 3C  adder: %08x\n",
	   NCR_read8(SIEN_REG), NCR_read8(SDID_REG), NCR_read8(SCNTL1_REG),
	   NCR_read8(SCNTL0_REG), NCR_read8(SOCL_REG), NCR_read8(SODL_REG),
	   NCR_read8(SXFER_REG), NCR_read8(SCID_REG), NCR_read8(SBCL_REG),
	   NCR_read8(SBDL_REG), NCR_read8(SIDL_REG), NCR_read8(SFBR_REG),
	   NCR_read8(SSTAT2_REG), NCR_read8(SSTAT1_REG), NCR_read8(SSTAT0_REG),
	   NCR_read8(DSTAT_REG), NCR_read32(DSA_REG), NCR_read8(CTEST3_REG),
	   NCR_read8(CTEST2_REG), NCR_read8(CTEST1_REG), NCR_read8(CTEST0_REG),
	   NCR_read8(CTEST7_REG), NCR_read8(CTEST6_REG), NCR_read8(CTEST5_REG),
	   NCR_read8(CTEST4_REG), NCR_read8(TEMP_REG), NCR_read8(LCRC_REG),
	   NCR_read8(CTEST8_REG), NCR_read8(ISTAT_REG), NCR_read8(DFIFO_REG),
	   NCR_read32(DBC_REG), NCR_read32(DNAD_REG), NCR_read32(DSP_REG),
	   NCR_read32(DSPS_REG), NCR_read32(SCRATCH_REG), NCR_read8(DCNTL_REG),
	   NCR_read8(DWT_REG), NCR_read8(DIEN_REG), NCR_read8(DMODE_REG_710),
	   NCR_read32(ADDER_REG));
    }
    restore_flags(flags);
}



/*
 * Function: int param_setup(char *str)
 */

static int
param_setup(char *str)
{
    char *cur = str;
    char *pc, *pv;
    int val;
    int base;
    int c;

    while (cur != NULL && (pc = strchr(cur, ':')) != NULL) {
	char *pe;

	val = 0;
	pv = pc;
	c = *++pv;

	if (c == 'n')
	    val = 0;
	else if	(c == 'y')
	    val = 1;
	else {
	    base = 0;
	    val = (int) simple_strtoul(pv, &pe, base);
	}
	if (!strncmp(cur, "addr:", 5))
	    opt_base = val;
	else if	(!strncmp(cur, "irq:", 4))
	    opt_irq = val;
	else if	(!strncmp(cur, "ignore:", 7))
	    ignore_ids = val;
	else if	(!strncmp(cur, "nodisc:", 7))
	    opt_nodisc = val;
	else if	(!strncmp(cur, "noneg:", 6))
	    opt_noneg = val;
	else if (!strncmp(cur, "hosttype:", 9))
	    hosttype = val;
#ifdef DEBUG
	else if (!strncmp(cur, "debug:", 6))
	    sim700_debug = val;
#endif
	else
	    printk("sim700: unexpected boot option '%.*s' ignored\n", (int)(pc-cur+1), cur);

	/* Allow ',', ' ', or '+' seperators.  Used to be ',' at boot and
	 * ' ' for module load, some installers crap out on the space and
	 * insmod doesn't like the comma.
	 */
	if ((pv = strchr(cur, ',')) || (pv = strchr(cur, ' ')) ||
		(pv = strchr(cur, '+')))
	    cur = pv + 1;
	else
	    break;
    }
    return 1;
}

#ifndef MODULE
__setup("sim700=", param_setup);
#endif


/*
 * Function: static const char *sbcl_to_phase (int sbcl)
 */

static const char *
sbcl_to_phase (int sbcl) {
    switch (sbcl & SBCL_PHASE_MASK) {
    case SBCL_PHASE_DATAIN:
	return "DATAIN";
    case SBCL_PHASE_DATAOUT:
	return "DATAOUT";
    case SBCL_PHASE_MSGIN:
	return "MSGIN";
    case SBCL_PHASE_MSGOUT:
	return "MSGOUT";
    case SBCL_PHASE_CMDOUT:
	return "CMDOUT";
    case SBCL_PHASE_STATIN:
	return "STATUSIN";
    default:
	return "unknown";
    }
}


/*
 * Function : static int ncr_halt (struct Scsi_Host *host)
 *
 * Purpose : halts the SCSI SCRIPTS(tm) processor on the NCR chip
 *
 * Inputs : host - SCSI chip to halt
 *
 * Returns : 0 on success
 */

static int
ncr_halt (struct Scsi_Host *host)
{
    unsigned long flags;
    unsigned char istat, tmp;
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;
    int stage;
    int timeout;
    int res = 0;

    save_flags(flags);
    cli();
    /* Stage 0 : eat all interrupts
       Stage 1 : set ABORT
       Stage 2 : eat all but abort interrupts
       Stage 3 : eat all interrupts
       We loop for 50000 times with a delay of 10us which should give us
       about half a second.
     */
    for (stage = 0, timeout = 50000; timeout; timeout--) {
	if (stage == 1) {
	    DEB(DEB_HALT, printk("ncr_halt: writing ISTAT_ABRT\n"));
	    NCR_write8(ISTAT_REG, ISTAT_ABRT);
	    ++stage;
	}
	istat = NCR_read8 (ISTAT_REG);
	if (istat & ISTAT_SIP) {
	    DEB(DEB_HALT, printk("ncr_halt: got ISTAT_SIP, istat=%02x\n", istat));
	    tmp = NCR_read8(SSTAT0_REG);
	    DEB(DEB_HALT, printk("ncr_halt: got SSTAT0_REG=%02x\n", tmp));
	} else if (istat & ISTAT_DIP) {
	    DEB(DEB_HALT, printk("ncr_halt: got ISTAT_DIP, istat=%02x\n", istat));
	    tmp = NCR_read8(DSTAT_REG);
	    DEB(DEB_HALT, printk("ncr_halt: got DSTAT_REG=%02x\n", tmp));
	    if (stage == 2) {
		if (tmp & DSTAT_ABRT) {
	    	    DEB(DEB_HALT, printk("ncr_halt: got DSTAT_ABRT, clearing istat\n"));
		    NCR_write8(ISTAT_REG, 0);
		    ++stage;
		} else {
		    res = 1;	/* Indicate failure */
		    break;
	    	}
    	    }
	}
	if (!(istat & (ISTAT_SIP|ISTAT_DIP))) {
	    if (stage == 0)
	    	++stage;
	    else if (stage == 3)
		break;
	}
	udelay(10);
    }
    restore_flags(flags);

    if (timeout == 0 || res) {
	printk(KERN_ALERT "scsi%d: could not halt NCR chip, stage %d\n",
			host->host_no, stage);
	return 1;
    }
    else {
	hostdata->state = STATE_HALTED;
	return 0;
    }
}

/*
 * Function : static void sim700_soft_reset (struct Scsi_Host *host)
 *
 * Purpose :  perform a soft reset of the NCR53c7xx chip
 *
 * Inputs : host - pointer to this host adapter's structure
 *
 * Preconditions : sim700_init must have been called for this
 *      host.
 *
 */

static void
sim700_soft_reset (struct Scsi_Host *host)
{
    unsigned long flags;
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;

    save_flags(flags);
    cli();
    /*
     * Do a soft reset of the chip so that everything is
     * reinitialized to the power-on state.
     *
     * Basically follow the procedure outlined in the NCR53c700
     * data manual under Chapter Six, How to Use, Steps Necessary to
     * Start SCRIPTS, with the exception of actually starting the
     * script and setting up the synchronous transfer gunk.
     */

    /* XXX Should we reset the scsi bus here? */

    NCR_write8(SCNTL1_REG, SCNTL1_RST);		/* Reset the bus */
    udelay(50);
    NCR_write8(SCNTL1_REG, 0);

    if (hostdata->chip == 710) {
	NCR_write8(ISTAT_REG, ISTAT_10_SRST);	/* Reset the chip */
	udelay(50);
	NCR_write8(ISTAT_REG, 0);

	mdelay(1000);				/* Let devices recover */

	NCR_write8(DCNTL_REG, DCNTL_10_COM | DCNTL_700_CF_3);
	NCR_write8(CTEST7_REG, CTEST7_10_CDIS | CTEST7_STD |
		((hostdata->options & OPT_NCR_DIFF) ? CTEST7_DIFF : 0));
	NCR_write8(DMODE_REG_710, DMODE_10_BL_8 | DMODE_10_FC2);
	NCR_write8(SCID_REG, 1 << host->this_id);
	NCR_write8(SBCL_REG, 0);
	NCR_write8(SXFER_REG, 0);
	NCR_write8(SCNTL1_REG, SCNTL1_ESR_700);
	NCR_write8(SCNTL0_REG, SCNTL0_EPC | SCNTL0_EPG_700 | SCNTL0_ARB1 |
		SCNTL0_ARB2);
	NCR_write8(DIEN_REG, DIEN_700_BF |
		DIEN_ABRT | DIEN_SSI | DIEN_SIR | DIEN_700_OPC);
	NCR_write8(SIEN_REG_700,
	    SIEN_PAR | SIEN_700_STO | SIEN_RST | SIEN_UDC | SIEN_SGE | SIEN_MA);
    }
    else {
	/* Must be a 53c700 */
	NCR_write8(DCNTL_REG, DCNTL_700_SRST);	/* Reset the chip */
	udelay(50);
	NCR_write8(DCNTL_REG, 0);

	mdelay(1000);				/* Let devices recover */

	NCR_write8(SCNTL0_REG, SCNTL0_ARB1 | SCNTL0_ARB2 /* | SCNTL0_EPC */ | SCNTL0_EPG_700);
	NCR_write8(SCNTL1_REG, SCNTL1_ESR_700);
	/* XXX Bit 4, selected/reselected int?  Bit 6, FC bit? */
	NCR_write8(SIEN_REG_700,
	    SIEN_PAR | SIEN_RST | SIEN_UDC | SIEN_SGE | SIEN_700_STO | SIEN_MA);
	NCR_write8(SCID_REG, 1 << host->this_id);
	NCR_write8(SXFER_REG, 0);
	NCR_write8(DMODE_REG_700, DMODE_10_BL_4);
	NCR_write8(DIEN_REG, DIEN_ABRT | DIEN_SSI | DIEN_SIR | DIEN_700_OPC);
	NCR_write8(DCNTL_REG, DCNTL_700_CF_1);
    }

    restore_flags(flags);
}


/*
 * Function : static void sim700_driver_init (struct Scsi_Host *host)
 *
 * Purpose : Initialize internal structures, as required on startup, or
 *	after a SCSI bus reset.
 *
 * Inputs : host - pointer to this host adapter's structure
 */

static void
sim700_driver_init (struct Scsi_Host *host)
{
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;
    int i, targ;

    hostdata->running = NULL;

    for (targ = 0; targ < N_TARGETS; targ++) {
        struct sim700_target *targdata = TARGDATA(targ);

	targdata->ba = (struct sim700_target *)(unsigned long)
			(hostdata->targets_busaddr + (targ << PAGE_SHIFT));
	targdata->msg_reject = MESSAGE_REJECT;
	memcpy (targdata->script, SCRIPT, sizeof(SCRIPT));
	for (i = 0; i < PATCHES; i++)
	    targdata->script[LABELPATCHES[i]] += low32(targdata->ba->script);
	if (NCR_LE_CPU_BE) {
	    for (i = 0; i < sizeof(SCRIPT)/4; i++)
		targdata->script[i] = cpu_to_le32(targdata->script[i]);
	}
	patch_add_32 (targdata->script, 0, msg_reject, 
    		low32(&(targdata->ba->msg_reject)));
#if 0	/* test1_src/dst need to be in targdata if we ever use them */
	patch_add_32 (targdata->script, 0, test1_src, 
    		low32(&(hostbus->test1_src));)
	patch_add_32 (targdata->script, 0, test1_dst, 
    		low32(&(hostbus->test1_dst)));
#endif
	patch_add_32 (targdata->script, 0, reselected_identify, 
    		low32(&(targdata->ba->reselected_identify)));
	patch_abs_8c (targdata->script, 0, targ_select, 1 << targ);
	patch_add_32 (targdata->script, 0, targ_cdb, 
    		low32(&(targdata->ba->targ_cdb)));
	patch_add_32 (targdata->script, 0, targ_msgout, 
    		low32(&(targdata->ba->targ_msgout)));
	patch_add_32 (targdata->script, 0, targ_msgin, 
    		low32(&(targdata->ba->targ_msgin)));
	patch_add_32 (targdata->script, 0, targ_status, 
    		low32(&(targdata->ba->targ_status)));
	/* Build 'JUMP end_data_trans' at end of din/dout scripts */
	targdata->din_script_start_index =
	    (low32(targdata->din_script) - low32(targdata->script))/sizeof(u32);
	targdata->din_script_end_index =
	    targdata->din_script_start_index + MAX_SG * 2;
	targdata->din_script[MAX_SG*2] = cpu_to_ncr32(0x80080000);
	targdata->din_script[MAX_SG*2+1] =
		cpu_to_ncr32(low32(targdata->ba->script + Ent_end_data_trans/4));
	targdata->dout_script_start_index =
	    (low32(targdata->dout_script) - low32(targdata->script))/sizeof(u32);
	targdata->dout_script_end_index =
	    targdata->dout_script_start_index + MAX_SG * 2;
	targdata->dout_script[MAX_SG*2] = cpu_to_ncr32(0x80080000);
	targdata->dout_script[MAX_SG*2+1] =
		cpu_to_ncr32(low32(targdata->ba->script + Ent_end_data_trans/4));
	targdata->bounce.buf = hostdata->bounce_bufs + (targ * PAGE_SIZE/8);
	if (hostdata->chip == 700) {
	    /* Need to zap the register-to-register instructions that are
	     * used on 710 to disable the selection timer, as they are
	     * illegal on 53c700.  This patches them to be jumps to the
	     * next instruction.
	     */
	    targdata->script[Ent_zap700a/4] = cpu_to_ncr32(0x80080000);
	    targdata->script[Ent_zap700a/4+1] = cpu_to_ncr32(low32(targdata->ba->script + Ent_zap700a/4 + 2));
	    targdata->script[Ent_zap700b/4] = cpu_to_ncr32(0x80080000);
	    targdata->script[Ent_zap700b/4+1] = cpu_to_ncr32(low32(targdata->ba->script + Ent_zap700b/4 + 2));
	    targdata->script[Ent_zap700c/4] = cpu_to_ncr32(0x80080000);
	    targdata->script[Ent_zap700c/4+1] = cpu_to_ncr32(low32(targdata->ba->script + Ent_zap700c/4 + 2));
	    targdata->script[Ent_zap700d/4] = cpu_to_ncr32(0x80080000);
	    targdata->script[Ent_zap700d/4+1] = cpu_to_ncr32(low32(targdata->ba->script + Ent_zap700d/4 + 2));
	}
    }
    hostdata->state = STATE_INITIALISED;
    hostdata->negotiate = 0xff;
}


/* Handle incoming Synchronous data transfer request.  If our negotiate
 * flag is set then this is a response to our request, otherwise it is
 * spurious request from the target.  Don't really expect target initiated
 * SDTRs, because we always negotiate on the first command.  Could still
 * get them though..
 * The chip is currently paused with ACK asserted on the last byte of the
 * SDTR.
 * resa is the resume address if the message is in response to our outgoing
 * SDTR.  Only possible on initial identify.
 * resb is the resume address if the message exchange is initiated by the
 * target.
 */

static u32
handle_sdtr (struct Scsi_Host * host, Scsi_Cmnd * cmd, u32 resa, u32 resb)
{
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;
    struct sim700_target *targdata = TARGDATA(cmd->target);
    u32 resume_offset;

    if (resa && hostdata->negotiate & (1 << cmd->target)) {
	DEB(DEB_SYNC, printk("scsi%d: Response to host SDTR = %02x %02x\n",
		host->host_no, targdata->targ_msgin[3], targdata->targ_msgin[4]));
	/* We always issue an SDTR with the identify, so we must issue
	 * the CDB next.
	 */
	resume_offset = resa;
	hostdata->negotiate &= ~(1 << cmd->target);
    }
    else {
	DEB(DEB_SYNC, printk("scsi%d: Target initiated SDTR = %02x %02x\n",
		host->host_no, targdata->targ_msgin[3], targdata->targ_msgin[4]));
	memcpy(targdata->targ_msgout, async_message, sizeof(async_message));
	patch_abs_24 (targdata->script, 0, targ_msgout_cnt, 
    		sizeof(async_message));
	/* I guess the target could do this anytime; we have to send our
	 * response, and then continue (sending the CDB if not already done).
	 */
	resume_offset = resb;
    }
    return resume_offset;
}


/*
 * Function : static u32 handle_rej()
 *
 * Purpose : Handle a MSG REJECT from target.  Only expected in response
 *           to an SDTR.  The anticipated resume offset is passed in so that
 *           we can override it and return zero if the reject was unexpected.
 */
static u32
handle_rej (struct Scsi_Host * host, Scsi_Cmnd * cmd, u32 resa)
{
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;
    u32 resume_offset;

    if (hostdata->negotiate & (1 << cmd->target)) {
	DEB(DEB_SYNC, printk("scsi%d: Response to host SDTR = MSG REJECT\n",
		host->host_no));
	/* Assume the traget wants to go async */
	resume_offset = resa;
	hostdata->negotiate &= ~(1 << cmd->target);
    }
    else {
	DEB(DEB_SYNC, printk("scsi%d: Target sent spurious MSG REJECT!\n",
		host->host_no));
	resume_offset = 0;
    }
    return resume_offset;
}


/*
 * Function : static int datapath_residual (Scsi_Host *host)
 *
 * Purpose : return residual data count of what's in the chip.
 *
 * Inputs : host - SCSI host
 */

static int
datapath_residual (struct Scsi_Host *host) {
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;
    int count, synchronous, sstat;
    unsigned int ddir;

    synchronous = NCR_read8 (SXFER_REG) & SXFER_MO_MASK;
    ddir = NCR_read8 (CTEST0_REG_700) & CTEST0_700_DDIR;

    if (hostdata->chip == 700) {
	/* XXX Not at all sure about this.... */
	count = ((NCR_read8 (DFIFO_REG) & DFIFO_00_BO_MASK) -
	(NCR_read32 (DBC_REG) & DFIFO_00_BO_MASK)) & DFIFO_00_BO_MASK;

	if (ddir) {
	    /* Receive */
	} else {
	    /* Send */
	    sstat = NCR_read8 (SSTAT1_REG);
	    if (sstat & SSTAT1_OLF)
		++count;
	    if (synchronous && (sstat & SSTAT1_ORF))
		++count;
	}
    }
    else {
	count = ((NCR_read8 (DFIFO_REG) & DFIFO_10_BO_MASK) -
	(NCR_read32 (DBC_REG) & DFIFO_10_BO_MASK)) & DFIFO_10_BO_MASK;

	if (ddir) {
	/* Receive */
	    if (synchronous) 
		count += (NCR_read8 (SSTAT2_REG) & SSTAT2_FF_MASK) >> SSTAT2_FF_SHIFT;
	    else if (NCR_read8 (SSTAT1_REG) & SSTAT1_ILF)
		++count;
	} else {
	    /* Send */
	    sstat = NCR_read8 (SSTAT1_REG);
	    if (sstat & SSTAT1_OLF)
		++count;
	    if (synchronous && (sstat & SSTAT1_ORF))
		++count;
	}
    }
    return count;
}


static u32
handle_idd (struct Scsi_Host * host, Scsi_Cmnd * cmd)
{
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;
    struct sim700_target *targdata = TARGDATA(cmd->target);
    u32 resume_offset = 0, index;
    int dma_dir = scsi_to_pci_dma_dir(cmd->sc_data_direction);
    index = low32((u32 *)(unsigned long)NCR_read32(DSP_REG) - targdata->ba->script);

    switch (index) {
    case Ent_wait_disc_complete/4 + 2:
	if (!cmd->use_sg) {
	    if (dma_dir != PCI_DMA_NONE && cmd->request_bufflen)
		pci_unmap_single(NULL, targdata->bus_addr,
				cmd->request_bufflen, dma_dir);
	}
	else {
	    struct scatterlist *sglist = (struct scatterlist *)cmd->buffer;

	    pci_unmap_sg(NULL, sglist, cmd->use_sg, dma_dir);
	}
	if (targdata->bounce.len)
	    memcpy(targdata->bounce.addr, targdata->bounce.buf,
			    targdata->bounce.len);
	cmd->result = targdata->targ_status[0];
        SCSI_DONE(cmd);
	targdata->cur_cmd = NULL;
	resume_offset = Ent_reselect;
	break;
    case Ent_wait_disc2/4 + 2:
	/* Disconnect after command - just wait for a reselect */
	targdata->resume_offset = Ent_resume_msgin2a;
	resume_offset = Ent_reselect;
	break;
    case Ent_wait_disc3/4 + 2:
	/* Disconnect after the data phase */
	targdata->resume_offset = Ent_resume_msgin3a;
	resume_offset = Ent_reselect;
	break;
    case Ent_wait_disc1/4 + 2:
	/* Disconnect before command - not expected */
	targdata->resume_offset = Ent_resume_msgin1a;
	resume_offset = Ent_reselect;
	break;
    default:
	printk("scsi%d: Unexpected Illegal Instruction, script[%04x]\n",
		host->host_no, index);
	printk("scsi%d: script[%04x]: %08x %08x %08x %08x %08x %08x %08x %08x\n",
			host->host_no, index-4,
			targdata->script[index-4], targdata->script[index-3],
			targdata->script[index-2], targdata->script[index-1],
			targdata->script[index+0], targdata->script[index+1],
			targdata->script[index+2], targdata->script[index+3]);
	DEB(DEB_ANY,ncr_dump(host));
	sim700_errors++;
	/* resume_offset is zero, which will cause host reset */
    }
    return resume_offset;
}


/* Handle a phase mismatch.
 */

static u32
handle_phase_mismatch (struct Scsi_Host * host, Scsi_Cmnd * cmd)
{
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;
    struct sim700_target *targdata = TARGDATA(cmd->target);
    u32 resume_offset = 0, index;
    unsigned char sbcl;

    sbcl = NCR_read8(SBCL_REG) & SBCL_PHASE_MASK;
    index = low32((u32 *)(unsigned long)NCR_read32(DSP_REG) - targdata->ba->script);

    DEB(DEB_PMM, printk("scsi%d: Phase mismatch, phase %s (%x) at script[0x%x]\n",
	host->host_no, sbcl_to_phase(sbcl), sbcl, index));
    DEB(DEB_PMM, print_command(cmd->cmnd));

    if (index == Ent_done_ident/4) {
	/* Sending initial message out - probably rejecting our sync
	 * negotiation request.
	 */
	NCR_write8(SOCL_REG, 0);	/* Negate ATN */
	if (sbcl == SBCL_PHASE_MSGIN)
	    resume_offset = Ent_resume_rej_ident;
	else if (sbcl == SBCL_PHASE_CMDOUT) {
	    /* Some old devices (SQ555) switch to cmdout after the first
	     * byte of an identify message, regardless of whether we
	     * have more bytes to send!
	     */
	    printk("scsi%d: Unexpected switch to CMDOUT during IDENTIFY\n",
		host->host_no);
	    resume_offset = Ent_resume_cmd;
	}
        else if (sbcl == SBCL_PHASE_STATIN) {
	    /* Some devices do this on parity error, at least */
	    printk("scsi%d: Unexpected switch to STATUSIN on initial message out\n",
		host->host_no);
	    resume_offset = Ent_end_data_trans;
	}
	else {
	    printk("scsi%d: Unexpected phase change to %s on initial msgout\n",
		host->host_no, sbcl_to_phase(sbcl));
	    /* resume_offset is zero, which will cause a host reset */
	}
	hostdata->negotiate &= ~(1 << cmd->target);
    }
    else if (index >= targdata->din_script_start_index &&
		index <= targdata->din_script_end_index) {
	/* DataIn transfer phase */
	u32 sg_id, oaddr, olen, naddr, nlen;
	int residual;

	sg_id = (index - targdata->din_script_start_index - 2) / 2;
	patch_abs_32(targdata->script, 0, targ_din_script,
		low32(targdata->ba->din_script + sg_id * 2));
	olen = ncr32_to_cpu(targdata->din_script[sg_id * 2]) & 0x00ffffff;
	oaddr = ncr32_to_cpu(targdata->din_script[sg_id * 2 + 1]);
	residual = datapath_residual (host);
	if (residual)
	    printk("scsi%d: Residual count %d on DataIn - NOT expected!!!\n",
		host->host_no, residual);
	naddr = NCR_read32(DNAD_REG) - residual;
	nlen  = (NCR_read32(DBC_REG) & 0x00ffffff) + residual;
	DEB(DEB_PMM, printk("scsi%d: DIN sg %d, old %08x/%08x, new %08x/%08x (%d)\n",
		host->host_no, sg_id, oaddr, olen, naddr, nlen, residual));
	if (oaddr+olen != naddr+nlen) {
	    printk("scsi%d: PMM DIN counts error: 0x%x + 0x%x != 0x%x + 0x%x",
		host->host_no, oaddr, olen, naddr, nlen);
	}
	else {
	    u32 *p = targdata->din_script + sg_id * 2;

	    *p = cpu_to_ncr32((ncr32_to_cpu(*p) & 0xff00000) + nlen);
	    *++p = cpu_to_ncr32(naddr);
	    resume_offset = Ent_resume_pmm;
	}
    }
    else if (index >= targdata->dout_script_start_index &&
		index <= targdata->dout_script_end_index) {
	/* Dataout transfer phase */
	u32 sg_id, oaddr, olen, naddr, nlen;
	int residual;

	sg_id = (index - targdata->dout_script_start_index - 2) / 2;
	patch_abs_32(targdata->script, 0, targ_dout_script,
		low32(targdata->ba->dout_script + sg_id * 2));
	olen = ncr32_to_cpu(targdata->dout_script[sg_id * 2]) & 0x00ffffff;
	oaddr = ncr32_to_cpu(targdata->dout_script[sg_id * 2 + 1]);
	residual = datapath_residual (host);
	naddr = NCR_read32(DNAD_REG) - residual;
	nlen  = (NCR_read32(DBC_REG) & 0x00ffffff) + residual;
	DEB(DEB_PMM, printk("scsi%d: DOUT sg %d, old %08x/%08x, new %08x/%08x (%d)\n",
		host->host_no, sg_id, oaddr, olen, naddr, nlen, residual));
	if (oaddr+olen != naddr+nlen) {
	    printk("scsi%d: PMM DOUT counts error: 0x%x + 0x%x != 0x%x + 0x%x",
		host->host_no, oaddr, olen, naddr, nlen);
	}
	else {
	    u32 *p = targdata->dout_script + sg_id * 2;
	    
	    *p = cpu_to_ncr32((ncr32_to_cpu(*p) & 0xff00000) + nlen);
	    *++p = cpu_to_ncr32(naddr);
	    resume_offset = Ent_resume_pmm;
	}
    }
    else if (sbcl == SBCL_PHASE_STATIN) {
	/* Change to Status In at some random point; probably wants to report a
	 * parity error or similar.
	 */
	printk("scsi%d: Unexpected phase change to STATUSIN at index 0x%x\n",
		host->host_no, index);
	    resume_offset = Ent_end_data_trans;
    }
    else {
	printk("scsi%d: Unexpected phase change to %s at index 0x%x\n",
		host->host_no, sbcl_to_phase(sbcl), index);
	/* resume_offset is zero, which will cause a host reset */
    }
    /* Flush DMA FIFO - XXX this is a guess for the 53c700 */
    if (hostdata->chip == 700) {
	NCR_write8 (DFIFO_REG, DFIFO_00_CLF);
	udelay(10);
	NCR_write8 (DFIFO_REG, 0);
    }
    else {
	NCR_write8 (CTEST8_REG, CTEST8_10_CLF);
	while (NCR_read8 (CTEST8_REG) & CTEST8_10_CLF)
	    ;
    }

    return resume_offset;
}


static u32
handle_script_int(struct Scsi_Host * host, Scsi_Cmnd * cmd)
{
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;
    struct sim700_target *targdata = TARGDATA(cmd->target);
    u32 dsps, resume_offset = 0;
    unsigned char sbcl;
    int dma_dir = scsi_to_pci_dma_dir(cmd->sc_data_direction);

    dsps = NCR_read32(DSPS_REG);

    switch (dsps) {
    case A_int_cmd_complete:
	if (!cmd->use_sg) {
	    if (dma_dir != PCI_DMA_NONE && cmd->request_bufflen)
		pci_unmap_single(NULL, targdata->bus_addr,
				cmd->request_bufflen, dma_dir);
	}
	else {
	    struct scatterlist *sglist = (struct scatterlist *)cmd->buffer;

	    pci_unmap_sg(NULL, sglist, cmd->use_sg, dma_dir);
	}
	if (targdata->bounce.len)
	    memcpy(targdata->bounce.addr, targdata->bounce.buf,
			    targdata->bounce.len);
	cmd->result = targdata->targ_status[0];
        SCSI_DONE(cmd);
	targdata->cur_cmd = NULL;
	resume_offset = Ent_reselect;
	break;
    case A_int_rej_msg1:
	resume_offset = handle_rej(host, cmd, Ent_resume_msgin1a);
	break;
    case A_int_msg_sdtr1:
	resume_offset = handle_sdtr(host, cmd,
		Ent_resume_msgin1a, Ent_resume_msgin1b);
	break;
    case A_int_msg_sdtr2:
	resume_offset = handle_sdtr(host, cmd, 0, Ent_resume_msgin2b);
	break;
    case A_int_msg_sdtr3:
	resume_offset = handle_sdtr(host, cmd, 0, Ent_resume_msgin3b);
	break;
    case A_int_disc1:
	/* Disconnect before command - not expected */
	targdata->resume_offset = Ent_resume_msgin1a;
	resume_offset = Ent_reselect;
	break;
    case A_int_disc2:
	/* Disconnect after command - just wait for a reselect */
	targdata->resume_offset = Ent_resume_msgin2a;
	resume_offset = Ent_reselect;
	break;
    case A_int_disc3:
	/* Disconnect after the data phase */
	targdata->resume_offset = Ent_resume_msgin3a;
	resume_offset = Ent_reselect;
	break;
    case A_int_reselected:
	targdata->script[Ent_patch_resume_reselect/4+1] = cpu_to_ncr32(
		low32(targdata->ba->script + targdata->resume_offset/4));
	resume_offset = Ent_resume_reselect;
	break;
    case A_int_data_bad_phase:
	sbcl = NCR_read8(SBCL_REG) & SBCL_PHASE_MASK;
	printk("scsi%d: int_data_bad_phase, phase %s (%x)\n",
		host->host_no, sbcl_to_phase(sbcl), sbcl);
	break;
    case A_int_rej_msg2:
    case A_int_rej_msg3:
    case A_int_bad_msg1:
    case A_int_bad_msg2:
    case A_int_bad_msg3:
    case A_int_cmd_bad_phase:
    case A_int_no_msgout1:
    case A_int_no_msgout2:
    case A_int_no_msgout3:
    case A_int_not_cmd_complete:
    case A_int_sel_no_ident:
    case A_int_sel_not_cmd:
    case A_int_status_not_msgin:
    case A_int_resel_not_msgin:
    case A_int_selected:
    case A_int_not_rej:
    default:
	sbcl = NCR_read8(SBCL_REG) & SBCL_PHASE_MASK;
	printk("scsi%d: Unimplemented script interrupt: %08x, phase %s\n",
		host->host_no, dsps, sbcl_to_phase(sbcl));
	sim700_errors++;
	/* resume_offset is zero, which will cause a host reset */
    }
    return resume_offset;
}


/* A quick wrapper for sim700_intr_handle to grab the spin lock */

static void
do_sim700_intr_handle(int irq, void *dev_id, struct pt_regs *regs)
{
    unsigned long flags;

    spin_lock_irqsave(&io_request_lock, flags);
    sim700_intr_handle(irq, dev_id, regs);
    spin_unlock_irqrestore(&io_request_lock, flags);
}


/* A "high" level interrupt handler */

static void
sim700_intr_handle(int irq, void *dev_id, struct pt_regs *regs)
{
    unsigned int flags;
    struct Scsi_Host * host = (struct Scsi_Host *)dev_id;
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;
    struct sim700_target *targdata = NULL;	/* Kill compiler warning */
    Scsi_Cmnd * cmd;
    unsigned char istat, dstat;
    unsigned char sstat0;
    u32 dsps, dsp, resume_offset = 0;
    int target = 0;

    istat = NCR_read8(ISTAT_REG);
    if (!(istat & (ISTAT_SIP|ISTAT_DIP))) {
	 DEB(DEB_ANY, printk("scsi%d: sim700_intr_handle() called with "
					 "no interrupt\n", host->host_no));
	 return;
    }
    sim700_intrs++;
    save_flags(flags);
    cli();

    {
	dsps = NCR_read32(DSPS_REG);
	dsp = NCR_read32(DSP_REG);
	hostdata->state = STATE_HALTED;
	sstat0 = dstat = 0;
	if (istat & ISTAT_SIP) {
	    sstat0 = NCR_read8(SSTAT0_REG);
	}
	if (istat & ISTAT_DIP) {
	    if (istat & ISTAT_ABRT)
		NCR_write8(ISTAT_REG, 0);
	    udelay(10);		/* Some comment somewhere about 10 cycles
				 * between accesses to sstat0 and dstat ??? */
	    dstat = NCR_read8(DSTAT_REG);
	}
	/* This will change if we have a common wait_reselect script */
	if ((target = TARGET(dsp)) < 0) {
	    printk("scsi%d: dsp = 0x%x is invalid\n", host->host_no, dsp);
	    targdata = NULL;
	    goto bail_out;
	}
	targdata = TARGDATA(target);
	DEB(DEB_INTS, printk("scsi%d: Int %d, istat %02x, sstat0 %02x "
		"dstat %02x, dsp [%04x], target %x\n",
	    host->host_no, sim700_intrs, istat, sstat0, dstat,
	    low32((u32 *)(unsigned long)dsp - targdata->ba->script), target));
	{
	    /* Should do this later, when we know if it is relevant */
	    u8 *p = targdata->targ_msgin;

	    DEB(DEB_INTS, printk("  targ_msgin: %02x %02x %02x %02x\n",
		    p[0], p[1], p[2], p[3]));
	}
	if ((dstat & DSTAT_SIR) && dsps == A_int_reselected) {
	    /* Reselected.  Identify the target from LCRC_REG, and
	     * update current command.  If we were trying to select
	     * a device, then that command needs to go back on the
	     * issue_queue for later.
	     * No LCRC on a 53c700...
	     */
	    unsigned char lcrc;
	    int id;

	    lcrc = (hostdata->chip == 700) ?
		    NCR_read8(SFBR_REG) : NCR_read8(LCRC_REG_10);
	    id = 0;
	    if (!(lcrc & 0x7f)) {
		printk("scsi%d: Reselected with %s = %02x\n",
			host->host_no,
			hostdata->chip == 700 ? "SFBR_REG" : "LCRC_REG_10",
			lcrc);
		cmd = NULL;
	    }
	    else {
		while (!(lcrc & 1)) {
		    id++;
		    lcrc >>= 1;
		}
		DEB(DEB_DISC, printk("scsi%d: Reselected by ID %d\n",
			host->host_no, id));
		if (hostdata->running) {
		    if (hostdata->chip == 710) {
			/* Clear SIGP */
			(void)NCR_read8(CTEST2_REG_700);
		    }
		    else {
			/* Clear abort */
			NCR_write8(ISTAT_REG, 0);
			dstat &= ~DSTAT_ABRT;
		    }

		    DEB(DEB_DISC, printk("scsi%d: Select of %d interrupted "
				"by reselect from %d (%p)\n",
				host->host_no, hostdata->running->target,
				id, TARGDATA(id)->cur_cmd));
		    cmd = hostdata->running;
		    TARGDATA(cmd->target)->cur_cmd = NULL;
		    cmd->SCp.ptr = (unsigned char *) hostdata->issue_queue;
		    hostdata->issue_queue = cmd;
		}
		target = id;
		targdata = TARGDATA(target);
		cmd = hostdata->running = targdata->cur_cmd;
	    }
	}
	else
	    cmd = hostdata->running;

	if (cmd && cmd->target != target && hostdata->chip == 710) {
	    printk("scsi%d: cmd->target = %d, but target = %d\n",
			    host->host_no, cmd->target, target);
	    printk("*** PLEASE TELL RICHARD!!!!\n");
	}

	if (!cmd) {
	    printk("scsi%d: No active command!\n", host->host_no);
	    printk("scsi%d: Int %d, istat %02x, sstat0 %02x "
		"dstat %02x, dsp [%04x], target %x, dsps %08x\n",
		host->host_no, sim700_intrs, istat, sstat0, dstat,
		low32((u32 *)(unsigned long)NCR_read32(DSP_REG) - 
	  	(unsigned long)targdata->ba->script), target, dsps);
	    /* resume_offset is zero, which will cause a host reset */
	}
	else if (sstat0 & SSTAT0_700_STO) {
	    DEB(DEB_TOUT, printk("scsi%d: Selection timeout\n", host->host_no));
	    cmd->result = DID_NO_CONNECT << 16;
	    SCSI_DONE(cmd);
	    targdata->cur_cmd = NULL;
	    resume_offset = Ent_reselect;
	}
	else if (hostdata->chip == 700 && (dstat & DSTAT_ABRT)) {
	    u32 offset = (dsp - low32(targdata->ba->script))/4;
	    if (offset == Ent_reselect/4 + 4) {
		DEB(DEB_DISC, printk("scsi%d: wait reselect aborted\n", host->host_no));
		resume_offset = Ent_patch_selection;
		targdata = TARGDATA(HOST_ID);
	    }
	    else {
		if (offset > Ent_reselect/4+4 && offset <= Ent_reselect/4+8) {
		    DEB(DEB_DISC, printk ("scsi%d: Aborted during reselect,"
				   " offset 0x%04x\n", host->host_no, offset));
		    /* This is inefficient (an extra interrupt), but clean
		     * from a code point of view.  Needs restructuring so
		     * we can go straight to the 'reselected' code here.
		     */
		    resume_offset = Ent_do_int_reselected;
		}
		else
		    printk("scsi%d: Bad dsp on abort, 0x%08x, offset 0x%04x\n",
			host->host_no, dsp, offset);
	    }
	}
	else if (sstat0 & (SSTAT0_SGE|SSTAT0_UDC|SSTAT0_RST|SSTAT0_PAR)) {
	    printk("scsi%d: Serious error, sstat0 = %02x\n", host->host_no,
			    sstat0);
	    ncr_dump(host);
	    sim700_errors++;
	    /* resume_offset is zero, which will cause a host reset */
	}
	else if (dstat & ((DSTAT_ABRT|DSTAT_SSI|DSTAT_WTD) |
				(hostdata->chip == 700 ? 0 : DSTAT_BF)))
	{
	    printk("scsi%d: Serious error, dstat = %02x\n", host->host_no,
			    dstat);
	    sim700_errors++;
	    /* resume_offset is zero, which will cause a host reset */
	}
	else if (dstat & DSTAT_SIR)
	    resume_offset = handle_script_int(host, cmd);
	else if (sstat0 & SSTAT0_MA)
	    resume_offset = handle_phase_mismatch(host, cmd);
	else if (dstat & DSTAT_IID) {
	    /* This can be due to a quick reselect while doing a WAIT
	     * DISCONNECT.
	     */
	    resume_offset = handle_idd(host, cmd);
	}
	else {
	    sim700_errors++;
	    printk("scsi%d: Spurious interrupt!\n", host->host_no);
	    /* resume_offset is zero, which will cause a host reset */
	}
    }

    /* Now check for any stacked interrupts.  We will accept an
     * ABORTED interrupt because for 53c700 we may have aborted
     * to select a new device just as something reselects us.
     * I am seeing UDC interrupts following an STO on 53c700, so
     * I'll ignore those also.  My 53c710 book says you get UDC
     * with STO.
     */

    while ((istat = NCR_read8(ISTAT_REG)) & (ISTAT_SIP|ISTAT_DIP)) {
	u8 dstat_bits, last_sstat0 = sstat0;

	dstat_bits = (hostdata->chip == 700 ? 0 : DSTAT_BF) |
		DSTAT_ABRT|DSTAT_SSI|DSTAT_SIR|DSTAT_WTD|DSTAT_IID;
	sstat0 = dstat = 0;
	if (istat & ISTAT_SIP) {
	    sstat0 = NCR_read8(SSTAT0_REG);
	}
	if (istat & ISTAT_DIP) {
	    udelay(10);
	    dstat = NCR_read8(DSTAT_REG);
	}
	dstat &= dstat_bits;
	if (hostdata->chip == 700 && (dstat & DSTAT_ABRT)) {
	    DEB(DEB_INTS, printk("scsi%d: Ignoring stacked ABRT int\n",
				host->host_no));
	    dstat &= ~DSTAT_ABRT;
	}
	if (hostdata->chip == 700 && (sstat0 & SSTAT0_UDC) &&
			(last_sstat0 & SSTAT0_700_STO)) {
	    DEB(DEB_INTS, printk("scsi%d: Ignoring stacked UDC int\n",
				host->host_no));
	    sstat0 &= ~SSTAT0_700_STO;
	}
	if (sstat0 || dstat) {
	    printk("scsi%d: Unexpected stacked interrupt, "
			"istat %02x, sstat0 %02x, dstat %02x\n",
			host->host_no, istat, sstat0, dstat);
	}
    }

bail_out:
    if (resume_offset) {
	u32 start_addr;

	if (resume_offset == Ent_reselect) {
	    hostdata->running = NULL;
	    hostdata->state = STATE_IDLE;
	    target = HOST_ID;
	    targdata = TARGDATA(target);
	}
	else
	    hostdata->state = STATE_BUSY;

	DEB(DEB_RESUME, printk("scsi%d: Resuming at script[%d][0x%x]\n",
		host->host_no, target, resume_offset/4));

	if (sim700_intrs == 0) {
		u32 *p = (u32 *)targdata;
		int i;

		for (i = 0; i < 1024; i += 8)
			printk ("%p: %08x %08x %08x %08x %08x %08x %08x %08x\n", p+i, p[i], p[i+1], p[i+2], p[i+3], p[i+4], p[i+5], p[i+6], p[i+7]);
	}
	start_addr = low32(targdata->ba->script+resume_offset/4);
	CHECK_WBACK_INV(targdata, PAGE_SIZE);

#ifdef DEBUG_LIMIT_INTS
	if (sim700_intrs < DEBUG_LIMIT_INTS)
#endif
	NCR_write32(DSP_REG, start_addr);
	if (resume_offset == Ent_reselect)
	    run_process_issue_queue(hostdata);
    }
    else {
	printk("scsi%d: Failed to handle interrupt.  Failing commands "
		"and resetting SCSI bus and chip\n", host->host_no);
	mdelay(4000);		/* Give chance to read screen!! */
	full_reset(host);
    }

    restore_flags(flags);
}


static void
run_command (struct sim700_hostdata *hostdata, Scsi_Cmnd *cmd)
{
    struct Scsi_Host *host = cmd->host;
    struct sim700_target *targdata = TARGDATA(cmd->target);
    int datain, dataout;
    int i, sg_start;
    u32 *dip, *dop;
    u32 start_addr;
    int dma_dir = scsi_to_pci_dma_dir(cmd->sc_data_direction);

    DEB(DEB_CMND, printk("scsi%d: id%d starting ", host->host_no,
		cmd->target));
    DEB(DEB_CMND, print_command(cmd->cmnd));

    switch (cmd->sc_data_direction) {
    case SCSI_DATA_WRITE:
        datain = 0; dataout = 1;
	break;
    case SCSI_DATA_READ:
        datain = 1; dataout = 0;
	break;
    case SCSI_DATA_NONE:
        datain = dataout = 0;
	break;
    default:
        datain = dataout = 1;
    }

    memcpy(targdata->targ_cdb, cmd->cmnd, MAX_CMND);
    patch_abs_24 (targdata->script, 0, targ_cdb_cnt, cmd->cmd_len);
    targdata->targ_msgout[0] =
		IDENTIFY((opt_nodisc & (1<<cmd->target)) ? 0 : 1 ,0);
    patch_abs_24 (targdata->script, 0, targ_msgout_cnt, 1);
    if (hostdata->negotiate & (1 << cmd->target)) {
	if (opt_noneg & (1 << cmd->target)) {
	    hostdata->negotiate ^= (1 << cmd->target);
	}
	else {
	    DEB(DEB_SYNC, printk("scsi%d: Negotiating async transfers "
		"for ID %d\n",
		host->host_no, cmd->target));
	    memcpy(targdata->targ_msgout+1, async_message, sizeof(async_message));
	    patch_abs_24 (targdata->script, 0, targ_msgout_cnt, sizeof(async_message) + 1);
	}
    }
    targdata->targ_msgin[0] = 0xff;
    targdata->targ_status[0] = 0xff;

    targdata->bounce.len = 0;		/* Assume aligned buffer */

    if (!cmd->use_sg) {
	dma_addr_t bbuf;
	/* XXX 64 bit XXX */
	void *vbuf = cmd->request_buffer;
	u32 cnt = cmd->request_bufflen;

	if ((((unsigned long)vbuf & 31) || (cnt & 31)) && (datain || dataout) &&
			!(datain && dataout) && cnt <= PAGE_SIZE/8) {
	    /* Bounce buffer needed - in practice this is only needed
	     * for Request Sense, Inquiry, Read Capacity, and similar.
	     */
	    if (datain) {
		targdata->bounce.len = cnt;
		targdata->bounce.addr = vbuf;
	    }
	    if (dataout) {
		targdata->bounce.len = 0;
		memcpy ((void *)targdata->bounce.buf, vbuf, cnt);
	    }
	    vbuf = targdata->bounce.buf;
	}
	if (dma_dir != PCI_DMA_NONE && cnt)
	    bbuf = pci_map_single(NULL, vbuf, cnt, dma_dir);
	else
	    bbuf = 0;
	targdata->virt_addr = vbuf;
	targdata->bus_addr = bbuf;

	sg_start = (MAX_SG - 1) * 2;
	dip = targdata->din_script + sg_start;
	dop = targdata->dout_script + sg_start;

	if (datain) {
	    *dip++	= cpu_to_ncr32(0x09000000 | cnt);
	    *dip++	= cpu_to_ncr32(bbuf);
	}
	if (dataout) {
	    *dop++	= cpu_to_ncr32(0x08000000 | cnt);
	    *dop++	= cpu_to_ncr32(bbuf);
	}
    }
    else {
	struct scatterlist *sglist = (struct scatterlist *)cmd->buffer;
	int map_cnt = pci_map_sg(NULL, sglist, cmd->use_sg, dma_dir);
	struct scatterlist *sg;

	sg_start = (MAX_SG - map_cnt) * 2;
	dip = targdata->din_script + sg_start;
	dop = targdata->dout_script + sg_start;

	for (i = 0, sg = sglist; i < map_cnt; i++, sg++) {

	    if (datain) {
		*dip++	= cpu_to_ncr32(0x09000000 | sg_dma_len(sg));
		*dip++	= cpu_to_ncr32(sg_dma_address(sg));
	    }
	    if (dataout) {
		*dop++	= cpu_to_ncr32(0x08000000 | sg_dma_len(sg));
		*dop++	= cpu_to_ncr32(sg_dma_address(sg));
	    }
	}
    }
    patch_abs_32(targdata->script, 0, targ_din_script,
	low32(targdata->ba->din_script + sg_start));
    patch_abs_32(targdata->script, 0, targ_dout_script,
	low32(targdata->ba->dout_script + sg_start));

    hostdata->running = targdata->cur_cmd = cmd;
    hostdata->state = STATE_BUSY;

    /* XXX This will change when we have disc/reselect.  Patch a jump as
     * to where to go to do the select (i.e. which target script), and
     * then for 710 we just set SIGP.  For 700 we have to abort it and
     * then write the DSP.  Maybe we get clever if there is no command
     * outstanding, and don't wait for reselect, so then we can just write
     * DSP.
     */
    start_addr = cpu_to_ncr32(low32(targdata->ba->script+Ent_do_select/4));
    TARGDATA(HOST_ID)->script[Ent_patch_selection/4 + 1] = start_addr;

    CHECK_WBACK_INV(TARGDATA(HOST_ID), PAGE_SIZE);

    CHECK_WBACK_INV(targdata, PAGE_SIZE);

    if (hostdata->chip == 700) {
	/* Abort the script, the interrupt handler will take over from there */
	NCR_write8(ISTAT_REG, ISTAT_ABRT);
    }
    else
	NCR_write8(ISTAT_REG, ISTAT_10_SIGP);
}


static volatile int process_issue_queue_running = 0;
 
static __inline__ void 
run_process_issue_queue(struct sim700_hostdata *hostdata)
{
    unsigned long flags;
    save_flags (flags);
    cli();
    if (!process_issue_queue_running) {
	process_issue_queue_running = 1;
	process_issue_queue(hostdata, flags);
	/*
	 * process_issue_queue_running is cleared in process_issue_queue
	 * once it can't do more work, and process_issue_queue exits with
	 * interrupts disabled.
	 */
    }
    restore_flags (flags);
}


/*
 * Function : process_issue_queue (hostdata, flags)
 *
 * Purpose : Start next command for any idle target.
 * 
 * NOTE : process_issue_queue exits with interrupts *disabled*, so the 
 *	caller must reenable them if it desires.
 * 
 * NOTE : process_issue_queue should be called from both 
 *	sim700_queue_command() and from the interrupt handler 
 *	after command completion.
 */

static void 
process_issue_queue (struct sim700_hostdata *hostdata, unsigned long flags)
{
    Scsi_Cmnd *tmp, *prev;
    int done;

    /*
     * We run (with interrupts disabled) until we're sure that none of 
     * the host adapters have anything that can be done, at which point 
     * we set process_issue_queue_running to 0 and exit.
     *
     * Interrupts are enabled before doing various other internal 
     * instructions, after we've decided that we need to run through
     * the loop again.
     *
     */

    do {
	cli(); /* Freeze request queues */
	done = 1;
	if (hostdata->issue_queue) {
	    if (hostdata->state == STATE_DISABLED) {
		tmp = (Scsi_Cmnd *) hostdata->issue_queue;
		hostdata->issue_queue = (Scsi_Cmnd *) tmp->SCp.ptr;
		tmp->result = (DID_BAD_TARGET << 16);
		tmp->scsi_done (tmp);
		done = 0;
	    }
	    else if (hostdata->state == STATE_IDLE) {
		for (tmp = hostdata->issue_queue, prev = NULL; tmp;
				prev = tmp, tmp = (Scsi_Cmnd *) tmp->SCp.ptr) {
		    if (TARGDATA(tmp->target)->cur_cmd == NULL) {
			if (prev)
			    prev->SCp.ptr = tmp->SCp.ptr;
			else
			    hostdata->issue_queue = (Scsi_Cmnd *) tmp->SCp.ptr;
			tmp->SCp.ptr = NULL;
			run_command (hostdata, tmp);
			done = 0;
		    } /* if target/lun is not busy */
		} /* scan issue queue for work */
	    } /* host is idle */
	} /* if hostdata->issue_queue */
	if (!done)
	    restore_flags (flags);
    } while (!done);
    process_issue_queue_running = 0;
}


int
sim700_queuecommand(Scsi_Cmnd * cmd, void (*done)(Scsi_Cmnd *))
{
    struct Scsi_Host *host = cmd->host;
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;
    Scsi_Cmnd *tmp;
    unsigned long flags;

    if (cmd->lun) {
	/* Silently ignore luns other than zero! */
	cmd->result = (DID_BAD_TARGET << 16);
	done(cmd);
	return 0;
    }

    DEB(DEB_CMND, printk("scsi%d: id%d queuing  ", host->host_no,
		cmd->target));
    DEB(DEB_CMND, print_command(cmd->cmnd));

    cmd->scsi_done = done;
    cmd->host_scribble = NULL;
    cmd->SCp.ptr = NULL;
    cmd->SCp.buffer = NULL;

    save_flags(flags);
    cli();

    if (ignore_ids & (1 << cmd->target)) {
	printk("scsi%d: ignoring target %d\n", host->host_no, cmd->target);
	cmd->result = (DID_BAD_TARGET << 16);
	done(cmd);
	restore_flags (flags);
	return 0;
    }
#ifdef DEBUG_LIMIT_INTS
    if (sim700_intrs > DEBUG_LIMIT_INTS) {
	cmd->result = (DID_BAD_TARGET << 16);
	done(cmd);
	restore_flags (flags);
	return 0;
    }
#endif
    if (cmd->use_sg > MAX_SG)
	panic ("cmd->use_sg = %d\n", cmd->use_sg);

    if (!(hostdata->issue_queue) || (cmd->cmnd[0] == REQUEST_SENSE)) {
        cmd->SCp.ptr = (unsigned char *) hostdata->issue_queue;
        hostdata->issue_queue = cmd;
    } else {
        for (tmp = hostdata->issue_queue; tmp->SCp.ptr;
                tmp = (Scsi_Cmnd *) tmp->SCp.ptr);
        tmp->SCp.ptr = (unsigned char *) cmd;
    }
    restore_flags (flags);
    run_process_issue_queue(hostdata);
    return 0;
}

int
sim700_init_host(Scsi_Host_Template *tpnt,
		    int chip,
		    unsigned long base_addr,
		    int requested_irq,
		    u32 options
		    )
{
    struct Scsi_Host * host = NULL;
    struct sim700_hostdata *hostdata;
    unsigned char scsi_id;
    int revision;

    unsigned long irq_mask;
    int timeout;
    u8 istat, sstat0, dstat;
    int probed_irq;
    u32 dsps, start_addr;
    dma_addr_t dma_addr;

#ifdef MODULE
    /* This is wrong really; should only do it once on insmod, not once
     * per host.  That would mean making param_setup() public and calling
     * it from lasi7xx.c.
     */
    param_setup(sim700);
#endif

    /* Override addr/irq from command line if requested */
    if (opt_base)
	base_addr = opt_base;
    if (opt_irq)
	requested_irq = opt_irq;

    host = scsi_register(tpnt, sizeof(struct sim700_hostdata));
    hostdata = (struct sim700_hostdata *)host->hostdata;
    memset(hostdata, 0, sizeof(struct sim700_hostdata));
    hostdata->targets = pci_alloc_consistent(NULL, PAGE_SIZE << 3, &dma_addr);
    if (!hostdata->targets) {
	DEB(DEB_ANY, printk("sim700: Couldn't get consistent shared memory\n"));
	dma_consistent = 0;
	hostdata->targets = (void *)__get_free_pages(GFP_ATOMIC, 3);
        if (!hostdata->targets) {
	    printk("sim700: Couldn't allocate shared memory\n");
	    goto err1;
	}
	dma_addr = virt_to_bus(hostdata->targets);
    }
    hostdata->targets_busaddr = dma_addr;
    hostdata->bounce_bufs = (void *)__get_free_pages(GFP_ATOMIC, 0);
    if (!hostdata->bounce_bufs) {
	printk("sim700: Couldn't get bounce buffer memory\n");
	goto err2;
    }
    memset((void *)hostdata->targets, 0, PAGE_SIZE << 3);
    scsi_id = 7;
    printk("sim700: Configuring 53c%d (SCSI-ID %d) at %lx, IRQ %d, options %x\n",
		    chip, scsi_id, base_addr, requested_irq, options);
    DEB(DEB_ANY, printk("sim700: hostdata = %p (%d bytes)\n",
		    hostdata, (u32)sizeof(struct sim700_hostdata)));
    DEB(DEB_ANY, printk("sim700: targdata = %p, %p, ... (%d bytes)\n",
			    TARGDATA(0), TARGDATA(1),
			    (u32)sizeof(struct sim700_target)));
    hostdata->options = options;
    hostdata->addr8_flip = (options & OPT_NCR_LE) ? 0 : 3;
    hostdata->chip = chip;
    host->irq = requested_irq;
    host->this_id = scsi_id;
    host->unique_id = base_addr;
    host->base = base_addr;

    if (hostdata->options & OPT_IO_MAPPED) {
	if (!request_region((unsigned long)host->base, 64, "sim700")) {
	    printk("sim700: Couldn't claim chip I/O region\n");
	    goto err3;
	}
    }
    else {
	if (!request_mem_region((unsigned long)host->base, 64, "sim700")) {
	    printk("sim700: Couldn't claim chip memory region\n");
	    goto err3;
	}
	host->base = (unsigned long)ioremap (host->base, 64);
    }

    DEB(DEB_ANY,ncr_dump(host));
    /* XXX May want to hit it with a chip reset rather than this... */
    if (ncr_halt(host)) {
	printk("sim700: Failed to initialise 53c%d at address %lx\n",
		chip, base_addr);
	goto err4;
    }
    revision = (NCR_read8(chip == 700 ? CTEST7_REG : CTEST8_REG) & 0xF0) >> 4;
    printk("scsi%d: Revision 0x%x\n",host->host_no,revision);

    sim700_soft_reset(host);
    sim700_driver_init(host);

    /* Now run test1 */
    hostdata->test1_src = 0x53c710aa;
    hostdata->test1_dst = 0x76543210;
    NCR_write32(DSPS_REG, 0x89abcdef);
    CHECK_WBACK_INV(hostdata->targets, PAGE_SIZE << 3);
    TARGDATA(HOST_ID)->script[Ent_test1/4+4] = cpu_to_ncr32(A_int_test1b);
    irq_mask = probe_irq_on();
    /* XXX for 53c700 we cannot do MEMORY-MEMORY moves, just skip that bit */
#if 1
    NCR_write32(DSP_REG, TARGDATA(HOST_ID)->ba->script+Ent_test1/4+3);
#else
    NCR_write32(DSP_REG, TARGDATA(HOST_ID)->ba->script+Ent_test1/4);
#endif
    timeout = 5;
    while (hostdata->test1_dst != hostdata->test1_src && timeout--) {
	mdelay(100);
        CHECK_INV(hostdata->targets, PAGE_SIZE << 3);
    }
    istat = NCR_read8(ISTAT_REG);
    sstat0 = NCR_read8(SSTAT0_REG);
    udelay(10);
    dstat = NCR_read8(DSTAT_REG);
    probed_irq = probe_irq_off(irq_mask);

    DEB(DEB_ANY, printk("Post test1, istat %02x, sstat0 %02x, dstat %02x\n", istat, sstat0, dstat));
    if (requested_irq == 0) {
	if (probed_irq > 0) {
	    printk("sim700: Chip is using IRQ %d\n", probed_irq);
	    requested_irq = host->irq = probed_irq;
	}
	else {
	    printk("sim700: Failed to probe for IRQ (returned %d)\n",
		    probed_irq);
	    ncr_halt(host);
	    goto err4;
	}
    }
    else if (probed_irq > 0 && probed_irq != requested_irq)
		printk("sim700: WARNING requested IRQ %d, but probed as %d\n",
			requested_irq, probed_irq);
    else if (probed_irq <= 0)
		DEB(DEB_ANY, printk("sim700: WARNING IRQ probe failed, (returned %d)\n",
			probed_irq));
  

    dsps = NCR_read32(DSPS_REG);
#if 1
    if (dsps == A_int_test1a)
	DEB(DEB_ANY, printk("scsi%d: WARNING: target data areas are not dma coherent!\n",
			host->host_no));
    else if (dsps == A_int_test1b)
	DEB(DEB_ANY, printk("scsi%d: Good, target data areas are dma coherent\n",
			host->host_no));
    else {
	printk("scsi%d: test 1 FAILED: dsps: exp 0x%08x, got 0x%08x\n",
			host->host_no, A_int_test1a, dsps);
	ncr_dump(host);
	ncr_halt(host);
	goto err4;
    }
#else
    if (hostdata->test1_dst != 0x53c710aa || dsps != A_int_test1a) {
	if (hostdata->test1_dst != 0x53c710aa)
		printk("scsi%d: test 1 FAILED: data: exp 0x53c710aa, got 0x%08x\n",
				host->host_no, hostdata->test1_dst);
	if (dsps != A_int_test1a)
		printk("scsi%d: test 1 FAILED: dsps: exp 0x%08x, got 0x%08x\n",
			host->host_no, A_int_test1a, dsps);
	ncr_dump(host);
	ncr_halt(host);
	goto err4;
    }
#endif
    printk("scsi%d: test 1 completed ok.\n", host->host_no);

    if (request_irq(requested_irq,do_sim700_intr_handle, SA_INTERRUPT, "sim700", host))
    {
	printk("scsi%d : IRQ%d not free, detaching\n",
		host->host_no, host->irq);
	goto err4;
    }
    /* Why bother? Nothing should reselect at this point... */
    start_addr = low32(TARGDATA(HOST_ID)->ba->script+Ent_reselect/4);
    CHECK_WBACK_INV(hostdata->targets, PAGE_SIZE << 3);
    NCR_write32(DSP_REG, start_addr);
    hostdata->state = STATE_IDLE;

    return TRUE;

err4:
    if (hostdata->options & OPT_IO_MAPPED)
	release_region((unsigned long)host->base, 64);
    else
	release_mem_region((unsigned long)host->base, 64);
err3:
    free_pages((unsigned long)hostdata->bounce_bufs, 0);
err2:
    if (dma_consistent)
	pci_free_consistent(NULL, PAGE_SIZE << 3, hostdata->targets,
		    hostdata->targets_busaddr);
    else
	free_pages((unsigned long)hostdata->targets, 3);
err1:
    scsi_unregister (host);
    return FALSE;
}

int
sim700_abort(Scsi_Cmnd * cmd)
{
    struct Scsi_Host * host = cmd->host;

    printk("scsi%d: Unable to abort command for target %d\n",
	   host->host_no, cmd->target);
    return FAILED;
}

/*
 * This is a device reset.  Need to select and send a Bus Device Reset msg.
 */

int
sim700_dev_reset(Scsi_Cmnd * SCpnt)
{
    struct Scsi_Host * host = SCpnt->host;

    printk("scsi%d: Unable to send Bus Device Reset for target %d\n",
	   host->host_no, SCpnt->target);
    return FAILED;
}

/*
 * This is bus reset.  We need to reset the bus and fail any active commands.
 */

int
sim700_bus_reset(Scsi_Cmnd * SCpnt)
{
    struct Scsi_Host * host = SCpnt->host;

    printk("scsi%d: Unable to do SCSI bus reset\n", host->host_no);
    return FAILED;
}

static int
full_reset(struct Scsi_Host * host)
{
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;
    int target;
    Scsi_Cmnd *cmd;
    u32 istat, dstat = 0, sstat0 = 0, sstat1 = 0, dsp, dsps;
    unsigned long flags;
    struct sim700_target *targdata;

    save_flags(flags);
    cli();

    istat = NCR_read8(ISTAT_REG);
    if (istat & ISTAT_SIP) {
	sstat0 = NCR_read8(SSTAT0_REG);
	sstat1 = NCR_read8(SSTAT1_REG);
	udelay(10);
    }
    if (istat & ISTAT_DIP)
	dstat = NCR_read8(DSTAT_REG);

    if (ncr_halt(host)) {
	restore_flags(flags);
	return FAILED;
    }
    restore_flags(flags);
    dsp = NCR_read32(DSP_REG);
    dsps = NCR_read32(DSPS_REG);
    /* XXX FIXME need correct target to report dsp offset */
    target = 0;
    targdata = TARGDATA(target);
    printk("scsi%d: istat = %02x, sstat0 = %02x, sstat1 = %02x, dstat = %02x\n",
	    host->host_no, istat, sstat0, sstat1, dstat);
    printk("scsi%d: dsp = %08x (script[0x%04x]), dsps = %08x, target = %x\n",
	    host->host_no, dsp,
	    (low32(dsp) - low32(targdata->ba->script))/4, dsps, target);

    for (target = 0; target < 7; target++) {
	if ((cmd = TARGDATA(target)->cur_cmd)) {
	    printk("scsi%d: Failing command for ID%d\n",
			host->host_no, target);
	    cmd->result = DID_RESET << 16;
	    cmd->scsi_done(cmd);
	    TARGDATA(target)->cur_cmd = NULL;
	}
    }

    sim700_soft_reset(host);
    sim700_driver_init(host);
    target = HOST_ID;
    targdata = TARGDATA(target);
    NCR_write32(DSP_REG, low32(TARGDATA(target)->ba->script+Ent_reselect/4));
    hostdata->state = STATE_IDLE;

    run_process_issue_queue(hostdata);

    return SUCCESS;
}

/*
 * This is host reset.  We need to reset the chip and the bus.
 */

int
sim700_host_reset(Scsi_Cmnd * SCpnt)
{
    struct Scsi_Host * host = SCpnt->host;

    printk("scsi%d: >>>>>>>>>>>> Host reset <<<<<<<<<<<<\n", host->host_no);

    return full_reset(host);
}

#ifdef MODULE

int
sim700_release(struct Scsi_Host *host)
{
    struct sim700_hostdata *hostdata = (struct sim700_hostdata *)host->hostdata;

    NCR_write8(DIEN_REG, 0);
    NCR_write8(SIEN_REG_700, 0);
    ncr_halt(host);
    free_pages((unsigned long)hostdata->bounce_bufs, 0);
    if (dma_consistent)
	pci_free_consistent(NULL, PAGE_SIZE << 3, hostdata->targets,
		    hostdata->targets_busaddr);
    else
	free_pages((unsigned long)hostdata->targets, 3);
    free_irq(host->irq, host);
    if (hostdata->options & OPT_IO_MAPPED)
	release_region((unsigned long)host->base, 64);
    else
	release_mem_region((unsigned long)host->base, 64);
    return 1;
}
#endif

#ifdef __hppa__
static Scsi_Host_Template driver_template = SCSI_LASI;
#else
static Scsi_Host_Template driver_template = SIM700_SCSI;
#endif

#include "scsi_module.c"
