/***************************************************************************
                          paddle.c  -  description
                             -------------------
    begin                : Fri Sep 7 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lbreakout.h"
#include "config.h"
#include "event.h"
#include "difficulty.h"
#include "levels.h"
#include "bricks.h"
#include "shots.h"
#include "paddle.h"
#ifdef SOUND
#include "audio.h"
#endif

/*
====================================================================
Basic paddle
====================================================================
*/
extern SDL_Surface *paddle_pic; /* paddle tiles: left, middle, right for each paddle type */
extern SDL_Surface *paddle_shadow;
int paddle_cw = 18, paddle_ch = 18; /* size of a graphical paddle component */
Paddle paddle; /* paddle data */
int paddle_pic_y_offset; /* use paddle tile set at this offset */
int paddle_frozen = 0; /* paddle frozen? */
int paddle_slime = 0; /* paddle covered with slime */
int paddle_attract = 0;
Delay paddle_resize_delay; /* every delay ms the paddle size is adjusted about two pixels */
int paddle_resized = 0; /* if this flag is set balls_update() will update the position of attached balls and clear this flag */
int paddle_invis = 0; /* is paddle invisible? */
int paddle_invis_delay; /* as long as this isn't timed out the paddle is seen. will be reset by movement */
enum { PADDLE_INVIS_DELAY = 200 };
/*
====================================================================
Plasma weapon stuff
====================================================================
*/
extern SDL_Surface *weapon_pic;
extern SDL_Surface *weapon_shadow;
int weapon_y_off = 0;
int weapon_x, weapon_y; /* last position where weapon has been drawn */
int weapon_w = 14;
int weapon_h = 18;
int weapon_fr_num = 4;
float weapon_fpms = 0.006;
float weapon_cur = 0;
int weapon_inst = 0; /* is weapon installed? */
int weapon_fire = 0; /* fire weapon! */
Delay weapon_delay; /* delay between shots */
/*
====================================================================
Other stuff
====================================================================
*/
extern Diff *diff; /* current difficulty */
extern Sdl sdl;
extern SDL_Surface *offscreen;
extern int motion;
extern int motion_x;
extern int motion_rel_x;
extern int keystate[SDLK_LAST];
extern Config config;
extern int shadow_size;
#ifdef SOUND
extern Sound_Chunk *wav_expand, *wav_shrink, *wav_frozen;
#endif
extern int active[EX_NUMBER];

/*
====================================================================
Load and free paddle graphics.
====================================================================
*/
void paddle_load()
{
	delay_set( &paddle_resize_delay, 40 );
}
void paddle_delete()
{
}
/*
====================================================================
Reset position and size of paddle.
====================================================================
*/
void paddle_reset() {
    paddle.len = diff->paddle_size;
    paddle.max_len = diff->paddle_max_size;
    paddle.w = (paddle.len + 2) * paddle_cw;
	paddle.wanted_w = paddle.w;
    paddle.h = paddle_ch;
    paddle.y = (MAP_HEIGHT - 2) * BRICK_HEIGHT;
    paddle.x = ((MAP_WIDTH * BRICK_WIDTH) - paddle.w) / 2; // centered //
    paddle.cur_x = paddle.x;
    paddle.friction = 0.3;
    paddle.time = 0;
    /* reset weapon delay&weapon */
    delay_set( &weapon_delay, 100 );
    weapon_inst = weapon_fire = 0;
    /* reset slime&frozen */
    paddle_slime = 0;
    paddle_frozen = 0;
    paddle_pic_y_offset = 0;
    /* attract */
    paddle_attract = ATTRACT_NONE;
	/* no ivisiblivty */
	paddle_invis = 0;
}
/*
====================================================================
Freeze paddle movement or set slime.
====================================================================
*/
void paddle_freeze( int freeze )
{
#ifdef SOUND
    if ( !paddle_frozen && freeze )
        sound_play( wav_frozen );
#endif
    paddle_frozen = freeze;
    if ( freeze )
        paddle_pic_y_offset = paddle_ch << 1;
    else
        if ( paddle_slime )
            paddle_pic_y_offset = paddle_ch;
        else
            paddle_pic_y_offset = 0;
}
void paddle_set_slime( int slime )
{
    paddle_slime = slime;
    if ( paddle_frozen )
        paddle_pic_y_offset = paddle_ch << 1;
    else
        if ( slime )
            paddle_pic_y_offset = paddle_ch;
        else
            paddle_pic_y_offset = 0;
}
int paddle_slimy()
{
    return paddle_slime;
}
/*
====================================================================
Set if paddle attracts boni/mali or none.
====================================================================
*/
void paddle_set_attract( int attract )
{
    paddle_attract = attract;
    /* no graphical change yet */
}
inline int paddle_attract_malus()
{
    return ( paddle_attract == ATTRACT_MALUS );
}
inline int paddle_attract_bonus()
{
    return ( paddle_attract == ATTRACT_BONUS );
}
/*
====================================================================
(De)activate ghostly behaviour: paddle is only seen when moved at
maximum 250ms before.
====================================================================
*/
void paddle_set_invis( int invis )
{
	if ( invis ) paddle_invis_delay = PADDLE_INVIS_DELAY;
	paddle_invis = invis;
}
int  paddle_solid()
{
	/* does paddle is visible? */
	if ( !paddle_invis ) return 1;
	if ( paddle_invis_delay ) return 1;
	return 0;
}
/*
====================================================================
Init paddle resize (the change between wanted_w and w MUST be
even (else the paddle shrinks til eternity)
====================================================================
*/
int paddle_init_resize( int c )
{
    /* resize possbile */
    if ( paddle.len + c > paddle.max_len || paddle.len + c < 1 ) return 0;
#ifdef SOUND
    if ( c < 0 )
        sound_play( wav_shrink );
    else
        sound_play( wav_expand );
#endif
    /* get wanted width */
    paddle.len += c;
	paddle.wanted_w = (paddle.len + 2) * paddle_cw;
	/* reset delay */
	delay_reset( &paddle_resize_delay );
    return 1;
}
/*
====================================================================
Actually resize paddle
====================================================================
*/
void paddle_resize( int ms )
{
	if ( paddle.w == paddle.wanted_w ) return;
	if ( !delay_timed_out( &paddle_resize_delay, ms ) ) return;
	/* change size and position */
	if ( paddle.w < paddle.wanted_w ) {
		paddle_resized = 1;
		paddle.w += 2;
		paddle.cur_x -= 1;
		paddle.x = (int)paddle.cur_x;
		/* check range */
    	if (paddle.x < BRICK_WIDTH)
        	paddle.x = BRICK_WIDTH;
	    if (paddle.x + paddle.w > sdl.screen->w - BRICK_WIDTH)
    	    paddle.x = sdl.screen->w - BRICK_WIDTH - paddle.w;
	}	
	else {
		paddle_resized = -1;
		paddle.w -= 2;
		paddle.cur_x += 1;
		paddle.x = (int)paddle.cur_x;
	}	
}
/*
====================================================================
Hide and show paddle on screen.
====================================================================
*/
void paddle_hide()
{
    int y = paddle.y;
    int w = paddle.w;
    int h = paddle.h;
    if ( weapon_inst ) {
        y -= weapon_y_off;
        h = weapon_h;
    }
    if ( config.shadow ) { w += shadow_size; h += shadow_size; }
    DEST(sdl.screen, paddle.x, y, w, h );
    SOURCE(offscreen, paddle.x, y);
    blit_surf();
    add_refresh_rect(paddle.x, y, w, h );
}
void paddle_show()
{
    int i;
    int w = paddle.w;
    int h = paddle.h;
	int aux_w = 0;
	int rem_middle_w; /* remaining points to draw in the middle */
	/* if invisible return or show alpha */
	if ( paddle_invis ) {
		if ( paddle_invis_delay != 0 ) 
			paddle_alphashow( 128 );
		return;
	}
    if ( config.shadow ) set_surf_clip( sdl.screen, 0, 0, sdl.screen->w - BRICK_WIDTH, sdl.screen->h );
    if ( config.shadow ) { w += shadow_size; h += shadow_size; }
    /* paddle */
	/* left end */
    if ( config.shadow ) {
        DEST(sdl.screen, paddle.x + shadow_size, paddle.y + shadow_size, paddle_cw, paddle_ch);
        SOURCE(paddle_shadow, 0, 0);
        alpha_blit_surf( SHADOW_ALPHA );
    }
    DEST(sdl.screen, paddle.x, paddle.y, paddle_cw, paddle_ch);
    SOURCE(paddle_pic, 0, paddle_pic_y_offset);
	if ( !active[EX_DARKNESS] )
       	blit_surf();
	else
		alpha_blit_surf( 128 );
	/* middle part */
    for ( i = paddle_cw, rem_middle_w = paddle.w - ( paddle_cw << 1 ); rem_middle_w > 0; i += paddle_cw, rem_middle_w -= paddle_cw ) {
		if ( rem_middle_w > paddle_cw )
			aux_w = paddle_cw;
		else
			aux_w = rem_middle_w;
        if ( config.shadow ) {
            DEST(sdl.screen, paddle.x + shadow_size + i, paddle.y + shadow_size, aux_w, paddle_ch);
            SOURCE(paddle_shadow, paddle_cw, 0);
            alpha_blit_surf( SHADOW_ALPHA );
        }
        DEST(sdl.screen, paddle.x + i, paddle.y, aux_w, paddle_ch);
        SOURCE(paddle_pic, paddle_cw, paddle_pic_y_offset);
		if ( !active[EX_DARKNESS] )
        	blit_surf();
		else
			alpha_blit_surf( 128 );
    }
	i = paddle.w - paddle_cw;	
	/* right end */
    if ( config.shadow ) {
        DEST(sdl.screen, paddle.x + shadow_size + i, paddle.y + shadow_size, paddle_cw, paddle_ch);
        SOURCE(paddle_shadow, paddle_cw * 2, 0);
        alpha_blit_surf( SHADOW_ALPHA );
    }
    DEST(sdl.screen, paddle.x + i, paddle.y, paddle_cw, paddle_ch);
    SOURCE(paddle_pic, paddle_cw * 2, paddle_pic_y_offset);
	if ( !active[EX_DARKNESS] )
       	blit_surf();
	else
		alpha_blit_surf( 128 );
    /* weapon */
    if ( weapon_inst ) {
        weapon_x = paddle.x + (paddle.w - weapon_w) / 2;
        weapon_y = paddle.y - weapon_y_off;
        DEST(sdl.screen, weapon_x, weapon_y, weapon_w, weapon_h);
        SOURCE(weapon_pic, (int)weapon_cur * weapon_w, 0);
		if ( !active[EX_DARKNESS] )
        	blit_surf();
		else
			alpha_blit_surf( 128 );
        add_refresh_rect(paddle.x, weapon_y, w, h);
    }
    else
        add_refresh_rect(paddle.x, paddle.y, w, h);
    if ( config.shadow ) set_surf_clip( sdl.screen, 0, 0, 0, 0 );
}
void paddle_alphashow( int a )
{
    int i, aux_w;
	int rem_middle_w;
	/* left end */
    DEST(sdl.screen, paddle.x, paddle.y, paddle_cw, paddle_ch);
    SOURCE(paddle_pic, 0, paddle_pic_y_offset);
    alpha_blit_surf(a);
	/* middle part */
    for ( i = paddle_cw, rem_middle_w = paddle.w - ( paddle_cw << 1 ); rem_middle_w > 0; i += paddle_cw, rem_middle_w -= paddle_cw ) {
		if ( rem_middle_w > paddle_cw )
			aux_w = paddle_cw;
		else
			aux_w = rem_middle_w;
        DEST(sdl.screen, paddle.x + i, paddle.y, aux_w, paddle_ch);
        SOURCE(paddle_pic, paddle_cw, paddle_pic_y_offset);
        alpha_blit_surf(a);
    }
	i = paddle.w - paddle_cw;	
	/* right end */
    DEST(sdl.screen, paddle.x + i, paddle.y, paddle_cw, paddle_ch);
    SOURCE(paddle_pic, paddle_cw * 2, paddle_pic_y_offset);
    alpha_blit_surf(a);
    if ( weapon_inst ) {
        weapon_x = paddle.x + (paddle.w - weapon_w) / 2;
        weapon_y = paddle.y - weapon_y_off;
        DEST(sdl.screen, weapon_x, weapon_y, weapon_w, weapon_h);
        SOURCE(weapon_pic, (int)weapon_cur * weapon_w, 0);
        alpha_blit_surf(a);
        add_refresh_rect(paddle.x, weapon_y, paddle.w, weapon_h);
    }
    else
        add_refresh_rect(paddle.x, paddle.y, paddle.w, paddle.h);
}
/*
====================================================================
Update position of paddle and weapon animation if any.
====================================================================
*/
void paddle_update( int ms )
{
#ifdef PADDLE_FRICTION
    int old_x = paddle.x;
    int off_x;
#endif
    int moved = 0;

    if ( paddle_frozen ) {
#ifdef PADDLE_FRICTION
        paddle.v_x = 0;
#endif
        return;
    }
	/* invisiblity */
	if ( paddle_invis && paddle_invis_delay > 0 ) {
		paddle_invis_delay -= ms;
		if ( paddle_invis_delay < 0 ) paddle_invis_delay = 0;
	}
    /* mouse motion */
    if (motion && config.control != 0) {
        if (config.rel_motion)
            paddle.cur_x += motion_rel_x;
        else
            paddle.cur_x = motion_x - ( paddle.w >> 1 );
#ifdef PADDLE_FRICTION
        paddle.time = 200;
#endif
        moved = 1;
    }
    /* keys */
    if (keystate[config.k_left] && config.control != 1) {
        paddle.cur_x -= config.key_speed * ms;
        paddle.time = 0;
        moved = 1;
    }
    if (keystate[config.k_right] && config.control != 1) {
        paddle.cur_x += config.key_speed * ms;
        paddle.time = 0;
        moved = 1;
    }
#ifdef PADDLE_FRICTION
    /* paddle should have friction for some time */
    if (paddle.time > 0) {
        paddle.time -= ms;
        if (paddle.time < 0) {
            paddle.time = 0;
            paddle.v_x = 0.0;
        }
    }
    else
        paddle.v_x = 0.0;
#endif
    /* check paddle when moved */
    if ( moved ) {
        /* check range */
        if (paddle.cur_x < BRICK_WIDTH)
            paddle.cur_x = BRICK_WIDTH;
        if (paddle.cur_x + paddle.w >= sdl.screen->w - BRICK_WIDTH)
            paddle.cur_x = sdl.screen->w - BRICK_WIDTH - paddle.w;
        /* absolute position */
        paddle.x = (int)paddle.cur_x;
#ifdef PADDLE_FRICTION
        /* offset */
        off_x = paddle.x - old_x;
        /* speed */
        paddle.v_x = (float)(off_x) / ms;
        if ( motion ) {
            /* limit mouse speed */
            if (paddle.v_x > 5.0) paddle.v_x = 5.0;
            if (paddle.v_x < -5.0) paddle.v_x = -5.0;
            paddle.v_x /= 5;
        }
		/* visible for some time */
		paddle_invis_delay = PADDLE_INVIS_DELAY;
#endif
    }
    /* weapon animation */
    if ( weapon_inst ) {
        weapon_cur += ms * weapon_fpms;
        if (weapon_cur >= weapon_fr_num) weapon_cur -= weapon_fr_num;
    }
    if ( weapon_inst && weapon_fire && delay_timed_out( &weapon_delay, ms ) && shots_below_limit() )
        shot_create( paddle.x + ( paddle.w >> 1 ), weapon_y + ( weapon_h >> 1 ) );
	/* check for resize */
	paddle_resize( ms );
}
/*
====================================================================
De/Activate weapon
====================================================================
*/
void weapon_install( int install )
{
    weapon_inst = install;
    if ( !install ) weapon_stop_fire();
}
/*
====================================================================
Check if weapon's installed
====================================================================
*/
int weapon_installed()
{
    return weapon_inst;
}
/*
====================================================================
Start firing at maxium rate until weapon_stop() is called.
====================================================================
*/
void weapon_start_fire()
{
    delay_reset( &weapon_delay );
    if ( shots_below_limit() ) shot_create( paddle.x + ( paddle.w >> 1 ), weapon_y + ( weapon_h >> 1 ) );
    weapon_fire = 1;
}
void weapon_stop_fire()
{
    weapon_fire = 0;
}
/*
====================================================================
weapon_firing() returns true if weapon is firing
====================================================================
*/
int weapon_firing()
{
    return weapon_fire;
}
