/***************************************************************************
                          paddle.h  -  description
                             -------------------
    begin                : Thu Sep 6 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* if this is not defined paddle has no velocity balls are reflected by convex surface */
#define PADDLE_FRICTION

typedef struct {
    float   cur_x;
    int     x, y;
#ifdef PADDLE_FRICTION
    float   v_x;
#endif
    int     w, h; /* actual measures */
	int		wanted_w; /* resize until w == wanted_w */
    int     len; /* how many middle components ? */
    int     max_len; /* limit */
    float   friction; /* how much relative speed is given to balls ? */
    int     time;
} Paddle;

/*
====================================================================
Load and free paddle graphics.
====================================================================
*/
void paddle_load();
void paddle_delete();
/*
====================================================================
Reset position and size of paddle.
====================================================================
*/
void paddle_reset();
/*
====================================================================
Freeze paddle movement or set slime.
====================================================================
*/
void paddle_freeze( int freeze );
void paddle_set_slime( int slime );
int paddle_slimy();
/*
====================================================================
Set if paddle attracts boni/mali or none.
====================================================================
*/
enum {
    ATTRACT_NONE = 0,
    ATTRACT_BONUS,
    ATTRACT_MALUS
};
void paddle_set_attract( int attract );
int paddle_attract_malus();
int paddle_attract_bonus();
/*
====================================================================
(De)activate ghostly behaviour: paddle is only seen when moved at
maximum 250ms before.
====================================================================
*/
void paddle_set_invis( int invis );
int  paddle_solid();
/*
====================================================================
Resize paddle
====================================================================
*/
int paddle_init_resize( int c );
/*
====================================================================
Hide and show paddle on screen.
====================================================================
*/
void paddle_hide();
void paddle_show();
void paddle_alphashow( int a );
/*
====================================================================
Update position of paddle and weapon animation if any.
====================================================================
*/
void paddle_update( int ms );
/*
====================================================================
De/Activate weapon
====================================================================
*/
void weapon_install( int install );
/*
====================================================================
Check if weapon's installed
====================================================================
*/
int weapon_installed();
/*
====================================================================
Start firing at maxium rate until weapon_stop() is called.
====================================================================
*/
void weapon_start_fire();
void weapon_stop_fire();
/*
====================================================================
weapon_firing() returns true if weapon is firing
====================================================================
*/
int weapon_firing();
