#! /usr/bin/perl -w

package common_data;
use base qw(Exporter);
@EXPORT=qw(%known_archs %known_sections %known_non_us %known_distributions
           %known_prios %known_source_fields %known_binary_fields
	   %known_obsolete_fields %known_essential %known_build_essential
	   %known_obsolete_packages %known_virtual_packages);

# simple defines for commonly needed data

%known_archs = map { $_ => 1 }
    ('alpha', 'arm', 'hppa', 'hurd-i386', 'i386', 'ia64', 'mips', 'mipsel',
     'm68k', 'powerpc', 's390', 'sh', 'sparc', 'any', 'all');

%known_sections = map { $_ => 1 }
    ('admin', 'base', 'comm', 'devel', 'doc', 'editors', 'electronics',
     'games', 'graphics', 'hamradio', 'interpreters', 'libs', 'mail',
     'math', 'misc', 'net', 'news', 'oldlibs', 'otherosfs', 'science',
     'shells', 'sound', 'tex', 'text', 'utils', 'web', 'x11'
    );

%known_non_us = map { $_ => 1 } ('non-free', 'contrib', 'main' );

%known_distributions = map { $_ => 1 }
    ('non-free', 'contrib', 'non-US', 'non-us' );

%known_prios = map { $_ => 1 }
    ('required', 'important', 'standard', 'optional', 'extra');

%known_source_fields = map { $_ => 1 }
    ('source', 'version', 'maintainer', 'binary', 'architecture',
     'standards-version', 'files', 'build-depends', 'build-depends-indep',
     'build-conflicts', 'build-conflicts-indep', 'format' );

%known_binary_fields = map { $_ => 1 }
    ('package', 'version', 'architecture', 'depends', 'pre-depends',
     'recommends', 'suggests', 'enhances', 'conflicts', 'provides',
     'replaces', 'essential', 'maintainer', 'section', 'priority',
     'source', 'description', 'installed-size');

%known_obsolete_fields = map { $_ => 1 }
    ('revision', 'package-revision', 'package_revision',
     'recommended', 'optional', 'class');

%known_essential = map { $_ => 1 }
    ('base-files', 'base-passwd', 'bash', 'bsdutils', 'debianutils',
     'diff', 'dpkg', 'e2fsprogs', 'fileutils', 'findutils', 'grep', 'gzip',
     'hostname', 'ldso', 'login', 'mount', 'ncurses-base', 'ncurses-bin',
     'perl-base', 'sed', 'shellutils', 'sysvinit', 'tar', 'textutils',
     'update', 'util-linux');

%known_build_essential = map { $_ => 1 }
    ('libc6-dev', 'libc-dev', 'gcc', 'g++', 'make', 'dpkg-dev');

%known_obsolete_packages = map { $_ => 1 }
    ('libstdc++2.8', 'ncurses3.4', 'slang0.99.38', 'newt0.25', 'mesag2',
     'libjpegg6a', 'gmp2', 'libgtop0', 'libghttp0', 'libpgsql', 'tk4.2',
     'tcl7.6', 'libpng0g', 'xbase');

%known_virtual_packages = map { $_ => 1 }
    ('x-terminal-emulator', 'x-window-manager', 'xserver', 'awk', 'c-compiler',
     'c-shell', 'dotfile-module', 'emacsen', 'fortran77-compiler',
     'ftp-server', 'httpd', 'ident-server', 'info-browser',
     'ispell-dictionary', 'kernel-headers', 'kernel-image', 'kernel-source',
     'linux-kernel-log-daemon', 'lambdamoo-core', 'lambdamoo-server',
     'libc-dev', 'libc.so.4', 'man-browser', 'pdf-preview', 'pdf-viewer',
     'postscript-preview', 'postscript-viewer', 'rsh-client', 'rsh-server',
     'system-log-daemon', 'tclsh', 'telnet-client', 'telnet-server',
     'time-daemon', 'ups-monitor', 'wish', 'wordlist', 'www-browser',
     'imap-client', 'imap-server', 'mail-reader', 'mail-transport-agent',
     'news-reader', 'news-transport-system', 'pgp', 'pop3-server',
     'mp3-encoder', 'mp3-decoder');

1;
