#---------------------------------------------------------------------------
#
#   libtunepimp -- The MusicBrainz tagging library.  
#                  Let a thousand taggers bloom!
#   
#   Copyright (C) Robert Kaye 2003
#   
#   This file is part of libtunepimp.
#
#   libtunepimp is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   libtunepimp is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with libtunepimp; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#   $Id: metadata.py,v 1.3 2004/03/25 09:20:15 robert Exp $
#
#---------------------------------------------------------------------------
import _tunepimp

def _swig_setattr(self,class_type,name,value):
    if (name == "this"):
        if isinstance(value, class_type):
            self.__dict__[name] = value.this
            if hasattr(value,"thisown"): self.__dict__["thisown"] = value.thisown
            del value.thisown
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    self.__dict__[name] = value

def _swig_getattr(self,class_type,name):
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types


class metadata(_object):
    '''This class is used to get/set the metadata for a track inside tunepimp. For details
       on how to use this class, please look up the main tunepimp documentation'''

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, metadata, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, metadata, name)
    def __repr__(self):
        return "<C metadata instance at %s>" % (self.this,)
    __swig_setmethods__["artist"] = _tunepimp.metadata_artist_set
    __swig_getmethods__["artist"] = _tunepimp.metadata_artist_get
    if _newclass:artist = property(_tunepimp.metadata_artist_get, _tunepimp.metadata_artist_set)
    __swig_setmethods__["sortName"] = _tunepimp.metadata_sortName_set
    __swig_getmethods__["sortName"] = _tunepimp.metadata_sortName_get
    if _newclass:sortName = property(_tunepimp.metadata_sortName_get, _tunepimp.metadata_sortName_set)
    __swig_setmethods__["album"] = _tunepimp.metadata_album_set
    __swig_getmethods__["album"] = _tunepimp.metadata_album_get
    if _newclass:album = property(_tunepimp.metadata_album_get, _tunepimp.metadata_album_set)
    __swig_setmethods__["track"] = _tunepimp.metadata_track_set
    __swig_getmethods__["track"] = _tunepimp.metadata_track_get
    if _newclass:track = property(_tunepimp.metadata_track_get, _tunepimp.metadata_track_set)
    __swig_setmethods__["trackNum"] = _tunepimp.metadata_trackNum_set
    __swig_getmethods__["trackNum"] = _tunepimp.metadata_trackNum_get
    if _newclass:trackNum = property(_tunepimp.metadata_trackNum_get, _tunepimp.metadata_trackNum_set)
    __swig_setmethods__["variousArtist"] = _tunepimp.metadata_variousArtist_set
    __swig_getmethods__["variousArtist"] = _tunepimp.metadata_variousArtist_get
    if _newclass:variousArtist = property(_tunepimp.metadata_variousArtist_get, _tunepimp.metadata_variousArtist_set)
    __swig_setmethods__["artistId"] = _tunepimp.metadata_artistId_set
    __swig_getmethods__["artistId"] = _tunepimp.metadata_artistId_get
    if _newclass:artistId = property(_tunepimp.metadata_artistId_get, _tunepimp.metadata_artistId_set)
    __swig_setmethods__["albumId"] = _tunepimp.metadata_albumId_set
    __swig_getmethods__["albumId"] = _tunepimp.metadata_albumId_get
    if _newclass:albumId = property(_tunepimp.metadata_albumId_get, _tunepimp.metadata_albumId_set)
    __swig_setmethods__["trackId"] = _tunepimp.metadata_trackId_set
    __swig_getmethods__["trackId"] = _tunepimp.metadata_trackId_get
    if _newclass:trackId = property(_tunepimp.metadata_trackId_get, _tunepimp.metadata_trackId_set)
    __swig_setmethods__["fileTrm"] = _tunepimp.metadata_fileTrm_set
    __swig_getmethods__["fileTrm"] = _tunepimp.metadata_fileTrm_get
    if _newclass:fileTrm = property(_tunepimp.metadata_fileTrm_get, _tunepimp.metadata_fileTrm_set)
    __swig_setmethods__["albumArtistId"] = _tunepimp.metadata_albumArtistId_set
    __swig_getmethods__["albumArtistId"] = _tunepimp.metadata_albumArtistId_get
    if _newclass:albumArtistId = property(_tunepimp.metadata_albumArtistId_get, _tunepimp.metadata_albumArtistId_set)
    __swig_setmethods__["duration"] = _tunepimp.metadata_duration_set
    __swig_getmethods__["duration"] = _tunepimp.metadata_duration_get
    if _newclass:duration = property(_tunepimp.metadata_duration_get, _tunepimp.metadata_duration_set)
    __swig_setmethods__["albumType"] = _tunepimp.metadata_albumType_set
    __swig_getmethods__["albumType"] = _tunepimp.metadata_albumType_get
    if _newclass:albumType = property(_tunepimp.metadata_albumType_get, _tunepimp.metadata_albumType_set)
    __swig_setmethods__["fileFormat"] = _tunepimp.metadata_fileFormat_set
    __swig_getmethods__["fileFormat"] = _tunepimp.metadata_fileFormat_get
    if _newclass:fileFormat = property(_tunepimp.metadata_fileFormat_get, _tunepimp.metadata_fileFormat_set)
    __swig_setmethods__["releaseYear"] = _tunepimp.metadata_releaseYear_set
    __swig_getmethods__["releaseYear"] = _tunepimp.metadata_releaseYear_get
    if _newclass:numTRMIds = property(_tunepimp.metadata_releaseYear_get, _tunepimp.metadata_releaseYear_set)
    __swig_setmethods__["releaseMonth"] = _tunepimp.metadata_releaseMonth_set
    __swig_getmethods__["releaseMonth"] = _tunepimp.metadata_releaseMonth_get
    if _newclass:numTRMIds = property(_tunepimp.metadata_releaseMonth_get, _tunepimp.metadata_releaseMonth_set)
    __swig_setmethods__["releaseDay"] = _tunepimp.metadata_releaseDay_set
    __swig_getmethods__["releaseDay"] = _tunepimp.metadata_releaseDay_get
    if _newclass:numTRMIds = property(_tunepimp.metadata_releaseDay_get, _tunepimp.metadata_releaseDay_set)
    __swig_setmethods__["releaseCountry"] = _tunepimp.metadata_releaseCountry_set
    __swig_getmethods__["releaseCountry"] = _tunepimp.metadata_releaseCountry_get
    if _newclass:numTRMIds = property(_tunepimp.metadata_releaseCountry_get, _tunepimp.metadata_releaseCountry_set)
    __swig_setmethods__["numTRMIds"] = _tunepimp.metadata_numTRMIds_set
    __swig_getmethods__["numTRMIds"] = _tunepimp.metadata_numTRMIds_get
    if _newclass:numTRMIds = property(_tunepimp.metadata_numTRMIds_get, _tunepimp.metadata_numTRMIds_set)


    def __init__(self, *args):
        _swig_setattr(self, metadata, 'this', _tunepimp.new_metadata(*args))
        _swig_setattr(self, metadata, 'thisown', 1)

    def __del__(self, destroy=_tunepimp.delete_metadata):
        try:
            if self.thisown: destroy(self)
        except: pass

    def clear(self):
        return _tunepimp.Clear(self.this)

    def convertToAlbumStatus(statusStr):
        return _tunepimp.ConvertToAlbumStatus(statusStr)

    def convertToAlbumType(typeStr):
        return _tunepimp.ConvertToAlbumType(typeStr)

    def convertFromAlbumStatus(status):
        return _tunepimp.ConvertFromAlbumStatus(status)

    def convertFromAlbumType(type):
        return _tunepimp.ConvertFromAlbumType(type)

    convertFromAlbumType = staticmethod(convertFromAlbumType)
    convertToAlbumType = staticmethod(convertToAlbumType)
    convertFromAlbumStatus = staticmethod(convertFromAlbumStatus)
    convertToAlbumStatus = staticmethod(convertToAlbumStatus)

class metadataPtr(metadata):
    def __init__(self, this):
        _swig_setattr(self, metadata, 'this', this)
        if not hasattr(self,"thisown"): _swig_setattr(self, metadata, 'thisown', 0)
        _swig_setattr(self, metadata,self.__class__,metadata)
_tunepimp.metadata_swigregister(metadataPtr)

