.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbSetDetectableAutoRepeat __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbSetDetectableAutoRepeat \- Sets DetectableAutoRepeat
.SH SYNTAX
.HP
.B Bool XkbSetDetectableAutoRepeat
.BI "(\^Display *" "display" "\^,"
.BI "Bool " "detectable" "\^,"
.BI "Bool *" "supported_rtrn" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- display
connection to X server
.TP
.I \- detectable
True => set DetectableAutoRepeat
.TP
.I \- supported_rtrn
backfilled True if DetectableAutoRepeat supported
.SH DESCRIPTION
.LP
Auto-repeat is the generation of multiple key events by a keyboard when the user
presses a key and holds it down. Keyboard hardware and device-dependent X server
software often implement auto-repeat by generating multiple KeyPress events with
no intervening KeyRelease event. The standard behavior of the X server is to
generate a KeyRelease event for every KeyPress event. If the keyboard hardware
and device-dependent software of the X server implement auto-repeat by
generating multiple KeyPress events, the device-independent part of the X server
by default synthetically generates a KeyRelease event after each KeyPress event.
This provides predictable behavior for X clients, but does not allow those
clients to detect the fact that a key is auto-repeating.

Xkb allows clients to request
.I detectable auto-repeat.
If a client requests and the server supports DetectableAutoRepeat, Xkb generates
KeyRelease events only when the key is physically released. If
DetectableAutoRepeat is not supported or has not been requested, the server
synthesizes a KeyRelease event for each repeating KeyPress event it generates.

DetectableAutoRepeat, unlike other controls, is not contained in the
XkbControlsRec structure, nor can it be enabled or disabled via the
EnabledControls control. Instead, query and set DetectableAutoRepeat using
.I XkbGetDetectableAutoRepeat
and
.I XkbSetDetectableAutoRepeat.

DetectableAutoRepeat is a condition that applies to all keyboard devices for a
client's connection to a given X server; it cannot be selectively set for some
devices and not for others. For this reason, none of the Xkb library functions
involving DetectableAutoRepeat involve a device specifier.

This request affects all keyboard activity for the requesting client only; other
clients still see the expected nondetectable auto-repeat behavior, unless they
have requested otherwise.

.I XkbSetDetectableAutoRepeat
sends a request to the server to set DetectableAutoRepeat on for the current
client if
.I detectable
is True, and off if
.I detectable
is False; it then waits for a reply. If
.I supported_rtrn
is not NULL,
.I XkbSetDetectableAutoRepeat
backfills
.I supported_rtrn
with True if the server supports DetectableAutoRepeat, and False if it does not.
.I XkbSetDetectableAutoRepeat
returns the current state of DetectableAutoRepeat for the requesting client:
True if DetectableAutoRepeat is set, and False otherwise.
.SH "RETURN VALUES"
.TP 15
True
The
.I XkbSetDetectableAutoRepeat
function returns True if DetectableAutoRepeat is set.
.TP 15
False
The
.I XkbSetDetectableAutoRepeat
function returns False if DetectableAutoRepeat is not set.
