<?php
/**
 * Mahara: Electronic portfolio, weblog, resume builder and social networking
 * Copyright (C) 2006-2009 Catalyst IT Ltd and others; see:
 *                         http://wiki.mahara.org/Contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package    mahara
 * @subpackage core
 * @author     Catalyst IT Ltd
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL
 * @copyright  (C) 2006-2009 Catalyst IT Ltd http://catalyst.net.nz
 *
 */

define('INTERNAL', 1);
define('PUBLIC', 1);
define('MENUITEM', '');
define('HOME', 1);
require('init.php');
define('TITLE', get_string('home'));

// Check for whether the user is logged in, before processing the page. After
// this, we can guarantee whether the user is logged in or not for this page.
if (!$USER->is_logged_in()) {
    $pagename = 'loggedouthome';
    $lang = param_alphanumext('lang', null);
    if (!empty($lang)) {
        $SESSION->set('lang', $lang);
        redirect();
    }
}
else {
    $pagename = 'home';
}

$smarty = smarty();
$smarty->assign('page_content', get_site_page_content($pagename));

if ($nviews = get_config('homepageviewlist')) {
    require_once('view.php');
    $views = View::view_search(null, null, null, null, $nviews, 0, true, 'mtime DESC');
    $smarty->assign('views', $views->data);
}

$smarty->display('index.tpl');

?>
