#!/usr/bin/perl

# Copyright (c) Kim Holviala <kimmy@iki.fi> 1997-2000

require 5.002;


# Configuration variables ===================================================

# Da string itself
	$historystring = "25|&#183;|&#183;|&#183;|&#183;|20|" .
		"&#183;|&#183;|&#183;|&#183;|15|" .
		"&#183;|&#183;|&#183;|&#183;|10|" .
		"&#183;|&#183;|&#183;|&#183;|5|" .
		"&#183;|&#183;|&#183;|&#183;|Now";

# Domains and countries
	%country = (
		'com', 'USA',
		'org', 'USA',
		'net', 'USA',
		'mil', 'USA',
		'edu', 'USA',
		'gov', 'USA',

		'as', 'American Samoa',
		'au', 'Australia',
		'at', 'Austria',
		'bs', 'Bahamas',
		'be', 'Belgium',
		'br', 'Brazil',
		'ca', 'Canada',
		'cn', 'China',
		'co', 'Colombia',
		'cr', 'Costa Rica',
		'cz', 'Czech Republic',
		'dk', 'Denmark',
		'do', 'Dominican Republic',
		'ec', 'Ecuador',
		'ee', 'Estonia',
		'fi', 'Finland',
		'fr', 'France',
		'tf', 'French Southern Territories',
		'de', 'Germany',
		'hk', 'Hong Kong',
		'hu', 'Hungary',
		'is', 'Iceland',
		'in', 'India',
		'ie', 'Ireland',
		'il', 'Israel',
		'it', 'Italy',
		'jp', 'Japan',
		'kw', 'Kuwait',
		'lt', 'Lithuania',
		'nl', 'Netherlands',
		'an', 'Netherlands Antilles',
		'nz', 'New Zealand',
		'ni', 'Nicaragua',
		'nu', 'Niue',
		'no', 'Norway',
		'my', 'Malaysia',
		'mx', 'Mexico',
		'pe', 'Peru',
		'pl', 'Poland',
		'pt', 'Portugal',
		'ro', 'Romania',
		'ru', 'Russian Federation',
		'za', 'South Africa',
		'es', 'Spain',
		'se', 'Sweden',
		'sg', 'Singapore',
		'ch', 'Switzerland',
		'th', 'Thailand',
		'tw', 'Taiwan',
		'tz', 'Tanzania',
		'ae', 'United Arab Emirates',
		'uk', 'United Kindom',
		'uy', 'Uruguay',
		'us', 'USA',
		've', 'Venezuela');

# Images for the graphs
	$darkimage = "log_darkblue.gif";
	$lightimage = "log_blue.gif";

# Alternative color for table backgrounds
	$altcolor = "BGCOLOR=\"#E0E0E0\"";


# Logfile parser ============================================================

# Handle everything ---------------------------------------------------------

sub makeLog {
	
	&loadLogConfig("$CONFIG{'LogPath'}log.cfg");
	&parseLog;
	&saveLogConfig("$CONFIG{'LogPath'}log.cfg");

	&addLogEntry;
}


# Return formatted date -----------------------------------------------------

sub getLogDate {

	($sec,$min,$hour,$day,$mon,$year,$wday) = gmtime(shift);

	return "$day-" .
		(Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec)[$mon] . '-' .
		($year + 1900);
}


# Parser --------------------------------------------------------------------

sub parseLog {

# Name for the created logfiles
	$filename = &getLogDate(time);

# Rename and open da logfile
	rename("$CONFIG{'LogPath'}main.log", "$CONFIG{'LogPath'}$filename\.log");
	open(FILE, "<$CONFIG{'LogPath'}$filename\.log");

	while (<FILE>) {

# Handle users
		if (/^user,(\d+),/) {

			$version = $1;									# Version of this entry

			if ($version == 1) {
				($temp, $version, $server, $user, $remotehost, $time, $between,
				$logincount, $msg, $boxsize, $language, $spamaction, $upload,
				$js, $width, $height, $depth, $browser) = split(/,/, $_, 18);

				tr/,//cd;
				length == 17 or next;
			}

			$firstdate = $time unless $firstdate;
			$lastdate = $time;

			chomp $browser;

			$usercount++;									# Number of users
			$general{'Total number of users'}++;
			$general{'New users'}++ if ($logincount == 0);	# New user

			$logins[int($logincount / 10) + 1]++;				# Number of logins / user

			$servers{$server}++;							# Mailreader.com server name
			$servercount++;

			$user =~ /\@(.*\.)*(.+)$/;						# Get the top level domain of mailbox
			$_ = $2;
			tr/A-Z/a-z/;
			tr/a-z//cd;

			if ($_ =~ /[a-z]/) {
				$maildomains{$country{$_} ? "$country{$_} (.$_)" : $_}++;
			}
			else {
				$maildomains{'(Unknown)'}++;
			}

			$remotehost =~ /(.*\.)*(.+)$/;					# Get the top level domain of remote host name
			$_ = $2;
			tr/A-Z/a-z/;

			if ($_ =~ /[a-z]/) {
				$domains{$country{$_} ? "$country{$_} (.$_)" : $_}++;
			}
			else {
				$domains{'(Unknown)'}++;
			}

			$support{'Total number of entries'}++;			# Total
			$support{'JavaScript 1.0'}++ if ($js > 0);		# JS 1.0
			$support{'JavaScript 1.1'}++ if ($js > 1);		# JS 1.1
			$support{'JavaScript 1.2'}++ if ($js > 2);		# JS 1.2
			$support{'File upload'}++ if ($upload); 		# File upload

			$messagestotal += $msg;							# Total number of messages
			$boxsizetotal += $boxsize;						# Total size of all mailboxes

			$messages[$msg]++;								# Number of messages in mailbox

			$largestmessage = $msg if ($largestmessage < $msg);
			$largestboxsize = $boxsize if ($largestboxsize < $boxsize);

			$weekday[(localtime($time))[6]]++;				# Weekday
			$hour[(localtime($time))[2]]++;					# Hour

			$betweens[int(($between / 86400) + 0.5)]++;		# Time between two logins in days

			$languages{ucfirst($language)}++;				# Languages

			if ($width > 0) {
				$resolution{"$width x $height"}++;			# Screen resolution
				$rescount++;
			}

			if ($depth > 0) {
				$depth = '24/32' if ($depth >= 24);
				$depth = '15/16' if ($depth == 15 or $depth == 16);

				$colordepth{"${depth} bit"}++;
				$colorcount++;
			}

			$browserfight{'Microsoft Internet Explorer'}++
				if ($browser =~ /Microsoft/ or $browser =~ /MSIE/);		# MSIE users

			for ($browser) {
				/X Win/i 	and do { $os{'X11 (Unix)'}++; last; };		# X-Window
				/X11/i 		and do { $os{'X11 (Unix)'}++; last; };		# X-Window

				/BeOS/i 	and do { $os{'BeOS'}++; last; };			# BeOS

				/Win.*NT/i 	and do { $os{'Windows NT'}++; last; };		# Winblows NT
				/Win.*98/i 	and do { $os{'Windows 98'}++; last; };		# Winblows 98
				/Win.*95/i 	and do { $os{'Windows 95'}++; last; };		# Winblows 95
				/Win.*32/i 	and do { $os{'Windows 32bit'}++; last; };	# Winblows 32bit
				/Win.*16/i 	and do { $os{'Windows 3.x'}++; last; };		# Winblows 3.x
				/Win/i 		and do { $os{'Windows (unknown)'}++; last; };	# Winblows (unknown)

				/Mac/i 		and do { $os{'Macintosh'}++; last; };		# Mac
				/Cyberdog/i	and do { $os{'Macintosh'}++; last; };		# Mac

				/Amiga/i	and do { $os{'Amiga'}++; last; };			# Amiga
				/IBrowse/i	and do { $os{'Amiga'}++; last; };			# Amiga

				/IBM/i		and do { $os{'OS/2'}++; last; };			# OS/2
				/OS\/2/i	and do { $os{'OS/2'}++; last; };			# OS/2

				/Arachne/i	and do { $os{'MS-DOS'}++; last; };			# MS-DOS
				/DOS/i		and do { $os{'MS-DOS'}++; last; };			# MS-DOS

				/Lynx/i		and do { $os{'Lynx (any OS)'}++; last; };	# Lynx

				/WebTV/i	and do { $os{'Set-top box'}++; last; };		# WebTV
				/Sega/i		and do { $os{'Set-top box'}++; last; };		# Sega Netlink

				/ANONYMIZER/i and do { $os{'via Anonymizer'}++; last; };	# Anonymizer

				$os{'Unknown'}++;										# Unknown OS
			}

			if ($browser =~ /Mozilla\/.*?\ (\w.+?)\(/i) {
				$browser = $1;
				$browser =~ s/\..*$/\.x/;
			}
			elsif ($browser =~ /Mozilla\/\d+/ and $browser !~ /compatible/i) {
				$browser = "$&.x";
				$browserfight{'Netscape Navigator/Communicator'}++;
			}
			elsif ($browser =~ /Mozilla\/\d+\.\d+.*\(compatible.*?;\s*(.*)/i) {
				$browser = $1;
				$browser =~ s/\..*$/\.x/;
				$browser =~ s/\;.*$//;
			}
			elsif ($browser =~ /Lynx/) {
				$browser = "Lynx (all versions)";
			}
			elsif ($browser =~ /(.+?\/\d+).+\(.+\)/ and $browser !~ /Mozilla/) {
				$browser = "$1.x";
			}

			$browsers{$browser}++ if ($browser =~ /\w/);
		}

# Handle errors
		elsif (/^err,(\d+),/) {

			$version = $1;									# Version of this entry

			if ($version == 1) {
				($temp, $version, $name, $code) = split(/,/);

				tr/,//cd;
				length == 3 or next;
			}

			chomp $code;

			$errorcount++;									# Total number of errors
			$general{'Total number of errors'}++;

			$errornames{"$name (\#$code)"}++;				# Error
		}

# Handle sent messages
		elsif (/^sent,(\d+),/) {

			$version = $1;									# Version of this entry

			if ($version == 1) {
				($temp, $version, $msgsize, $prts, $html, $sentvcard, $confirm, $newsgroups) = split(/,/);

				tr/,//cd;
				length == 7 or next;
			}

			$sentcount++;									# Number of messages sent
			$sentsizetotal += $msgsize;						# Total size of sent messages

			$sent{'Total number of messages sent'}++;					# Total
			$sent{'Messages with attachments'}++ if ($prts != 0);		# Attachments
			$sent{'Messages with >1 attachment'}++ if ($prts > 1);		# Attachments > 1
			$sent{'Messages with >2 attachments'}++ if ($prts > 2);		# Attachments > 2
			$sent{'Messages formatted with HTML'}++ if ($html != 0);	# HTML
			$sent{'Confirmed messages'}++ if ($confirm != 0);			# Confirm
			$sent{'Messages sent with a vCard'}++ if ($sentvcard != 0);		# vCard
			$sent{'Messages sent to newsgroups'}++ if ($newsgroups != 0);	# Newsgroups

			$largestprts = $prts if ($largestprts < $prts);				# Largest number of attachments
			$largestsent = $msgsize if ($largestsent < $msgsize);		# Largest sent message
		}

# Handle help-page showings
		elsif (/^help,(\d+),/) {

			$version = $1;									# Version of this entry

			if ($version == 1) {
				($temp, $version, $language) = split(/,/);

				tr/,//cd;
				length == 2 or next;
			}

			chomp $language;

			$general{"Help shown in $language"}++;
		}
	}

# Close da logfile
	close(FILE);

# Enough entries to create log?
	return if ($usercount == 0 or $sentcount == 0 or $messagestotal == 0);

# Close up browserfight
	$browserfight{'Other browsers'} = $usercount - $browserfight{'Microsoft Internet Explorer'} -
		$browserfight{'Netscape Navigator/Communicator'};

# Get usage during the last 26 weeks
	@history = split(/\s*\,\s*/, $LOG{'History'});
	shift @history;

	$history[25] = $usercount;
	$LOG{'History'} = '';

	for (0 .. 25) {
		$LOG{'History'} .= "$history[$_], ";
	}

# Get new users during the last 26 weeks
	@newusershistory = split(/\s*\,\s*/, $LOG{'NewUsersHistory'});
	shift @newusershistory;

	$newusershistory[25] = $general{'New users'};
	$LOG{'NewUsersHistory'} = '';

	for (0 .. 25) {
		$LOG{'NewUsersHistory'} .= "$newusershistory[$_], ";
	}

# Print the html-file
	open(FILE, ">$CONFIG{'LogPath'}$filename\.html");

	print FILE "<HTML><HEAD><TITLE>Mailreader.com - Log from ",
		&getLogDate($firstdate), " to ", &getLogDate($lastdate),
		"</TITLE></HEAD>\n<BODY BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\" LINK=\"#0000FF\" ",
		"VLINK=\"#800080\" ALINK=\"#FF0000\">\n",

		"<H1>Mailreader.com - Log from ",
		&getLogDate($firstdate), " to ", &getLogDate($lastdate), "</H1>\n";

	printHorizontal('General statistics', $usercount, 10, %general);
	printVertical('Users per week (last 26 weeks)', 0, 25, $historystring, @history);
	printVertical('New users per week (last 26 weeks)', 0, 25, $historystring, @newusershistory);

	printVertical('Total number of logins / user', 1, 26, '', @logins);
	print FILE "&nbsp; <FONT SIZE=2>x 10</FONT>\n";

	print FILE "<BR><BR><H2>Incoming messages:</H2>\n";
	print FILE "<TABLE BORDER=1>\n",
		"<TR><TD $altcolor>Total number of incoming messages handled</TD>\n",
		"<TD ALIGN=right $altcolor>$messagestotal</TD></TR>\n",

		"<TR><TD>Average number of messages / mailbox</TD>\n",
		"<TD ALIGN=right>";

	printf FILE "%.1f</TD></TR>\n", $messagestotal / $usercount;

	print FILE
		"<TR><TD $altcolor>Average size of one mailbox (KB)</TD>\n",
		"<TD ALIGN=right $altcolor>";

	printf FILE "%.1f</TD></TR>\n", ($boxsizetotal / $usercount) / 1024;

	print FILE
		"<TR><TD>Average size of one message (KB)</TD>\n",
		"<TD ALIGN=right>";

	printf FILE "%.1f</TD></TR>\n", ($boxsizetotal / $messagestotal) / 1024;

	print FILE
		"<TR><TD $altcolor>Biggest number of messages / mailbox</TD>\n",
		"<TD ALIGN=right $altcolor>$largestmessage</TD></TR>\n",

		"<TR><TD>Largest mailbox (KB)</TD>\n",
		"<TD ALIGN=right>", int($largestboxsize / 1024), "</TD></TR>\n",

		"</TABLE>\n\n";

	print FILE "<BR><BR><H2>Sent messages:</H2>\n";
	print FILE "<TABLE BORDER=1>\n" .
		"<TR><TD $altcolor>Total number of messages sent</TD>\n",
		"<TD ALIGN=right $altcolor>$sentcount</TD></TR>\n",

		"<TR><TD>Average size of one sent message (KB)</TD>\n",
		"<TD ALIGN=right>";

	printf FILE "%.1f</TD></TR>\n", ($sentsizetotal / $sentcount) / 1024;

	print FILE
		"<TR><TD $altcolor>Average number of messages sent by a user</TD>\n",
		"<TD ALIGN=right $altcolor>";

	printf FILE "%.2f</TD></TR>\n", $sentcount / $usercount;

	print FILE
		"<TR><TD>Biggest number of attachments in a message</TD>\n",
		"<TD ALIGN=right>$largestprts</TD></TR>\n",

		"<TR><TD $altcolor>Largest message sent (KB)</TD>\n",
		"<TD ALIGN=right $altcolor>", int($largestsent / 1024), "</TD></TR>\n",

		"</TABLE><BR>\n\n";

	printHorizontal('', $sentcount, 10, %sent);

	printVertical('Number of messages in mailbox', 0, 25, '', @messages);
	printVertical('Usage by hour', 0, 23, '', @hour);
	printVertical('Usage by weekday', 0, 6, "Sun|Mon|Tue|Wed|Thu|Fri|Sat", @weekday);
	printVertical('Days between two logins', 0, 25, '', @betweens);

	printHorizontal('Operating systems', $usercount, 50, %os);
	printHorizontal('Screen resolutions', $rescount, 10, %resolution);
	printHorizontal('Color depth (bits/pixel)', $colorcount, 10, %colordepth);
	printHorizontal('Browser capabilities', $usercount, 15, %support);
	printHorizontal('Netscape vs. Microsoft IE vs. Others', $usercount, 5, %browserfight);
	printHorizontal('Browsers', $usercount, 30, %browsers);
	printHorizontal('Languages', $usercount, 30, %languages);
	printHorizontal('Users\' location top 50', $usercount, 50, %domains);
	printHorizontal('Location of mailbox top 50', $usercount, 50, %maildomains);
	printHorizontal('Mailreader.com servers', $servercount, 30, %servers);
	printHorizontal('Errors', $errorcount, 100, %errornames);

	print FILE "<BR><BR><BR><BR>\n";

	close(FILE);
}


# Add an entry to index.html ------------------------------------------------

sub addLogEntry {

	$index = &loadFile("$CONFIG{'LogPath'}$CONFIG{'DefaultHTMLFile'}");

	if ($index !~ /HTML/i) {
		$index = "<HTML><HEAD><TITLE>Mailreader.com - Log index</TITLE></HEAD>\n" .
			"<BODY BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\" LINK=\"#0000FF\" VLINK=\"#800080\" ALINK=\"#FF0000\">\n" .
			"<H1>Mailreader.com - Log index</H1>\n<!--begin-->\n</BODY>\n</HTML>\n";
	}

	$link = "<A HREF=\"$filename\.html\"><B>" .
		&getLogDate($firstdate) . ' - ' . &getLogDate($lastdate) .
		"<\/B><\/A> ($usercount users)<BR>";

	$index =~ s/<!--begin-->/<!--begin-->\n$link/;

	open(FILE, ">$CONFIG{'LogPath'}$CONFIG{'DefaultHTMLFile'}");
	print FILE $index;
	close FILE;

	chmod 0777, "$CONFIG{'LogPath'}$CONFIG{'DefaultHTMLFile'}";
}


# Load configuration --------------------------------------------------------

sub loadLogConfig {

	open(FILE, '<'.shift) or return 0;
	undef %LOG;

	while (<FILE>) {
		/^#/ and next;
		tr/\x0A\x0D//d;

		($name, $value) = split(/\s*=\s*/, $_, 2);
		$LOG{$name} = $value;
	}
	close FILE;

	return 1;
}


# Save configuration --------------------------------------------------------

sub saveLogConfig {

	my ($file) = shift;

	open(FILE, ">$file") or return;
	flock(FILE, 2);
	seek FILE, 0, 2;

	foreach (keys %LOG) {
		print FILE "$_=$LOG{$_}\n";
	}

	flock(FILE, 8);
	close FILE;

	chmod 0777, $file;
}


# Print one row of info -----------------------------------------------------

sub printRow {

	my ($color, $title, $count, $max1, $max2, $img) = @_;
	my ($len);

	print FILE "<TR><TD $color>$title</TD>\n" .
	"<TD ALIGN=right $color>$count</TD>\n";

	printf FILE "<TD ALIGN=right $color>%.1f&#37;</TD>\n", ($count / $max2) * 100;

	$len = int(($count / $max1) * 200) + 1;
	print FILE "<TD $color><IMG SRC=\"$img\" HEIGHT=15 WIDTH=$len BORDER=1></TD></TR>\n";
}


# Print a hash of data horizontally -----------------------------------------

sub printHorizontal {

	my ($title, $max2, $limit, %hash) = @_;
	my ($stripe, $key, $max1, $img, $color);

	print FILE "<BR><BR><H2>$title:</H2>\n" if $title;
	print FILE "<TABLE BORDER=1>\n";

	$stripe = 1;

	foreach $key (sort {$hash{$b} <=> $hash{$a}} keys %hash) {

		$limit-- == 0 and last;

		$max1 = $hash{$key} if (!$max1);

		if ($stripe) {
			$color = $altcolor;
			$img = $darkimage;
		}
		else {
			$color = "";
			$img = $lightimage;
		}

		$stripe = 1 - $stripe;

		printRow($color, $key, $hash{$key}, $max1, $max2, $img);
	}

	print FILE "</TABLE>\n\n";
}


# Print a hash of data vertically -------------------------------------------

sub printVertical {

	my ($title, $start, $stop, $names, @data) = @_;
	my ($stripe, $key, $max, $img, $color, $num, $row1, $row2, $width, $height);

	for ($start .. $stop) {
		$max = $data[$_] if ($data[$_] > $max);
		$num++;
	}

	$stripe = 1;
	$width = int(400 / $num);
	$width = 30 if ($width > 30);

	$divider = 1;
	for ($count = 100; $count <= 10000000; $count *= 10) {
		$divider = $count / 100 if ($max > $count);
	}

	for ($start .. $stop) {

		if ($stripe) {
			$color = $altcolor;
			$img = $darkimage;
		}
		else {
			$color = "";
			$img = $lightimage;
		}

		$stripe = 1 - $stripe;
		$height = int(($data[$_] / $max) * 200) + 1;
		$value = $data[$_]/$divider;

		if ($value < 10 and $value != int($value)) {
			$value = sprintf("%3.1f", $value);
		}
		else { $value = int($value); }

		$row1 .= "<TD ALIGN=center VALIGN=bottom $color>\n" .
			"<FONT SIZE=1>$value</FONT><BR>\n" .
			"<IMG SRC=\"$img\" WIDTH=$width HEIGHT=$height BORDER=1></TD>\n";

		if ($names) {
			$_ = (split(/\|/, $names))[$_];
		}

		$row2 .= "<TD ALIGN=center $color>$_</TD>\n";
	}

	print FILE "<BR><BR><H2>$title:</H2>\n" if $title;
	print FILE "&nbsp; <FONT SIZE=2>x $divider</FONT>" if ($divider > 1);
	print FILE "<TABLE BORDER=0>\n<TR>$row1</TR>\n<TR>$row2</TR>\n</TABLE>\n\n";
}
