# Example mararc file (unabridged version)

# The various zones we support

# We must initialize the csv1 hash, or MaraDNS will be unable to
# load any zone files
csv1 = {}

# This is just to show the format of the file
include(zones.inc)

# The address this DNS server runs on.  If you want to bind 
# to all addresses a given machine has, use "0.0.0.0".
bind_address = "216.231.62.189"
#bind_address = "0.0.0.0"
# The directory with all of the zone files
chroot_dir = "/etc/maradns"
# The numeric UID MaraDNS will run as
maradns_uid = 65534
# The (optional) numeric GID MaraDNS will run as
# maradns_gid = 99
# The maximum number of threads (or processes, with the zone server)
# MaraDNS is allowed to run
maxprocs = 96
# It is possible to specify a different maximum number of processes that
# the zone server can run.  If this is not set, the maximum number of 
# processes that the zone server can have defaults to the 'maxprocs' value
# above
# max_tcp_procs = 64

# Normally, MaraDNS has some MaraDNS-specific features, such as DDIP
# synthesizing, a special DNS query ("erre-con-erre-cigarro.maradns.org." 
# with a TXT query returns the version of MaraDNS that a server is 
# running), unique handling of multiple QDCOUNTs, etc.  Some people 
# might not like these features, so I have added a switch that lets 
# a sys admin disable all these features.  Just give "no_fingerprint" 
# a value of one here, and MaraDNS should be more or less 
# indistinguishable from a tinydns server.
no_fingerprint = 1

# Normally, MaraDNS only returns A and MX records when given a
# QTYPE=* (all RR types) query.  Changing the value of default_rrany_set
# to 15 causes MaraDNS to also return the NS and SOA records, which
# some registars require.  The default value of this is 3
default_rrany_set = 3

# These constants limit the number of records we will display, in order
# to help keep packets 512 bytes or smaller.  This, combined with round_robin
# record rotation, help to use DNS as a crude load-balancer.

# The maximum number of records to display in a chain of records (list
# of records) for a given host name
max_chain = 8
# The maximum number of records to display in a list of records in the
# additional section of a query.  If this is any value besides one,
# round robin rotation is disabled (due to limitations in the current
# data structure MaraDNS uses)
max_ar_chain = 1
# The maximum number of records to show total for a given question
max_total = 20

# The number of messages we log to stdout
# 0: No messages except for fatal parsing errors
# 1: Only startup messages logged (default)
# 2: Error queries logged
# 3: All queries logged (but not very verbosely right now)
verbose_level = 1

# Initialize the IP aliases, which are used by the list of root name servers,
# the ACL for zone transfers, and the ACL of who gets to perform recursive
# queries
ipv4_alias = {}

# Various sets of root name servers
# Note: Netmasks can exist, but are ignored when specifying root name server

# ICANN: the most common and most controversial root name server
# http://www.icann.org
ipv4_alias["icann"] = "198.41.0.4,128.9.0.107,192.33.4.12,128.8.10.90,192.203.230.10,192.5.5.241,192.112.36.4,128.63.2.53,192.36.148.17,198.41.0.10,193.0.14.129,198.32.64.12,202.12.27.33"

# OSRC: http://www.open-rsc.org/
ipv4_alias["osrc"] = "199.166.24.1,205.189.73.102,199.166.24.3,204.80.125.130,207.126.103.16,195.117.6.10,199.166.31.3,199.166.31.250,199.5.157.128,205.189.73.10,204.57.55.100,213.196.2.97"

# AlterNIC: http://www.alternic.org/
ipv4_alias["alternic"] = "160.79.129.192,65.2.214.15,160.79.133.70,24.13.64.102,216.99.37.240,199.224.64.190,160.79.133.66,216.99.37.246,216.99.37.247"

# OpenNIC: http://www.opennic.unrated.net/
ipv4_alias["opennic"] = "157.238.46.24,209.104.33.250,209.104.63.249,130.94.168.216,131.161.247.228,199.175.137.211,207.6.128.246,167.216.255.199,216.178.136.117,216.178.136.116"
#ipv4_alias["opennic"] = "209.21.75.51,216.74.72.7,216.74.72.8,209.21.75.53,209.104.33.250,209.104.63.249"


# Pacific Root: http://www.pacificroot.com/
ipv4_alias["pacificroot"] = "204.107.129.2,208.179.42.162,12.28.140.20,204.107.129.10,212.115.192.151,202.76.159.5,209.54.94.3,167.160.132.2"

# IRSC: http://www.irsc.ah.net/
ipv4_alias["irsc"] = "203.21.205.2,203.21.205.3,212.234.36.20,212.234.36.19,207.180.91.9,198.199.168.92,207.180.91.10"

# TINC: http://www.tinc-org.com/
ipv4_alias["tinc"] = "64.6.65.10,208.128.113.35,212.172.21.254,207.112.147.14,145.89.234.7,209.133.38.16"

# Super Root: http://www.superroot.org/
ipv4_alias["superroot"] = "195.117.6.10,199.166.31.3,199.5.157.128,205.189.73.10,199.166.31.250,199.166.24.1,205.189.73.102,199.166.24.3,204.80.125.130,207.126.103.16,204.57.55.100"

# End of list of root name server lists

# Here is a ACL which restricts who is allowed to perform zone transfer from 
# the zoneserver program

# VERY IMPORTANT: Do not put spaces in the zone_transfer_acl list
# Good: zone_transfer_acl = "office,home"
# Bad:  zone_transfer_acl = "office, home"

# Simplest form: 10.1.1.1/24 (IP: 10.1.1.1, 24 left bits in IP need to match)
# and 10.100.100.100/255.255.255.224 (IP: 10.100.100.100, netmask
# 255.255.255.224) are allowed to connect to the zone server 
# zone_transfer_acl = "10.1.1.1/24,10.100.100.100/255.255.255.224"

# More complex: We create two aliases: One called "office" and another
# called "home".  We allow anyone in the office or at home to perform zone
# transfers
# ipv4_alias["office"] = "10.1.1.1/24"
# ipv4_alias["home"] = "10.100.100.100/255.255.255.224"
# zone_transfer_acl = "office,home"

# More complex then the last example.  We have three employees,
# Susan, Becca, and Mia, whose computers we give zone transfer rights to.
# Susan and Becca are system administrators, and Mia is a developer.
# They are all part of the company.  We give the entire company zone
# transfer access
# ipv4_alias["susan"]     = "10.6.7.8/32"  # Single IP allowed
# ipv4_alias["becca"]     = "10.7.8.9"     # also a single IP
# ipv4_alias["mia"]       = "10.8.9.10/255.255.255.255" # Also a single IP
# ipv4_alias["sysadmins"] = "susan,becca"
# ipv4_alias["devel"]     = "mia"
# ipv4_alias["company"]   = "sysadmins,devel"
# This is equivalent to the above line
# ipv4_alias["company"]   = "susan,becca,mia"
# zone_transfer_acl       = "company"

ipv4_alias["wooznat"]   = "192.168.4.0/24"
ipv4_alias["shlick"]	= "198.136.194.34"
zone_transfer_acl	= "shlick,wooznat"

# If you want to enable recursion on the loopback interface, uncomment
# the relevent lines in the following section

# Recursive ACL: Who is allowd to perform recursive queries.  The format
# is identical to that of "zone_transfer_acl", including ipv4_alias support

#ipv4_alias["localhost"] = "127.0.0.0/8"
#ipv4_alias["woozle"] = "192.168.4.0/24"
#recursive_acl = "localhost,woozle"

# Random seed file: The file from which we read 16 bytes from to get the
# 128-bit random Rijndael key.  This is ideally a file which is a good source
# of random numbers, but can also be a fixed file if your OS does not have
# a decent random number generator (make sure the contents of that file is
# random and with 600 perms, owned by root, since we read the file *before*
# dropping root privledges)

random_seed_file = "/dev/urandom"

# The maximum number of elements we can have in the cache.  If we have more 
# elements in the cache than this amount, the "custodian" kicks in to effect,
# removing elements at random from the cache (8 elements removed per query)
# until we are at the 99% level or so again.

maximum_cache_elements = 1024

# The root servers which we use when making recursive queries.

# The following line must be uncommented to enable recursive queries
root_servers = {}

# You can choose which set of root servers to use.  Current values (set above)
# are: icann, osrc, alternic, opennic,  pacificroot, irsc, tinc, and 
# superroot.
root_servers["."] = "opennic"

# You can tell MaraDNS to *not* query certain DNS servers when in recursive
# mode.  This is mainly used to not allow spam-friendly domains to resolve,
# since spammers are starting to get in the habit of using spam-friendly
# DNS servers to resolve their domains, allowing them to hop from ISP to 
# ISP.  The format of this is the same as for zone_transfer_acl and 
# recursive_acl

# For example, at the time of this document (August 12, 2001), azmalink.net
# is a known spam-friendly DNS provider (see doc/detailed/spammers/azmalink.net
# for details.)  Note that this is based on IPs, and azmalink.net constantly
# changes IPs (as they constantly have to change ISPs)
# Updated 2002/10/12 to reflect Azmalink's current ISP
ipv4_alias["azmalink"] = "12.164.194.0/24"

# As of September 20, 2001, hiddenonline.net is a known spam-friendly
# DNS provider (see doc/detailed/spammers/hiddenonline for details).
ipv4_alias["hiddenonline"] = "65.107.225.0/24"
spammers = "azmalink,hiddenonline"

# And that does it for the caching at this point
hide_disclaimer = "YES"
