/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.rte.comm.CommunicationException;
import com.sap.dbtech.rte.comm.ConnectPacket;
import com.sap.dbtech.rte.comm.CserverPacketLayout;
import com.sap.dbtech.rte.comm.DbPacketLayout;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.PacketLayout;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.rte.comm.RteSocketPacket;
import com.sap.dbtech.util.FullswapMem;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class SecureCommunication
extends JdbcCommunication {
    private static int DEFAULT_TIMEOUT = 0;
    private static int counter = 0;
    private SSLSocket sslsocket;
    private InputStream instream;
    private OutputStream outstream;
    private int senderRef;
    private int receiverRef;
    private int maxSendLen;
    private int remoteSwapping;
    private String host;
    private int port;
    private String dbname;
    private PacketLayout packetLayout;
    private boolean dbSession;
    private int socketTimeOut;
    private boolean ignoreServerCertificate;
    private boolean ignoreHostNameInCertificate;
    public static final JdbcCommFactory factory = new JdbcCommFactory(){

        public JdbcCommunication open(String string, String string2, Properties properties) throws RTEException {
            return SecureCommunication.connectDB(string, string2, properties);
        }

        public JdbcCommunication xopen(String string, String string2, String string3, String string4, Properties properties) throws RTEException {
            return SecureCommunication.sqlxconnect(string, string2, string3, string4, properties);
        }
    };
    public static final int controlPacketSize_C = 16384;

    private SecureCommunication(String string, Properties properties) throws RTEException {
        int n = string.indexOf(":");
        if (n == -1) {
            this.host = string;
            this.port = 7270;
        } else {
            this.host = string.substring(0, n);
            try {
                this.port = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new RTEException(MessageTranslator.translate("error.unknown.host", string, numberFormatException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])));
            }
        }
        String string2 = properties.getProperty("communicationtimeout");
        if (string2 == null) {
            this.socketTimeOut = DEFAULT_TIMEOUT;
        } else {
            try {
                this.socketTimeOut = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.socketTimeOut = DEFAULT_TIMEOUT;
            }
        }
        this.ignoreHostNameInCertificate = DriverSapDB.getBooleanProperty(properties, "ignoreHostNameInCert", false);
        this.ignoreServerCertificate = DriverSapDB.getBooleanProperty(properties, "acceptServerCertAlways", false);
        this.openSocket();
    }

    private void buildRTEHeader(StructuredBytes structuredBytes, int n) {
        structuredBytes.putInt4(0, 0);
        structuredBytes.putInt1(3, 4);
        structuredBytes.putInt1(n, 5);
        structuredBytes.putInt1(0, 6);
        structuredBytes.putInt1(0, 7);
        structuredBytes.putInt4(this.senderRef, 8);
        structuredBytes.putInt4(this.receiverRef, 12);
        structuredBytes.putInt2(0, 16);
        structuredBytes.putInt2(0, 18);
        structuredBytes.putInt4(this.maxSendLen, 20);
    }

    public void cancel() throws SQLException {
        try {
            DbPacketLayout dbPacketLayout = new DbPacketLayout();
            SecureCommunication secureCommunication = new SecureCommunication(this.host + ":" + this.port, null);
            StructuredBytes structuredBytes = SecureCommunication.createRawPacket(296);
            this.buildRTEHeader(structuredBytes, 65);
            structuredBytes.putInt4(this.senderRef, 12);
            ConnectPacket connectPacket = new ConnectPacket(structuredBytes.bytes(), this.dbname, dbPacketLayout);
            connectPacket.close();
            secureCommunication.sendData(structuredBytes, connectPacket.length());
            secureCommunication.closeSocket();
        }
        catch (RTEException rTEException) {
            throw new SQLException(rTEException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        try {
            this.sslsocket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.sslsocket = null;
        }
    }

    public static SecureCommunication connectAdmin(String string, String string2, String string3, String string4, Properties properties) throws RTEException {
        CserverPacketLayout cserverPacketLayout = new CserverPacketLayout();
        SecureCommunication secureCommunication = new SecureCommunication(string, properties);
        secureCommunication.sendAdminConnect(string2, string3, string4, cserverPacketLayout);
        secureCommunication.receiveConnect();
        secureCommunication.packetLayout = cserverPacketLayout;
        return secureCommunication;
    }

    public static SecureCommunication connectDB(String string, String string2, Properties properties) throws RTEException {
        DbPacketLayout dbPacketLayout = SecureCommunication.doInfoRequest(string, string2, properties);
        SecureCommunication secureCommunication = new SecureCommunication(string, properties);
        secureCommunication.dbSession = true;
        secureCommunication.dbname = string2;
        secureCommunication.packetLayout = secureCommunication.dbConnectExchange(string2, dbPacketLayout);
        return secureCommunication;
    }

    private static StructuredBytes createRawPacket(int n) {
        return new StructuredBytes(n + 24);
    }

    private PacketLayout dbConnectExchange(String string, PacketLayout packetLayout) throws RTEException {
        this.sendDbConnect(string, packetLayout);
        StructuredBytes structuredBytes = this.receiveConnect();
        packetLayout = SecureCommunication.getPacketLayoutFromReply(structuredBytes, true);
        return packetLayout;
    }

    private static DbPacketLayout doInfoRequest(String string, String string2, Properties properties) throws RTEException {
        DbPacketLayout dbPacketLayout = new DbPacketLayout();
        SecureCommunication secureCommunication = new SecureCommunication(string, properties);
        StructuredBytes structuredBytes = SecureCommunication.createRawPacket(296);
        secureCommunication.buildRTEHeader(structuredBytes, 51);
        ConnectPacket connectPacket = new ConnectPacket(structuredBytes.bytes(), string2, dbPacketLayout);
        connectPacket.close();
        secureCommunication.sendData(structuredBytes, connectPacket.length());
        StructuredBytes structuredBytes2 = secureCommunication.receiveConnect();
        int n = structuredBytes2.getInt2(16);
        if (n != 0) {
            secureCommunication.release();
            throw new CommunicationException(n);
        }
        secureCommunication.release();
        DbPacketLayout dbPacketLayout2 = SecureCommunication.getPacketLayoutFromReply(structuredBytes2, false);
        return dbPacketLayout2;
    }

    private static DbPacketLayout getPacketLayoutFromReply(StructuredBytes structuredBytes, boolean bl) {
        int n = structuredBytes.getInt4(36);
        int n2 = structuredBytes.getInt4(44);
        int n3 = structuredBytes.getInt4(40);
        int n4 = bl ? structuredBytes.getInt4(32) : n3;
        DbPacketLayout dbPacketLayout = new DbPacketLayout(n, n4, n2, n3);
        return dbPacketLayout;
    }

    private static void dumpRteHeader(StructuredMem structuredMem, PrintStream printStream) {
        printStream.println("RTE Header");
        printStream.print("ActSendLen: ");
        printStream.println(structuredMem.getInt4(0));
        printStream.print("ProtocolID: ");
        printStream.println(structuredMem.getInt1(4));
        printStream.print("MessClass: ");
        printStream.println(structuredMem.getInt1(5));
        printStream.print("RTEFlags: ");
        printStream.println(structuredMem.getInt1(6));
        printStream.print("ResidualPackets: ");
        printStream.println(structuredMem.getInt1(7));
        printStream.print("SenderRef: ");
        printStream.println(structuredMem.getInt4(8));
        printStream.print("ReceiverRef: ");
        printStream.println(structuredMem.getInt4(12));
        printStream.print("RTEReturnCode: ");
        printStream.println(structuredMem.getInt2(16));
        printStream.print("Filler: ");
        printStream.println(structuredMem.getInt2(18));
        printStream.print("MaxSendLen: ");
        printStream.println(structuredMem.getInt4(20));
    }

    protected void finalize() throws Throwable {
        if (this.sslsocket != null) {
            this.release();
        }
        super.finalize();
    }

    public StructuredMem getRequestPacket() {
        RteSocketPacket rteSocketPacket = new RteSocketPacket(this.packetLayout.maxCmdDataLength());
        return rteSocketPacket;
    }

    public boolean isConnected() {
        return this.sslsocket != null;
    }

    private int lookupPort() {
        return this.port;
    }

    private void openSocket() throws RTEException {
        try {
            Object[] objectArray;
            SSLContext sSLContext = null;
            SSLSocketFactory sSLSocketFactory = null;
            if (this.ignoreServerCertificate) {
                objectArray = new TrustManager[]{new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }
                }};
                sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(null, (TrustManager[])objectArray, new SecureRandom());
                sSLSocketFactory = sSLContext.getSocketFactory();
            } else {
                sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            this.sslsocket = (SSLSocket)sSLSocketFactory.createSocket(this.host, this.lookupPort());
            this.sslsocket.startHandshake();
            if (!this.ignoreHostNameInCertificate) {
                objectArray = this.sslsocket.getSession().getPeerCertificates();
                if (objectArray.length == 0) {
                    throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, "No certificate in SSL session", new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
                }
                try {
                    X509Certificate x509Certificate = (X509Certificate)objectArray[0];
                    X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                    String string = x500Principal.getName("RFC2253");
                    if (!this.validate(string, this.host)) {
                        throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, "Host name verification failed, found " + string + ", expected CN=" + this.host, new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, "SSL connection works currently only with X509 certificates", new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
                }
            }
            try {
                this.sslsocket.setSoTimeout(this.socketTimeOut);
                this.sslsocket.setTcpNoDelay(true);
                this.sslsocket.setReceiveBufferSize(36864);
                this.sslsocket.setSendBufferSize(36864);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            this.instream = this.sslsocket.getInputStream();
            this.outstream = this.sslsocket.getOutputStream();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, noSuchAlgorithmException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
        }
        catch (KeyManagementException keyManagementException) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, keyManagementException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RTEException(MessageTranslator.translate("error.unknown.host", this.host, unknownHostException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])), RteC.CommunicationErrorCodeMap_C[13]);
        }
        catch (IOException iOException) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, iOException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
        }
    }

    public StructuredMem receive() throws RTEException {
        return this.receiveData();
    }

    private StructuredBytes receiveConnect() throws RTEException {
        int n;
        StructuredBytes structuredBytes;
        int n2 = 320;
        byte[] byArray = new byte[n2];
        try {
            int n3;
            int n4;
            if (n4 < 25) {
                throw new RTEException(MessageTranslator.translate("error.recv.connect"), RteC.CommunicationErrorCodeMap_C[8]);
            }
            this.remoteSwapping = byArray[25];
            structuredBytes = this.replyMem(byArray);
            n = structuredBytes.getInt4(0);
            for (n4 = this.instream.read(byArray, 0, n2); n4 < n; n4 += n3) {
                n3 = this.instream.read(byArray, n4, n - n4);
                if (n3 == -1) {
                    throw new RTEException(MessageTranslator.translate("error.connect.receivefailed", "End of file before packet was read."), RteC.CommunicationErrorCodeMap_C[1]);
                }
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            throw new RTEException(MessageTranslator.translate("error.connect.receivefailed", iOException.getMessage()), RteC.CommunicationErrorCodeMap_C[1]);
        }
        this.senderRef = structuredBytes.getInt4(8);
        n = structuredBytes.getInt2(16);
        if (n != 0) {
            throw new RTEException(RteC.getCommunicationError(n), RteC.getCommunicationErrorMapCode(n));
        }
        return structuredBytes;
    }

    private StructuredMem receiveData() throws RTEException {
        boolean bl = true;
        byte[] byArray = new byte[24];
        int n = 0;
        int n2 = 0;
        byte[] byArray2 = null;
        StructuredBytes structuredBytes = null;
        StructuredBytes structuredBytes2 = null;
        try {
            InputStream inputStream = this.instream;
            while (bl || n2 < n) {
                int n3;
                int n4 = inputStream.read(byArray, 0, 24);
                if (n4 != 24) {
                    RTEException rTEException = new RTEException(MessageTranslator.translate("error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8]);
                    throw rTEException;
                }
                if (bl) {
                    structuredBytes = this.replyMem(byArray);
                    bl = false;
                    int n5 = structuredBytes.getInt2(16);
                    if (n5 != 0) {
                        throw new CommunicationException(n5);
                    }
                    n = structuredBytes.getInt4(20) - n4;
                    byArray2 = new byte[n];
                    structuredBytes2 = new StructuredBytes(byArray2);
                }
                if ((n3 = structuredBytes.getInt4(0) - n4) < 0 || n2 + n3 > byArray2.length) {
                    // empty if block
                }
                while (n3 > 0) {
                    int n6;
                    try {
                        n6 = inputStream.read(byArray2, n2, n3);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new ArrayIndexOutOfBoundsException(MessageTranslator.translate("error.chunkoverflow", Integer.toString(n3), Integer.toString(n2), Integer.toString(byArray2.length)));
                    }
                    if (n6 < 0) {
                        throw new RTEException(MessageTranslator.translate("error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8]);
                    }
                    n2 += n6;
                    n3 -= n6;
                }
            }
        }
        catch (IOException iOException) {
            throw new RTEException(MessageTranslator.translate("error.data.receivefailed.reason", iOException.getMessage()), RteC.CommunicationErrorCodeMap_C[8]);
        }
        if (Tracer.isOn(9)) {
            Tracer.traceObject("REPLY:", structuredBytes2);
        }
        return structuredBytes2;
    }

    public void reconnect() throws RTEException {
        try {
            this.sslsocket.close();
            this.sslsocket = null;
        }
        catch (Exception exception) {
            this.sslsocket = null;
        }
        this.openSocket();
        if (!this.dbSession) {
            throw new RTEException(MessageTranslator.translate("error.admin.reconnect"), RteC.CommunicationErrorCodeMap_C[3]);
        }
        this.dbConnectExchange(this.dbname, this.packetLayout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            StructuredBytes structuredBytes = SecureCommunication.createRawPacket(0);
            this.buildRTEHeader(structuredBytes, 66);
            this.sendData(structuredBytes, 0);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sslsocket.close();
        }
        catch (IOException iOException) {
        }
        catch (RTEException rTEException) {
        }
        finally {
            this.sslsocket = null;
        }
    }

    private StructuredBytes replyMem(byte[] byArray) throws RTEException {
        StructuredBytes structuredBytes;
        switch (this.remoteSwapping) {
            case 1: {
                structuredBytes = new StructuredBytes(byArray);
                break;
            }
            case 2: {
                structuredBytes = new FullswapMem(byArray);
                break;
            }
            default: {
                throw new RTEException(MessageTranslator.translate("error.invalid.swapping"), -708);
            }
        }
        return structuredBytes;
    }

    public void request(StructuredMem structuredMem, int n) throws RTEException {
        if (Tracer.isOn(9)) {
            Tracer.traceObject("REQUEST:", structuredMem, n + 24);
        }
        StructuredBytes structuredBytes = ((RteSocketPacket)structuredMem).rteHeader;
        this.buildRTEHeader(structuredBytes, 63);
        this.sendData(structuredBytes, n);
    }

    private void sendAdminConnect(String string, String string2, String string3, PacketLayout packetLayout) throws RTEException {
        StructuredBytes structuredBytes = SecureCommunication.createRawPacket(packetLayout.maxDataLength());
        this.buildRTEHeader(structuredBytes, 91);
        ConnectPacket connectPacket = new ConnectPacket(structuredBytes.bytes(), string, packetLayout);
        connectPacket.addConnectString(string2, 100);
        connectPacket.addConnectString(string3, 112);
        connectPacket.close();
        this.sendData(structuredBytes, connectPacket.length());
    }

    private void sendData(StructuredBytes structuredBytes, int n) throws RTEException {
        OutputStream outputStream;
        this.setActSendLen(structuredBytes, n);
        try {
            if (this.outstream == null) {
                this.outstream = this.sslsocket.getOutputStream();
            }
            outputStream = this.outstream;
        }
        catch (IOException iOException) {
            throw new RTEException("sendData: getOutputStream failed", RteC.CommunicationErrorCodeMap_C[7]);
        }
        try {
            outputStream.write(structuredBytes.bytes(), 0, n + 24);
        }
        catch (IOException iOException) {
            throw new RTEException(MessageTranslator.translate("error.send.write"), RteC.CommunicationErrorCodeMap_C[7]);
        }
    }

    private void sendDbConnect(String string, PacketLayout packetLayout) throws RTEException {
        StructuredBytes structuredBytes = SecureCommunication.createRawPacket(packetLayout.maxDataLength());
        this.buildRTEHeader(structuredBytes, 61);
        ConnectPacket connectPacket = new ConnectPacket(structuredBytes.bytes(), string, packetLayout);
        connectPacket.close();
        this.sendData(structuredBytes, connectPacket.length());
    }

    private void setActSendLen(StructuredBytes structuredBytes, int n) {
        structuredBytes.putInt4(n += 24, 0);
        structuredBytes.putInt4(n, 20);
    }

    public static void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static SecureCommunication sqlaconnect(String string, String string2) throws RTEException {
        return null;
    }

    public StructuredMem sqlareceive() throws RTEException {
        return this.receive();
    }

    public void sqlarelease() throws RTEException {
        this.release();
    }

    public void sqlarequest(StructuredMem structuredMem, int n) throws RTEException {
        this.request(structuredMem, n);
    }

    public static SecureCommunication sqlxconnect(String string, String string2, String string3, String string4, Properties properties) throws RTEException {
        SecureCommunication secureCommunication = SecureCommunication.connectAdmin(string, string2, string3, string4, properties);
        return secureCommunication;
    }

    public String toString() {
        String string = super.toString() + " on " + this.sslsocket;
        return string;
    }

    private boolean validate(String string, String string2) {
        int n = string.indexOf(",");
        String string3 = string.substring(0, n).toUpperCase();
        String string4 = ("CN=" + string2).toUpperCase();
        return string4.equals(string3);
    }
}

