#ifndef __OMS_BEFOREIMAGELIST_HPP
#define __OMS_BEFOREIMAGELIST_HPP

#define OMS_BEFOREIMAGE_MAX_SUBTRANS_LEVEL 32

class OMS_DumpInterface;
class OMS_Context;
class OMS_Session;
class OMS_ClassIdEntry;
class OmsObjectContainer;

class OMS_BeforeImageList {
public :
  OMS_BeforeImageList ();
  ~OMS_BeforeImageList();
  void Dump(OMS_DumpInterface& dumpObj) const;
  void freeBeforeImages     ();
  void init(OMS_Session* c);
  void insertBeforeImage    (OmsObjectContainer*, int subtransLvl);
  void insertNewBeforeImage (OmsObjectContainer*, OMS_ClassIdEntry* clsinfo, int subtransLvl);
  void removeContext        (OMS_Context* pContext);
  void subtransRollback     (int subtransLvl);
  void subtransCommit       (int subtransLvl);
  /// Check if all updated objects have been stored (in simulator)
  void checkStores          ();
private :
  OmsObjectContainer* m_beforeImages[OMS_BEFOREIMAGE_MAX_SUBTRANS_LEVEL]; 
  OMS_Session*        m_session;
};

#endif // __OMS_BEFOREIMAGELIST_HPP
