/*!***************************************************************************

  module      : gbd491.h

  -------------------------------------------------------------------------

  author      : TorstenS
  responsible : UweH

  special area: CreateIndexParticipant
  description : 


  last changed: 1999-08-03  14:00
  see also    : 

  -------------------------------------------------------------------------

  copyright:    (c) 1999-2004 SAP AG



    ========== licence begin  GPL
    Copyright (c) 1999-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*****************************************************************************/



#ifndef GBD491_H
#define GBD491_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

                     // Content of include files
#include "gsp00.h"   // PASCAL: SP_basic_constants_and_types
#include "ggg00.h"   // PASCAL: GG_kernel_constants_and_types
#include "gbd00.h"   // PASCAL: BD_kernel_constants_and_types
#include "gbd300.h"  // CPP   : InvHandling
#include "gbd495.h"  // CPP   : DoubleQueueHandling
#include "gbd497.h"  // CPP   : StackDescInfo

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  FORWARD DECLARATION                                                      *
 *===========================================================================*/

class cbd491_NodeList;
class cbd491_InvRecDescList;

/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

class cbd491_CreateIndexParticipant
{
public:
    
    cbd491_CreateIndexParticipant(
        tbd_current_tree    &PrimCurrent,
        tgg00_StackDesc     &StackDesc,
        tgg00_IndexCounter  &IndexCounter,
        bool                 bUseMemorySort = true);
    
    ~cbd491_CreateIndexParticipant();
    
    
    void bd491InsertionSort(
        cbd300_InvCurrent   &InvCurrent,
        tgg00_IndexMode      IndexMode,
        tsp00_BytePtr        pStartPrimKey,      
        tsp00_BytePtr        pStopPrimKey,    
        tsp00_Int4           StartPrimKeyLen, 
        tsp00_Int4           StopPrimKeyLen,  
        tsp00_Bool          &bEntriesExist); 

    void bd491MemorySort(
        cbd495_DoubleWriteQueue  &InvQueue,
        tsp00_BytePtr             pStartPrimKey,      
        tsp00_BytePtr             pStopPrimKey,    
        tsp00_Int4                StartPrimKeyLen, 
        tsp00_Int4                StopPrimKeyLen,  
        tsp00_Int4                NumLeavesToScan,
        tsp00_Int4                AvgRecordsPerLeaf,
        tsp00_Bool               &bEntriesExist); 
    
private:

    void bd491_AddInvRecord(
        cbd300_InvCurrent   &InvCurrent,
        tgg00_IndexMode      IndexMode,
        tgg00_RecPtr         pRec);
    
    void bd491_AppendInvRecords(
        cbd495_DoubleWriteQueue &InvQueue,
        cbd491_InvRecDescList   &InvRecDescList);                                              
    
    void bd491_ProcessPrimTreeRange(
        cbd491_NodeList         &NodePtrList,
        cbd491_InvRecDescList   &InvRecDescList,
        tsp00_BytePtr            pStartPrimKey,
        tsp00_BytePtr            pStopPrimKey,
        tsp00_Int4               StartPrimKeyLen,
        tsp00_Int4               StopPrimKeyLen);

    void bd491_NextRecord(
        const tsp00_PageNo  leafPageNo,
        tbd_node_ptrs       &pIndexNptr,
        tbd_node_ptrs       &pPrimNptr,
        tsp00_Int4          &primRecIndex );

private:

    tgg00_BasisError        &m_TrError;
    tgg00_TransContext      &m_Trans;
    tbd_current_tree        &m_PrimCurrent;
    tgg00_IndexCounter      &m_IndexCounter;
    /* */
    cbd497_StackDescInfo    m_Stack;
    tsp00_Key               m_UndefNullKey;
    tsp00_BytePtr           m_pUndefNullKey;
};

/*===========================================================================*
 *  DEFINITION OF METHODS                                                    *
 *===========================================================================*/

#endif  /* GBD491_H */
 