/*  MikMod example player
	(c) 1999 Miodrag Vallat and others - see file AUTHORS for
	complete list.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
 
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

/*==============================================================================

  $Id: mdialog.h,v 1.3 1999/07/05 04:00:02 miod Exp $

  Some common dialog types

==============================================================================*/

#ifndef MDIALOG_H
#define MDIALOG_H

/* Function which is called on input
   button: selected button (str- and int-fileds selected -> button==0)
   input: input in a int- or str-field
   data: user-pointer which was passed to dlg-function */
typedef void (*handleDlgFunc)(int,void*,void*);

/* Opens a message box
   msg   : text to display, can contain '\n'
   button: ".&..|...|...", &: hotkey, e.g.: "&Yes|&No"
   active: active button (0...n)
   data  : passed to handle_dlg */
void dlg_message_open(char*,char*,int,handleDlgFunc,void*);

/* Shows message describing the errno error code.
   txt must contain '%s' (err-txt will be inserted) */
void dlg_error_show(char*);

/* Opens a string input dialog
   msg   : text to display, can contain '\n'
   str   : default text
   length: max allowed input length */
void dlg_input_str(char*,char*,int,handleDlgFunc,void*);

/* Opens an integer input dialog
   msg   : text to display, can contain '\n'
   value : default integer
   min,max: min, max allowed values */
void dlg_input_int(char*,int,int,int,handleDlgFunc,void*);

#endif /* MDIALOG_H */
