/*
 * Copyright 2003-2004 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/**
 * @test
 * @bug 4920005 4882798
 * @summary make sure getObjectSize(null) throws NullPointerException.
 * @author Robert Field as modified from the code of Gabriel Adauto, Wily Technology
 *
 * @run build NullGetObjectSizeTest
 * @run shell MakeJAR.sh basicAgent
 * @run main/othervm -javaagent:basicAgent.jar NullGetObjectSizeTest NullGetObjectSizeTest
 */

public class
NullGetObjectSizeTest
    extends ASimpleInstrumentationTestCase
{

    /**
     * Constructor for NullGetObjectSizeTest.
     * @param name
     */
    public NullGetObjectSizeTest(String name) {
        super(name);
    }

    public static void
    main (String[] args) throws Throwable {
        ATestCaseScaffold   test = new NullGetObjectSizeTest(args[0]);
        test.runTest();
    }

    protected final void
    doRunTest() {
        testNullGetObjectSize();
    }


    public void
    testNullGetObjectSize() {
        boolean caught = false;

        // Test that a null argument throws NullPointerException
        try {
            fInst.getObjectSize(null);
        } catch (NullPointerException npe) {
            caught = true;
        }
        assertTrue(caught);
    }

}
