/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.openide.awt.DisabledIcon;

class ToolbarButtonUI
extends WindowsButtonUI {
    static final long serialVersionUID = 5306796614639723529L;
    private static ImageIcon brush;
    Icon oldDisabledIcon;
    boolean oldFocusPainted;
    boolean oldBorderPainted;
    boolean oldRolloverEnabled;
    protected static final Insets defaultMargin;
    private static final ToolbarButtonUI toolbarButtonUI;

    ToolbarButtonUI() {
    }

    private ImageIcon getBrush() {
        if (brush != null) {
            return brush;
        }
        brush = new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/core/resources/plaf/crosshatch.gif"));
        return brush;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return toolbarButtonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        this.oldFocusPainted = abstractButton.isFocusPainted();
        this.oldBorderPainted = abstractButton.isBorderPainted();
        this.oldRolloverEnabled = abstractButton.isRolloverEnabled();
        abstractButton.setFocusPainted(false);
        abstractButton.setBorderPainted(false);
        abstractButton.setRolloverEnabled(true);
        ImageIcon imageIcon = (ImageIcon)abstractButton.getDisabledIcon();
        if (imageIcon instanceof DisabledIcon) {
            ((DisabledIcon)imageIcon).setBorderPainted(true);
        } else if (imageIcon instanceof ImageIcon) {
            abstractButton.setDisabledIcon(new DisabledIcon(imageIcon.getImage()));
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        abstractButton.setFocusPainted(this.oldFocusPainted);
        abstractButton.setBorderPainted(this.oldBorderPainted);
        abstractButton.setRolloverEnabled(this.oldRolloverEnabled);
        ImageIcon imageIcon = (ImageIcon)abstractButton.getDisabledIcon();
        if (imageIcon instanceof DisabledIcon) {
            ((DisabledIcon)imageIcon).setBorderPainted(false);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isSelected() && !buttonModel.isRollover()) {
            graphics.setClip(2, 2, abstractButton.getWidth() - 4, abstractButton.getHeight() - 4);
            this.getBrush().paintIcon(jComponent, graphics, 0, 0);
            graphics.setClip(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
        }
        super.paint(graphics, jComponent);
        if (buttonModel.isEnabled()) {
            if (buttonModel.isSelected()) {
                this.draw3DRect(graphics, 1, 1, abstractButton.getWidth() - 2, abstractButton.getHeight() - 2, UIManager.getDefaults().getColor("controlShadow"), UIManager.getDefaults().getColor("controlLtHighlight"));
            } else if (buttonModel.isRollover()) {
                Color color = UIManager.getDefaults().getColor("controlLtHighlight");
                Color color2 = UIManager.getDefaults().getColor("controlShadow");
                if (buttonModel.isArmed() && buttonModel.isPressed()) {
                    color = UIManager.getDefaults().getColor("controlShadow");
                    color2 = UIManager.getDefaults().getColor("controlLtHighlight");
                }
                this.draw3DRect(graphics, 1, 1, abstractButton.getWidth() - 2, abstractButton.getHeight() - 2, color, color2);
            }
        }
    }

    private void draw3DRect(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        graphics.setColor(color);
        graphics.drawLine(n5 - 1, n2, n, n2);
        graphics.drawLine(n, n2 + 1, n, n6 - 1);
        graphics.setColor(color2);
        graphics.drawLine(n, n6, n5, n6);
        graphics.drawLine(n5, n6 - 1, n5, n2);
    }

    public Insets getDefaultMargin(AbstractButton abstractButton) {
        return defaultMargin;
    }

    static {
        defaultMargin = new Insets(2, 1, 0, 1);
        toolbarButtonUI = new ToolbarButtonUI();
    }
}

