/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeTable;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class TreeTableView
extends BeanTreeView {
    protected JTable treeTable;
    private NodeTableModel tableModel;
    private JScrollBar hScrollBar;
    private JScrollPane scrollPane;
    private ScrollListener listener;
    private boolean allowHideColumns = false;
    private boolean allowSortingByColumn = false;
    private boolean hideHScrollBar = false;
    private JButton colsButton = null;
    SortedNodeTreeModel sortedNodeTreeModel = new SortedNodeTreeModel();
    private ActionListener defaultTreeActionListener;
    private TableCellRenderer defaultHeaderRenderer = null;
    private MouseListener tableMouseListener;
    private AccessibleContext accessContext;
    private static final String COLUMNS_ICON = "/org/openide/resources/columns.gif";
    private static final String SORT_ASC_ICON = "org/openide/resources/columnsSortedAsc.gif";
    private static final String SORT_DESC_ICON = "org/openide/resources/columnsSortedDesc.gif";
    private TreeColumnProperty treeColumnProperty = new TreeColumnProperty();
    private int treeColumnWidth;
    static /* synthetic */ Class class$org$openide$explorer$view$TreeTable;
    static /* synthetic */ Class class$org$openide$explorer$view$NodeTableModel;

    public TreeTableView() {
        this(new NodeTableModel());
    }

    public TreeTableView(NodeTableModel nodeTableModel) {
        this.tableModel = nodeTableModel;
        this.initializeTreeTable();
        this.setPopupAllowed(true);
        this.setDefaultActionAllowed(true);
        this.initializeTreeScrollSupport();
        CompoundScrollPane compoundScrollPane = new CompoundScrollPane();
        compoundScrollPane.setLayout(new BorderLayout());
        this.scrollPane.setViewportView(this.treeTable);
        compoundScrollPane.add("Center", this.scrollPane);
        ImageIcon imageIcon = new ImageIcon((class$org$openide$explorer$view$TreeTable == null ? (class$org$openide$explorer$view$TreeTable = TreeTableView.class$("org.openide.explorer.view.TreeTable")) : class$org$openide$explorer$view$TreeTable).getResource(COLUMNS_ICON));
        this.colsButton = new JButton(imageIcon);
        this.colsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeTableView.this.selectVisibleColumns();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.hScrollBar);
        compoundScrollPane.add("South", jPanel);
        super.setHorizontalScrollBarPolicy(31);
        super.setVerticalScrollBarPolicy(21);
        this.setViewportView(compoundScrollPane);
    }

    public void setHorizontalScrollBarPolicy(int n) {
        boolean bl = this.hideHScrollBar = n == 31;
        if (this.hideHScrollBar) {
            this.hScrollBar.setVisible(false);
            ((TreeTable)this.treeTable).setTreeHScrollingEnabled(false);
        }
    }

    public void setVerticalScrollBarPolicy(int n) {
        if (this.scrollPane == null) {
            return;
        }
        boolean bl = this.allowHideColumns = n == 22;
        if (this.allowHideColumns) {
            this.scrollPane.setCorner("UPPER_RIGHT_CORNER", this.colsButton);
        }
        this.treeTable.getTableHeader().setReorderingAllowed(this.allowHideColumns);
        this.scrollPane.setVerticalScrollBarPolicy(n);
    }

    protected NodeTreeModel createModel() {
        return this.sortedNodeTreeModel;
    }

    private void setAllowSortingByColumn(boolean bl) {
        if (bl && bl != this.allowSortingByColumn) {
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    Component component = mouseEvent.getComponent();
                    if (component instanceof JTableHeader) {
                        JTableHeader jTableHeader = (JTableHeader)component;
                        int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                        TreeTableView.this.clickOnColumnAction(n - 1);
                    }
                }
            });
        }
        this.allowSortingByColumn = bl;
    }

    private void clickOnColumnAction(int n) {
        if (n == -1) {
            if (this.treeColumnProperty.isComparable()) {
                if (this.treeColumnProperty.isSortingColumn()) {
                    if (this.treeColumnProperty.isSortOrderDescending()) {
                        this.setSortingOrder(true);
                    } else {
                        this.setSortingOrder(false);
                    }
                } else {
                    this.setSortingColumn(n);
                    this.setSortingOrder(true);
                }
            }
        } else if (this.tableModel.isComparableColumn(n)) {
            if (this.tableModel.isSortingColumn(n)) {
                if (this.tableModel.isSortOrderDescending()) {
                    this.setSortingOrder(true);
                } else {
                    this.setSortingOrder(false);
                }
            } else {
                this.setSortingColumn(n);
                this.setSortingOrder(true);
            }
        }
    }

    private void selectVisibleColumns() {
        this.setCurrentWidths();
        String string = null;
        if (this.getParent() != null) {
            string = this.getParent().getName();
        }
        if (this.tableModel.selectVisibleColumns(string, this.treeTable.getColumnName(0), this.sortedNodeTreeModel.getRootDescription())) {
            if (this.tableModel.getVisibleSortingColumn() == -1) {
                this.sortedNodeTreeModel.setSortedByProperty(null);
            }
            this.setTreePreferredWidth(this.treeColumnWidth);
            int n = 0;
            while (n < this.tableModel.getColumnCount()) {
                this.setTableColumnPreferredWidth(this.tableModel.getArrayIndex(n), this.tableModel.getVisibleColumnWidth(n));
                ++n;
            }
        }
    }

    private void setCurrentWidths() {
        this.treeColumnWidth = this.treeTable.getColumnModel().getColumn(0).getWidth();
        int n = 0;
        while (n < this.tableModel.getColumnCount()) {
            int n2 = this.treeTable.getColumnModel().getColumn(n + 1).getWidth();
            this.tableModel.setVisibleColumnWidth(n, n2);
            ++n;
        }
    }

    void initializeTree() {
    }

    private void initializeTreeTable() {
        this.treeModel = this.createModel();
        this.treeTable = new TreeTable(this.treeModel, this.tableModel);
        this.tree = ((TreeTable)this.treeTable).getTree();
        this.defaultHeaderRenderer = this.treeTable.getTableHeader().getDefaultRenderer();
        this.treeTable.getTableHeader().setDefaultRenderer(new SortingHeaderRenderer());
        this.managerListener = new TreeView.TreePropertyListener(this);
        this.tree.addTreeExpansionListener(this.managerListener);
        this.defaultActionListener = new TreeView.PopupSupport(this);
        this.treeTable.addFocusListener(this.defaultActionListener);
        this.tree.addMouseListener(this.defaultActionListener);
        this.tableMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!TreeTableView.this.isPopupAllowed()) {
                    return;
                }
                if (MouseUtils.isRightMouseButton(mouseEvent)) {
                    if (mouseEvent.getY() > TreeTableView.this.treeTable.getHeight()) {
                        TreeTableView.this.treeTable.clearSelection();
                    }
                    TreeTableView.this.createPopup(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.treeTable.addMouseListener(this.tableMouseListener);
        this.treeTable.setGridColor(UIManager.getColor("control"));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessContext == null) {
            this.accessContext = new AccessibleTreeTableView();
        }
        return this.accessContext;
    }

    private void initializeTreeScrollSupport() {
        this.scrollPane = new JScrollPane(){

            public void setBorder(Border border) {
                super.setBorder(null);
            }
        };
        this.scrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.hScrollBar = new JScrollBar(0);
        this.hScrollBar.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        this.listener = new ScrollListener();
        this.treeTable.addPropertyChangeListener(this.listener);
        this.scrollPane.getViewport().addComponentListener(this.listener);
        this.tree.addPropertyChangeListener(this.listener);
        this.hScrollBar.getModel().addChangeListener(this.listener);
    }

    public void setPopupAllowed(boolean bl) {
        if (this.tree == null) {
            return;
        }
        super.setPopupAllowed(bl);
    }

    public void setDefaultActionAllowed(boolean bl) {
        if (this.tree == null) {
            return;
        }
        this.defaultActionEnabled = bl;
        if (bl) {
            this.defaultTreeActionListener = new DefaultTreeAction();
            this.treeTable.registerKeyboardAction(this.defaultTreeActionListener, KeyStroke.getKeyStroke(10, 0, false), 0);
        } else {
            this.defaultTreeActionListener = null;
            this.treeTable.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        }
    }

    public void setProperties(Node.Property[] propertyArray) {
        this.tableModel.setProperties(propertyArray);
        this.treeColumnProperty.setProperty(this.tableModel.propertyForColumn(-1));
        if (this.treeColumnProperty.isComparable() || this.tableModel.existsComparableColumn()) {
            this.setAllowSortingByColumn(true);
            if (this.treeColumnProperty.isSortingColumn()) {
                this.sortedNodeTreeModel.setSortedByName(true, !this.treeColumnProperty.isSortOrderDescending());
            } else {
                int n = this.tableModel.getVisibleSortingColumn();
                if (n != -1) {
                    this.sortedNodeTreeModel.setSortedByProperty(this.tableModel.propertyForColumn(n), !this.tableModel.isSortOrderDescending());
                }
            }
        }
    }

    public final void setTableAutoResizeMode(int n) {
        this.treeTable.setAutoResizeMode(n);
    }

    public final int getTableAutoResizeMode() {
        return this.treeTable.getAutoResizeMode();
    }

    public final void setTableColumnPreferredWidth(int n, int n2) {
        this.tableModel.setArrayColumnWidth(n, n2);
        int n3 = this.tableModel.getVisibleIndex(n);
        if (n3 != -1) {
            this.treeTable.getColumnModel().getColumn(n3 + 1).setPreferredWidth(n2);
        }
    }

    public final int getTableColumnPreferredWidth(int n) {
        return this.tableModel.getArrayColumnWidth(n);
    }

    public final void setTreePreferredWidth(int n) {
        this.treeTable.getColumnModel().getColumn(((TreeTable)this.treeTable).getTreeColumnIndex()).setPreferredWidth(n);
    }

    public final int getTreePreferredWidth() {
        return this.treeTable.getColumnModel().getColumn(((TreeTable)this.treeTable).getTreeColumnIndex()).getPreferredWidth();
    }

    public void addNotify() {
        if (this.treeTable.getParent() != null) {
            this.treeTable.getParent().addMouseListener(this.tableMouseListener);
        }
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        this.tableModel.setNodes(new Node[0]);
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.treeTable.getTableHeader().addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        this.treeTable.getTableHeader().removeMouseListener(mouseListener);
    }

    public void setDragSource(boolean bl) {
    }

    public void setDropTarget(boolean bl) {
    }

    void createPopup(int n, int n2) {
        int n3 = this.scrollPane.getViewport().getViewPosition().y;
        n2 -= (n3 -= this.scrollPane.getColumnHeader().getPreferredSize().height);
        n -= ((TreeTable)this.treeTable).getPositionX();
        if (this.allowHideColumns || this.allowSortingByColumn) {
            int n4 = this.treeTable.getColumnModel().getColumnIndexAtX(n);
            super.createExtendedPopup(n, n2, this.getListMenu(n4));
        } else {
            super.createPopup(n, n2);
        }
    }

    private JMenu getListMenu(final int n) {
        JMenuItem jMenuItem;
        JMenu jMenu = new JMenu(NbBundle.getBundle(class$org$openide$explorer$view$NodeTableModel == null ? (class$org$openide$explorer$view$NodeTableModel = TreeTableView.class$("org.openide.explorer.view.NodeTableModel")) : class$org$openide$explorer$view$NodeTableModel).getString("LBL_ListOptions"));
        if (this.allowHideColumns && n > 0) {
            JMenuItem jMenuItem2;
            jMenuItem = new JMenu(NbBundle.getBundle(class$org$openide$explorer$view$NodeTableModel == null ? (class$org$openide$explorer$view$NodeTableModel = TreeTableView.class$("org.openide.explorer.view.NodeTableModel")) : class$org$openide$explorer$view$NodeTableModel).getString("LBL_ColsMenu"));
            boolean bl = false;
            if (n > 1) {
                jMenuItem2 = new JMenuItem(NbBundle.getBundle(class$org$openide$explorer$view$NodeTableModel == null ? (class$org$openide$explorer$view$NodeTableModel = TreeTableView.class$("org.openide.explorer.view.NodeTableModel")) : class$org$openide$explorer$view$NodeTableModel).getString("LBL_MoveLeft"));
                jMenuItem2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.treeTable.getColumnModel().moveColumn(n, n - 1);
                    }
                });
                ((JMenu)jMenuItem).add(jMenuItem2);
                bl = true;
            }
            if (n < this.tableModel.getColumnCount()) {
                jMenuItem2 = new JMenuItem(NbBundle.getBundle(class$org$openide$explorer$view$NodeTableModel == null ? (class$org$openide$explorer$view$NodeTableModel = TreeTableView.class$("org.openide.explorer.view.NodeTableModel")) : class$org$openide$explorer$view$NodeTableModel).getString("LBL_MoveRight"));
                jMenuItem2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.treeTable.getColumnModel().moveColumn(n, n + 1);
                    }
                });
                ((JMenu)jMenuItem).add(jMenuItem2);
                bl = true;
            }
            if (bl) {
                jMenu.add(jMenuItem);
            }
        }
        if (this.allowSortingByColumn) {
            int n2;
            JRadioButtonMenuItem jRadioButtonMenuItem;
            jMenuItem = new JMenu(NbBundle.getBundle(class$org$openide$explorer$view$NodeTableModel == null ? (class$org$openide$explorer$view$NodeTableModel = TreeTableView.class$("org.openide.explorer.view.NodeTableModel")) : class$org$openide$explorer$view$NodeTableModel).getString("LBL_SortMenu"));
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(NbBundle.getBundle(class$org$openide$explorer$view$NodeTableModel == null ? (class$org$openide$explorer$view$NodeTableModel = TreeTableView.class$("org.openide.explorer.view.NodeTableModel")) : class$org$openide$explorer$view$NodeTableModel).getString("LBL_NoSort"), !this.sortedNodeTreeModel.sortingActive());
            jRadioButtonMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TreeTableView.this.noSorting();
                }
            });
            ((JMenu)jMenuItem).add(jRadioButtonMenuItem2);
            int n3 = 0;
            if (this.treeColumnProperty.isComparable()) {
                ++n3;
                jRadioButtonMenuItem = new JRadioButtonMenuItem(this.treeTable.getColumnName(0), this.treeColumnProperty.isSortingColumn());
                jRadioButtonMenuItem.setHorizontalTextPosition(2);
                jRadioButtonMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.setSortingColumn(-1);
                    }
                });
                ((JMenu)jMenuItem).add(jRadioButtonMenuItem);
            }
            int n4 = 0;
            while (n4 < this.tableModel.getColumnCount()) {
                if (this.tableModel.isComparableColumn(n4)) {
                    ++n3;
                    jRadioButtonMenuItem = new JRadioButtonMenuItem(this.tableModel.getColumnName(n4), this.tableModel.isSortingColumn(n4));
                    jRadioButtonMenuItem.setHorizontalTextPosition(2);
                    n2 = n4;
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            TreeTableView.this.setSortingColumn(n2);
                        }
                    });
                    ((JMenu)jMenuItem).add(jRadioButtonMenuItem);
                }
                n4 += 1;
            }
            if (n3 > 0) {
                ((JMenu)jMenuItem).addSeparator();
                n2 = this.treeColumnProperty.isSortingColumn() ? this.treeColumnProperty.isSortOrderDescending() : this.tableModel.isSortOrderDescending();
                JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(NbBundle.getBundle(class$org$openide$explorer$view$NodeTableModel == null ? (class$org$openide$explorer$view$NodeTableModel = TreeTableView.class$("org.openide.explorer.view.NodeTableModel")) : class$org$openide$explorer$view$NodeTableModel).getString("LBL_Ascending"), n2 == 0);
                jRadioButtonMenuItem3.setHorizontalTextPosition(2);
                jRadioButtonMenuItem3.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.setSortingOrder(true);
                    }
                });
                ((JMenu)jMenuItem).add(jRadioButtonMenuItem3);
                JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem(NbBundle.getBundle(class$org$openide$explorer$view$NodeTableModel == null ? (class$org$openide$explorer$view$NodeTableModel = TreeTableView.class$("org.openide.explorer.view.NodeTableModel")) : class$org$openide$explorer$view$NodeTableModel).getString("LBL_Descending"), n2 != 0);
                jRadioButtonMenuItem4.setHorizontalTextPosition(2);
                jRadioButtonMenuItem4.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.setSortingOrder(false);
                    }
                });
                ((JMenu)jMenuItem).add(jRadioButtonMenuItem4);
                if (!this.sortedNodeTreeModel.sortingActive()) {
                    jRadioButtonMenuItem3.setEnabled(false);
                    jRadioButtonMenuItem4.setEnabled(false);
                }
                jMenu.add(jMenuItem);
            }
        }
        if (this.allowHideColumns) {
            jMenuItem = new JMenuItem(NbBundle.getBundle(class$org$openide$explorer$view$NodeTableModel == null ? (class$org$openide$explorer$view$NodeTableModel = TreeTableView.class$("org.openide.explorer.view.NodeTableModel")) : class$org$openide$explorer$view$NodeTableModel).getString("LBL_ChangeColumns"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TreeTableView.this.selectVisibleColumns();
                }
            });
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    private void setSortingColumn(int n) {
        this.tableModel.setSortingColumn(n);
        if (n != -1) {
            this.sortedNodeTreeModel.setSortedByProperty(this.tableModel.propertyForColumn(n), !this.tableModel.isSortOrderDescending());
            this.treeColumnProperty.setSortingColumn(false);
        } else {
            this.sortedNodeTreeModel.setSortedByName(true, !this.treeColumnProperty.isSortOrderDescending());
            this.treeColumnProperty.setSortingColumn(true);
        }
        this.treeTable.getTableHeader().repaint();
    }

    private void noSorting() {
        this.tableModel.setSortingColumn(-1);
        this.sortedNodeTreeModel.setNoSorting();
        this.treeColumnProperty.setSortingColumn(false);
        this.treeTable.getTableHeader().repaint();
    }

    private void setSortingOrder(boolean bl) {
        if (this.treeColumnProperty.isSortingColumn()) {
            this.treeColumnProperty.setSortOrderDescending(!bl);
        } else {
            this.tableModel.setSortOrderDescending(!bl);
        }
        this.sortedNodeTreeModel.setSortOrder(bl);
        this.treeTable.getTableHeader().repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TreeColumnProperty {
        private Node.Property p = null;

        private TreeColumnProperty() {
        }

        void setProperty(Node.Property property) {
            this.p = property;
        }

        boolean isComparable() {
            if (this.p == null) {
                return false;
            }
            Object object = this.p.getValue("ComparableColumnTTV");
            if (object != null && object instanceof Boolean) {
                return (Boolean)object;
            }
            return false;
        }

        boolean isSortingColumn() {
            if (this.p == null) {
                return false;
            }
            Object object = this.p.getValue("SortingColumnTTV");
            if (object != null && object instanceof Boolean) {
                return (Boolean)object;
            }
            return false;
        }

        void setSortingColumn(boolean bl) {
            if (this.p == null) {
                return;
            }
            this.p.setValue("SortingColumnTTV", bl ? Boolean.TRUE : Boolean.FALSE);
        }

        boolean isSortOrderDescending() {
            if (this.p == null) {
                return false;
            }
            Object object = this.p.getValue("DescendingOrderTTV");
            if (object != null && object instanceof Boolean) {
                return (Boolean)object;
            }
            return false;
        }

        void setSortOrderDescending(boolean bl) {
            if (this.p == null) {
                return;
            }
            this.p.setValue("DescendingOrderTTV", bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private class SortingHeaderRenderer
    extends DefaultTableCellRenderer {
        private SortingHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = TreeTableView.this.defaultHeaderRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                if (n2 == 0 && TreeTableView.this.treeColumnProperty.isSortingColumn()) {
                    ((JLabel)component).setIcon(this.getProperIcon(TreeTableView.this.treeColumnProperty.isSortOrderDescending()));
                    ((JLabel)component).setHorizontalTextPosition(2);
                    component.setFont(component.getFont().deriveFont(1));
                } else if (n2 != 0 && TreeTableView.this.tableModel.getVisibleSortingColumn() + 1 == n2) {
                    ((JLabel)component).setIcon(this.getProperIcon(TreeTableView.this.tableModel.isSortOrderDescending()));
                    ((JLabel)component).setHorizontalTextPosition(2);
                    component.setFont(component.getFont().deriveFont(1));
                } else {
                    ((JLabel)component).setIcon(null);
                }
            }
            return component;
        }

        private ImageIcon getProperIcon(boolean bl) {
            if (bl) {
                return new ImageIcon(Utilities.loadImage(TreeTableView.SORT_DESC_ICON));
            }
            return new ImageIcon(Utilities.loadImage(TreeTableView.SORT_ASC_ICON));
        }
    }

    private class SortedNodeTreeModel
    extends NodeTreeModel {
        private Node.Property sortedByProperty;
        private boolean sortAscending = true;
        private Comparator rowComparator;
        private boolean sortedByName = false;
        private boolean noSorting = false;

        private SortedNodeTreeModel() {
        }

        void setNoSorting() {
            this.noSorting = true;
            this.setSortedByProperty(null);
            this.setSortedByName(false);
        }

        boolean sortingActive() {
            return this.sortedByProperty != null || this.sortedByName;
        }

        void setSortedByProperty(Node.Property property) {
            if (this.sortedByProperty == property) {
                return;
            }
            this.sortedByProperty = property;
            if (property == null) {
                this.rowComparator = null;
            } else {
                this.sortedByName = false;
            }
            this.sortingChanged();
        }

        void setSortedByProperty(Node.Property property, boolean bl) {
            if (this.sortedByProperty == property && bl == this.sortAscending) {
                return;
            }
            this.sortedByProperty = property;
            this.sortAscending = bl;
            if (property == null) {
                this.rowComparator = null;
            } else {
                this.sortedByName = false;
            }
            this.sortingChanged();
        }

        void setSortedByName(boolean bl, boolean bl2) {
            if (this.sortedByName == bl && bl2 == this.sortAscending) {
                return;
            }
            this.sortedByName = bl;
            this.sortAscending = bl2;
            if (this.sortedByName) {
                this.sortedByProperty = null;
            }
            this.sortingChanged();
        }

        void setSortedByName(boolean bl) {
            this.sortedByName = bl;
            if (this.sortedByName) {
                this.sortedByProperty = null;
            }
            this.sortingChanged();
        }

        void setSortOrder(boolean bl) {
            if (bl == this.sortAscending) {
                return;
            }
            this.sortAscending = bl;
            this.sortingChanged();
        }

        public Object getChild(Object object, int n) {
            if ((this.sortedByProperty != null || this.sortedByName || this.noSorting) && object instanceof VisualizerNode) {
                VisualizerNode visualizerNode = (VisualizerNode)object;
                List list = visualizerNode.getChildren();
                this.sort(list);
                return list.get(n);
            }
            return super.getChild(object, n);
        }

        public int getIndexOfChild(Object object, Object object2) {
            if ((this.sortedByProperty != null || this.sortedByName || this.noSorting) && object instanceof VisualizerNode) {
                VisualizerNode visualizerNode = (VisualizerNode)object;
                List list = visualizerNode.getChildren();
                this.sort(list);
                return list.indexOf(object2);
            }
            return super.getIndexOfChild(object, object2);
        }

        private Node.Property getNodeProperty(Node node, Node.Property property) {
            Node.PropertySet[] propertySetArray = node.getPropertySets();
            int n = 0;
            int n2 = propertySetArray.length;
            while (n < n2) {
                Node.Property[] propertyArray = propertySetArray[n].getProperties();
                int n3 = 0;
                int n4 = propertyArray.length;
                while (n3 < n4) {
                    if (propertyArray[n3].equals(property)) {
                        return propertyArray[n3];
                    }
                    ++n3;
                }
                ++n;
            }
            return null;
        }

        synchronized Comparator getRowComparator() {
            if (this.rowComparator == null) {
                this.rowComparator = new Comparator(this){
                    private final /* synthetic */ SortedNodeTreeModel this$1;
                    {
                        this.this$1 = sortedNodeTreeModel;
                    }

                    public int compare(Object object, Object object2) {
                        if (object == object2) {
                            return -1;
                        }
                        Node node = ((VisualizerNode)object).node;
                        Node node2 = ((VisualizerNode)object2).node;
                        if (SortedNodeTreeModel.access$1600(this.this$1) == null && !SortedNodeTreeModel.access$1700(this.this$1)) {
                            Node[] nodeArray = node.getParentNode().getChildren().getNodes();
                            int n = 0;
                            while (n < nodeArray.length) {
                                if (nodeArray[n].equals(node)) {
                                    return -1;
                                }
                                if (nodeArray[n].equals(node2)) {
                                    return 1;
                                }
                                ++n;
                            }
                            return 0;
                        }
                        if (SortedNodeTreeModel.access$1700(this.this$1)) {
                            int n = node.getDisplayName().compareTo(node2.getDisplayName());
                            return SortedNodeTreeModel.access$1800(this.this$1) ? n : -n;
                        }
                        Node.Property property = SortedNodeTreeModel.access$1900(this.this$1, node, SortedNodeTreeModel.access$1600(this.this$1));
                        Node.Property property2 = SortedNodeTreeModel.access$1900(this.this$1, node2, SortedNodeTreeModel.access$1600(this.this$1));
                        if (property == null && property2 == null) {
                            return 0;
                        }
                        try {
                            int n;
                            if (property == null) {
                                n = -1;
                            } else if (property2 == null) {
                                n = 1;
                            } else {
                                Object object3 = property.getValue();
                                Object object4 = property2.getValue();
                                if (object3 == null && object4 == null) {
                                    return 0;
                                }
                                if (object3 == null) {
                                    n = -1;
                                } else if (object4 == null) {
                                    n = 1;
                                } else {
                                    if (object3.getClass() != object4.getClass() || !(object3 instanceof Comparable)) {
                                        object3 = object3.toString();
                                        object4 = object4.toString();
                                    }
                                    n = ((Comparable)object3).compareTo(object4);
                                }
                            }
                            return SortedNodeTreeModel.access$1800(this.this$1) ? n : -n;
                        }
                        catch (Exception exception) {
                            return 0;
                        }
                    }
                };
            }
            return this.rowComparator;
        }

        void sort(List list) {
            Comparator comparator = this.getRowComparator();
            if (comparator == null) {
                return;
            }
            Collections.sort(list, comparator);
        }

        void sortingChanged() {
            TreeNode treeNode = (TreeNode)this.getRoot();
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            Enumeration<TreePath> enumeration = TreeTableView.this.tree.getExpandedDescendants(new TreePath(treeNode));
            while (enumeration != null && enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            this.nodeStructureChanged(treeNode);
            int n = 0;
            while (n < arrayList.size()) {
                TreeTableView.this.tree.expandPath((TreePath)arrayList.get(n));
                ++n;
            }
        }

        String getRootDescription() {
            if (this.getRoot() instanceof VisualizerNode) {
                return ((VisualizerNode)this.getRoot()).getShortDescription();
            }
            return "";
        }

        static /* synthetic */ Node.Property access$1600(SortedNodeTreeModel sortedNodeTreeModel) {
            return sortedNodeTreeModel.sortedByProperty;
        }

        static /* synthetic */ boolean access$1700(SortedNodeTreeModel sortedNodeTreeModel) {
            return sortedNodeTreeModel.sortedByName;
        }

        static /* synthetic */ boolean access$1800(SortedNodeTreeModel sortedNodeTreeModel) {
            return sortedNodeTreeModel.sortAscending;
        }

        static /* synthetic */ Node.Property access$1900(SortedNodeTreeModel sortedNodeTreeModel, Node node, Node.Property property) {
            return sortedNodeTreeModel.getNodeProperty(node, property);
        }
    }

    private class DefaultTreeAction
    implements ActionListener {
        private DefaultTreeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SystemAction systemAction;
            if (TreeTableView.this.treeTable.getSelectedColumn() != ((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex()) {
                return;
            }
            Node[] nodeArray = TreeTableView.this.manager.getSelectedNodes();
            if (nodeArray.length == 1 && (systemAction = nodeArray[0].getDefaultAction()) != null) {
                TreeView.invokeAction(systemAction, new ActionEvent(nodeArray[0], 1001, ""));
            }
        }
    }

    private static final class CompoundScrollPane
    extends JPanel
    implements Scrollable {
        private CompoundScrollPane() {
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }

        public boolean getScrollableTracksViewportHeight() {
            return true;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }
    }

    private final class ScrollListener
    extends ComponentAdapter
    implements PropertyChangeListener,
    ChangeListener {
        boolean movecorrection = false;

        private ScrollListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex() == -1) {
                return;
            }
            if ("width".equals(propertyChangeEvent.getPropertyName())) {
                if (!TreeTableView.this.treeTable.equals(propertyChangeEvent.getSource())) {
                    Dimension dimension = TreeTableView.this.hScrollBar.getPreferredSize();
                    dimension.width = TreeTableView.this.treeTable.getColumnModel().getColumn(((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex()).getWidth();
                    TreeTableView.this.hScrollBar.setPreferredSize(dimension);
                    TreeTableView.this.hScrollBar.revalidate();
                    TreeTableView.this.hScrollBar.repaint();
                }
                this.revalidateScrollBar();
            } else if ("positionX".equals(propertyChangeEvent.getPropertyName())) {
                this.revalidateScrollBar();
            } else if ("treeColumnIndex".equals(propertyChangeEvent.getPropertyName())) {
                TreeTableView.this.treeTable.getColumnModel().getColumn(((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex()).addPropertyChangeListener(TreeTableView.this.listener);
            } else if ("column_moved".equals(propertyChangeEvent.getPropertyName())) {
                int n = (Integer)propertyChangeEvent.getOldValue();
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                if (n == 0 || n2 == 0) {
                    if (this.movecorrection) {
                        this.movecorrection = false;
                    } else {
                        this.movecorrection = true;
                        TreeTableView.this.treeTable.getColumnModel().moveColumn(n2, n);
                    }
                    return;
                }
                TreeTableView.this.treeTable.getTableHeader().getColumnModel().getColumn(n).setModelIndex(n);
                TreeTableView.this.treeTable.getTableHeader().getColumnModel().getColumn(n2).setModelIndex(n2);
                TreeTableView.this.tableModel.moveColumn(n - 1, n2 - 1);
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.revalidateScrollBar();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = TreeTableView.this.hScrollBar.getModel().getValue();
            ((TreeTable)TreeTableView.this.treeTable).setPositionX(n);
        }

        private void revalidateScrollBar() {
            int n = TreeTableView.this.treeTable.getColumnModel().getColumn(((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex()).getWidth();
            int n2 = TreeTableView.this.tree.getPreferredSize().width;
            int n3 = ((TreeTableView)TreeTableView.this).scrollPane.getViewport().getSize().height;
            int n4 = TreeTableView.this.tree.getPreferredSize().height;
            int n5 = ((TreeTable)TreeTableView.this.treeTable).getPositionX();
            int n6 = Math.max(0, Math.min(n5, n2 - n));
            boolean bl = TreeTableView.this.hScrollBar.isVisible();
            boolean bl2 = TreeTableView.this.scrollPane.getVerticalScrollBar().isVisible();
            int n7 = bl ? TreeTableView.this.hScrollBar.getHeight() : 0;
            int n8 = TreeTableView.this.scrollPane.getVerticalScrollBar().getWidth();
            TreeTableView.this.hScrollBar.setValues(n6, n, 0, n2);
            if (TreeTableView.this.hideHScrollBar || n2 <= n || bl2 && n4 <= n3 + n7 && n2 <= n + n8) {
                TreeTableView.this.hScrollBar.setVisible(false);
            } else {
                TreeTableView.this.hScrollBar.setVisible(true);
            }
        }
    }

    private class AccessibleTreeTableView
    extends JScrollPane.AccessibleJScrollPane {
        AccessibleTreeTableView() {
            super(TreeTableView.this);
        }

        public void setAccessibleName(String string) {
            super.setAccessibleName(string);
            if (TreeTableView.this.treeTable != null) {
                TreeTableView.this.treeTable.getAccessibleContext().setAccessibleName(string);
            }
        }

        public void setAccessibleDescription(String string) {
            super.setAccessibleDescription(string);
            if (TreeTableView.this.treeTable != null) {
                TreeTableView.this.treeTable.getAccessibleContext().setAccessibleDescription(string);
            }
        }
    }
}

