/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.openide.TopManager;
import org.openide.execution.NbfsURLConnection;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ReferencesResolver;

class DefaultResolver
implements ReferencesResolver {
    private static final String NAME_DELIMITER = "/";
    private static final String DOT = ".";
    private static final String DOUBLE_DOT = "..";

    DefaultResolver() {
    }

    public FileObject find(URL uRL, FileObject fileObject) {
        FileObject fileObject2;
        if ("nbfs".equals(uRL.getProtocol()) && (fileObject2 = NbfsURLConnection.decodeURL(uRL)) != null) {
            return fileObject2;
        }
        return this.resolveRelativeName(uRL.getPath(), fileObject);
    }

    public URL translateURL(URL uRL, FileObject fileObject) {
        if (!"nbfs".equals(uRL.getProtocol())) {
            return uRL;
        }
        FileObject fileObject2 = NbfsURLConnection.decodeURL(uRL);
        if (fileObject2 == null) {
            return uRL;
        }
        try {
            return this.createRelativeURL(fileObject2, fileObject);
        }
        catch (MalformedURLException malformedURLException) {
            TopManager.getDefault().notifyException(malformedURLException);
            return uRL;
        }
    }

    private FileObject resolveRelativeName(String string, FileObject fileObject) {
        if (string.length() == 0) {
            return fileObject;
        }
        if (string.startsWith(NAME_DELIMITER)) {
            try {
                fileObject = fileObject.getFileSystem().getRoot();
            }
            catch (IOException iOException) {
                return null;
            }
        } else {
            fileObject = fileObject.getParent();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, NAME_DELIMITER);
        while (stringTokenizer.hasMoreElements() && fileObject != null) {
            int n;
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 0 || string2.equals(DOT)) continue;
            fileObject = string2.equals(DOUBLE_DOT) ? fileObject.getParent() : ((n = string2.lastIndexOf(DOT)) != -1 ? fileObject.getFileObject(string2.substring(0, n), string2.substring(n + 1)) : fileObject.getFileObject(string2));
        }
        return fileObject;
    }

    private URL createRelativeURL(FileObject fileObject, FileObject fileObject2) throws MalformedURLException {
        if (fileObject.equals(fileObject2)) {
            return new URL("file:.");
        }
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        this.createPath(fileObject2, linkedList);
        this.createPath(fileObject, linkedList2);
        int n = linkedList.size();
        int n2 = linkedList2.size();
        int n3 = 0;
        Iterator iterator = linkedList.iterator();
        Iterator iterator2 = linkedList2.iterator();
        FileObject fileObject3 = null;
        FileObject fileObject4 = null;
        while (iterator.hasNext() && iterator2.hasNext()) {
            fileObject3 = (FileObject)iterator.next();
            if (fileObject3 != (fileObject4 = (FileObject)iterator2.next())) break;
            ++n3;
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        while (n3 < n - 1) {
            stringBuffer.append("../");
            ++n3;
        }
        if (fileObject4 != null) {
            stringBuffer.append(fileObject4.getNameExt());
        }
        while (iterator2.hasNext()) {
            fileObject4 = (FileObject)iterator2.next();
            stringBuffer.append('/');
            stringBuffer.append(fileObject4.getNameExt());
        }
        return new URL("file:" + stringBuffer.toString());
    }

    private void createPath(FileObject fileObject, LinkedList linkedList) {
        while (!fileObject.isRoot()) {
            linkedList.addFirst(fileObject);
            fileObject = fileObject.getParent();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }
}

