/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.util.actions.NodeAction;

public abstract class CookieAction
extends NodeAction {
    private static final String PROP_COOKIES = "cookies";
    public static final int MODE_ONE = 1;
    public static final int MODE_SOME = 2;
    public static final int MODE_ALL = 4;
    public static final int MODE_EXACTLY_ONE = 8;
    public static final int MODE_ANY = 7;
    private static final long serialVersionUID = 6031319415908298424L;
    private CookiesChangeListener listener = new CookiesChangeListener(this);

    protected abstract int mode();

    protected abstract Class[] cookieClasses();

    private Class[] getCookies() {
        Class[] classArray = (Class[])this.getProperty(PROP_COOKIES);
        if (classArray != null) {
            return classArray;
        }
        classArray = this.cookieClasses();
        this.putProperty(PROP_COOKIES, classArray);
        return classArray;
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return false;
        }
        this.listener.setNodes(nodeArray);
        return this.doEnable(nodeArray);
    }

    boolean doEnable(Node[] nodeArray) {
        int n = this.resolveSupported(nodeArray);
        if (n == 0) {
            return false;
        }
        int n2 = this.mode();
        return (n2 & 1) != 0 || (n2 & 4) != 0 && n == nodeArray.length || (n2 & 8) != 0 && nodeArray.length == 1 || (n2 & 2) != 0 && n < nodeArray.length;
    }

    private int resolveSupported(Node[] nodeArray) {
        int n = nodeArray.length;
        int n2 = 0;
        Class[] classArray = this.getCookies();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < classArray.length) {
                if (nodeArray[n3].getCookie(classArray[n4]) != null) {
                    ++n2;
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        return n2;
    }

    private static final class CookiesChangeListener
    extends NodeAdapter {
        private List nodes;
        private Reference action;

        public CookiesChangeListener(CookieAction cookieAction) {
            this.action = new WeakReference<CookieAction>(cookieAction);
        }

        void setNodes(Node[] nodeArray) {
            List list = this.nodes;
            if (list != null) {
                this.detachListeners(list);
            }
            this.nodes = null;
            if (nodeArray != null) {
                this.nodes = new ArrayList(nodeArray.length);
                int n = 0;
                while (n < nodeArray.length) {
                    this.nodes.add(new WeakReference<Node>(nodeArray[n]));
                    ++n;
                }
                this.attachListeners(this.nodes);
            }
        }

        void detachListeners(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)((Reference)iterator.next()).get();
                if (node == null) continue;
                node.removeNodeListener(this);
            }
        }

        void attachListeners(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)((Reference)iterator.next()).get();
                if (node == null) continue;
                node.addNodeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!"cookie".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            CookieAction cookieAction = (CookieAction)this.action.get();
            if (cookieAction == null) {
                return;
            }
            List list = this.nodes;
            if (list != null) {
                Object object;
                ArrayList<Node[]> arrayList = new ArrayList<Node[]>(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    object = (Node)((Reference)iterator.next()).get();
                    if (object != null) {
                        arrayList.add((Node[])object);
                        continue;
                    }
                    return;
                }
                object = new Node[arrayList.size()];
                arrayList.toArray((T[])object);
                cookieAction.setEnabled(cookieAction.enable((Node[])object));
            }
        }
    }
}

