/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.EventListenerList;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.TransferListener;

public class ExTransferable
implements Transferable {
    public static final Transferable EMPTY = new Empty();
    public static final DataFlavor multiFlavor = new DataFlavor("application/x-java-openide-multinode;class=org.openide.util.datatransfer.MultiTransferObject", NbBundle.getBundle(class$org$openide$util$datatransfer$ExTransferable == null ? (class$org$openide$util$datatransfer$ExTransferable = ExTransferable.class$("org.openide.util.datatransfer.ExTransferable")) : class$org$openide$util$datatransfer$ExTransferable).getString("transferFlavorsMultiFlavorName"));
    private HashMap map = new HashMap();
    private EventListenerList listeners;
    static /* synthetic */ Class class$org$openide$util$datatransfer$ExTransferable;
    static /* synthetic */ Class class$org$openide$util$datatransfer$TransferListener;

    private ExTransferable(final Transferable transferable) {
        final DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        if (dataFlavorArray != null) {
            int n = 0;
            while (n < dataFlavorArray.length) {
                try {
                    final int n2 = n;
                    this.map.put(dataFlavorArray[n], new Single(dataFlavorArray[n]){

                        public Object getData() throws IOException, UnsupportedFlavorException {
                            return transferable.getTransferData(dataFlavorArray[n2]);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    public void put(Single single) {
        this.map.put(single.flavor, single);
    }

    public void remove(DataFlavor dataFlavor) {
        this.map.remove(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.map.keySet().toArray(new DataFlavor[0]);
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.map.containsKey(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        Single single = (Single)this.map.get(dataFlavor);
        if (single == null) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return single.getTransferData(dataFlavor);
    }

    public static ExTransferable create(Transferable transferable) {
        if (transferable instanceof ExTransferable) {
            return (ExTransferable)transferable;
        }
        return new ExTransferable(transferable);
    }

    public final synchronized void addTransferListener(TransferListener transferListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(class$org$openide$util$datatransfer$TransferListener == null ? (class$org$openide$util$datatransfer$TransferListener = ExTransferable.class$("org.openide.util.datatransfer.TransferListener")) : class$org$openide$util$datatransfer$TransferListener, transferListener);
    }

    public final synchronized void removeTransferListener(TransferListener transferListener) {
        if (this.listeners != null) {
            this.listeners.remove(class$org$openide$util$datatransfer$TransferListener == null ? (class$org$openide$util$datatransfer$TransferListener = ExTransferable.class$("org.openide.util.datatransfer.TransferListener")) : class$org$openide$util$datatransfer$TransferListener, transferListener);
        }
    }

    final void fireAccepted(int n) {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.getListenerList();
        int n2 = objectArray.length - 1;
        while (n2 >= 0) {
            ((TransferListener)objectArray[n2]).accepted(n);
            n2 -= 2;
        }
    }

    final void fireRejected() {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.getListenerList();
        int n = objectArray.length - 1;
        while (n >= 0) {
            ((TransferListener)objectArray[n]).rejected();
            n -= 2;
        }
    }

    final void fireOwnershipLost() {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.getListenerList();
        int n = objectArray.length - 1;
        while (n >= 0) {
            ((TransferListener)objectArray[n]).ownershipLost();
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Empty
    implements Transferable {
        Empty() {
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[0];
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return false;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            throw new UnsupportedFlavorException(dataFlavor);
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    public static class Multi
    implements Transferable {
        private MultiTransferObject transferObject;
        private static final DataFlavor[] flavorList = new DataFlavor[]{multiFlavor};

        public Multi(Transferable[] transferableArray) {
            this.transferObject = new TransferObjectImpl(transferableArray);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return flavorList;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(multiFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.transferObject;
        }

        static class TransferObjectImpl
        implements MultiTransferObject {
            private Transferable[] trans;

            public TransferObjectImpl(Transferable[] transferableArray) {
                this.trans = transferableArray;
            }

            public int getCount() {
                return this.trans.length;
            }

            public Transferable getTransferableAt(int n) {
                return this.trans[n];
            }

            public boolean isDataFlavorSupported(int n, DataFlavor dataFlavor) {
                try {
                    return this.trans[n].isDataFlavorSupported(dataFlavor);
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public boolean areDataFlavorsSupported(DataFlavor[] dataFlavorArray) {
                HashSet<DataFlavor> hashSet = new HashSet<DataFlavor>();
                int n = 0;
                while (n < dataFlavorArray.length) {
                    hashSet.add(dataFlavorArray[n]);
                    ++n;
                }
                int n2 = 0;
                while (n2 < this.trans.length) {
                    block5: {
                        DataFlavor[] dataFlavorArray2 = this.trans[n2].getTransferDataFlavors();
                        if (dataFlavorArray2 == null) {
                            return false;
                        }
                        int n3 = 0;
                        while (n3 < dataFlavorArray2.length) {
                            if (!hashSet.contains(dataFlavorArray2[n3])) {
                                ++n3;
                                continue;
                            }
                            break block5;
                        }
                        return false;
                    }
                    ++n2;
                }
                return true;
            }

            public DataFlavor[] getTransferDataFlavors(int n) {
                return this.trans[n].getTransferDataFlavors();
            }

            public Object getTransferData(int n, DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                return this.trans[n].getTransferData(dataFlavor);
            }
        }
    }

    public static abstract class Single
    implements Transferable {
        private DataFlavor flavor;

        public Single(DataFlavor dataFlavor) {
            this.flavor = dataFlavor;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.flavor.equals(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.flavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.getData();
        }

        protected abstract Object getData() throws IOException, UnsupportedFlavorException;
    }
}

