/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.pocketword;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.openoffice.xmerge.util.EndianConverter;

class DocumentDescriptor {
    private short numParagraphs = 0;
    private short length = 0;
    private short numLines = 0;
    private Vector paragraphDesc = new Vector(0, 1);

    DocumentDescriptor() {
    }

    public void addParagraph(short s, short s2) {
        ParagraphDescriptor paragraphDescriptor = new ParagraphDescriptor(s, s2);
        this.paragraphDesc.add(paragraphDescriptor);
        this.numParagraphs = (short)(this.numParagraphs + 1);
        this.numLines = (short)(this.numLines + s2);
        this.length = (short)(this.length + paragraphDescriptor.length);
    }

    public byte[] getDescriptor() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeHeader(byteArrayOutputStream);
        try {
            byteArrayOutputStream.write(EndianConverter.writeShort((short)((short)(6 + this.numParagraphs * 2))));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.numParagraphs));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)0));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.numParagraphs));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)0));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.length));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)0));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.numLines));
            byteArrayOutputStream.write(new byte[8]);
            int n = 0;
            while (n < this.paragraphDesc.size()) {
                ParagraphDescriptor paragraphDescriptor = (ParagraphDescriptor)this.paragraphDesc.elementAt(n);
                byteArrayOutputStream.write(paragraphDescriptor.getDescriptor());
                ++n;
            }
            byteArrayOutputStream.write(EndianConverter.writeShort((short)0));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)65));
        }
        catch (IOException iOException) {}
        return byteArrayOutputStream.toByteArray();
    }

    private void writeHeader(OutputStream outputStream) {
        try {
            byte[] byArray = new byte[132];
            byArray[4] = 7;
            byArray[6] = 6;
            byArray[8] = 21;
            byArray[10] = 16;
            byArray[12] = 1;
            byArray[14] = -48;
            byArray[15] = 47;
            byArray[18] = -32;
            byArray[19] = 61;
            byArray[22] = -16;
            byArray[26] = -96;
            byArray[27] = 5;
            byArray[30] = -96;
            byArray[31] = 5;
            byArray[34] = -96;
            byArray[35] = 5;
            byArray[38] = -96;
            byArray[39] = 5;
            byArray[56] = 10;
            byArray[62] = 4;
            byArray[72] = 10;
            byArray[78] = 4;
            byArray[94] = 8;
            byArray[96] = 7;
            byArray[98] = 16;
            byArray[100] = 1;
            byArray[120] = 18;
            byArray[128] = 31;
            byArray[129] = 4;
            outputStream.write(byArray);
            byte[] byArray2 = new byte[4];
            byArray2[0] = -30;
            byArray2[1] = 2;
            outputStream.write(byArray2);
            byte[] byArray3 = new byte[12];
            byArray3[8] = 61;
            byArray3[9] = 4;
            outputStream.write(byArray3);
            byte[] byArray4 = new byte[4];
            byArray4[0] = -30;
            byArray4[1] = 2;
            outputStream.write(byArray4);
            byte[] byArray5 = new byte[16];
            byArray5[12] = 64;
            byArray5[14] = 8;
            outputStream.write(byArray5);
        }
        catch (IOException iOException) {}
    }

    private class ParagraphDescriptor {
        private short filler = 0;
        private short lines = 0;
        private short length = 0;
        private short unknown = (short)35;

        public ParagraphDescriptor(short s, short s2) {
            this.lines = s2;
            this.length = (short)(s + 1);
        }

        public byte[] getDescriptor() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(EndianConverter.writeShort((short)this.filler));
                byteArrayOutputStream.write(EndianConverter.writeShort((short)this.lines));
                byteArrayOutputStream.write(EndianConverter.writeShort((short)this.length));
                byteArrayOutputStream.write(EndianConverter.writeShort((short)this.unknown));
            }
            catch (IOException iOException) {}
            return byteArrayOutputStream.toByteArray();
        }
    }
}

