/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.aportisdoc;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.openoffice.xmerge.converter.palm.Record;
import org.openoffice.xmerge.converter.xml.sxw.aportisdoc.DocConstants;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.Resources;

final class DocDecoder
implements DocConstants {
    private static final int COUNT_BITS = 3;
    private Resources res = Resources.getInstance();

    DocDecoder() {
    }

    String parseRecords(Record[] recs) throws IOException {
        HeaderInfo header = this.readHeader(recs[0].getBytes());
        this.dumpHeader(header);
        StringBuffer textBuffer = new StringBuffer(header.textLen);
        switch (header.version) {
            case 2: {
                int i = 1;
                while (i <= header.textRecordCount) {
                    byte[] bytes = this.decompress(recs[i].getBytes(), header.textRecordSize);
                    this.log("processing " + bytes.length + " bytes");
                    String str = new String(bytes, "8859_1");
                    textBuffer.append(str);
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 1;
                while (i <= header.textRecordCount) {
                    byte[] bytes = recs[i].getBytes();
                    this.log("processing " + bytes.length + " bytes");
                    String str = new String(bytes, "8859_1");
                    textBuffer.append(str);
                    ++i;
                }
                break;
            }
            default: {
                throw new IOException(this.res.getString("UNKNOWN_DOC_VERSION"));
            }
        }
        return textBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private byte[] decompress(byte[] cBytes, int textRecordSize) throws IOException {
        uBytes = new byte[textRecordSize * 2];
        up = 0;
        cp = 0;
lbl4:
        // 3 sources

        try {
            while (cp < cBytes.length) {
                block7: {
                    if ((c = cBytes[cp++] & 255) <= 0 || c >= 9) break block7;
                    while (c-- > 0) {
                        uBytes[up++] = cBytes[cp++];
                    }
                    ** GOTO lbl4
                }
                if (c < 128) {
                    uBytes[up++] = (byte)c;
                    continue;
                }
                if (c >= 192) {
                    uBytes[up++] = 32;
                    uBytes[up++] = (byte)(c ^ 128);
                    continue;
                }
                c <<= 8;
                m = ((c += cBytes[cp++] & 255) & 16383) >> 3;
                n = c & 7;
                n += 3;
                while (n-- > 0) {
                    uBytes[up] = uBytes[up - m];
                    ++up;
                }
                ** GOTO lbl4
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException(this.res.getString("DOC_TEXT_RECORD_SIZE_EXCEEDED"));
        }
        textBytes = new byte[up];
        System.arraycopy(uBytes, 0, textBytes, 0, up);
        return textBytes;
    }

    private HeaderInfo readHeader(byte[] bytes) throws IOException {
        HeaderInfo header = new HeaderInfo();
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bis);
        dis.readByte();
        header.version = dis.readByte();
        dis.readShort();
        header.textLen = dis.readInt();
        if (header.textLen < 0) {
            throw new IOException(this.res.getString("DOC_TEXT_LENGTH_EXCEEDED"));
        }
        header.textRecordCount = dis.readShort() & 0xFFFF;
        header.textRecordSize = dis.readShort() & 0xFFFF;
        dis.readInt();
        return header;
    }

    private void dumpHeader(HeaderInfo header) {
        this.log("<DOC_INFO ");
        this.log("version=\"" + header.version + "\" ");
        this.log("text-length=\"" + header.textLen + "\" ");
        this.log("number-of-records=\"" + header.textRecordCount + "\" ");
        this.log("record-size=\"" + header.textRecordSize + "\" />");
    }

    private void log(String str) {
        Debug.log((int)4, (String)str);
    }

    static {
        COUNT_BITS = 3;
    }

    private class HeaderInfo {
        int textLen = 0;
        int textRecordCount = 0;
        int textRecordSize = 0;
        int version = 0;

        private HeaderInfo() {
        }
    }
}

