/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.minicalc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import jmc.CellAttributes;
import jmc.CellDescriptor;
import jmc.JMCException;
import jmc.Workbook;
import jmc.Worksheet;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.converter.palm.PalmDB;
import org.openoffice.xmerge.converter.palm.PalmDocument;
import org.openoffice.xmerge.converter.palm.Record;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.SpreadsheetDecoder;
import org.openoffice.xmerge.converter.xml.sxc.minicalc.MinicalcDataString;
import org.openoffice.xmerge.util.Debug;

final class MinicalcDecoder
extends SpreadsheetDecoder {
    private Workbook wb;
    private Worksheet ws;
    private CellDescriptor cell = null;
    private Format fmt = new Format();
    private String password = null;
    private int maxRows = 0;
    private int maxCols = 0;
    private String[] worksheetNames = null;

    MinicalcDecoder(String string, String[] stringArray, String string2) throws IOException {
        super(string, string2);
        this.password = string2;
        this.worksheetNames = stringArray;
        try {
            this.wb = new Workbook(string, string2);
        }
        catch (JMCException jMCException) {
            Debug.log((int)2, (String)("MinicalcDecoder.constructor:" + jMCException.getMessage()));
            throw new IOException(jMCException.getMessage());
        }
    }

    public void addDeviceContent(ConvertData convertData) throws IOException {
        try {
            int n = 0;
            Enumeration enumeration = convertData.getDocumentEnumeration();
            while (enumeration.hasMoreElements()) {
                PalmDocument palmDocument = (PalmDocument)enumeration.nextElement();
                PalmDB palmDB = palmDocument.getPdb();
                String string = this.worksheetNames[n];
                int n2 = palmDB.getRecordCount();
                String string2 = new String(String.valueOf(this.wb.getWorkbookName()) + "-" + string);
                this.ws = new Worksheet();
                this.ws.initWorksheet(string2, n2);
                int n3 = 0;
                while (n3 < n2) {
                    Record record = palmDB.getRecord(n3);
                    byte[] byArray = record.getBytes();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    int n4 = byArray.length;
                    this.ws.readNextRecord((InputStream)byteArrayInputStream, n4);
                    ++n3;
                }
                this.wb.addWorksheet(this.ws);
                ++n;
            }
        }
        catch (JMCException jMCException) {
            Debug.log((int)2, (String)("MinicalcDecoder.addPDB:" + jMCException.getMessage()));
            throw new IOException(jMCException.getMessage());
        }
    }

    private String convertToStarDate(String string) {
        MinicalcDataString minicalcDataString = new MinicalcDataString(string);
        String string2 = minicalcDataString.convertToStarDate();
        return string2;
    }

    private String convertToStarTime(String string) {
        MinicalcDataString minicalcDataString = new MinicalcDataString(string);
        String string2 = minicalcDataString.convertToStarTime();
        return string2;
    }

    private String currencyRemoveSign(String string) {
        MinicalcDataString minicalcDataString = new MinicalcDataString(string);
        String string2 = minicalcDataString.currencyRemoveSign();
        return string2;
    }

    public String getCellContents() {
        String string = null;
        if (this.cell != null) {
            string = this.cell.getCellContents();
            if (string == null) {
                return new String("");
            }
            if (string.startsWith("=")) {
                string = this.parseFormula(string);
            }
            if (this.fmt.getCategory().equalsIgnoreCase("currency")) {
                string = this.currencyRemoveSign(string);
            } else if (this.fmt.getCategory().equalsIgnoreCase("percentage")) {
                string = this.percentRemoveSign(string);
            } else if (this.fmt.getCategory().equalsIgnoreCase("date")) {
                string = this.convertToStarDate(string);
            } else if (this.fmt.getCategory().equalsIgnoreCase("time")) {
                string = this.convertToStarTime(string);
            }
        }
        return string;
    }

    public String getCellDataType() {
        String string;
        boolean bl = false;
        String string2 = string = this.getCellFormatType();
        String string3 = this.getCellContents();
        if (string3 != null) {
            MinicalcDataString minicalcDataString = new MinicalcDataString(string3);
            if (minicalcDataString.isFormula()) {
                Debug.log((int)1, (String)("   " + string3 + " Is a Function   Format = " + string + "\n"));
                return string2;
            }
            try {
                Double d = Double.valueOf(string3);
                bl = true;
                Debug.log((int)1, (String)("   " + string3 + " Is a Number   Format = " + string));
            }
            catch (NumberFormatException numberFormatException) {
                Debug.log((int)1, (String)("    " + string3 + " Not a Number   Format= " + string));
                bl = false;
            }
            string2 = bl ? (string.equals("currency") ? "currency" : (string.equals("percentage") ? "percentage" : "float")) : (minicalcDataString.isBoolean() ? "boolean" : (minicalcDataString.isDate() ? "date" : (minicalcDataString.isTime() ? "time" : (minicalcDataString.isPercent() ? "percentage" : (minicalcDataString.isCurrency() ? "currency" : "string")))));
        }
        Debug.log((int)1, (String)(" TYPE = " + string2 + "\n"));
        return string2;
    }

    public Format getCellFormat() {
        return new Format(this.fmt);
    }

    String getCellFormatType() {
        CellAttributes cellAttributes;
        String string = "float";
        if (this.cell != null && (cellAttributes = this.cell.getCellAttributes()) != null) {
            long l = cellAttributes.getFormat();
            long l2 = l & 0xF0L;
            long l3 = l & 0xFL;
            if (l2 == 0L) {
                String string2 = this.getCellContents();
                string = string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("true") ? "boolean" : "string";
            } else if (l2 == 16L) {
                string = "float";
            } else if (l2 == 48L) {
                string = "time";
            } else if (l2 == 32L) {
                string = "date";
            } else if (l2 == 64L) {
                string = "currency";
            } else if (l2 == 80L) {
                string = "percentage";
            }
        }
        return string;
    }

    public String getCellValue() {
        return null;
    }

    public int getColNumber() {
        int n = -1;
        if (this.cell != null) {
            n = this.cell.getColNumber();
        }
        return n;
    }

    public int getNumberOfColumns() {
        return this.maxCols;
    }

    public int getNumberOfRows() {
        return this.maxRows;
    }

    public int getNumberOfSheets() {
        return this.wb.getNumberOfSheets();
    }

    public int getRowNumber() {
        int n = -1;
        if (this.cell != null) {
            n = this.cell.getRowNumber();
        }
        return n;
    }

    public String getSheetName() {
        String string = this.ws.getName();
        return string;
    }

    public boolean goToNextCell() throws IOException {
        boolean bl = false;
        try {
            this.cell = this.ws.getNextCell();
            if (this.cell != null) {
                bl = true;
            }
            this.readCellFormat();
        }
        catch (JMCException jMCException) {
            Debug.log((int)2, (String)("MinicalcDecoder.goToNextCell:" + jMCException.getMessage()));
            throw new IOException(jMCException.getMessage());
        }
        return bl;
    }

    protected String parseFormula(String string) {
        string = string.replace(',', ';');
        string = string.replace('!', '.');
        return string;
    }

    private String percentRemoveSign(String string) {
        MinicalcDataString minicalcDataString = new MinicalcDataString(string);
        String string2 = minicalcDataString.percentRemoveSign();
        return string2;
    }

    private void readCellFormat() {
        this.fmt.clearFormatting();
        this.fmt.setCategory(this.getCellFormatType());
    }

    public void setWorksheet(int n) throws IOException {
        try {
            this.ws = this.wb.getWorksheet(n);
            this.ws.initAccess(this.password);
            this.maxRows = 0;
            this.maxCols = 0;
            while (this.goToNextCell()) {
                this.maxRows = Math.max(this.maxRows, this.cell.getRowNumber());
                this.maxCols = Math.max(this.maxCols, this.cell.getColNumber());
            }
            this.ws.initAccess(this.password);
        }
        catch (JMCException jMCException) {
            Debug.log((int)2, (String)("MinicalcDecoder.setWorksheet:" + jMCException.getMessage()));
            throw new IOException(jMCException.getMessage());
        }
    }
}

