/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.BarRenderer;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.ChartEntity;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;

public class VerticalBarRenderer
extends BarRenderer
implements CategoryItemRenderer {
    public VerticalBarRenderer() {
        this(null, null);
    }

    public VerticalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this(categoryToolTipGenerator, null);
    }

    public VerticalBarRenderer(CategoryURLGenerator categoryURLGenerator) {
        this(null, categoryURLGenerator);
    }

    public VerticalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, valueAxis, categoryDataset, chartRenderingInfo);
        this.calculateCategoryAndItemSpans(graphics2D, rectangle2D, categoryPlot, categoryDataset, rectangle2D.getWidth());
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D, Shape shape) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        Paint paint = marker.getOutlinePaint();
        Stroke stroke = marker.getOutlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawCategoryItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, Object object, int n2, Object object2) {
        Number number = categoryDataset.getValue(n, object);
        if (number != null) {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            double d = rectangle2D.getX() + rectangle2D.getWidth() * categoryPlot.getIntroGapPercent();
            int n3 = categoryDataset.getCategoryCount();
            int n4 = categoryDataset.getSeriesCount();
            if (n3 > 1) {
                d = d + (double)n2 * (this.categorySpan / (double)n3) + ((double)n2 * (this.categoryGapSpan / (double)(n3 - 1)) + (double)n * this.itemSpan / (double)(n3 * n4));
                if (n4 > 1) {
                    d += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
                }
            } else {
                d += (double)n * this.itemSpan / (double)(n3 * n4);
                if (n4 > 1) {
                    d += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
                }
            }
            double d2 = number.doubleValue();
            double d3 = 0.0;
            if (this.upperClip <= 0.0) {
                if (d2 >= this.upperClip) {
                    return;
                }
                d3 = this.upperClip;
                if (d2 <= this.lowerClip) {
                    d2 = this.lowerClip;
                }
            } else if (this.lowerClip <= 0.0) {
                if (d2 >= this.upperClip) {
                    d2 = this.upperClip;
                } else if (d2 <= this.lowerClip) {
                    d2 = this.lowerClip;
                }
            } else {
                if (d2 <= this.lowerClip) {
                    return;
                }
                d3 = this.lowerClip;
                if (d2 >= this.upperClip) {
                    d2 = this.upperClip;
                }
            }
            double d4 = valueAxis.translateValueToJava2D(d3, rectangle2D);
            double d5 = valueAxis.translateValueToJava2D(d2, rectangle2D);
            double d6 = Math.min(d5, d4);
            double d7 = this.itemWidth;
            double d8 = Math.abs(d5 - d4);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d, d6, d7, d8);
            Paint paint = null;
            paint = !this.getUseCategoriesPaint() ? categoryPlot.getSeriesPaint(n) : this.getCategoryPaint(n2);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (this.itemWidth > 3.0) {
                graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
                graphics2D.setPaint(categoryPlot.getSeriesOutlinePaint(n));
                graphics2D.draw(double_);
                if (categoryPlot.getLabelsVisible()) {
                    object6 = categoryPlot.getLabelFont();
                    graphics2D.setFont((Font)object6);
                    object5 = categoryPlot.getLabelPaint();
                    graphics2D.setPaint((Paint)object5);
                    object4 = categoryPlot.getLabelFormatter();
                    object3 = ((Format)object4).format(number);
                    FontMetrics fontMetrics = graphics2D.getFontMetrics();
                    int n5 = (int)((this.itemWidth - (double)fontMetrics.stringWidth((String)object3)) / 2.0);
                    graphics2D.drawString((String)object3, (int)(d + (double)n5), (int)(d6 - 5.0));
                }
            }
            if (this.getInfo() != null && (object6 = this.getInfo().getEntityCollection()) != null) {
                object5 = null;
                if (this.getToolTipGenerator() != null) {
                    object5 = this.getToolTipGenerator().generateToolTip(categoryDataset, n, object);
                }
                object4 = null;
                if (this.getURLGenerator() != null) {
                    object4 = this.getURLGenerator().generateURL(categoryDataset, n, object);
                }
                object3 = new CategoryItemEntity(double_, (String)object5, (String)object4, n, object, n2);
                object6.addEntity((ChartEntity)object3);
            }
        }
    }

    public boolean hasItemGaps() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset categoryDataset) {
        return categoryDataset.getSeriesCount();
    }
}

