/*************************************************************************
 *
 *  $RCSfile: ConceptGraph.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:02:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

import com.sun.xmlsearch.util.IndexAccessor;

class ConceptGraph {
  protected static final int CHILD = 0;
  protected BtreeDict _tmap;
  protected VectorBtree _edges;

  protected ConceptGraph() {}

  public ConceptGraph(String dbName) throws Exception {
    Schema schema = new Schema(new IndexAccessor(dbName), false);
    _edges = new VectorBtree(new VectorBtreeParameters(schema, "EDGE"));
    _tmap = new BtreeDict(new BtreeDictParameters(schema, "DICTIONARY"));
  }
  
  public void children(String concept) throws Exception {
    int id = _tmap.fetch(concept);
    if (id != 0) {
      System.out.println(id);
      VectorBtreeIterator iter = _edges.makeIterator();
      byte[] prefix = CompactEdgeFormat.makeVector();
      CompactEdgeFormat.setSrc(prefix, id);
      byte[] vec;
      for (vec = iter.first(prefix, 5); vec != null; vec = iter.next())
	System.out.println(_tmap.fetch(CompactEdgeFormat.getDst(vec)));
    }
    else
      System.out.println(concept + " not found");
  }
  
  public static void main(String[] args) {
    try {
      ConceptGraph cg = new ConceptGraph("/files/resources/lexicon/LIF_ONT");
      cg.children("!N/CHANGE");
      System.out.println("--------------------");
      cg.children("!N/DAMAGE");
      cg.children("!N/DAMAGE");
      cg.children("!N/DAMAGE");
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
