/*************************************************************************
 *
 *  $RCSfile: GeneratorHeap.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

final class GeneratorHeap {
    private static final int        InitSize = 128;
    private int                     _heapSize = 0;
    private ConceptGroupGenerator[] _heap;
    private int                     _size = InitSize;
    private int                     _free = 0;
  
    public GeneratorHeap() {
	_heap = new ConceptGroupGenerator[InitSize];
    }
  
    public void reset() {
	_free = 0;
    }
  
    public void addGenerator(ConceptGroupGenerator gen) {
	if (_free == _size) {
	    final ConceptGroupGenerator[] newArray =
		new ConceptGroupGenerator[_size *= 2];
	    System.arraycopy(_heap, 0, newArray, 0, _free);
	    _heap = newArray;
	}
	_heap[_free++] = gen;
    }
    
    private void buildHeap() {
	for (int i = _heapSize/2; i >= 0; i--) {
	    heapify(i);
	}
    }

    private void heapify(int root) {
	for (int smallest;;) {
	    final int right = (root + 1) << 1;
	    final int left = right - 1;
	    smallest = left<_heapSize &&
		_heap[left].position() < _heap[root].position()
		? left : root;
	    if (right<_heapSize &&
		_heap[right].position()<_heap[smallest].position()) {
		smallest = right;
	    }
	    if (smallest != root) {
		final ConceptGroupGenerator temp = _heap[smallest];
		_heap[smallest] = _heap[root];
		_heap[root] = temp;
		root = smallest;
	    }
	    else {
		break;
	    }
	}
    }

    public boolean start(RoleFiller[] array) throws Exception {
	if ((_heapSize = _free) > 0) {
	    for (int i = 0; i < _free; i++) {
		_heap[i].next();
	    }
	    buildHeap();
	    _heap[0].generateFillers(array);
	    return true;
	}
	else {
	    return false;
	}
    }

    public boolean start() throws Exception {
	if ((_heapSize = _free) > 0) {
	    for (int i = 0; i < _free; i++) {
		_heap[i].step();
	    }
	    buildHeap();
	    return true;
	}
	else {
	    return false;
	}
    }

    public boolean next(RoleFiller[] array) throws Exception {
	if (_heapSize > 0) {
	    if (!_heap[0].next()) { // no more
		if (_heapSize > 1) {
		    _heap[0] = _heap[--_heapSize];
		}
		else {
		    _heapSize = 0;
		    return false;
		}
	    }
	    heapify(0);
	    _heap[0].generateFillers(array);
	    return true;
	}
	else {
	    return false;
	}
    }
    
    public boolean next() throws Exception {
	if (_heapSize > 0) {
	    if (!_heap[0].step()) { // no more
		if (_heapSize > 1) {
		    _heap[0] = _heap[--_heapSize];
		}
		else {
		    _heapSize = 0;
		    return false;
		}
	    }
	    heapify(0);
	    return true;
	}
	else {
	    return false;
	}
    }

    public int position() {
	return _heap[0].position();
    }
    
    public int getConcept() throws Exception {
	return _heap[0].getConcept();
    }
}
