/*************************************************************************
 *
 *  $RCSfile: c_bridge.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 16:23:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef __C_BRIDGE_HXX__
#define __C_BRIDGE_HXX__

#include <list>
#include <malloc.h>

#ifndef _UNO_CUNO_H_
#include <uno/cuno.h>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _OSL_INTERLOCK_H_
#include <osl/interlck.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _UNO_MAPPING_H_
#include <uno/mapping.h>
#endif
#ifndef _UNO_ENVIRONMENT_H_
#include <uno/environment.h>
#endif
#ifndef _UNO_DISPATCHER_H_
#include <uno/dispatcher.h>
#endif
#ifndef _TYPELIB_TYPEDESCRIPTION_H_
#include <typelib/typedescription.h>
#endif

#if OSL_DEBUG_LEVEL > 1
#define __TRACE(x) OSL_TRACE(x)
#else
#define __TRACE(x)
#endif


// xxx todo: generate XInterface by cunomaker tool
extern "C"
{

struct _com_sun_star_uno_XInterface_ftab;
typedef struct _com_sun_star_uno_XInterface_ftab * com_sun_star_uno_XInterface;

typedef struct _com_sun_star_uno_XInterface_ftab
{
    cuno_ErrorCode (SAL_CALL * queryInterface)(
		com_sun_star_uno_XInterface *, uno_Any *,
		com_sun_star_uno_XInterface **, typelib_TypeDescriptionReference* );
    cuno_ErrorCode (SAL_CALL * acquire)(
		com_sun_star_uno_XInterface * );
    cuno_ErrorCode (SAL_CALL * release)(
		com_sun_star_uno_XInterface * );
} com_sun_star_uno_XInterface_ftab;

} // extern "C"

namespace c_uno
{

//==================================================================================================
void SAL_CALL c_release(
	void * pInterface ) SAL_THROW_EXTERN_C();

// UNO -> C
//==================================================================================================
extern "C" void SAL_CALL unoInterfaceProxy_dispatch(
	uno_Interface * pUnoI, const typelib_TypeDescription * pMemberDescr,
	void * pReturn, void * pArgs[], uno_Any ** ppException ) SAL_THROW_EXTERN_C();
//==================================================================================================
extern "C" cuno_ErrorCode SAL_CALL call_c_function(
	void * fptr, void * pParams, sal_Int32 nParams ) SAL_THROW_EXTERN_C();

// C -> UNO
//==================================================================================================
extern "C" cuno_ErrorCode SAL_CALL proxy_ftable_call(
	sal_Int32 nFtableCall, void ** pCallStack ) SAL_THROW_EXTERN_C();

//##################################################################################################

struct Bridge;
//==================================================================================================
struct Mapping : public uno_Mapping
{
	Bridge * pBridge;
	Mapping( Bridge * pBridge, uno_MapInterfaceFunc fpMap ) SAL_THROW( () );
};
//==== holding environments and mappings ===========================================================
struct Bridge
{
	oslInterlockedCount			nRef;

	uno_ExtEnvironment *		pCEnv;
	uno_ExtEnvironment *		pUnoEnv;

	Mapping						aC2Uno;
	Mapping						aUno2C;

	bool						bExportC2Uno;

	void SAL_CALL acquire() SAL_THROW( () );
	void SAL_CALL release() SAL_THROW( () );

	Bridge(
		uno_ExtEnvironment * pCEnv_, uno_ExtEnvironment * pUnoEnv_,
		bool bExportC2Uno_ ) SAL_THROW( () );
    ~Bridge() SAL_THROW( () );
};

//==== a cpp proxy wrapping an uno interface =======================================================
struct cInterfaceProxy
{
	struct _com_sun_star_uno_XInterface_ftab * ftab;

	oslInterlockedCount					nRef;
	Bridge *							pBridge;

	// mapping information
	uno_Interface *						pUnoI; // wrapped interface
	typelib_InterfaceTypeDescription *	pTypeDescr;
	::rtl::OUString						oid;

	void SAL_CALL acquireProxy() SAL_THROW( () );
	void SAL_CALL releaseProxy() SAL_THROW( () );

	// ctor
	cInterfaceProxy(
		Bridge * pBridge_,
		uno_Interface * pUnoI_,
		typelib_InterfaceTypeDescription * pTypeDescr_,
		::rtl::OUString const & rOId_ ) SAL_THROW( () );
};

//==== a uno proxy wrapping a cpp interface ========================================================
struct unoInterfaceProxy : public uno_Interface
{
	oslInterlockedCount					nRef;
	Bridge *							pBridge;

	// mapping information
	com_sun_star_uno_XInterface *		pCI; // wrapped interface
	typelib_InterfaceTypeDescription *	pTypeDescr;
	::rtl::OUString						oid;

	// ctor
	unoInterfaceProxy(
		Bridge * pBridge_,
		com_sun_star_uno_XInterface * pCI_,
		typelib_InterfaceTypeDescription * pTypeDescr_,
		::rtl::OUString const & rOId_ ) SAL_THROW( () );
};

//==================================================================================================
class Ftables
{
	typedef ::std::list< void * > t_pSpacesList;

	::osl::Mutex _aMutex;
	t_pSpacesList _aSpaces;

	sal_uInt32 _nCurrent;
	void * _pCurrent;

public:
	struct _com_sun_star_uno_XInterface_ftab * getFtable( sal_uInt32 nSize ) SAL_THROW( () );

	inline Ftables( sal_uInt32 nSize = 256 ) SAL_THROW( () )
		: _nCurrent( 0 )
		, _pCurrent( 0 )
		{ getFtable( nSize ); }
	~Ftables() SAL_THROW( () );
};

} // namespace c_uno

#endif
