/*************************************************************************
 *
 *  $RCSfile: rcpnitem.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: er $ $Date: 2001/05/13 03:18:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _RCPNITEM_HXX
#define _RCPNITEM_HXX "$Revision: 1.2 $"

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _OUTITEMS_HXX
#include <outitems.hxx>
#endif

namespace chaos {

/*========================================================================
 *
 * CntOutMsgProtocolType.
 *
 * [Description]
 *
 * Describes the protocol a message uses for its way out.
 *
 * NOTE:
 *   Wenn neue Protokolle hinzugefuegt werden, muessen die Methoden
 *   CntRecipientInfo::ToProtocolString und CntRecipientInfo::ToProtocolType
 *   modifiziert werden.
 *
 *   Bei Aenderung des Startwerts, Umsortierung oder Erweiterung muss
 *   'sfx2\source\expchaos\cntpg.cxx\CntStdProtSendTabPage::Reset()'
 *   angepasst werden.
 *
 *======================================================================*/
enum CntOutMsgProtocolType
{
	CNT_OUTMSG_PROTOCOL_SMTP = 0,
	CNT_OUTMSG_PROTOCOL_VIM,
	CNT_OUTMSG_PROTOCOL_MAPI,
	CNT_OUTMSG_PROTOCOL_MBOX,
	CNT_OUTMSG_PROTOCOL_NNTP,
	CNT_OUTMSG_PROTOCOL_COPY,

	CNT_OUTMSG_PROTOCOL_END
};

/*========================================================================
 *
 * CntOutMsgRoleType.
 *
 * [Description]
 *
 * Describes the role of the recipient.
 *
 *======================================================================*/
enum CntOutMsgRoleType
{
	CNT_OUTMSG_ROLE_TO,
	CNT_OUTMSG_ROLE_CC,
	CNT_OUTMSG_ROLE_BCC,
	CNT_OUTMSG_ROLE_NEWSGROUP,
	CNT_OUTMSG_ROLE_REPLY_TO,
	CNT_OUTMSG_ROLE_FOLLOWUP_TO
};

/*========================================================================
 *
 * CntRecipientInfo
 *
 * [Description]
 *
 * Contains description of a recipient of a message together with the state
 * information concerning this recipient (e.g. locally delivered, ...)
 *
 *======================================================================*/
class CntRecipientInfo
{
    String                 _aToRecipient;
	String                 _aCcRecipient;
	String                 _aBccRecipient;
	String                 _aNewsRecipient;
	String                 _aServer;
	String                 _sProtocolError;
	CntOutMsgProtocolType  _eProtocol;
	CntOutMsgInternalState _eState;
	USHORT                 _nSendTries;
	USHORT                 _nProtocolError;
	String                 _aUsername;
	String                 _aPassword;
	String                 _aVIMPOPath;

public:
	CntRecipientInfo (void)
		: _eProtocol      (CNT_OUTMSG_PROTOCOL_SMTP),
		  _eState         (CNTOUT_ISTATE_WRITTEN),
		  _nSendTries     (0),
		  _nProtocolError (0)
	{}

	CntRecipientInfo (
		const String&          aToRecipient,
		const String&          aCcRecipient,
		const String&          aBccRecipient,
		const String&          aNewsRecipient,
		const String&          aServer,
		const String&          aProcolErrorStr,
		CntOutMsgProtocolType  eProtocol,
		CntOutMsgInternalState eState,
		USHORT                 nProtocolError,
		USHORT                 nSendRetries,
		const String&          aUsername,
		const String&          aPassword,
		const String&          aVIMPOPath);

	BOOL operator== (const CntRecipientInfo &rOther) const;
	BOOL operator!= (const CntRecipientInfo &rOther) const
	{ return !operator==(rOther); }

	void Load  (SvStream& rStream, USHORT nVersion);
	void Store (SvStream& rStream, USHORT nVersion) const;

	CntOutMsgProtocolType  GetProtocol() const { return _eProtocol; }
	CntOutMsgInternalState GetState() const { return _eState; }

	const String& GetToRecipient() const { return _aToRecipient; }
	const String& GetCcRecipient() const { return _aCcRecipient; }
	const String& GetBccRecipient() const { return _aBccRecipient; }
	const String& GetNewsRecipient() const { return _aNewsRecipient; }

	const String& GetServer() const { return _aServer; }
	const String& GetUsername() const { return _aUsername; }
	const String& GetPassword() const { return _aPassword; }

	USHORT        GetSendTries() const { return _nSendTries; }
	INT16         GetProtocolError() const { return _nProtocolError; }
	const String& GetProtocolErrorStr() const { return _sProtocolError; }
	const String& GetVIMPOPath() const { return _aVIMPOPath; }

	void SetState (CntOutMsgInternalState eState) { _eState = eState; }
	void SetSendTries (USHORT nSendTries) { _nSendTries = nSendTries; }
	void SetProtocolError (USHORT nError) { _nProtocolError = nError; }
	void SetProtocolErrorStr (const String& rStr) { _sProtocolError = rStr; }

	void ResetState (void);

	static String ToProtocolString (const CntOutMsgProtocolType eType);
	static CntOutMsgProtocolType ToProtocolType (const String& rType);

	void          IncSendTries (void) { _nSendTries++; }
};

/*
 * ResetState (i.e. prepare for resend).
 */
inline void CntRecipientInfo::ResetState (void)
{
	_eState = CNTOUT_ISTATE_WRITTEN;
	_nSendTries = 0;
	_nProtocolError = 0;
	_sProtocolError.Erase();
}

/*========================================================================
 *
 * CntRecipientInfoItem.
 * (Intended for CntOutTrayNode internal usage).
 *
 *======================================================================*/
class CntRecipientInfoItem : public SfxPoolItem
{
	CntRecipientInfo *m_pInfo;

public:
	TYPEINFO();

	CntRecipientInfoItem (USHORT nWhich = 0, CntRecipientInfo *pInfo = NULL)
		: SfxPoolItem (nWhich), m_pInfo (pInfo)
	{}
	CntRecipientInfoItem (const CntRecipientInfoItem &rOther)
		: SfxPoolItem (rOther.Which()), m_pInfo (rOther.m_pInfo)
	{}
	virtual ~CntRecipientInfoItem (void);

	CntRecipientInfo* GetValue (void) const { return m_pInfo; }

	virtual int operator== (const SfxPoolItem& rItem) const;
	virtual SfxPoolItem* Clone (SfxItemPool *pPool = NULL) const;
};

/*========================================================================
 *
 * CntRecipientListItem.
 *
 * [Description]
 *
 * Collects <CntRecipientInfo>'s to a complete description
 * of all the recipients of a message.
 *
 *======================================================================*/
SV_DECL_PTRARR_DEL (CntRecipientInfoArr, CntRecipientInfo*, 1, 3)

class CntRecipientListItem : public SfxPoolItem
{
	String              _aPresentation;
	CntRecipientInfoArr _aInfos;

	CntRecipientListItem (USHORT nWhich, SvStream &, USHORT nVersion);

public:
	TYPEINFO();

	CntRecipientListItem (USHORT nWhich = 0);
	CntRecipientListItem (const CntRecipientListItem& rOther);
	virtual ~CntRecipientListItem (void);

	virtual int 			operator==( const SfxPoolItem& ) const;
	virtual int				Compare( const SfxPoolItem &rWith ) const;
	virtual SfxPoolItem*    Clone( SfxItemPool *pPool = 0 ) const;
	virtual SfxPoolItem*	Create(SvStream &, USHORT nItemVersion) const;
	virtual SvStream&		Store(SvStream &, USHORT nItemVersion ) const;
	virtual USHORT			GetVersion( USHORT nFileFormatVersion ) const;

	USHORT					Count() const { return _aInfos.Count(); }
	const CntRecipientInfo* operator[] (USHORT n) const { return _aInfos[n]; }
	CntRecipientInfo*       operator[] (USHORT n) { return _aInfos[n]; }

	void					Append (const CntRecipientInfo* pInfo);
	CntRecipientInfo *		Find (CntOutMsgProtocolType eProtocol,
								  const String & rUsername,
								  const String & rPassword,
								  const String & rServer,
								  const String & rVIMPOPath);
	void					Delete (CntRecipientInfo* pInfo);

	String					GetRecipientString() const;
	String					GetToString() const;
	String					GetCcString() const;
	String					GetBccString() const;
	String					GetNewsgroupString() const;
	SfxItemPresentation 	GetPresentation( SfxItemPresentation,
											 SfxMapUnit,
											 SfxMapUnit,
											 XubString &rText,
                                             const IntlWrapper * = 0 )
		const;

	BOOL IsCompletelySent (void) const;
	BOOL IsCompletelyProcessed (void) const;
	BOOL IsPartiallySent (void) const;

	void CleanUpAndPromoteAddresses_Impl (void);
	void ResetState (void);

	virtual	BOOL PutValue  ( const com::sun::star::uno::Any& rVal,
						     BYTE nMemberId = 0 );
	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;
};

}


#endif /* !_RCPNITEM_HXX */

