/*************************************************************************
 *
 *  $RCSfile: adrcont.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ADDRCONT_HXX
#define ADDRCONT_HXX

#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HXX_
#include <smart/com/sun/star/frame/XFrameActionListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HXX_
#include <smart/com/sun/star/frame/XComponentLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAME_HXX_
#include <smart/com/sun/star/frame/XFrame.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HXX_
#include <smart/com/sun/star/frame/FrameActionEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTION_HXX_
#include <smart/com/sun/star/frame/FrameAction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWDESCRIPTOR_HXX_
#include <smart/com/sun/star/awt/WindowDescriptor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_INVALIDATESTYLE_HXX_
#include <smart/com/sun/star/awt/InvalidateStyle.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XTOOLKIT_HXX_
#include <smart/com/sun/star/awt/XToolkit.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XWINDOWPEER_HXX_
#include <smart/com/sun/star/awt/XWindowPeer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWCLASS_HXX_
#include <smart/com/sun/star/awt/WindowClass.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XSYSTEMDEPENDENTWINDOWPEER_HXX_
#include <smart/com/sun/star/awt/XSystemDependentWindowPeer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWATTRIBUTE_HXX_
#include <smart/com/sun/star/awt/WindowAttribute.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XPOINTER_HXX_
#include <smart/com/sun/star/awt/XPointer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_SYSTEMPOINTER_HXX_
#include <smart/com/sun/star/awt/SystemPointer.hxx>
#endif

#ifndef _SV_SPLITWIN_HXX
#include <vcl/splitwin.hxx>
#endif


#ifndef _SV_TIMER_HXX //autogen wg. Timer
#include <vcl/timer.hxx>
#endif

#ifndef _ADR_DATMAN_HXX
#include "datman.hxx"
#endif

#define TOP_WINDOW							1
#define BOTTOM_WINDOW						2


class AdrWindowContainer: public DockingWindow
{
	private:
		Window*					pChild;
		
	protected:
		virtual void			Resize();
		
	public:
		AdrWindowContainer( Window* pParent,WinBits nStyle = WB_NOBORDER);
		AdrWindowContainer( Window* pParent,Window* pChild, WinBits nStyle = WB_NOBORDER);
		~AdrWindowContainer();

		Window*					GetChild(){return pChild;}
		void					SetChild(Window* pWin);
};


class AdrBookContainer: public SplitWindow
{
	private:

		XFrameRef				xTopFrameRef;
		XFrameRef				xBottomFrameRef;

		XWindowRef				xTopPeerRef;
		XWindowRef				xBottomPeerRef;
		BOOL					bFirstTime;
		Point					aOldPoint;

		DockingWindow*			pTopWin;
		DockingWindow*			pBottomWin;
		AdrDataManagerHdl		ppDatMan;
		Timer					aTimer;
		
		DECL_LINK( SplitHdl, Timer*);
		
	protected:

		virtual void			Split();
		virtual void			SetPosSizePixel( long nX, long nY,long nWidth, long nHeight,USHORT nFlags);

		void					CreateTopWin();
		void					CreateBottomWin();
		XWindowPeer*			GetTopComponentInterface( BOOL bCreate = TRUE );
		void					SetTopComponentInterface( XWindowPeer* pIFace );

		XWindowPeer*			GetBottomComponentInterface( BOOL bCreate = TRUE );
		void					SetBottomComponentInterface( XWindowPeer* pIFace );

		VCLXWindow* 			GetTopWindowPeer();
		void					SetTopWindowPeer( VCLXWindow* pPeer );

		VCLXWindow* 			GetBottomWindowPeer();
		void					SetBottomWindowPeer( VCLXWindow* pPeer );

	public:
		
		AdrBookContainer(Window* pParent,AdrDataManagerHdl, WinBits nStyle = WB_NOBORDER );
		~AdrBookContainer();

		DockingWindow*			GetTopWin() {return pTopWin;}
		DockingWindow*			GetBottomWin() {return pBottomWin;}


		void					createTopFrame(const UString & rURL );

		void					createBottomFrame(const UString & rURL );

		void					createTopFrame(Window* pWin);

		void					createBottomFrame(Window* pWin);

};

#endif
