/*************************************************************************
 *
 *  $RCSfile: toolbar.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ADR_TOOLBAR_HXX
#define _ADR_TOOLBAR_HXX

#ifndef _SMART_COM_SUN_STAR_FRAME_XCONTROLLER_HXX_
#include <smart/com/sun/star/frame/XController.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HXX_
#include <smart/com/sun/star/frame/XFrameActionListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HXX_
#include <smart/com/sun/star/frame/XComponentLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAME_HXX_
#include <smart/com/sun/star/frame/XFrame.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HXX_
#include <smart/com/sun/star/frame/FrameActionEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTION_HXX_
#include <smart/com/sun/star/frame/FrameAction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWDESCRIPTOR_HXX_
#include <smart/com/sun/star/awt/WindowDescriptor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_INVALIDATESTYLE_HXX_
#include <smart/com/sun/star/awt/InvalidateStyle.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XTOOLKIT_HXX_
#include <smart/com/sun/star/awt/XToolkit.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XWINDOWPEER_HXX_
#include <smart/com/sun/star/awt/XWindowPeer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWCLASS_HXX_
#include <smart/com/sun/star/awt/WindowClass.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XSYSTEMDEPENDENTWINDOWPEER_HXX_
#include <smart/com/sun/star/awt/XSystemDependentWindowPeer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWATTRIBUTE_HXX_
#include <smart/com/sun/star/awt/WindowAttribute.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XPOINTER_HXX_
#include <smart/com/sun/star/awt/XPointer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_SYSTEMPOINTER_HXX_
#include <smart/com/sun/star/awt/SystemPointer.hxx>
#endif



#ifndef _SV_TOOLBOX_HXX //autogen wg. ToolBox
#include <vcl/toolbox.hxx>
#endif

#ifndef _SV_LSTBOX_HXX //autogen wg. ListBox
#include <vcl/lstbox.hxx>
#endif

#ifndef _SV_EDIT_HXX //autogen wg. Edit
#include <vcl/edit.hxx>
#endif

#ifndef _SV_FIXED_HXX //autogen wg. FixedText
#include <vcl/fixed.hxx>
#endif

#ifndef _SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif

#ifndef _SV_TIMER_HXX //autogen wg. Timer
#include <vcl/timer.hxx>
#endif

#ifndef _SMART_COM_SUN_STAR_FRAME_XSTATUSLISTENER_HXX_
#include <smart/com/sun/star/frame/XStatusListener.hxx>
#endif


class AdrToolBar;

class AdrToolBarListener:	public XStatusListener,
							public UsrObject
{
private:

	USHORT			nIndex;
	UString			aCommand;

protected:

	AdrToolBar		*pToolBar;

public:

	AdrToolBarListener(AdrToolBar *pTB,UString aStr,USHORT nId);

	UString			GetCommand();
	void			SetCommand(const UString& aStr);

	USHORT			GetIndex();
	void			SetIndex(USHORT nIndex);
	// XInterface
	virtual void	acquire()							{ UsrObject::acquire(); }
	virtual void	release()							{ UsrObject::release(); }
	virtual BOOL 	queryInterface( UsrUik aUIK, XInterfaceRef& );
	virtual void*	getImplementation(Reflection *p) 	{ return NULL; }

	// XEventListener
	// we do not hold References to dispatches, so there is nothing to do on disposal
	virtual void 	disposing(const EventObject& Source)
											THROWS( (UsrSystemException) ) {};

	// XStatusListener
	virtual void	statusChanged(const FeatureStateEvent& Event)
											THROWS( (UsrSystemException) );

};

class AdrTBListBoxListener:	public AdrToolBarListener
{
public:

	AdrTBListBoxListener(AdrToolBar *pTB,UString aStr,USHORT nId);

	virtual void	statusChanged(const FeatureStateEvent& Event)
											THROWS( (UsrSystemException) );

};

class AdrTBEditListener: public	AdrToolBarListener
{
public:

	AdrTBEditListener(AdrToolBar *pTB,UString aStr,USHORT nId);

	virtual void	statusChanged(const FeatureStateEvent& Event)
											THROWS( (UsrSystemException) );

};

class AdrTBQueryMenuListener:	public AdrToolBarListener
{
public:

	AdrTBQueryMenuListener(AdrToolBar *pTB,UString aStr,USHORT nId);

	virtual void	statusChanged(const FeatureStateEvent& Event)
											THROWS( (UsrSystemException) );

};


typedef AdrToolBarListener* AdrToolBarListenerPtr;
SV_DECL_PTRARR_DEL( AdrToolBarListenerArr, AdrToolBarListenerPtr, 4, 4 );

class AdrToolBar:	public ToolBox
{
	private:

		AdrToolBarListenerArr	aListenerArr;
		XControllerRef			xController;
		Timer					aTimer;
		Timer					aMenuTimer;

		FixedText				aFtSource;
		ListBox					aLBSource;
		FixedText				aFtQuery;
		Edit					aEdQuery;
		PopupMenu				aPopupMenu;
		USHORT					nMenuId;
		USHORT					nSelMenuItem;
		UString					aQueryField;
		DECL_LINK( SelHdl, ListBox* );
		DECL_LINK( SendSelHdl, Timer* );
		DECL_LINK( MenuHdl, Timer* );

	protected:

		void					InitListener();
		virtual void			Select();
		virtual void			Click();
		void					SendDispatch(USHORT nId, const Sequence< PropertyValue >& rArgs);
		long					PreNotify( NotifyEvent& rNEvt );


	public:
		
		AdrToolBar(Window* pParent, WinBits nStyle = 0 );
		~AdrToolBar();

		void	SetXController(const XControllerRef&);

		void	ClearSourceList();
		void	UpdateSourceList(BOOL bFlag=TRUE);
		void	EnableSourceList(BOOL bFlag=TRUE);
		void	InsertSourceEntry(const XubString&,USHORT nPos=LISTBOX_APPEND );
		void	SelectSourceEntry(const XubString& );

		void	EnableQuery(BOOL bFlag=TRUE);
		void	SetQueryString(const XubString& );

		void	ClearFilterMenu();
		USHORT	InsertFilterItem(const XubString& );
		void	SelectFilterItem(USHORT	nId);
};




#endif
