/*************************************************************************
 *
 *  $RCSfile: acvload.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _COM_SUN_STAR_FRAME_XFRAMELOADER_HPP_
#include <com/sun/star/frame/XFrameLoader.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XLOADEVENTLISTENER_HPP_
#include <com/sun/star/frame/XLoadEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

// helper classes and functions
#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase2.hxx>
#endif
#ifndef _UNO_DISPATCHER_H_
#include <uno/dispatcher.h>
#endif
#ifndef _UNO_MAPPING_HXX_
#include <uno/mapping.hxx>
#endif
#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif

// namespaces
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::awt;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::registry;
using namespace ::rtl;
using namespace ::cppu;

#include "addrconv.hxx"

class AddressBookConverterLoader : public WeakImplHelper2< XFrameLoader, XServiceInfo >
{
	Reference < XMultiServiceFactory > m_xFact;
public:
							AddressBookConverterLoader( const Reference < XMultiServiceFactory >& rFact )
								: m_xFact( rFact )
							{}
	// XLoader
    virtual void SAL_CALL 				  load( const Reference< XFrame >& aFrame, 
												const OUString& aURL, 
												const Sequence< PropertyValue >& aArgs, 
												const Reference< XLoadEventListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL 				  cancel() throw(RuntimeException);

	// XServiceInfo
    virtual OUString SAL_CALL			  getImplementationName() throw(RuntimeException);
    virtual sal_Bool SAL_CALL			  supportsService( const OUString& ServiceName ) throw(RuntimeException);
    virtual Sequence< OUString > SAL_CALL getSupportedServiceNames() throw(RuntimeException);

	// static Helper functions
    static Sequence< OUString > 		  getSupportedServiceNames_Static();
	static OUString 					  getImplementationName_Static()
										  {
											return L"com.sun.star.extensions.AddressBookConverter";
										  }
};

OUString SAL_CALL AddressBookConverterLoader::getImplementationName() throw(RuntimeException)
{
	return getImplementationName_Static();
}

sal_Bool SAL_CALL AddressBookConverterLoader::supportsService( const OUString& ServiceName ) throw(RuntimeException)
{
	Sequence< OUString > aSNL = getSupportedServiceNames();
	const OUString * pArray = aSNL.getConstArray();
	for( sal_Int32 i = 0; i < aSNL.getLength(); i++ )
		if( pArray[i] == ServiceName )
			return true;
	return false;
}

Sequence< OUString > SAL_CALL AddressBookConverterLoader::getSupportedServiceNames() throw(RuntimeException)
{
	return getSupportedServiceNames_Static();
}

Sequence< OUString > AddressBookConverterLoader::getSupportedServiceNames_Static()
{
	Sequence< OUString > aSNS( 1 );
    aSNS.getArray()[0] = L"com.sun.star.frame.FrameLoader";
	return aSNS;
}

void SAL_CALL AddressBookConverterLoader::load( const Reference< XFrame >& aFrame, const OUString& aURL, const Sequence< PropertyValue >& aArgs, const Reference< XLoadEventListener >& xListener ) throw(::com::sun::star::uno::RuntimeException)
{
	AddressBookConverter addrBookConverter;
	addrBookConverter.Convert();
	
	if ( xListener.is() )
		xListener->loadFinished( this );
}

void SAL_CALL AddressBookConverterLoader::cancel() throw(RuntimeException)
{
}

Reference <XInterface> AddressBookConverterLoader_CreateInstance(  const Reference <XMultiServiceFactory >& xMgr )
{
	return (XInterface *)*(new AddressBookConverterLoader( xMgr ) );
}

//==================================================================================================
extern "C" sal_Bool SAL_CALL writeComponentInfo( uno_Interface * pXUnoKey )
{
	if (pXUnoKey)
	{
		Mapping aUno2Current( UNO_LB_UNO, CPPU_CURRENT_LANGUAGE_BINDING_NAME );
		if (aUno2Current.is())
		{
			XRegistryKey * pKey = (XRegistryKey *)aUno2Current.mapInterface(
				pXUnoKey, ::getCppuType( (const Reference< XRegistryKey > *)0 ) );
			if (pKey)
			{
				Reference< XRegistryKey > xKey( pKey );
				pKey->release();

				try
				{
					OUString aImpl ( L"/" );
					aImpl += AddressBookConverterLoader::getImplementationName_Static();
					OUString aTempStr = aImpl;
					aTempStr += OUString ( L"/UNO/SERVICES" ); 
					Reference< XRegistryKey > xNewKey = xKey->createKey( aTempStr );

					const Sequence< OUString > & rSNL = AddressBookConverterLoader::getSupportedServiceNames_Static();
					const OUString * pArray = rSNL.getConstArray();
					for ( sal_Int32 nPos = rSNL.getLength(); nPos--; )
						xNewKey->createKey( pArray[nPos] );

					aTempStr = aImpl;
					aTempStr += OUString ( L"/UNO/Loader" );
					xNewKey = xKey->createKey( aTempStr );
					aTempStr = aImpl;
					aTempStr += OUString ( L"/Loader" ); 
					Reference < XRegistryKey > xLoaderKey = xKey->createKey( aTempStr );
					xNewKey = xLoaderKey->createKey( L"Pattern" );
					xNewKey->setAsciiValue( L".component:AddressBookConverter" ); /**/

					return sal_True;
				}
				catch (InvalidRegistryException &)
				{
				}
			}
		}
	}
	return sal_False;
}


//==================================================================================================
extern "C" uno_Interface* SAL_CALL createComponentFactory( const sal_Unicode * pImplementationName,
									    				   uno_Interface * pXUnoSMgr,
									    				   uno_Interface * pXUnoKey )
{
	uno_Interface * pRet = 0;

	Mapping aUno2Current( UNO_LB_UNO, CPPU_CURRENT_LANGUAGE_BINDING_NAME );
	Mapping aCurrent2Uno( CPPU_CURRENT_LANGUAGE_BINDING_NAME, UNO_LB_UNO );

	if (aUno2Current.is() && aCurrent2Uno.is())
	{
		Reference< XMultiServiceFactory > xMgr;
		if (pXUnoSMgr)
		{
			XMultiServiceFactory * pSF = (XMultiServiceFactory *)aUno2Current.mapInterface(
				pXUnoSMgr, ::getCppuType( (const Reference< XMultiServiceFactory > *)0 ) );
			if (pSF)
			{
				xMgr = pSF;
				pSF->release();
			}
		}

		if (AddressBookConverterLoader::getImplementationName_Static().equals( pImplementationName ))
		{
			Reference< XSingleServiceFactory > xFactory( createSingleFactory(
				xMgr, pImplementationName,
				AddressBookConverterLoader_CreateInstance,
				AddressBookConverterLoader::getSupportedServiceNames_Static() ) );

			if (xFactory.is())
			{
				pRet = (uno_Interface *)aCurrent2Uno.mapInterface(
					xFactory.get(), ::getCppuType( (const Reference<XSingleServiceFactory > *)0 ) );
			}
		}
	}
	return pRet;
}
