/*************************************************************************
 *
 *  $RCSfile: os2mgr.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define INCL_PM
#define INCL_WIN
#define INCL_DOS
#define INCL_DOSERRORS
#include <tools/svpm.h>
#include <vcl/svapp.hxx>

#include <plugin/impl.hxx>

//--------------------------------------------------------------------------------------------------


static void addPluginDescriptions(PCSZ pszPath, Sequence<PluginDescription> & rDescriptions)
{
    CHAR   szBuffer[CCHMAXPATHCOMP];
    USHORT nStrLen;

    // copy plugin path to buffer
    strcpy(szBuffer, pszPath);
    nStrLen = strlen(szBuffer);

    // append file mask to buffer
    strcpy(szBuffer + nStrLen++, "\\NP*.DLL");

    HDIR  hDir = HDIR_CREATE;
    ULONG ulEntries = 1;
    FILEFINDBUF3 ffBuffer;

    // find all plugin dlls
    for(APIRET rc = DosFindFirst(szBuffer, &hDir, FILE_NORMAL, &ffBuffer, sizeof(ffBuffer), &ulEntries, FIL_STANDARD);
        rc == NO_ERROR;
        rc = DosFindNext(hDir, &ffBuffer, sizeof(ffBuffer), &ulEntries))
    {
		// Skip Null-Plugin. DLL cannot be unloaded correctly!
        // It registers as handler for *.* - This is useless for us.
        if ( stricmp( ffBuffer.achName, "NPNULOS2.DLL" ) == 0 )
			continue;

        HMODULE hModule;
        CHAR    szLoadError[CCHMAXPATHCOMP];
		
        // append correct module name to plugin path
        strcpy(szBuffer + nStrLen, ffBuffer.achName);

        // try to load module - if already loaded, this increases the refcount
        if(NO_ERROR != DosLoadModule(szLoadError, sizeof(szLoadError), szBuffer, &hModule))
            continue;

        PVOID   pResource1;
        PVOID   pResource2;
        UString aComment;
        UString aName(StringToOUString(szBuffer, CHARSET_SYSTEM));

        // retrieve product name
        if(NO_ERROR == DosGetResource(hModule, RT_RCDATA, NP_INFO_ProductName, &pResource1))
        {
            aComment.operator=(StringToOUString((PCSZ) pResource1, CHARSET_SYSTEM));
            DosFreeResource(pResource1);
        }

        if(NO_ERROR == DosGetResource(hModule, RT_RCDATA, NP_INFO_MIMEType, &pResource1))
        {
            if(NO_ERROR == DosGetResource(hModule, RT_RCDATA, NP_INFO_FileExtents, &pResource2))
            {

                String aExtensions((PSZ) pResource2);
                String aMIME((PSZ) pResource1);

                USHORT nToken = aExtensions.GetTokenCount( '|' );
                USHORT nMToken = aMIME.GetTokenCount( '|' );
                if (nToken != nMToken)
                {
                    DBG_ERROR( "### mime type count differ to extension count!" );
                    nToken = (nToken > nMToken ? nMToken : nToken);
                }

                UINT32 nStart = rDescriptions.getLen();
                rDescriptions.realloc( nStart + nToken );
                PluginDescription* pDescriptions = rDescriptions.getArray();

                // for every extension and MIME Type
                for ( ; nToken--; )
                {
                    USHORT nIndex;
                    String aExts = aExtensions.GetToken( nToken, '|' );

                    // prepare extensions for office
                    aExts.Insert("*.", 0);

                    // insert "*." after every delimiter
                    nIndex = 0;
                    while((nIndex = aExts.SearchAndReplace( ";", ";*.", nIndex + 3)) != STRING_NOTFOUND)
                        ;

                    // insert "*." after every delimiter
                    nIndex = 0;
                    while((nIndex = aExts.SearchAndReplace( ",", ";*.", nIndex + 3)) != STRING_NOTFOUND)
                        ;

                    
                    PluginDescription& rDescr = pDescriptions[nStart+nToken];
                    rDescr.PluginName	= aName;
                    rDescr.Description	= aComment;
                    rDescr.Mimetype.operator =(StringToOUString(aMIME.GetToken( nToken, '|' ), CHARSET_SYSTEM));
                    rDescr.Extension.operator=(StringToOUString(aExts, CHARSET_SYSTEM));
                }

                DosFreeResource(pResource2);
            }

            DosFreeResource(pResource1);
        }

        // free module
        DosFreeModule(hModule);
    }

    DosFindClose(hDir);
}

//--------------------------------------------------------------------------------------------------
Sequence<PluginDescription> XPluginManager_Impl::getPluginDescriptions(void)
{
	static s_bInit = FALSE;
        static Sequence<PluginDescription> s_aDescriptions( 0 );

        if (!s_bInit)
        {
            CHAR  szBuffer[CCHMAXPATHCOMP];
            ULONG ulSize  = sizeof(szBuffer);

            ULONG ulBytes = PrfQueryProfileString(HINI_PROFILE, "Netscape", NULL, NULL, szBuffer, ulSize);

            if(ulBytes)
            {
                float fmax = 0;
                PSZ   pszMax = NULL;

                // find the latest revision
                for(PSZ cp = szBuffer; *cp; cp += strlen(cp) + 1)
                {
                    float fRevision = atof(cp);

                    if(fRevision > fmax)
                    {
                        fmax = fRevision;
                        pszMax = cp;
                    }
                }

                // query netscape directory
                if(pszMax && (ulBytes = PrfQueryProfileString(HINI_PROFILE, "Netscape", pszMax, NULL, szBuffer, ulSize)))
                {
                    // append plugin path
                    strcpy(szBuffer + ulBytes, "\\PROGRAM\\PLUGINS");

                    addPluginDescriptions(szBuffer, s_aDescriptions);
                }
            }

            // search in office plugin path
            String aAppPath = Application::GetAppFileName();

            USHORT nIndex = STRING_LEN;

            // use loop here: binary might move to a bin subtree
            for(BYTE n = 1; n; n--)
                nIndex = aAppPath.SearchCharBackward("\\", nIndex);

            aAppPath.Erase(nIndex + 1);
            aAppPath += "PLUGIN";

            addPluginDescriptions(aAppPath.GetStr(), s_aDescriptions);

            s_bInit = TRUE;
        }

        return s_aDescriptions;
}

