/*************************************************************************
 *
 *  $RCSfile: b3dgeom.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: aw $ $Date: 2001/09/20 16:32:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _B3D_B3DGEOM_HXX
#define _B3D_B3DGEOM_HXX

#ifndef _B3D_B3DENTITY_HXX
#include "b3dentty.hxx"
#endif

#ifndef _B3D_VOLUM_HXX
#include "b3dvolum.hxx"
#endif

/*************************************************************************
|*
|* Defines fuer die Erzeugung von Default-Normalen und -Texturkoordinaten
|*
\************************************************************************/

#define	B3D_CREATE_DEFAULT_X			(0x0001)
#define	B3D_CREATE_DEFAULT_Y			(0x0002)
#define	B3D_CREATE_DEFAULT_Z			(0x0004)
#define	B3D_CREATE_DEFAULT_ALL			(B3D_CREATE_DEFAULT_X|B3D_CREATE_DEFAULT_Y|B3D_CREATE_DEFAULT_Z)


/*************************************************************************
|*
|* Index-Klasse fuer Geometrie-Bucket der B3dGeometry-Klasse
|*
\************************************************************************/

#define	B3D_INDEX_MODE_FILLED					(0)
#define	B3D_INDEX_MODE_LINE						(1)
#define	B3D_INDEX_MODE_POINT					(2)
#define	B3D_INDEX_MODE_UNUSED					(3)

class GeometryIndexValue
{
private:
	unsigned					nIndex		: 30;
	unsigned					nMode		:  2;

public:
	GeometryIndexValue() : nIndex(0), nMode(B3D_INDEX_MODE_FILLED) {}
	GeometryIndexValue(UINT32 nInd) : nIndex(nInd), nMode(B3D_INDEX_MODE_FILLED) {}
	GeometryIndexValue(UINT32 nInd, UINT8 nMod) : nIndex(nInd), nMode(nMod) {}

	UINT32 GetIndex() { return ((UINT32)nIndex); }
	void SetIndex(UINT32 nNew) { nIndex = nNew; }

	UINT8 GetMode() { return ((UINT8)nMode); }
	void SetMode(UINT8 nNew) { nMode = nNew; }

protected:
};

/*************************************************************************
|*
|* Bucket fuer Indices
|*
\************************************************************************/

BASE3D_DECL_BUCKET(GeometryIndexValue, Bucket)

/*************************************************************************
|*
|* Geometrie eines 3D-Objektes
|*
\************************************************************************/
class B3dComplexPolygon;
class Matrix4D;

class B3dGeometry
{
private:
	// Tool zum triangulieren komplexer Polygone
	// Wird nur temporaer erzeugt
	B3dComplexPolygon*			pComplexPolygon;

	// Bucket fuer grundsaetzliche Geometrie
	B3dEntityBucket				aEntityBucket;

	// Indices der Polygonendpunkte
	GeometryIndexValueBucket	aIndexBucket;

	// Ausgangszustand der Variablen herstellen
	void Reset();

	// Freien Eintrag zum fuellen holen
	B3dEntity& GetFreeEntity();

	// Hint-Variable
	unsigned					bHintIsComplex		: 1;
	unsigned					bOutline			: 1;

public:
	// Konstruktor, Destruktor
	B3dGeometry();

	// #92030# add access to bOutline hint flag
	sal_Bool IsOutline() const { return (sal_Bool)bOutline; }

	// Geometrieerzeugung
	void StartDescription();
	void EndDescription();

	void StartObject(BOOL bHintIsComplex=TRUE, BOOL bOutl=FALSE);
	void EndObject();

	void AddEdge(const Vector3D& rPoint);
	void AddEdge(const Vector3D& rPoint,
		const Vector3D& rNormal);
	void AddEdge(const Vector3D& rPoint,
		const Vector3D& rNormal,
		const Vector3D& rTexture);

	// Inhalte loeschen
	void Erase();
	// Inhalte loeschen	und Speicher freigeben
	void Empty();

	// Copy-Operator
	void operator=(const B3dGeometry& rObj);

	// Zugriff auf beide Buckets um die Geometrie zu lesen
	B3dEntityBucket& GetEntityBucket() { return aEntityBucket; }
	GeometryIndexValueBucket& GetIndexBucket() { return aIndexBucket; }

	// Eine beliebige Transformation auf die Geometrie anwenden
	void Transform(const Matrix4D&);

	// Hittest auf Geometrie, -1:Kein Treffer, sonst die Tiefe
	INT32 CheckHit(const Vector3D &rFront, const Vector3D &rBack, USHORT nTol);

	// BoundVolume liefern
	B3dVolume GetBoundVolume();

	// Mittelpunkt liefern
	Vector3D GetCenter();

	// Standard - Normalen generieren
	void CreateDefaultNormalsSphere();
	void RemoveNormals();

	// Standard - Texturkoordinaten generieren
	void CreateDefaultTexture(UINT16 nCreateWhat=B3D_CREATE_DEFAULT_ALL,
		BOOL bUseSphere=TRUE);
	void RemoveTexture();

	// Default-Geometrien erstellen
	void CreateCube(const B3dVolume& rVolume);
	void CreateSphere(const B3dVolume& rVolume, double nX, double nY);

	// Normalen invertieren
	void InvertNormals();

protected:
	// Callbacks bei komplexen Primitiven
	friend class B3dComplexPolygon;
	void StartComplexPrimitive();
	void EndComplexPrimitive();
	void AddComplexVertex(B3dEntity& rNew, BOOL bIsVisible);

	// PolygonStart und -Ende aufzeichnen
	void StartPolygon();
	void EndPolygon();

	// Hittest fuer einzelnes Polygon, -1: Kein Hit, sonst die Tiefe
	INT32 CheckSinglePolygonHit(UINT32 nLow, UINT32 nHigh, const Vector3D& rFront, const Vector3D& rBack);

	// Schnittpunkt Polygon/Vektor bestimmen
	BOOL GetCutPoint(UINT32 nLow, Vector3D& rCut, const Vector3D& rFront, const Vector3D& rBack);

	// Test auf drin/draussen fuer einzelnes Polygon
	BOOL IsInside(UINT32 nLow, UINT32 nHigh, const Vector3D& rPnt);

	// Normale ermitteln fuer einzelnes Polygon
	Vector3D CalcNormal(UINT32 nLow, UINT32 nHigh);
};


#endif          // _B3D_B3DGEOM_HXX
