/*************************************************************************
 *
 *  $RCSfile: mailbody.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:30:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _MAILBODY_HXX
#define _MAILBODY_HXX

// include ---------------------------------------------------------------

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _DATETIME_HXX //autogen
#include <tools/datetime.hxx>
#endif
#ifndef _SFXBRDCST_HXX //autogen
#include <svtools/brdcst.hxx>
#endif
#include "mailenum.hxx"

// forward ---------------------------------------------------------------

class MailReceiverList;
class MailAttachFileList;
class INetCoreMIMEMessage;
class SvStream;

struct MessageRef;
struct MailExtras_Impl;

// define ----------------------------------------------------------------

#define MAIL_FLAG_READ			0x01000000
#define MAIL_FLAG_UNREAD		0x02000000

#define MAIL_FLAG_PRIO_LOW		0x00010000
#define MAIL_FLAG_PRIO_NORMAL	0x00020000
#define MAIL_FLAG_PRIO_HIGH		0x00040000

// class Mail ------------------------------------------------------------

class Mail : public SfxBroadcaster
{
protected:
	MailExtras_Impl*	pExtras;
	String				aSubject;
	String				aMessage;
	MailPriority		ePriority;
	BOOL				bRetReceipt;
	MailReceiverList*	pReceiverList;
	MailAttachFileList* pAttachList;
	String				aSenderAddress;
	String				aSenderName;
	DateTime			aSendDateTime;
	String				aDateTimeStr;

public:
						Mail();
						Mail( const Mail& rMail );
	Mail&			 	operator =( const Mail& rMail );
	virtual			 	~Mail();

	const String&		GetSenderAddress() const { return aSenderAddress; }
	const String&		GetSenderName() const { return aSenderName; }
	const DateTime&		GetSendDateTime() const { return aSendDateTime; }
	const String&		GetSendDateTimeStr() const { return aDateTimeStr; }

	const String&		GetSubject() const { return aSubject; }
	const String&		GetMessage() const { return aMessage; }
	MailPriority		GetPriority() const { return ePriority; }
	BOOL				IsRetReceipt() const { return bRetReceipt; }

	USHORT				GetReceiverCount() const;
	String				GetReceiverName( USHORT nNo ) const;
	MailReceiverRole	GetReceiverRole( USHORT nNo ) const;

	USHORT				GetAttachCount() const;
	String				GetAttachFile( USHORT nNo ) const;
	String				GetAttachName( USHORT nNo ) const;

	void				Load( SvStream& rStrm, FASTBOOL bAttach = FALSE );
	SvStream&			Save( SvStream& rStrm,
							  FASTBOOL bSingle = FALSE ) const;

	FASTBOOL			IsRead() const;
	const String&		GetLocalName() const;
	void				SetLocalName( const String& rNew );
	FASTBOOL			IsFile() const;
	void				SetFile( const String& rFile );
	USHORT				GetFolder() const;
	void				SetFolder( USHORT nNew );
	const String&		GetPath() const;
	void				SetPath( const String& rNew );
	FASTBOOL			IsFolderMail() const;
	FASTBOOL			IsDeleted() const;
	const String&		GetMessageId() const;
	void				SetMessageId( const String& rNew );
	const String&		GetReferences() const;
	void				SetReferences( const String& rNew );
	FASTBOOL			IsSent() const;
	void				SetSent( FASTBOOL bNew );
	FASTBOOL			IsOpen() const;
	void				SetOpen( FASTBOOL bNew );
	const String&		GetBestAlternativeFile() const;
	void				SetBestAlternativeFile( const String& rNew );
	FASTBOOL			IsCompletelyLoaded() const;

	FASTBOOL				IsAlternative() const;
	INetCoreMIMEMessage*	GetAlternativeMessage() const;
	void					SetAlternativeMessage( INetCoreMIMEMessage* pMsg );
	USHORT					GetAlternativeCount() const;
	String					GetAlternativeFile( USHORT nNo ) const;
	String					GetAlternativeType( USHORT nNo ) const;
};

// class IncomingMail ----------------------------------------------------

class IncomingMail : public Mail
{
friend class MailServer;
friend class SmtpMailServer;

private:
	MessageRef*			pMessageRef;
	MailServer*			pMailServer;

						// f"ur den MailServer
						IncomingMail( MessageRef* pRef, MailServer* pServer,
									  BOOL bAttach = TRUE );
						IncomingMail( MessageRef* pRef,
									  MailServer* pServer, const Mail& rMail );

						// den  Gebrauch verbieten
						IncomingMail();
						IncomingMail( const IncomingMail& rMail );
	IncomingMail&		operator =(  const IncomingMail& rMail  );

public:
	virtual				~IncomingMail();

	BOOL				IsRead() const;
	void				MarkAsRead();
	MailState			Kill();
	void				BroadcastKill();
	ULONG				GetPos() const;
	MessageRef*			GetRef() const { return pMessageRef; }
};

// class OutgoingMail ----------------------------------------------------

class OutgoingMail : public Mail
{
private:
	FASTBOOL			bDlgRequired;

public:
						OutgoingMail();
						OutgoingMail( const OutgoingMail& rMail );
						OutgoingMail( const IncomingMail& rMail );
	OutgoingMail&		operator =( const OutgoingMail& rMail );

	virtual				~OutgoingMail();

	void				SetSenderAddress( const String& rAddress )
							{	aSenderAddress = rAddress; }
	void				SetSenderName( const String& rName )
							{	aSenderName = rName; }
	void				SetSendDateTime( const DateTime& rDT )
							{	aSendDateTime = rDT; }
	void				SetSendDateTimeStr( const String& rDT )
							{	aDateTimeStr = rDT; }

	void				SetSubject( const String& rNewSubject )
							{	aSubject = rNewSubject; }
	void				SetMessage( const String& rNewMessage )
							{	aMessage = rNewMessage; }
	void				SetPriority( MailPriority eNewPrio )
							{	ePriority = eNewPrio; }
	void				SetRetReceipt( BOOL bNew )
							{	bRetReceipt = bNew; }
	void				AddReceiver( const String& rUserName,
							MailReceiverRole eRole = MAIL_RECEIVER_TO );
	void				ClearReceiver();
	void				ClearReceiverPart( BOOL bNewsgroup = TRUE );
	void				AttachFile( const String& rFile, const String& rName );
	void				ClearAttach();

	FASTBOOL			IsDialogRequired() const	{ return bDlgRequired; }
	void				SetDialogRequired( FASTBOOL bNew )
							{ bDlgRequired = bNew; }
	FASTBOOL            HasMailReceiver() const;
};


#endif

