/*************************************************************************
 *
 *  $RCSfile: testpi.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:30:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <sv.hxx>
#include <helppi.hxx>
#include <libcall.hxx>
#include <sobase.hxx>


class MyApp : public Application
{
public:
	virtual void Main( int, char*[] );
};

class PIWindow : public Window
{
private:
	HelpPI*				pHelpPI;


protected:
	virtual void    Resize();
	DECL_LINK( 		TopicChanged, HelpPI* );

public:
					PIWindow( Window* pParent );
					~PIWindow();

	void			LoadTopic( const String& rFileName, ULONG nId );

};

PIWindow::PIWindow( Window* pParent ) : Window( pParent )
{
	pHelpPI = new HelpPI( this );
	pHelpPI->GetTopicChangedHdl() = LINK( this, PIWindow, TopicChanged );
	SetText( "Help-PI" );

	Show();
//	LoadTopic( HELPFILE,  1 );
}

PIWindow::~PIWindow()
{
	delete pHelpPI;
}

void PIWindow::LoadTopic( const String& rFileName, ULONG nId )
{
	pHelpPI->LoadTopic( rFileName, nId );
}

IMPL_LINK( PIWindow, TopicChanged, HelpPI*, EMPTYARG )
{
	String aTitle = pHelpPI->GetTopicTitle();
	GetParent()->SetText( aTitle );
	return 0;
}

void PIWindow::Resize()
{
	pHelpPI->Resize();
}


class PITestAppWindow : public WorkWindow
{
private:
	PIWindow			aPIWindow;

protected:
	virtual void    Resize();

public:
					PITestAppWindow();
					~PITestAppWindow();
	PIWindow&		GetPIWindow() { return aPIWindow; }

};

PITestAppWindow::PITestAppWindow()
	: WorkWindow( NULL, WB_APP | WB_STDWORK | WB_SVLOOK ),
	  aPIWindow( this )
{
	aPIWindow.Show();
	Show();
}

PITestAppWindow::~PITestAppWindow()
{
}

void PITestAppWindow::Resize()
{
	long nBorder = 5;
	Size aSz = GetOutputSizePixel();
	aSz.Width() -= 2*nBorder;
	aSz.Height() -= 2*nBorder;
	aPIWindow.SetPosSizePixel( Point( nBorder, nBorder ), aSz );
}

void MyApp::Main( int argc, char* argv[] )
{
	EnableSVLook();
	Help::EnableQuickHelp();

	SvFactory::Init();

	PITestAppWindow aWindow;

	String aHelpFile;
	ULONG nId = 0;

	if ( argc >= 2 )
		aHelpFile = argv[1];
	if ( argc >= 3 )
		nId = (ULONG) String( argv[1] );

	aWindow.GetPIWindow().LoadTopic( aHelpFile, nId );

	Execute();

	SvFactory::DeInit();
}

MyApp aMyApp;
