/*************************************************************************
 *
 *  $RCSfile: JavaLoaderFactory.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dbo $ $Date: 2002/08/13 11:40:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.comp.loader;

import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.ServiceNotRegisteredException;
import com.sun.star.lang.WrappedTargetException;

import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Exception;

public class JavaLoaderFactory implements XSingleServiceFactory, XServiceInfo {

    private static String[] supportedServices = {
        "com.sun.star.loader.Java",
        "com.sun.star.loader.Java2"
    };

	private static final boolean DEBUG = false;
	
	private static final void DEBUG(String dbg) {
	    if (DEBUG)
	        System.err.println(" >>> JavaLoaderFactory - " + dbg);
	}
		
	protected XMultiServiceFactory multiServiceFactory = null;
	
	/** default constructor
	 */
//  	public JavaLoaderFactory() {}
	
	public JavaLoaderFactory(XMultiServiceFactory factory) {
	    multiServiceFactory = factory;
	}
	
    public java.lang.Object createInstance() 
            throws com.sun.star.uno.Exception, 
                   com.sun.star.uno.RuntimeException
    {
        return new JavaLoader(multiServiceFactory);
    }

    public java.lang.Object createInstanceWithArguments( java.lang.Object[] args ) 
            throws com.sun.star.uno.Exception, 
                   com.sun.star.uno.RuntimeException
    {
        JavaLoader loader = new JavaLoader();
        loader.initialize(args);
        
        return loader;
    }
    
    /** implements the XServiceInfo interface
	 */
	public String getImplementationName() 
	        throws com.sun.star.uno.RuntimeException 
    {
		return JavaLoader.class.getName();
	}
    
    /** implements the XServiceInfo interface
	 */
	public boolean supportsService(String serviceName) 
	        throws com.sun.star.uno.RuntimeException 
	{
		for ( int i = 0; i < supportedServices.length; i++ ) {
			if ( supportedServices[i].equals(serviceName) )
				return true;
		}
		return false;
	}
    
    /** implements the XServiceInfo interface
	 */
	public String[] getSupportedServiceNames() 
	        throws com.sun.star.uno.RuntimeException 
	{
		return supportedServices;
	}
}

