/*************************************************************************
 *
 *  $RCSfile: Handler.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.net.protocol.uno;


import java.io.IOException;
import java.io.InputStream;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;


import com.sun.star.lib.sandbox.ResourceProxy;

import com.sun.star.uno.IBridge;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;

import com.sun.star.connection.XConnector;
import com.sun.star.connection.XConnection;

import com.sun.star.bridge.XBridge;

class UNOConnection extends URLConnection {
    private static boolean debug = false;// debugging?

	protected String _conDcp = null;
	protected String _protDcp = null;
	protected String _rootOid = null;

    protected UNOConnection(URL url) throws MalformedURLException, IOException {
		super(url);

		String dcp = url.getFile();
		
		int index = dcp.indexOf(':') + 1; // get also the slash
		String bla = dcp.substring(0, index).trim();
		dcp = dcp.substring(index + 1).trim();
		
		index = dcp.indexOf(';');
		_conDcp = dcp.substring(0, index).trim();
		dcp = dcp.substring(index + 1).trim();
		
		index = dcp.indexOf(';');
		_protDcp = dcp.substring(0, index).trim();
		dcp = dcp.substring(index + 1).trim();
		
		_rootOid = dcp.trim().trim();

		System.err.println("blblblb:" + _conDcp);
		System.err.println("blblblb:" + _protDcp);
		System.err.println("blblblb:" + _rootOid);
    }

	static String neededServices[] = new String[] {
		"com.sun.star.comp.servicemanager.ServiceManager",
		"com.sun.star.comp.loader.JavaLoader",
		"com.sun.star.comp.connections.Connector",
  		"com.sun.star.comp.connections.Acceptor",
		"com.sun.star.lib.uno.bridges.java_remote.java_remote_bridge"
	};


	public static synchronized Object getContent(ResourceProxy resource, URL url) {
		return null;
	}
	
    public void connect() throws IOException {
//  		debug("Looking for "+cachedURL+" in AppletResourceLoader");
//  		ResourceProxy resourceProxy = ResourceProxy.load(cachedURL, null);

//  		Object content = getContent(resourceProxy, cachedURL);

//  		if (content == null) {
//  			debug("Invalid resource name");
//  			resource = null;
//  			return;
//  		} else {
//  			debug("Found resource");
//  			resource = content;
//  		}
    }

    public Object getContent() throws IOException {
		Object object = null;

		try {
			com.sun.star.comp.servicemanager.ServiceManager smgr = new com.sun.star.comp.servicemanager.ServiceManager();
			smgr.addFactories(neededServices);
			
			XConnector  xConnector  = (XConnector)UnoRuntime.queryInterface(XConnector.class, smgr.createInstance("com.sun.star.connection.Connector"));
			XConnection xConnection = xConnector.connect(_conDcp);
			
			XBridge xBridge = (XBridge)UnoRuntime.queryInterface(XBridge.class, smgr.createInstanceWithArguments("com.sun.star.bridge.RemoteBridge", new Object[]{_protDcp, xConnection, null}));
		
			object = xBridge.getInstance("NamingService");
		}
		catch(Exception exception) {
			System.err.println("##### " + getClass().getName() + ".getContent - exception:" + exception.getMessage());
		}

		return object;
    }

    public InputStream getInputStream() throws IOException {
//  		if (!connected) {
//  			connect();
//  		}

//  		if (resource instanceof InputStream) {
//  			return (InputStream) resource;
//  		}
  		return null; //ResourceProxy.load(cachedURL, null).getInputStream();
    }

    private void debug(String msg) {
		if (debug) {
			System.err.println(msg);
		}
    }
}

public class Handler extends URLStreamHandler {
    public URLConnection openConnection(URL u) throws IOException {
		return new UNOConnection(u);
    }
}

