
package org.netbeans.modules.openoffice;

import java.awt.Image;
import java.beans.*;

import org.openide.compiler.ExternalCompilerType;
import org.openide.util.NbBundle;


/**
 *
 * @author  Michael Bohn
 *
 */

public class OOIDLCompilerTypeBeanInfo extends SimpleBeanInfo {

    /** Get default info.
     * @return infos from super
     */
    public BeanInfo[] getAdditionalBeanInfo () {
        try {
            return new BeanInfo[] {
                       Introspector.getBeanInfo (ExternalCompilerType.class)
                   };
        } catch (IntrospectionException ie) {
            if (Boolean.getBoolean ("netbeans.debug.exceptions"))
                ie.printStackTrace ();
            return null;
        }
    }

    /** Get the bean descriptor.
     * @return a localized descriptor
     */

    public BeanDescriptor getBeanDescriptor () {
        BeanDescriptor desc = new BeanDescriptor (OOIDLCompilerType.class);
        desc.setDisplayName (NbBundle.getBundle (OOIDLCompilerTypeBeanInfo.class).getString ("LABEL_OOIDLCompilerType"));
        desc.setShortDescription (NbBundle.getBundle (OOIDLCompilerTypeBeanInfo.class).getString ("HINT_OOIDLCompilerType"));
        return desc;
    }

    
    /** Cached icon.
     */
    private static Image icon;
    /** Get a bean icon.
     * @param type the style
     * @return the icon
     */
    public Image getIcon (int type) {
        if (type == BeanInfo.ICON_COLOR_16x16 || type == BeanInfo.ICON_MONO_16x16) {
            if (icon == null)
                icon = loadImage ("idl.gif");
            return icon;
        } else {
            return null;
        }
    }

    
}
