
package org.netbeans.modules.openoffice;

import java.beans.*;
import java.awt.Image;

import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;


public final class OOURDDataLoaderBeanInfo extends SimpleBeanInfo {

    /** Get inherited bean infos.
     * @return the super info
     */
    public BeanInfo[] getAdditionalBeanInfo () {
        try {
            return new BeanInfo[] { Introspector.getBeanInfo (UniFileLoader.class) };
        } catch (IntrospectionException ie) {
            if (Boolean.getBoolean ("netbeans.debug.exceptions"))
                ie.printStackTrace ();
            return null;
        }
    }


    /** Icons for compiler settings objects. */
    private static Image icon;

    /** Get the bean icon for the loader.
     * @param type desired type of the icon
     * @return returns the OOURD loader's icon
     */
    public Image getIcon(final int type) {
        if ((type == java.beans.BeanInfo.ICON_COLOR_16x16) ||
                (type == java.beans.BeanInfo.ICON_MONO_16x16)) {
            if (icon == null)
                icon = loadImage("/org/netbeans/modules/openoffice/urd.gif");
            return icon;
        } else {
            return null;
        }
    }

}
