
package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.util.Create;
import org.netbeans.modules.openoffice.wizard.util.FwdDclCreator;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class CreateFwdDclAction extends NodeAction
    implements Create
{

    public CreateFwdDclAction()
    {
    }

    public void performAction(Node anode[])
    {
        FwdDclCreator fwddclcreator = (FwdDclCreator)anode[0].getCookie(FwdDclCreator.class);
        fwddclcreator.createForwardDcl();
    }

    public boolean enable(Node anode[])
    {
        if(anode.length != 1)
            return false;
        else
            return anode[0].getCookie(FwdDclCreator.class) != null;
    }

    public boolean isEnabled(Node anode[])
    {
        return enable(anode);
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName()
    {
        return NbBundle.getBundle(CreateFwdDclAction.class).getString("TXT_CreateFwdDcl");
    }

    public String toString()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_FwdDcl");
    }

   
}
