/*************************************************************************
 *
 *  $RCSfile: dirw9x.c,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: obr $ $Date: 2001/06/07 09:23:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define	UNICODE
#include <system.h>

#include "dirW9X.h"
#include <sal/types.h>

// Implementation of FindFirstFile for WIN9X

static HANDLE WINAPI FindFirstFile_W9X(LPCWSTR lpFileNameW, LPWIN32_FIND_DATAW lpDataW)
{
	CHAR				*pFileNameA=NULL;
	WIN32_FIND_DATAA	DataA;
	HANDLE				hfile;
	int					needed;

	if (lpFileNameW)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpFileNameW, -1, NULL, 0, NULL, NULL);
		pFileNameA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpFileNameW, -1, pFileNameA, needed, NULL, NULL);
	}

	hfile=FindFirstFileA(pFileNameA, &DataA);

	if (pFileNameA) 
		free(pFileNameA);

	if (hfile!=INVALID_HANDLE_VALUE)
	{
		memcpy(lpDataW, &DataA, sizeof(WIN32_FIND_DATAA)-(MAX_PATH+14));
		MultiByteToWideChar(CP_ACP, 0, DataA.cFileName, -1, lpDataW->cFileName, MAX_PATH);
		MultiByteToWideChar(CP_ACP, 0, DataA.cAlternateFileName, -1, lpDataW->cAlternateFileName, 14);
	}

	return hfile;
}

// Implementation of FindNextFile for WIN9X

static BOOL WINAPI FindNextFile_W9X(HANDLE hFile, LPWIN32_FIND_DATAW lpDataW)
{
	WIN32_FIND_DATAA DataA;
	BOOL ffile;

	ffile=FindNextFileA(hFile, &DataA);

	if (ffile)
	{
		memcpy(lpDataW, &DataA, sizeof(WIN32_FIND_DATAA)-(MAX_PATH+14));
		MultiByteToWideChar(CP_ACP, 0, DataA.cFileName, -1, lpDataW->cFileName, MAX_PATH);
		MultiByteToWideChar(CP_ACP, 0, DataA.cAlternateFileName, -1, lpDataW->cAlternateFileName, 14);
	}

	return ffile;
}

// Implementation of SetFileAttributes for WIN9X

static BOOL WINAPI SetFileAttributes_W9X(LPCWSTR lpFileNameW, DWORD dwFileAttributes)
{
	CHAR *pFileNameA=NULL;
	BOOL fSuccess;
	int needed;

	if (lpFileNameW)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpFileNameW, -1, NULL, 0, NULL, NULL);
		pFileNameA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpFileNameW, -1, pFileNameA, needed, NULL, NULL);
	}

	WideCharToMultiByte(CP_ACP,0, lpFileNameW, -1, pFileNameA, MAX_PATH, NULL, NULL);

	fSuccess=SetFileAttributesA(pFileNameA, dwFileAttributes);

	if (pFileNameA)
		free(pFileNameA);

	return fSuccess;
}

// Implementation of SearchPath for WIN9X

static DWORD WINAPI SearchPath_W9X(LPCWSTR lpPathW, LPCWSTR lpFileNameW, LPCWSTR lpExtensionW, DWORD nBufferLength, LPWSTR lpBufferW, LPWSTR *lpFilePartW )
{
	CHAR *pPathA = 0;
	CHAR *pFileNameA = 0;
	CHAR *pExtensionA = 0;
	CHAR BufferA[MAX_PATH];
	CHAR *FilePartA = 0;
	DWORD nLength;
	int needed;

	if (lpPathW)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpPathW, -1, NULL, 0, NULL, NULL);
		pPathA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpPathW, -1, pPathA, needed, NULL, NULL);
	}

	if (lpFileNameW)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpFileNameW, -1, NULL, 0, NULL, NULL);
		pFileNameA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpFileNameW, -1, pFileNameA, needed, NULL, NULL);
	}

	if (lpExtensionW)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpExtensionW, -1, NULL, 0, NULL, NULL);
		pExtensionA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpExtensionW, -1, pExtensionA, needed, NULL, NULL);
	}

	nLength=SearchPathA(pPathA, pFileNameA, pExtensionA, nBufferLength, BufferA, &FilePartA);

	if ((0<nLength) && (nLength<=nBufferLength))
	{
		MultiByteToWideChar(CP_ACP, 0, BufferA, -1, lpBufferW, MAX_PATH);
		*lpFilePartW= lpBufferW+(FilePartA-BufferA);	
	}

	if (pPathA)
		free(pPathA);

	if (pFileNameA)
		free(pFileNameA);

	if (pExtensionA)
		free(pExtensionA);

	return nLength;
}



DWORD WINAPI WNetAddConnection2_W9X(LPNETRESOURCEW lpNetResourceW, LPCWSTR lpPasswordW, LPCWSTR lpUsernameW, DWORD dwFlags)
{
	int				needed;	
	DWORD			Success;
	LPNETRESOURCEA	sNetResourceA;
	CHAR			*pPasswordA=NULL;
	CHAR			*pUsernameA=NULL;

	memcpy(&sNetResourceA, lpNetResourceW, 4*sizeof(DWORD));

	if (lpNetResourceW->lpLocalName)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpNetResourceW->lpLocalName, -1, NULL, 0, NULL, NULL);
		sNetResourceA->lpLocalName = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpNetResourceW->lpLocalName, -1, sNetResourceA->lpLocalName, needed, NULL, NULL);
	}
	else 
	{
		lpNetResourceW->lpLocalName=NULL;
	}
	
	if (lpNetResourceW->lpRemoteName )
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpNetResourceW->lpRemoteName , -1, NULL, 0, NULL, NULL);
		sNetResourceA->lpRemoteName  = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpNetResourceW->lpRemoteName , -1, sNetResourceA->lpRemoteName , needed, NULL, NULL);
	}
	else 
	{
		lpNetResourceW->lpRemoteName =NULL;
	}

	if (lpNetResourceW->lpComment )
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpNetResourceW->lpComment , -1, NULL, 0, NULL, NULL);
		sNetResourceA->lpComment  = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpNetResourceW->lpComment , -1, sNetResourceA->lpComment , needed, NULL, NULL);
	}
	else 
	{
		lpNetResourceW->lpComment =NULL;
	}

	if (lpNetResourceW->lpProvider )
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpNetResourceW->lpProvider , -1, NULL, 0, NULL, NULL);
		sNetResourceA->lpProvider  = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpNetResourceW->lpProvider , -1, sNetResourceA->lpProvider , needed, NULL, NULL);
	}
	else 
	{
		lpNetResourceW->lpProvider =NULL;
	}
 
	if (lpPasswordW)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpPasswordW, -1, NULL, 0, NULL, NULL);
		pPasswordA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpPasswordW, -1, pPasswordA, needed, NULL, NULL);
	}
	
	if (lpUsernameW)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpUsernameW, -1, NULL, 0, NULL, NULL);
		pUsernameA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpUsernameW, -1, pUsernameA, needed, NULL, NULL);
	}

	Success=WNetAddConnection2A(sNetResourceA, pPasswordA, pUsernameA, dwFlags);
	
	if (pPasswordA)
		free(pPasswordA);

	if (pUsernameA)
		free(pUsernameA);

	if (lpNetResourceW->lpLocalName)
		free(lpNetResourceW->lpProvider);

	if (lpNetResourceW->lpRemoteName)
		free(lpNetResourceW->lpProvider);

	if (lpNetResourceW->lpComment)
		free(lpNetResourceW->lpProvider);

	if (lpNetResourceW->lpProvider)
		free(lpNetResourceW->lpProvider);

	return Success;

}

static DWORD WINAPI WNetCancelConnection2_W9X( LPCWSTR lpNameW, DWORD dwFlags, BOOL fForce)
{
	int				needed;	
	BOOL			fSuccess;
	CHAR			*pNameA=NULL;

	if (lpNameW)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpNameW, -1, NULL, 0, NULL, NULL);
		pNameA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpNameW, -1, pNameA, needed, NULL, NULL);
	}

	fSuccess=WNetCancelConnection2A( pNameA, dwFlags, fForce);

	if (pNameA)
		free(pNameA);

	return fSuccess;

}

static DWORD WINAPI WNetGetUser_W9X( LPCWSTR lpNameW, LPWSTR lpUserNameW, LPDWORD lpnLength)
{
	char			tmpBuffer[1024];
	int				needed;	
	DWORD			nBufferSize = sizeof( tmpBuffer );
	DWORD			Success;
	CHAR			*pNameA=NULL;
	CHAR			*pUserNameA=tmpBuffer;

	if (lpNameW)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpNameW, -1, NULL, 0, NULL, NULL);
		pNameA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpNameW, -1, pNameA, needed, NULL, NULL);
	}

	Success=WNetGetUserA(pNameA, pUserNameA, &nBufferSize );

	if (Success== NO_ERROR)
	{
		needed = MultiByteToWideChar(CP_ACP, 0, pUserNameA, -1, NULL, 0);
		needed = min( (int)*lpnLength, needed );
//		pUserNameA = malloc (needed*sizeof(CHAR));
		MultiByteToWideChar(CP_ACP, 0, pUserNameA, -1, lpUserNameW, needed );
		*lpnLength = needed;
	}

	if (pNameA)
		free(pNameA);

//	if (pUserNameA)
//		free(pUserNameA);

	return Success;
}

static UINT WINAPI GetWindowsDirectory_W9X(LPWSTR lpBuffer, UINT uSize)
{
	sal_Char	*buffer;
	UINT		Success;

	buffer = malloc (uSize*sizeof(sal_Char));
	GetWindowsDirectoryA(buffer, uSize);

	Success=MultiByteToWideChar(CP_ACP, 0, buffer, -1, lpBuffer, uSize);	

	free (buffer);
	return Success;
}

BOOL WINAPI WritePrivateProfileString_W9X( LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpString, LPCWSTR lpFileName )
{
	CHAR *pAppNameA  = NULL;
	CHAR *pKeyNameA  = NULL;
	CHAR *pStringA   = NULL;
	CHAR *pFileNameA = NULL;
	BOOL fSuccess;
	int  needed;

	if (lpAppName)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpAppName, -1, NULL, 0, NULL, NULL);
		pAppNameA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpAppName, -1, pAppNameA, needed, NULL, NULL);
	}

	if (lpKeyName)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpKeyName, -1, NULL, 0, NULL, NULL);
		pKeyNameA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpKeyName, -1, pKeyNameA, needed, NULL, NULL);
	}

	if (lpString)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpString, -1, NULL, 0, NULL, NULL);
		pStringA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpString, -1, pStringA, needed, NULL, NULL);
	}

	if (lpFileName)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpFileName, -1, NULL, 0, NULL, NULL);
		pFileNameA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpFileName, -1, pFileNameA, needed, NULL, NULL);
	}

	fSuccess = WritePrivateProfileStringA( pAppNameA, pKeyNameA, pStringA, pFileNameA );

	if (pAppNameA)
		free(pAppNameA);
	if (pKeyNameA)
		free(pKeyNameA);
	if (pStringA)
		free(pStringA);
	if (pFileNameA)
		free(pFileNameA);

	return fSuccess;
}

DWORD WINAPI GetPrivateProfileString_W9X( LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpDefault, LPWSTR lpReturnedString, DWORD nSize, LPCWSTR lpFileName )
{
	CHAR *pAppNameA  = NULL;
	CHAR *pKeyNameA  = NULL;
	CHAR *pDefaultA  = NULL;
	CHAR *pReturnedA = NULL;
	CHAR *pFileNameA = NULL;
	DWORD dwSuccess;
	int  needed;

	if (lpAppName)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpAppName, -1, NULL, 0, NULL, NULL);
		pAppNameA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpAppName, -1, pAppNameA, needed, NULL, NULL);
	}

	if (lpKeyName)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpKeyName, -1, NULL, 0, NULL, NULL);
		pKeyNameA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpKeyName, -1, pKeyNameA, needed, NULL, NULL);
	}

	if (lpReturnedString)
	{
		/* multi byte charsets may need more chars than nSize */
		pReturnedA = malloc (nSize*4*sizeof(CHAR));
	}

	if (lpDefault)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpDefault, -1, NULL, 0, NULL, NULL);
		pDefaultA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpDefault, -1, pDefaultA, needed, NULL, NULL);
	}

	if (lpFileName)
	{
		needed = WideCharToMultiByte(CP_ACP,0, lpFileName, -1, NULL, 0, NULL, NULL);
		pFileNameA = malloc (needed*sizeof(CHAR));
		WideCharToMultiByte(CP_ACP,0, lpFileName, -1, pFileNameA, needed, NULL, NULL);
	}

	dwSuccess = GetPrivateProfileStringA( pAppNameA, pKeyNameA, pDefaultA, pReturnedA, nSize, pFileNameA );

	if (pAppNameA)
		free(pAppNameA);
	if (pKeyNameA)
		free(pKeyNameA);
	if (pDefaultA)
		free(pDefaultA);
	if (pReturnedA)
	{
		if (dwSuccess)
		{
			CHAR  *pszStrA = pReturnedA;
			WCHAR *pszStrW = lpReturnedString;
			DWORD  dwFree  = nSize;

			/* reserve space for end of list value */
			if (!(lpAppName && lpKeyName))
				pszStrW[--dwFree] = 0;

			while ((*pszStrA) && dwFree)
			{	
				needed = MultiByteToWideChar( CP_ACP, 0, pszStrA, -1, NULL, 0 );

				if ((DWORD) needed <= dwFree)
				{
					dwFree  -= MultiByteToWideChar( CP_ACP, 0, pszStrA, -1, pszStrW, needed );
					pszStrA += needed;
					pszStrW += needed;
				}
				else
				{
					/* emulate original behavior */
					WCHAR *pszTmpW = malloc(needed * sizeof(WCHAR));
					MultiByteToWideChar( CP_ACP, 0, pszStrA, -1, pszTmpW, needed );
					wcsncpy( pszStrW, pszTmpW, dwFree - 1);
					pszStrW[dwFree - 1] = 0;

					break;
				}
			}
		}

		free (pReturnedA);
	}

	if (pFileNameA)
		free(pFileNameA);

	return dwSuccess;
}

//-------------------------------------------------------------------
// definition of the function pointer
//-------------------------------------------------------------------

HANDLE ( WINAPI *lpfnFindFirstFile )( 
	LPCWSTR lpFileName, 
	LPWIN32_FIND_DATAW lpDataW 
) = FindFirstFile_W9X;

BOOL ( WINAPI *lpfnFindNextFile )( 
	HANDLE hfile, 
	LPWIN32_FIND_DATAW lpDataW 
) = FindNextFile_W9X;

BOOL ( WINAPI *lpfnSetFileAttributes )(
	LPCWSTR lpFileName, 
	DWORD dwFileAttributes
) = SetFileAttributes_W9X;

DWORD ( WINAPI *lpfnSearchPath )( 
	LPCWSTR lpPath, 
	LPCWSTR lpFileName, 
	LPCWSTR lpExtension, 
	DWORD nBufferLength, 
	LPWSTR lpBuffer, 
	LPWSTR *lpFilePart 
) = SearchPath_W9X;


DWORD ( WINAPI *lpfnWNetAddConnection2 )( 
	LPNETRESOURCEW lpNetResource, 
	LPCWSTR lpPassword, 
	LPCWSTR lpUsername, 
	DWORD dwFlags
) = WNetAddConnection2_W9X;

DWORD ( WINAPI *lpfnWNetCancelConnection2 )( 
	LPCWSTR lpName, 
	DWORD dwFlags, 
	BOOL fForce
) = WNetCancelConnection2_W9X;

DWORD ( WINAPI *lpfnWNetGetUser )( 
	LPCWSTR lpName, 
	LPWSTR lpUserName, 
	LPDWORD lpnLength
) = WNetGetUser_W9X;

UINT ( WINAPI *lpfnGetWindowsDirectory )(
	LPWSTR lpBuffer, 
	UINT uSize
) = GetWindowsDirectory_W9X;

BOOL ( WINAPI *lpfnWritePrivateProfileString )(
	LPCWSTR lpAppName, 
	LPCWSTR lpKeyName, 
	LPCWSTR lpString, 
	LPCWSTR lpFileName 
) = WritePrivateProfileString_W9X;

DWORD ( WINAPI *lpfnGetPrivateProfileString )( 
	LPCWSTR lpAppName, 
	LPCWSTR lpKeyName, 
	LPCWSTR lpDefault, 
	LPWSTR lpReturnedString, 
	DWORD nSize, 
	LPCWSTR lpFileName
) = GetPrivateProfileString_W9X;
