/*************************************************************************
 *
 *  $RCSfile: SendMessage.c,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:48:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <windows.h>
#include <commdlg.h>
#include <shlobj.h>
#include <systools/win32/StrConvert.h>

#if OSL_DEBUG_LEVEL == 0
#define NDEBUG
#endif
#include <assert.h>


#define DLL_EXPORT extern

#define OFFSET 100

LRESULT WINAPI SMGetFolderPathW( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam )
{
    LRESULT lResult;
    LPSTR   lpFolderPathA = NULL;

    AllocSpaceAndCopyWStr2Str( (LPWSTR)lParam, wParam, &lpFolderPathA );
    lResult = SendMessageA( hWnd, Msg, wParam, (LPARAM)lpFolderPathA );

    // copy back the result
	MultiByteToWideChar(
        CP_ACP, 0, lpFolderPathA, wParam * sizeof( char ), (LPWSTR)lParam, wParam );

	FreeSpaceStr( lpFolderPathA );

	return lResult;
}

LRESULT WINAPI SMGetSpecW( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam )
{
    LRESULT lResult;
    LPSTR   lpSpecA = NULL;

    AllocSpaceAndCopyWStr2Str( (LPWSTR)lParam, wParam, &lpSpecA );
    lResult = SendMessageA( hWnd, (Msg - OFFSET), wParam, (LPARAM)lpSpecA );

    // copy back the result
	MultiByteToWideChar(
        CP_ACP, 0, lpSpecA, wParam * sizeof( char ), (LPWSTR)lParam, wParam );

	FreeSpaceStr( lpSpecA );

	return lResult;
}

LRESULT WINAPI SMGetFilePathW( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam )
{
	LPSTR   lpFileNameA = NULL;
	LRESULT lResult;

	assert( CDM_GETFILEPATH == Msg );

	AllocSpaceAndCopyWStr2Str( (LPWSTR)lParam, wParam, &lpFileNameA );

	lResult = SendMessageA( hWnd, Msg, wParam, (LPARAM)lpFileNameA );

	// copy back the result
	MultiByteToWideChar( CP_ACP, 0, lpFileNameA, wParam * sizeof( char ), (LPWSTR)lParam, wParam );

	FreeSpaceStr( lpFileNameA );

	return lResult;
}

LRESULT WINAPI SMAddStringW( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam )
{
	LPSTR   lpStringA = NULL;
	LRESULT lResult;

	assert( CB_ADDSTRING == Msg );

	AllocNecessarySpaceAndCopyWStr2Str( (LPWSTR)lParam, &lpStringA );

	lResult = SendMessageA( hWnd, Msg, wParam, (LPARAM)lpStringA );

	FreeSpaceStr( lpStringA );

	return lResult;
}

LRESULT WINAPI SMGetLbTextW( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam )
{
	LPSTR   lpStringA = NULL;
	LRESULT lResult;
	DWORD	len;

	assert( CB_GETLBTEXT == Msg );

	// we must determine the length of the string
	// ourself because we don't get it via the
	// message params
	len = SendMessageA( hWnd, CB_GETLBTEXTLEN, wParam, lParam );

	AllocSpaceAndCopyWStr2Str( (LPWSTR)lParam, len, &lpStringA );

	lResult = SendMessageA( hWnd, CB_GETLBTEXT, wParam, (LPARAM)lpStringA );

	// copy back the result
	MultiByteToWideChar( CP_ACP, 0, lpStringA, len * sizeof( char ), (LPWSTR)lParam, len );

	FreeSpaceStr( lpStringA );

	return lResult;
}

LRESULT WINAPI SMBffmSetStatusText( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam )
{
	LPSTR   lpStringA;
	LRESULT lResult;

	assert( BFFM_SETSTATUSTEXT == Msg );

	AllocNecessarySpaceAndCopyWStr2Str( (LPWSTR)lParam, &lpStringA );

	lResult = SendMessageA( hWnd, Msg, (WPARAM)0, (LPARAM)lpStringA );

	FreeSpaceStr( lpStringA );

	return lResult;
}

//-----------------------------------------
// Precondition:
//
DLL_EXPORT LRESULT WINAPI SendMessageW_9x (
	HWND hWnd,		// handle to the destination window
	UINT Msg,		// message
	WPARAM wParam,	// first message parameter
	LPARAM lParam	// second message parameter
)
{
	LRESULT lResult;

	switch( Msg )
	{
	case BFFM_SETSTATUSTEXT:
		SMBffmSetStatusText( hWnd, Msg, wParam, lParam );
		break;

	case BM_GETCHECK:
		lResult = SendMessageA( hWnd, Msg, wParam, lParam );	
		break;

	case BM_SETCHECK:
		lResult = SendMessageA( hWnd, Msg, wParam, lParam );
		break;

	case CB_ADDSTRING:
		lResult = SMAddStringW( hWnd, Msg, wParam, lParam );
		break;

	case CB_GETLBTEXT:
		lResult = SMGetLbTextW( hWnd, Msg, wParam, lParam );
		break;

	case CB_GETCURSEL:
		lResult = SendMessageA( hWnd, Msg, wParam, lParam );
		break;

	case CB_GETLBTEXTLEN:
		lResult = SendMessageA( hWnd, Msg, wParam, lParam );
		break;

    case CB_GETCOUNT:
        lResult = SendMessageA( hWnd, Msg, wParam, lParam );
        break;

    case CB_SETCURSEL:
        lResult = SendMessageA( hWnd, Msg, wParam, lParam );
        break;

    case CB_DELETESTRING:
        lResult = SendMessageA( hWnd, Msg, wParam, lParam );
        break;

	case CDM_GETFILEPATH:
		lResult = SMGetFilePathW( hWnd, Msg, wParam, lParam );
		break;

    case CDM_GETFOLDERPATH:
        lResult = SMGetFolderPathW( hWnd, Msg, wParam, lParam );
        break;

    // this is a very ugly hack because the
    // message id of CDM_GETSPEC and 
    // BFFM_SETSTATUSTEXT is equal
    case (CDM_GETSPEC + OFFSET):
        lResult = SMGetSpecW( hWnd, Msg, wParam, lParam );
        break;

	case STM_SETIMAGE:
		lResult = SendMessageA( hWnd, Msg, wParam, lParam );
		break;

	case STM_GETIMAGE:
		lResult = SendMessageA( hWnd, Msg, wParam, lParam );
		break;

	default:
        assert( FALSE );
		lResult = SendMessageA( hWnd, Msg, wParam, lParam );
		break;
	}

	return lResult;
}





