/*************************************************************************
 *
 *  $RCSfile: schview.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: bm $ $Date: 2001/09/12 16:24:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SCH_SCHVIEW_HXX
#define _SCH_SCHVIEW_HXX

#ifndef _SVDEDXV_HXX //autogen
#include <svx/svdedxv.hxx>
#endif
#ifndef _E3D_VIEW3D_HXX //autogen
#include <svx/view3d.hxx>
#endif

#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _TRANSFER_HXX //autogen
#include <svtools/transfer.hxx>
#endif


#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif

#include "docshell.hxx"

class SchViewShell;
class SchPage;
class SchWindow;
class ChartModel;
class SchDragServerRef;
class E3dScene;
class Graphic;

namespace com { namespace sun { namespace star { namespace datatransfer {
	class XTransferable;
}}}}

DECLARE_LIST(E3dLogicalObjList, E3dObject*);

/*************************************************************************
|*
|* View
|*
\************************************************************************/

class SchView : public E3dView
{
 protected:
	ChartModel*   pDoc;
	SchChartDocShell*   pDocSh;
	SchViewShell*       pViewSh;
	BOOL                bDragActive;
	USHORT              nLogicalMarked;
	USHORT              nLogicalEntered;

	Timer aTimer;
	static void      DeleteChartUserData(ChartModel& rDoc);
	void             Construct();
//  	SchDragServerRef CreateDataObject(SchView* pView, const Point& rDragPos);
//  	SchDragServerRef CreateDataObject(ChartModel* pDocument);
	void                SetMarkHandles();

 public:

	//void NotifySelection();
	DECL_LINK(NotifySelection,void*);

	SchView(SchChartDocShell* pDocSh, OutputDevice* pOutDev, SchViewShell* pShell);
	SchView(ChartModel* pDoc, OutputDevice* pOutDev);
	virtual ~SchView();

	virtual BOOL DoCut(Window* pWindow=NULL);
	virtual void DoCopy(Window* pWindow=NULL);
	virtual void DoPaste(Window* pWindow=NULL);

	FASTBOOL BegTextEdit(SdrObject* pObj, SdrPageView* pPV = NULL,
						 Window* pWin = NULL, FASTBOOL bIsNewObj = FALSE,
						 SdrOutliner* pGivenOutliner = NULL,
						 OutlinerView* pGivenOutlinerView = NULL,
						 FASTBOOL bDontDeleteOutliner = FALSE,
						 FASTBOOL bOnlyOneView = FALSE);
	SdrEndTextEditKind EndTextEdit();

	BOOL IsChartObjSelected();
	long GetSelectedRow() const;
	BOOL CanDeleteMarkedObjects();
	BOOL DeleteMarkedObjects(const String& rUndoStr);
	BOOL CanSetDataAttr();
	void PutMarkedToPos(ULONG nObjPos);
	void MovMarkedToPos(ULONG nObjPos);

	String GetContext();
	String GetContextType();

	ChartModel& GetDoc() const { return *pDoc; }

	BOOL BeginDrag( Window* pWindow, Point aStartPos );

	// clipboard / drag and drop methods using XTransferable
	sal_Bool InsertData( TransferableDataHelper& rDataHelper, const Point& rPos, BOOL bCopy, ULONG nFormat = 0 );
	::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable > CreateDragDropDataObject( SchView* pView, Window& rWindow, const Point& rDragPos );
	::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable > CreateClipboardDataObject();
	::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable > CreateSelectionDataObject( SchView* pWorkView, Window& rWindow );

	void UpdateSelectionClipboard( BOOL bForceDeselect );

	BOOL InsertGraphic( const Graphic& rGraphic, const Point& rPos );

	BOOL IsActive() const { return bDragActive; }

	virtual void InvalidateOneWin(Window& rWin, const Rectangle& rRect);

	void       SetDefault();

	virtual BOOL NotifyNewUndoAction();
	virtual void MarkListHasChanged();

	FASTBOOL    EnterMarkedGroup();
	void		LeaveOneGroup();
	void		LeaveAllGroup();

	FASTBOOL	IsLogicalGroupMarked() { return (nLogicalMarked != 0); }
	FASTBOOL	IsLogicalGroupEntered() { return (nLogicalEntered != 0); }
	void		MarkLogicalGroup();

	FASTBOOL    PickObj(const Point& rPnt, short nTol, SdrObject*& prObj,
						SdrPageView*& prPV,ULONG nOptions=0) const;

	FASTBOOL    IsMarkedHit(const Point& rPnt, short nTol=-2) const;

	E3dLogicalObjList GetLogicalObjList();
	SchChartDocShell* GetDocShell() const { return pDocSh; }

	// drag and drop
	virtual sal_Int8 AcceptDrop( const AcceptDropEvent& rEvt, SchWindow* pWin );
	virtual sal_Int8 ExecuteDrop( const ExecuteDropEvent& rEvt, SchWindow* pWin );

    Window* GetWindow() const;

    virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
};

#endif		// _SCH_SCHVIEW_HXX
