/*************************************************************************
 *
 *  $RCSfile: chtmode5.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: bm $ $Date: 2002/09/05 13:03:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif

#ifndef _SVDORECT_HXX
#include <svx/svdorect.hxx>
#endif

#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#ifndef _SCH_MEMCHRT_HXX
#include "memchrt.hxx"
#endif

#ifndef _SVX_CHRTITEM_HXX //autogen
#define ITEMID_DOUBLE	        0
#define ITEMID_CHARTTEXTORDER   SCHATTR_TEXT_ORDER
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
#include <svx/chrtitem.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include <chtmodel.hxx>
#include <globfunc.hxx>
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif
#ifndef _SCH_SCHIOCMP_HXX
#include "schiocmp.hxx"
#endif
#ifndef _SCH_SCHRESID_HXX
#include "schresid.hxx"
#endif
#include <math.h>
#include <float.h>
#include "glob.hrc"

#include "globfunc.hxx"
#include "pairs.hxx"
#include "chaxis.hxx"

#ifndef _ZFORLIST_HXX
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif


/*************************************************************************
|*
|* Chart-Objekt ermitteln;
|* Es koennen nur Objekte ermittelt werden, von denen es jeweils
|* EIN Exemplar gibt.
|*
\************************************************************************/

SdrObject* ChartModel::GetChartObj(UINT16 nId)
{
	SdrPage* pPage = GetPage(0);
	DBG_ASSERT(pPage, "ChartModel::GetChartObj:Keine Seite vorhanden!");

	SdrObject* pObj = GetObjWithId(nId, *pPage);

	if (!pObj)
	{
		SdrObjGroup* pDiagram =
			(SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *pPage);
		DBG_ASSERT(pDiagram, "ChartModel::GetChartObj:Kein Diagramm-Objekt vorhanden!");

		pObj = GetObjWithId(nId, *pDiagram->GetSubList());
	}

	return pObj;
}

/*************************************************************************
|*
|* Chartdaten auslesen //Angepasst an Umsortierunng
|*
\************************************************************************/

double ChartModel::GetData(long nCol,long nRow,BOOL  bPercent,BOOL  bRowData) const
{
	double fData = IsDataSwitched()   //abhaengig vom Charttyp - statt bSwitchData
					   ? pChartData->GetTransData(nRow, nCol)
					   : pChartData->GetTransData(nCol, nRow);

	if ((fData == DBL_MIN) || !bPercent) return fData;
	else
	{
		return IsDataSwitched()   //abhaengig vom Charttyp - statt bSwitchData
					? pChartData->GetTransDataInPercent(nRow,nCol,!bRowData)
					: pChartData->GetTransDataInPercent(nCol,nRow,bRowData);
	}
}

/*************************************************************************
|*
|* Datenreihen-Objekt ermitteln
|*
\************************************************************************/

SdrObject* ChartModel::GetDataRowObj(long nRow)
{
	SdrPage* pPage = GetPage(0);
	DBG_ASSERT(pPage, "ChartModel::GetDataRowObj:Keine Seite vorhanden!");

	SdrObjGroup* pDiagram =
		(SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *pPage);
	DBG_ASSERT(pDiagram, "ChartModel::GetDataRowObj:Kein Diagramm-Objekt vorhanden!");

	return GetObjWithRow(nRow, *pDiagram->GetSubList());
}
/*************************************************************************
|*
|* Datenreihen-Objekt eines PieChart ermitteln (Col,Row sind vertauscht
|*
\************************************************************************/

SdrObject* ChartModel::GetPieDataRowObj(const long nRow)
{
	SdrPage* pPage = GetPage(0);
	DBG_ASSERT(pPage, "ChartModel::GetPieDataRowObj:Keine Seite vorhanden!");

	SdrObjGroup* pDiagram =
		(SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *pPage);
	DBG_ASSERT(pDiagram, "ChartModel::GetPieDataRowObj:Kein Diagramm-Objekt vorhanden!");

	//return GetObjWithRow(nRow, *);
	SdrObjList* pObjList= pDiagram->GetSubList();

	ULONG nIndex = 0;

	SdrObjListIter aIterator(*pObjList, IM_FLAT);

	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchDataRow* pDataRow = GetDataRow(*pObj);
		if(pDataRow)
		{
			long nT=pDataRow->GetRow();
			if( nT == nRow)
			{
				return (SdrObject*)pDataRow;
			}
		}
		nIndex++;
	}
	return NULL;
}
/*************************************************************************
|*
|* Datenreihengruppe (Liste der Datenreihen)
|*
\************************************************************************/

SdrObject* ChartModel::GetDataRowGroup(const long nRow)
{
	SdrPage* pPage = GetPage(0);
	DBG_ASSERT(pPage, "ChartModel::GetPieDataRowObj:Keine Seite vorhanden!");

	SdrObjGroup* pDiagram =
		(SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *pPage);
	DBG_ASSERT(pDiagram, "ChartModel::GetPieDataRowObj:Kein Diagramm-Objekt vorhanden!");

	SdrObjList* pObjList= pDiagram->GetSubList();

	ULONG nIndex = 0;

	SdrObjListIter aIterator(*pObjList, IM_FLAT);

	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchDataRow* pDataRow = GetDataRow(*pObj);
		if(pDataRow)
		{
			long nT=pDataRow->GetRow();
			if( nT == nRow)
			{
				return (SdrObject*)pObj;
			}
		}
		nIndex++;
	}
	return NULL;
}

/*************************************************************************
|*
|* Datenpunkt-Objekt ermitteln
|*
\************************************************************************/

SdrObject* ChartModel::GetDataPointObj(long nCol, long nRow)
{
	SdrPage* pPage = GetPage(0);
	DBG_ASSERT(pPage, "ChartModel::GetDataPointObj:Keine Seite vorhanden!");

	SdrObjGroup* pDiagram =
		(SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *pPage);
	DBG_ASSERT(pDiagram, "ChartModel::GetDataPointObj:Kein Diagramm-Objekt vorhanden!");

	SdrObject* pObj =
		GetObjWithColRow(nCol, nRow, *pDiagram->GetSubList());

	if (!pObj)
	{
		SdrObjGroup* pDataRow =
			(SdrObjGroup*)GetObjWithRow(nRow, *pDiagram->GetSubList());

		if(pDataRow)
			pObj = GetObjWithColRow(nCol, nRow, *pDataRow->GetSubList());
		else
			DBG_TRACE("ChartModel::GetDataPointObj:Datenreihen-Objekt nicht gefunden!");
	}

	return pObj;
}
/*************************************************************************
|*
|* fr SP2 #66110# bzw. #61907#
|*
\************************************************************************/
void ChartModel::SetChartDataBuffered(SchMemChart& rData, BOOL bNewTitles)
{
	if( pChartDataBuffered )
		delete pChartDataBuffered;

	pChartDataBuffered = NULL;

	if( pDocShell && pDocShell->IsActive() )
	{
		pChartDataBuffered = new SchMemChart(rData);
	}
	else
	{
		SetChartData(*new SchMemChart(rData), bNewTitles);
		BuildChart (TRUE);
	}
}


void ChartModel::CatchUpBufferedData()
{
	if( pChartDataBuffered )
	{
		SetChartData( *pChartDataBuffered, FALSE );		// don't update titles. Titles may only be updated via UI 
		pChartDataBuffered = NULL;
		BuildChart (TRUE);
	}
}

/*************************************************************************
|*
|* neue Chart-Datenstruktur setzen; bisherige wird ggf. geloescht
|*
\************************************************************************/

void ChartModel::SetChartData(SchMemChart& rData, BOOL bNewTitles)
{
	if (pChartData != &rData)
	{
		BOOL bWasData;
		long nOldRowCount = 0;
		long nOldColumnCount = 0;

		if (pChartData)
		{
			nOldRowCount	= pChartData->GetRowCount();
			nOldColumnCount	= pChartData->GetColCount();
			if(pChartData->DecreaseRefCount())
				delete pChartData;

			bWasData = TRUE;
		}
		else
			bWasData = FALSE;

		pChartData  = &rData;
		pChartData->IncreaseRefCount();
		long nColCnt = GetColCount();
		long nRowCnt = GetRowCount();

        // #102853# the adaption of min/max should be (and is) handled by the
        // axis themselves.  (It should at least check, if the min/max values
        // are 'auto')

// 		for (long nCol = 0; nCol < nColCnt; nCol++)
// 		{
// 			for (long nRow = 0; nRow < nRowCnt; nRow++)
// 			{
// 				double fData = GetData(nCol, nRow);

// 				if ((nCol == 0) && (nRow == 0))
// 				{
					//ToDo: wozu das hier? klren!
//					pChartYAxis->SetMin(fData);
//					pChartYAxis->SetMax(fData);
// 				}

// 				if (fData < pChartYAxis->GetMin())
// 					pChartYAxis->SetMin(fData);
// 				if (fData > pChartYAxis->GetMax())
// 					pChartYAxis->SetMax(fData);
// 			}
// 		}

		if (!bWasData || bNewTitles)
		{
			aMainTitle  = pChartData->GetMainTitle();
			aSubTitle   = pChartData->GetSubTitle();
			aXAxisTitle = pChartData->GetXAxisTitle();
			aYAxisTitle = pChartData->GetYAxisTitle();
			aZAxisTitle = pChartData->GetZAxisTitle();
		}

		InitDataAttrs();

		if( rData.GetNumberFormatter() )
		{
			SvNumberFormatter* pNewFormatter = rData.GetNumberFormatter();
			if( pNewFormatter != pNumFormatter )
			{
				// merge numberformatters:
				// merge old one to new one and set new one as member
				if( pNewFormatter && pNumFormatter )
				{
					SvULONGTable* pTransTable =
						pNewFormatter->MergeFormatter( *pNumFormatter );

					SetNumberFormatter( pNewFormatter );

					if( pTransTable && pTransTable->Count() )
					{
						TranslateAllNumFormatIds( pTransTable );
					}
				}
				else if( pNewFormatter )
				{
					SetNumberFormatter( pNewFormatter );
				}
			}
			CheckForNewAxisNumFormat();
		}

		if( (nOldRowCount != nRowCnt) ||
			(nOldColumnCount != nColCnt ))
		{
			DataRangeChanged( nOldRowCount, nOldColumnCount );
		}
	}
}
/*************************************************************************
|*
|* Erstelle Diagrammtitel
|*
\************************************************************************/

SdrTextObj *ChartModel::CreateTitle (SfxItemSet   *pTitleAttr,
									 short        nID,
									 BOOL         bSwitchColRow,
									 const String &rText,
									 BOOL         bVert,
									 ChartAdjust  *pTextDirection)
{
	DBG_ASSERT (pTextDirection, "ChartModel::CreateTitle:Titel-Erzeugung ohne Text-Ausrichtungsinformation");
	if (pTextDirection == NULL) return NULL;  //FG: sonst Absturz

	SfxItemSet aTextAttr(*pItemPool, nTitleWhichPairs);
	SvxChartTextOrient eOrient = ((const SvxChartTextOrientItem&)pTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue();

	if (bVert)
	{
		if (bSwitchColRow)
		{
			*pTextDirection = CHADJUST_BOTTOM_CENTER;
			if (eOrient == CHTXTORIENT_AUTOMATIC) eOrient = CHTXTORIENT_STANDARD;
		}
		else
		{
			*pTextDirection= CHADJUST_CENTER_LEFT;
			if (eOrient == CHTXTORIENT_AUTOMATIC) eOrient = CHTXTORIENT_BOTTOMTOP;
		}
	}
	else
	{
		*pTextDirection = bSwitchColRow ? CHADJUST_CENTER_LEFT : CHADJUST_BOTTOM_CENTER;
		if (eOrient == CHTXTORIENT_AUTOMATIC)
		{
			eOrient = bSwitchColRow ? CHTXTORIENT_BOTTOMTOP : CHTXTORIENT_STANDARD;
		}
	}

	aTextAttr.Put(*pTitleAttr);
	aTextAttr.Put(SvxChartTextOrientItem(eOrient));

	// Seit 4/1998 koennen Texte frei gedreht werden: SCHATTR_TEXT_DEGREES
	// Hier wird ein Wert nachgetragen, falls CHTXTORIENT_AUTOMATIC
	// im Attribut stehen sollte und noch kein Winkel gesetzt wurde
	// ... bisher ohne auswirkung ...? ... evtl. an dieser Stelle unnoetig
	GetTextRotation(aTextAttr,eOrient);

	return CreateTextObj (nID, Point(), rText,
						  aTextAttr, TRUE, *pTextDirection);
}
/*************************************************************************
|*
|* Extractor fuer SvStream zum Laden
|*
\************************************************************************/

BOOL ChartModel::ChangeStatistics (const SfxItemSet &rInAttrs)
{
    long nRowCnt = IsPieChart()
        ? GetColCount()
        : GetRowCount();

    for( long nRow = 0;
         nRow < nRowCnt;
         nRow++ )
        PutDataRowAttr( nRow, rInAttrs );

    const SfxPoolItem *pPoolItem = NULL;
	BOOL              bChanged   = FALSE;

	if (rInAttrs.GetItemState(SCHATTR_STAT_AVERAGE, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bShowAverage = ((const SfxBoolItem*) pPoolItem)->GetValue();
		bChanged     = TRUE;
	}

	if (rInAttrs.GetItemState(SCHATTR_STAT_KIND_ERROR, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		eErrorKind = (SvxChartKindError) ((const SfxInt32Item*) pPoolItem)->GetValue();
		bChanged   = TRUE;
	}

	if (rInAttrs.GetItemState(SCHATTR_STAT_PERCENT, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		fIndicatePercent = ((const SvxDoubleItem*) pPoolItem)->GetValue();
		bChanged         = TRUE;
	}

	if (rInAttrs.GetItemState(SCHATTR_STAT_BIGERROR, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		fIndicateBigError = ((const SvxDoubleItem*) pPoolItem)->GetValue();
		bChanged          = TRUE;
	}

	if (rInAttrs.GetItemState(SCHATTR_STAT_CONSTPLUS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		fIndicatePlus = ((const SvxDoubleItem*) pPoolItem)->GetValue();
		bChanged      = TRUE;
	}

	if (rInAttrs.GetItemState(SCHATTR_STAT_CONSTMINUS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		fIndicateMinus = ((const SvxDoubleItem*) pPoolItem)->GetValue();
		bChanged       = TRUE;
	}

	if (rInAttrs.GetItemState(SCHATTR_STAT_INDICATE, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		eIndicate = (SvxChartIndicate) ((const SfxInt32Item*) pPoolItem)->GetValue();
		bChanged  = TRUE;
	}

	if (rInAttrs.GetItemState(SCHATTR_STAT_REGRESSTYPE, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		eRegression = (SvxChartRegress) ((const SfxInt32Item*) pPoolItem)->GetValue();
		bChanged    = TRUE;
	}

	if( bChanged )
    {
        BuildChart( FALSE );
    }

    return bChanged;
}

void ChartModel::DataRangeChanged( long _nOldRowCnt , long _nOldColCnt )
{
	if( Is3DChart() )
	{
		// delete depth-attributes for 3d charts
		long i, nCount = aDataRowAttrList.Count();
		SfxItemSet	*	pAttributes;

		for( i=0; i<nCount; i++ )
//-/			aDataRowAttrList.GetObject( i )->ClearItem( SID_ATTR_3D_DEPTH );
			aDataRowAttrList.GetObject( i )->ClearItem(SDRATTR_3DOBJ_DEPTH);

		nCount = aDataPointAttrList.Count();
		for( i=0; i < nCount; i++ )
		{
			pAttributes = aDataPointAttrList.GetObject( i );
			if (pAttributes != NULL)
				pAttributes->ClearItem(SDRATTR_3DOBJ_DEPTH);
		}
		
		nCount = aSwitchDataPointAttrList.Count();
		for( i=0; i < nCount; i++ )
		{
			pAttributes = aSwitchDataPointAttrList.GetObject( i );
			if (pAttributes != NULL)
				pAttributes->ClearItem(SDRATTR_3DOBJ_DEPTH);
		}
	}
}


