 /*************************************************************************
 *
 *  $RCSfile: AccessibleDocumentView.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/24 16:03:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "AccessibleDocumentView.hxx"
#include "ChartElementFactory.hxx"

// UAA interfaces
#ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLE_HPP_
#include <com/sun/star/accessibility/XAccessible.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEROLE_HPP_
#include <com/sun/star/accessibility/AccessibleRole.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#endif

// UNO interfaces
#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif
#ifndef	_COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef	_COM_SUN_STAR_CONTAINER_XCHILD_HPP_
#include <com/sun/star/container/XChild.hpp>
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_XDOCUMENTINFOSUPPLIER_HPP_
#include <com/sun/star/document/XDocumentInfoSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEvenetListener.hpp>
#endif
#ifndef _COM_SUN_STAR_VIEW_XSELECTIONSUPPLIER_HPP_
#include <com/sun/star/view/XSelectionSupplier.hpp>
#endif

// tools
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

// STL
#include <algorithm>

// local headers
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#ifndef _SCH_SDWINDOW_HXX
#include "chwindow.hxx"
#endif
#ifndef _SCH_REBUILDHINT_HXX
#include "ReBuildHint.hxx"
#endif
#ifndef _SCH_PROPERTYCHANGEHINT_HXX
#include "PropertyChangeHint.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SCH_SCHVIEW_HXX
#include "schview.hxx"
#endif
#ifndef _SCH_VIEWSHEL_HXX
#include "viewshel.hxx"
#endif
#include "AccLegend.hxx"
#include "AccTitle.hxx"

#ifndef _SVDMODEL_HXX
#include <svx/svdmodel.hxx>
#endif

#if OSL_DEBUG_LEVEL > 1
#include <stdio.h>
#include <string.h>
#endif

using namespace ::rtl;
using namespace ::com::sun::star;
using namespace	::com::sun::star::accessibility;

using ::com::sun::star::uno::Reference;
using ::com::sun::star::uno::UNO_QUERY;
using ::com::sun::star::uno::Any;
using ::com::sun::star::uno::RuntimeException;
using ::com::sun::star::view::XSelectionChangeListener;
using ::osl::MutexGuard;
using ::osl::ResettableMutexGuard;
using ::rtl::OUString;
using ::rtl::OUStringBuffer;

namespace accessibility {

AccessibleDocumentView::AccessibleDocumentView(
    SchWindow* pWindow,
    ChartModel* pChartModel,
    const Reference< frame::XController >& rxController,
    const Reference< XAccessible >& rxParent ) :

        AccessibleBase( AccessibleUniqueId(), NULL, true ),

        m_xController( rxController ),
        m_xWindow( pWindow->GetComponentInterface(), UNO_QUERY ),
        m_xParent( rxParent ),

        m_bHasLegend( false ),
        m_bHasMainTitle( false ),
        m_bHasSubTitle( false ),
        m_bHasXAxisTitle( false ),
        m_bHasYAxisTitle( false ),
        m_bHasZAxisTitle( false ),
        m_bHasDiagram( false )
{
    SetChartModel( pChartModel );
    SetWindow( pWindow );

    if( pChartModel != NULL )
        StartListening( *pChartModel );

    RemoveState( ::com::sun::star::accessibility::AccessibleStateType::SELECTABLE );
    RemoveState( ::com::sun::star::accessibility::AccessibleStateType::FOCUSABLE );
}

void AccessibleDocumentView::StartUNOListening()
{
    // listen to death of model
    // Is this necessary?
// 	if( m_xModel.is() )
// 		m_xModel->addEventListener( this );

    // initialize current selection

    SchWindow * pWin = GetWindow();
    if( pWin )
    {
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        SchViewShell * pViewShell = pWin->GetViewShell();
        if( pViewShell )
        {
            SchView * pView = pViewShell->GetView();
            if( pView )
            {
                const SdrMarkList & rMarkList = pView->GetMarkList();
                if( rMarkList.GetMarkCount() > 0 )
                {
                    SdrObject * pObj = rMarkList.GetMark( 0 )->GetObj();
                    m_aLastSelectedId = ChartElementFactory::GetUniqueIdForDrawObject( pObj );
                }
            }
        }
        // \-- solar
    }

    // listen to selection changes
    Reference< view::XSelectionSupplier > xSelSupp( m_xController, UNO_QUERY );
    if( xSelSupp.is() )
        xSelSupp->addSelectionChangeListener( this );
}

AccessibleDocumentView::~AccessibleDocumentView (void)
{
    OSL_ASSERT( CheckDisposeState( false /* don't throw exceptions */ ) );
    EndListeningAll();
}

void AccessibleDocumentView::LoseFocus()
{
    AccessibleUniqueId aId;

    {
        // /--
        MutexGuard aGuard( GetMutex() );
        aId = m_aLastSelectedId;
        // \--
    }

    if( aId.IsValid() )
    {
        NotifyEvent( LOST_SELECTION, aId );
    }
}

void AccessibleDocumentView::GainFocus()
{
    AccessibleUniqueId aId;

    {
        // /--
        MutexGuard aGuard( GetMutex() );
        aId = m_aLastSelectedId;
        // \--
    }

    if(aId.IsValid() )
    {
        NotifyEvent( GOT_SELECTION, aId );
    }
}

// ________ XInterface ________
Any SAL_CALL AccessibleDocumentView::queryInterface( const uno::Type& aType )
    throw (uno::RuntimeException)
{
    Any aAny = AccessibleBase::queryInterface( aType );
	if( aAny.hasValue() )
		return aAny;

	return ::cppu::queryInterface(
		aType,
        static_cast< XSelectionChangeListener * >( this )
        );
}

void SAL_CALL AccessibleDocumentView::acquire()
    throw ()
{
    AccessibleBase::acquire();
}

void SAL_CALL AccessibleDocumentView::release()
    throw ()
{
    AccessibleBase::release();
}

// ________ XTypeProvider ________
uno::Sequence< uno::Type > SAL_CALL AccessibleDocumentView::getTypes()
    throw (uno::RuntimeException)
{
    static uno::Sequence< uno::Type > st_aTypeSequence;

    if( st_aTypeSequence.getLength() == 0 )
    {
        MutexGuard aGuard( GetMutex() );

        // check again with locked mutex
        if( st_aTypeSequence.getLength() == 0 )
        {
            st_aTypeSequence = AccessibleBase::getTypes();
            st_aTypeSequence.realloc( st_aTypeSequence.getLength() + 1 );
            st_aTypeSequence[ st_aTypeSequence.getLength() - 1 ] =
                ::getCppuType( (const Reference< XSelectionChangeListener > *)0 );
        }
    }

    return st_aTypeSequence;
}

uno::Sequence< sal_Int8 > SAL_CALL AccessibleDocumentView::getImplementationId()
    throw (uno::RuntimeException)
{
	static uno::Sequence< sal_Int8 > st_aId;
	if( st_aId.getLength() == 0 )
	{
		st_aId.realloc( 16 );
		rtl_createUuid( (sal_uInt8 *)st_aId.getArray(), 0, sal_True );
	}
	return st_aId;
}

// ________ XServiceInfo ________
::rtl::OUString SAL_CALL AccessibleDocumentView::getImplementationName()
    throw (uno::RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM( "AccessibleChartDocumentView" ));
}

uno::Sequence< ::rtl::OUString > SAL_CALL AccessibleDocumentView::getSupportedServiceNames()
    throw (uno::RuntimeException)
{
    uno::Sequence< OUString > aResult = AccessibleBase::getSupportedServiceNames();
    aResult.realloc( aResult.getLength() + 1 );
    aResult[ aResult.getLength() - 1 ] =
        OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.chart.AccessibleChartDocumentView" ));

    return aResult;
}

// ________ XComponent ________
void SAL_CALL AccessibleDocumentView::dispose()
    throw (uno::RuntimeException)
{
    EndListeningAll();

    // stop listening to selection changes
    Reference< view::XSelectionSupplier > xSelSupp( m_xController, UNO_QUERY );
    if( xSelSupp.is() )
        xSelSupp->removeSelectionChangeListener( this );

    AccessibleBase::dispose();
}


// ________ XAccessibleContext ________
OUString SAL_CALL AccessibleDocumentView::getAccessibleDescription()
    throw (::com::sun::star::uno::RuntimeException)
{
	OUString sDescription;
    if( m_xController.is())
    {
        Reference< frame::XModel > xModel( m_xController->getModel() );
        Reference< document::XDocumentInfoSupplier > xSupp( xModel, UNO_QUERY );
        if ( xSupp.is() )
        {
            Reference< document::XDocumentInfo > xDocInfo = xSupp->getDocumentInfo();
            Reference< beans::XPropertySet > xProperties (xDocInfo, UNO_QUERY);
            if (xProperties.is())
            {
                xProperties->getPropertyValue(
                    OUString(RTL_CONSTASCII_USTRINGPARAM("Description"))) >>= sDescription;
                if (!sDescription.getLength())
                    sDescription = xModel->getURL();
            }
        }
    }
	return sDescription;
}

sal_Int32 SAL_CALL AccessibleDocumentView::getAccessibleIndexInParent()
    throw (uno::RuntimeException)
{
    // the AccessibleDocumentView is always the only child of the window
    return 0;
}

sal_Int16 SAL_CALL AccessibleDocumentView::getAccessibleRole()
    throw (RuntimeException)
{
    return AccessibleRole::DOCUMENT;
}

Reference< XAccessible > SAL_CALL AccessibleDocumentView::getAccessibleParent()
    throw (uno::RuntimeException)
{
    CheckDisposeState();
    return m_xParent;
}

// ________ XAccessibleComponent ________
awt::Rectangle SAL_CALL AccessibleDocumentView::getBounds()
    throw (uno::RuntimeException)
{
    CheckDisposeState();
    return GetWindowPosSize();
}

awt::Point SAL_CALL AccessibleDocumentView::getLocation()
    throw (uno::RuntimeException)
{
    CheckDisposeState();
    awt::Rectangle aBBox( GetWindowPosSize() );
    return awt::Point( aBBox.X, aBBox.Y );
}

awt::Point SAL_CALL AccessibleDocumentView::getLocationOnScreen()
    throw (uno::RuntimeException)
{
    CheckDisposeState();
    return GetUpperLeftOnScreen();
}

awt::Size SAL_CALL AccessibleDocumentView::getSize()
    throw (uno::RuntimeException)
{
    CheckDisposeState();
    awt::Rectangle aBBox( GetWindowPosSize() );
    return awt::Size( aBBox.Width, aBBox.Height );
}

// ________ XSelectionChangeListener ________
void SAL_CALL AccessibleDocumentView::selectionChanged( const lang::EventObject& aEvent )
    throw (uno::RuntimeException)
{
    // we use the UNO object only to get notified about the fact that the
    // selection has changed, but we acquire the information from the core view
    SchWindow * pWin = GetWindow();
    if( pWin )
    {
        AccessibleUniqueId aId;
        AccessibleUniqueId aLastId;

        {
            // /--
            MutexGuard aGuard( GetMutex());
            aLastId = m_aLastSelectedId;
            // \--
        }

        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        SchViewShell * pViewShell = pWin->GetViewShell();
        if( pViewShell )
        {
            SchView * pView = pViewShell->GetView();
            if( pView )
            {
                const SdrMarkList & rMarkList = pView->GetMarkList();
                if( rMarkList.GetMarkCount() > 0 )
                {
                    SdrObject * pObj = rMarkList.GetMark( 0 )->GetObj();
                    if( pObj )
                    {
                        aId = ChartElementFactory::GetUniqueIdForDrawObject( pObj );
#if OSL_DEBUG_LEVEL > 1
                OSL_TRACE(
                    ::rtl::OUStringToOString(
                        OUString( RTL_CONSTASCII_USTRINGPARAM(
                                      "Object selected: " )) +
                        aId.toString(),
                        RTL_TEXTENCODING_ASCII_US ).getStr() );
#endif
                    }
                }
            }
        }
        // \-- solar

        if( aLastId.IsValid())
            NotifyEvent( LOST_SELECTION, aLastId );

        if( aId.IsValid())
        {
            NotifyEvent( GOT_SELECTION, aId );
        }

        // /--
        MutexGuard aGuard( GetMutex());
        m_aLastSelectedId = aId;
        // \--
    }
}

// ________ AccessibleBase::XEventListener ________
void SAL_CALL AccessibleDocumentView::disposing( const lang::EventObject& Source )
    throw (RuntimeException)
{
    // Source.Source
}

// SfxListener
void AccessibleDocumentView::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
    OSL_TRACE( "Hint received" );
    if( rHint.ISA( SchReBuildHint ))
    {
        KillAllChildren();
        UpdateChildren();
    }
    else if( rHint.ISA( SchPropertyChangeHint ))
    {
        const SdrObject * pObj =
            static_cast< const SchPropertyChangeHint & >( rHint ).GetDrawObject();
        if( pObj )
        {
            AccessibleUniqueId aId =
                ChartElementFactory::GetUniqueIdForDrawObject( pObj );
#if OSL_DEBUG_LEVEL > 1
            OSL_TRACE(
                ::rtl::OUStringToOString(
                    OUString( RTL_CONSTASCII_USTRINGPARAM(
                                  "SchPropertyChangeHint received resending to " )) +
                    aId.toString(),
                    RTL_TEXTENCODING_ASCII_US ).getStr() );
#endif
            NotifyEvent( PROPERTY_CHANGE, aId, &rHint );
        }
    }
    else if( rHint.ISA( SdrHint ))
    {
        const SdrHint & rSdrHint =  static_cast< const SdrHint & >( rHint );
        if( rSdrHint.GetKind() == HINT_OBJCHG )
        {
            const SdrObject* pObj = rSdrHint.GetObject();
            if( pObj )
            {
                AccessibleUniqueId aId =
                    ChartElementFactory::GetUniqueIdForDrawObject( pObj );
#if OSL_DEBUG_LEVEL > 1
                OSL_TRACE(
                    ::rtl::OUStringToOString(
                        OUString( RTL_CONSTASCII_USTRINGPARAM(
                                      "SdrHint received resending to " )) +
                        aId.toString(),
                        RTL_TEXTENCODING_ASCII_US ).getStr() );
#endif
                NotifyEvent( OBJECT_CHANGE, aId );
            }
        }
    }
}

// ____________ protected ____________
bool AccessibleDocumentView::UpdateChildren()
{
    ChartModel * pModel = GetChartModel();

    // /-- solar
    ::vos::OClearableGuard aSolarGuard( Application::GetSolarMutex() );
    // avoid warning on cast from BOOL to bool
    bool bHasLegend        = ( true && pModel->GetShowLegend() );
    bool bHasMainTitle     = ( true && pModel->ShowMainTitle() );
    bool bHasSubTitle      = ( true && pModel->ShowSubTitle() );
    bool bHasXAxisTitle    = ( true && pModel->ShowXAxisTitle() );
    bool bHasYAxisTitle    = ( true && pModel->ShowYAxisTitle() );
    bool bHasZAxisTitle    = ( pModel->Is3DChart() && pModel->ShowZAxisTitle() );
    aSolarGuard.clear();
    // \-- solar

    // /--
    ResettableMutexGuard aGuard( GetMutex() );

    bool bMemberLegend = m_bHasLegend;
    bool bMemberMainTitle = m_bHasMainTitle;
    bool bMemberSubTitle = m_bHasSubTitle;
    bool bMemberXAxisTitle = m_bHasXAxisTitle;
    bool bMemberYAxisTitle = m_bHasYAxisTitle;
    bool bMemberZAxisTitle = m_bHasZAxisTitle;
    bool bMemberDiagram = m_bHasDiagram;
    // there is always a diagram as well as an area
    bool bMemberArea = m_bHasDiagram;

    aGuard.clear();
    // \--

    bMemberLegend =      UpdateChild( CHOBJID_LEGEND, bMemberLegend, bHasLegend );
    bMemberMainTitle =   UpdateChild( CHOBJID_TITLE_MAIN, bMemberMainTitle, bHasMainTitle );
    bMemberSubTitle =    UpdateChild( CHOBJID_TITLE_SUB, bMemberSubTitle, bHasSubTitle );
    bMemberXAxisTitle =  UpdateChild( CHOBJID_DIAGRAM_TITLE_X_AXIS, bMemberXAxisTitle, bHasXAxisTitle );
    bMemberYAxisTitle =  UpdateChild( CHOBJID_DIAGRAM_TITLE_Y_AXIS, bMemberYAxisTitle, bHasYAxisTitle );
    bMemberZAxisTitle =  UpdateChild( CHOBJID_DIAGRAM_TITLE_Z_AXIS, bMemberZAxisTitle, bHasZAxisTitle );
    bMemberDiagram =     UpdateChild( CHOBJID_DIAGRAM, bMemberDiagram, true );
    UpdateChild( CHOBJID_DIAGRAM_AREA, bMemberArea, true );

    // /--
    aGuard.reset();

    m_bHasLegend = bMemberLegend;
    m_bHasMainTitle = bMemberMainTitle;
    m_bHasSubTitle = bMemberSubTitle;
    m_bHasXAxisTitle = bMemberXAxisTitle;
    m_bHasYAxisTitle = bMemberYAxisTitle;
    m_bHasZAxisTitle = bMemberZAxisTitle;
    m_bHasDiagram = bMemberDiagram;

    return true;
    // \--
}

awt::Rectangle AccessibleDocumentView::GetWindowPosSize() const
{
    // this should do, but it doesn't => HACK
//    return m_xWindow->getPosSize();

    awt::Rectangle aBBox( m_xWindow->getPosSize() );
    awt::Point     aOffset;

    Reference< XAccessible > xParent(
        const_cast< AccessibleDocumentView * >( this )->getAccessibleParent() );
    if( xParent.is())
    {
        Reference< XAccessibleComponent > xContext( xParent->getAccessibleContext(), uno::UNO_QUERY );
        if( xContext.is())
        {
            // get position of accessible parent
            awt::Point aAccParentPos( xContext->getLocationOnScreen() );

            // get real screen position
            awt::Point aRealPosition( aAccParentPos );
            Window * pWin = GetWindow();
            if( pWin != NULL )
            {
                // /-- solar
                ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
                Point aVCLPoint( pWin->OutputToAbsoluteScreenPixel( Point( 0, 0 ) ));
                aRealPosition.X = aVCLPoint.X();
                aRealPosition.Y = aVCLPoint.Y();
                // \-- solar

                aOffset.X = aRealPosition.X - aAccParentPos.X;
                aOffset.Y = aRealPosition.Y - aAccParentPos.Y;

                DBG_ASSERT( ( aOffset.X != 0 ) && ( aOffset.Y != 0 ),
                            "VCL method works! Hack can be removed" );
            }
        }
    }

    aBBox.X += aOffset.X;
    aBBox.Y += aOffset.Y;
    return aBBox;
}


awt::Point AccessibleDocumentView::GetUpperLeftOnScreen() const
{
    awt::Point aParentPosition;

    // the const cast is needed, because UNO parameters are never const
    Reference< XAccessible > xParent(
        const_cast< AccessibleDocumentView * >( this )->getAccessibleParent() );
    if( xParent.is())
    {
        Reference< XAccessibleComponent > xContext( xParent->getAccessibleContext(), uno::UNO_QUERY );
        if( xContext.is())
        {
            aParentPosition = xContext->getLocationOnScreen();

            awt::Rectangle aBBox( GetWindowPosSize() );
            aParentPosition.X += aBBox.X;
            aParentPosition.Y += aBBox.Y;
        }
    }

    return aParentPosition;
}

void AccessibleDocumentView::KillAllChildren()
{
    AccessibleBase::KillAllChildren();

    MutexGuard aGuard( GetMutex());

    // reset all member variables
    m_bHasLegend = m_bHasMainTitle = m_bHasSubTitle =
    m_bHasXAxisTitle = m_bHasYAxisTitle = m_bHasZAxisTitle =
    m_bHasDiagram = false;
}

} // end of namespace accessibility
