/*************************************************************************
 *
 *  $RCSfile: schopt.cxx,v $
 *
 *  $Revision: 1.4.150.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 17:57:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
// header for SvStream
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
// header for SAL_STATIC_CAST
#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#include "schopt.hxx"

#include "cfgids.hxx"
#include "defines.hxx"			// for ROW_COLOR_COUNT
#include "schresid.hxx"
#include "strings.hrc"

using namespace com::sun::star;

#define SCH_OPTIONS_VERSION_001		USHORT( 1 )

TYPEINIT1( SchColorTableItem, SfxPoolItem );

SchColorTable::SchColorTable()
{}

SchColorTable::SchColorTable( const SchColorTable & _rSource ) :
        m_aColorEntries( _rSource.m_aColorEntries )
{}

// accessors
size_t SchColorTable::size() const
{
    return m_aColorEntries.size();
}

const XColorEntry & SchColorTable::operator[]( size_t _nIndex ) const
{
    if( _nIndex < 0 ||
        _nIndex >= m_aColorEntries.size())
    {
        DBG_ERROR( "SchColorTable::[] invalid index" );
        return m_aColorEntries[ 0 ];
    }

    return m_aColorEntries[ _nIndex ];
}

ColorData SchColorTable::getColorData( size_t _nIndex ) const
{
    if( _nIndex < 0 ||
        _nIndex >= m_aColorEntries.size())
    {
        DBG_ERROR( "SchColorTable::getColorData invalid index" );
        return COL_BLACK;
    }

    // GetColor should be const but unfortunately isn't
    return const_cast< XColorEntry & >( m_aColorEntries[ _nIndex ] ).GetColor().GetRGBColor();
}

// mutators
void SchColorTable::clear()
{
    m_aColorEntries.clear();
}

void SchColorTable::append( const XColorEntry & _rEntry )
{
    m_aColorEntries.push_back( _rEntry );
}

void SchColorTable::replace( size_t _nIndex, const XColorEntry & _rEntry )
{
    DBG_ASSERT( _nIndex >= 0 &&
                _nIndex <= m_aColorEntries.size(),
                "SchColorTable::replace invalid index" );
    m_aColorEntries[ _nIndex ] = _rEntry;
}

void SchColorTable::useDefault()
{
	ColorData aColors[] = {
		RGB_COLORDATA( 0x99,  0x99, 0xff ),
		RGB_COLORDATA( 0x99,  0x33, 0x66 ),
		RGB_COLORDATA( 0xff,  0xff, 0xcc ),
		RGB_COLORDATA( 0xcc,  0xff, 0xff ),
		RGB_COLORDATA( 0x66,  0x00, 0x66 ),
		RGB_COLORDATA( 0xff,  0x80, 0x80 ),
		RGB_COLORDATA( 0x00,  0x66, 0xcc ),
		RGB_COLORDATA( 0xcc,  0xcc, 0xff ),
		RGB_COLORDATA( 0x00,  0x00, 0x80 ),
		RGB_COLORDATA( 0xff,  0x00, 0xff ),
		RGB_COLORDATA( 0x00,  0xff, 0xff ),
		RGB_COLORDATA( 0xff,  0xff, 0x00 )
	};

    clear();

	String aResName( SchResId( STR_DIAGRAM_ROW ));
	String aPrefix, aPostfix, aName;
	xub_StrLen nPos = aResName.SearchAscii( "$(ROW)" );
	if( nPos != STRING_NOTFOUND )
	{
		aPrefix = String( aResName, 0, nPos );
		aPostfix = String( aResName, nPos + sizeof( "$(ROW)" ) - 1, STRING_LEN );
	}
	else
		aPrefix = aResName;

	for( sal_Int32 i=0; i<ROW_COLOR_COUNT; i++ )
	{
		aName = aPrefix;
		aName.Append( String::CreateFromInt32( i + 1 ));
		aName.Append( aPostfix );

        append( XColorEntry( aColors[ i % sizeof( aColors ) ], aName ));
	}
}

// comparison
bool SchColorTable::operator==( const SchColorTable & _rOther ) const
{
    // note: XColorEntry has no operator ==
    bool bEqual = ( this->m_aColorEntries.size() == _rOther.m_aColorEntries.size() );

    if( bEqual )
    {
        for( size_t i = 0; i < m_aColorEntries.size(); ++i )
        {
            if( getColorData( i ) != _rOther.getColorData( i ))
            {
                bEqual = false;
                break;
            }
        }
    }

    return bEqual;
}

// ====================
// class SchOptions
// ====================

SchOptions::SchOptions() :
		::utl::ConfigItem( rtl::OUString::createFromAscii( "Office.Chart" )),
		mbIsInitialized( FALSE )
{
	maPropertyNames.realloc( 1 );
	maPropertyNames[ 0 ] = ::rtl::OUString::createFromAscii( "DefaultColor/Series" );
}

SchOptions::~SchOptions()
{
// 	maDefColors.ClearAndDestroy();
}

const SchColorTable& SchOptions::GetDefaultColors()
{
	if( ! mbIsInitialized )
	{
		mbIsInitialized = RetrieveOptions();
	}

	return maDefColors;
}

void SchOptions::SetDefaultColors( const SchColorTable& aCol )
{
	maDefColors = aCol;
	SetModified();
}

BOOL SchOptions::RetrieveOptions()
{
	// get sequence containing all properties
	
	uno::Sequence< ::rtl::OUString > aNames = GetPropertyNames();
	uno::Sequence< uno::Any > aProperties( aNames.getLength());
	aProperties = GetProperties( aNames );

	if( aProperties.getLength() == aNames.getLength())
	{
		// 1. default colors for series
// 		maDefColors.ClearAndDestroy();
        maDefColors.clear();
		uno::Sequence< sal_Int64 > aColorSeq;
		aProperties[ 0 ] >>= aColorSeq;

		sal_Int32 nCount = aColorSeq.getLength();
		Color aCol;

		// create strings for entry names
		String aResName( SchResId( STR_DIAGRAM_ROW ));
		String aPrefix, aPostfix, aName;
		xub_StrLen nPos = aResName.SearchAscii( "$(ROW)" );
		if( nPos != STRING_NOTFOUND )
		{
			aPrefix = String( aResName, 0, nPos );
			aPostfix = String( aResName, nPos + sizeof( "$(ROW)" ) - 1, STRING_LEN );
		}
		else
			aPrefix = aResName;

		// set color values
		for( sal_Int32 i=0; i < nCount; i++ )
		{
			aCol.SetColor( SAL_STATIC_CAST( ColorData, aColorSeq[ i ] ));

			aName = aPrefix;
			aName.Append( String::CreateFromInt32( i + 1 ));
			aName.Append( aPostfix );

// 			maDefColors.Insert( i, new XColorEntry( aCol, aName ) );
            maDefColors.append( XColorEntry( aCol, aName ));
		}
		return TRUE;
	}
	return FALSE;
}

void SchOptions::Commit()
{
	uno::Sequence< ::rtl::OUString > aNames = GetPropertyNames();
	uno::Sequence< uno::Any > aValues( aNames.getLength());

	if( aValues.getLength() >= 1 )
	{
		// 1. default colors for series
		// convert list to sequence
		const size_t nCount = maDefColors.size();
		uno::Sequence< sal_Int64 > aColors( nCount );
		for( size_t i=0; i < nCount; i++ )
			aColors[ i ] = maDefColors.getColorData( i );

		aValues[ 0 ] <<= aColors;
	}

	PutProperties( aNames, aValues );
}

// --------------------
// class SchColorTableItem
// --------------------

SchColorTableItem::SchColorTableItem( USHORT nWhich, const SchColorTable& aTable ) :
		SfxPoolItem( nWhich ),
		SchColorTable( aTable )
{
}

SchColorTableItem::SchColorTableItem( const SchColorTableItem& rOther ) :
		SfxPoolItem( rOther ),
		SchColorTable( rOther )
{
}

SfxPoolItem* __EXPORT SchColorTableItem::Clone( SfxItemPool *pPool ) const
{
	return new SchColorTableItem( *this );
}

int __EXPORT SchColorTableItem::operator==( const SfxPoolItem& rAttr ) const
{
	DBG_ASSERT( SfxPoolItem::operator==( rAttr ), "SchColorTableItem::operator== : types differ" );

	return SchColorTable::operator==( (const SchColorTable&)(const SchColorTableItem&)rAttr );
}

void __EXPORT SchColorTableItem::SetOptions( SchOptions* pOpts ) const
{
	if( pOpts )
	{
		pOpts->SetDefaultColors( *this );
	}
}


