/*************************************************************************
 *
 *  $RCSfile: schdrgmt.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/26 18:01:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// header for SdrPageView
#ifndef _SVDPAGV_HXX
#include <svx/svdpagv.hxx>
#endif
// header for SdrDragView
#ifndef _SVDDRGV_HXX
#include <svx/svddrgv.hxx>
#endif
// header for Vector2D
#ifndef _SV_VECTOR2D_HXX
#include <vcl/vector2d.hxx>
#endif
// header for ExtOutputDevice
#ifndef _XOUTX_HXX
#include <svx/xoutx.hxx>
#endif
// header for SdrPathObj
#ifndef _SVDOPATH_HXX
#include <svx/svdopath.hxx>
#endif

#include "chtmodel.hxx"
#include "datapoin.hxx"
#include "schview.hxx"
#include "schdrgmt.hxx"
#include "schresid.hxx"
#include "strings.hrc"

//************************************************************
//   SchDragConstrainedToVector
//************************************************************

TYPEINIT1(SchDragConstrainedToVector,SdrDragMethod);

SchDragConstrainedToVector::SchDragConstrainedToVector( SdrDragView& rNewView,
														Vector2D aConstraint, double fCurrPercent ) :
		SdrDragMethod( rNewView ),
		aConstraintVector( aConstraint ),
		fStartShift( fCurrPercent/100.0 ),
		fRadiusPercent( 0.0 )
{
	fConstraintVecScalar = aConstraint.Scalar( aConstraint );
}

void SchDragConstrainedToVector::TakeComment( String& rStr ) const
{
	rStr = String( SchResId( STR_PIE_SEGMENT_EXPLODED ) );
	rStr.SearchAndReplaceAscii( "$(PERCENT)", String::CreateFromInt32( (long)fRadiusPercent ));
}

FASTBOOL SchDragConstrainedToVector::Beg()
{
	aTranslationVector = Vector2D( SAL_STATIC_CAST( Pair, DragStat().GetStart() ) );
	DragStat().SetActionRect( GetMarkedRect() );

	SdrPageView* pPV = rView.GetPageViewPvNum( 0 );

	if( pPV )
	{
		SdrObject* pObj = rView.GetMarkList().GetMark( 0 )->GetObj();
		if( pObj )
		{
			pObj->TakeXorPoly( pPV->DragPoly0(), TRUE );
			pPV->DragPoly() = pPV->DragPoly0();
		}
	}

	Show();

	return TRUE;
}

void SchDragConstrainedToVector::Mov(const Point& rPnt)
{
	if( DragStat().CheckMinMoved( rPnt ) )
	{
		Vector2D aShiftVector(( Vector2D( SAL_STATIC_CAST( Pair, rPnt )) - aTranslationVector ));
		double fShift = aConstraintVector.Scalar( aShiftVector ) / fConstraintVecScalar;	// projection

		if( fShift )
		{
			if( fShift < -fStartShift )
				fShift = -fStartShift;
			else if( fShift > 1.0 - fStartShift )
				fShift = 1.0 - fStartShift;

			fRadiusPercent = fShift * 100.0;

			Vector2D aNewPosVect = aTranslationVector + (aConstraintVector * fShift);
			Point aNewPos = Point( (long)(aNewPosVect.X()), (long)(aNewPosVect.Y()) );
			if( aNewPos != DragStat().GetNow() )
			{
				DragStat().NextMove( aNewPos );
				Hide();
				SdrPageView* pPV = rView.GetPageViewPvNum( 0 );

				if( pPV->HasMarkedObj() )
				{
					pPV->DragPoly() = pPV->DragPoly0();
					pPV->DragPoly().Move( DragStat().GetDX(), DragStat().GetDY() );
				}
				Show();
			}
		}
	}
}

FASTBOOL SchDragConstrainedToVector::End(FASTBOOL bCopy)
{
//  	rView.MoveMarkedObj( Size( DragStat().GetDX(), DragStat().GetDY() ), bCopy );
	Hide();

	// this is done to transfer the result to the chart objects
	// If sometimes the pies are more specific objects than SdrCircObjs
	// they will get a method for the transfer
	ChartModel& rModel = SAL_STATIC_CAST( SchView&, rView ).GetDoc();

	SdrObject*  pObj = rView.GetMarkList().GetMark(0)->GetObj();

	SchDataPoint* pPoint = GetDataPoint( *pObj );
	DBG_ASSERT( pPoint, "Pie has no data point user data" );

	if( pPoint )
		rModel.SetPieSegOfs( pPoint->GetCol(),
                             rModel.PieSegOfs( pPoint->GetCol())
                             + (long)fRadiusPercent );

	return TRUE;
}

Pointer SchDragConstrainedToVector::GetPointer() const
{
	return Pointer(POINTER_MOVE);
}

FASTBOOL SchDragConstrainedToVector::IsMoveOnly() const
{
	return TRUE;
}

