/*************************************************************************
 *
 *  $RCSfile: xeautil.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:50:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <tools.hxx>
#include <tlfsys.hxx>

#include "xeastrip.hxx"
#include "xeajoin.hxx"

enum Mode
{
	MODE_HELP,
	MODE_FONT,
	MODE_STRIP,
	MODE_JOIN
};

int main( int nArgs, char *pArgs[] )
{
	Mode eMode = MODE_HELP;
	SiDirEntry aPath, aSource;
	USHORT nError = 0;
	for ( USHORT n = 1; n < nArgs; ++n )
	{
		if ( strcmp( pArgs[n], "/s" ) == 0 || strcmp( pArgs[n], "-s" ) == 0 ||
			 strcmp( pArgs[n], "/S" ) == 0 || strcmp( pArgs[n], "-S" ) == 0 )
			eMode = MODE_STRIP;

		else if ( strcmp( pArgs[n], "/j" ) == 0 || strcmp( pArgs[n], "-j" ) == 0 ||
				  strcmp( pArgs[n], "/J" ) == 0 || strcmp( pArgs[n], "-J" ) == 0 )
			eMode = MODE_JOIN;

		else if ( (n+1) <= nArgs &&
				  ( strcmp( pArgs[n], "/a" ) == 0 || strcmp( pArgs[n], "-a" ) == 0 ||
					strcmp( pArgs[n], "/A" ) == 0 || strcmp( pArgs[n], "-A" ) == 0 ) )
			aSource = SiDirEntry( pArgs[++n] );

		else if ( pArgs[n][0] == '/' || pArgs[n][0] == '-' )
		{
			fprintf( stderr, "error: unknown switch (%s)\n", pArgs[n] );
			nError = 1;
			eMode = MODE_HELP;
		}

		else
			aPath = SiDirEntry( pArgs[n] );
	}

	switch ( eMode )
	{
		case MODE_STRIP:
		{
			if ( FileStat( aPath ).IsKind( FSYS_KIND_WILD ) )
				StripEAs( aPath.GetPath(), WildCard( aPath.GetName(), ';' ), aSource );
			else
				StripEAs( aPath, WildCard( "*" ), aSource );
			break;
		}

		case MODE_JOIN:
		{
			if ( FileStat( aPath ).IsKind( FSYS_KIND_WILD ) )
				JoinEAs( aPath.GetPath(), WildCard( aPath.GetName(), ';' ), aSource );
			else
				JoinEAs( aPath, WildCard( "*" ), aSource );
			break;
		}

		case MODE_HELP:
		{
			puts( "xeautil - utility for recursive ae stripping/joining" );
			puts( "(C)1993 Star Division GmbH, Hamburg" );
			puts( "" );
			puts( "syntax:" );
			puts( "xeautil [path[\\wildcard]] -s|-j [-a source]" );
			puts( "-s strip eas from files giving *.??$ files" );
			puts( "-j join eas from *.??$ files (or 'source') into data files" );
			puts( "-a use eas in 'source' to join" );
			puts( "" );
			puts( "example:" );
			puts( "xeautil x:\\master.os2\\*.sdw -j -a c:\\tmp\\dokument.sd$" );
			puts( "Joins EAs in dokument.sd$ to all files matching *.sdw in" );
			puts( "and below 'x:\\master.os2'." );
			break;
		}
	}

	return nError;
}

